package software.amazon.awscdk.services.logs;

/**
 * Collection of grant methods for a ILogGroupRef.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.interfaces.logs.*;
 * ILogGroupRef logGroupRef;
 * LogGroupGrants logGroupGrants = LogGroupGrants.fromLogGroup(logGroupRef);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:24.197Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.LogGroupGrants")
public class LogGroupGrants extends software.amazon.jsii.JsiiObject {

    protected LogGroupGrants(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LogGroupGrants(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates grants for LogGroupGrants.
     * <p>
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.LogGroupGrants fromLogGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.logs.ILogGroupRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.logs.LogGroupGrants.class, "fromLogGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogGroupGrants.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Give permissions to read and filter events from this log group.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant read(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "read", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Give permissions to create and write to streams in this log group.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant write(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "write", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.logs.ILogGroupRef getResource() {
        return software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.logs.ILogGroupRef.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IResourceWithPolicyV2 getPolicyResource() {
        return software.amazon.jsii.Kernel.get(this, "policyResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IResourceWithPolicyV2.class));
    }
}
