package software.amazon.awscdk.services.logs;

/**
 * A filter that extracts information from CloudWatch Logs and emits to CloudWatch Metrics.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * MetricFilter.Builder.create(this, "MetricFilter")
 *         .logGroup(logGroup)
 *         .metricNamespace("MyApp")
 *         .metricName("Latency")
 *         .filterPattern(FilterPattern.all(FilterPattern.exists("$.latency"), FilterPattern.regexValue("$.message", "=", "bind: address already in use")))
 *         .metricValue("$.latency")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:24.202Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.MetricFilter")
public class MetricFilter extends software.amazon.awscdk.Resource {

    protected MetricFilter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MetricFilter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.MetricFilter.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public MetricFilter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.MetricFilterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Return the given named metric for this Metric Filter.
     * <p>
     * Default: avg over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Return the given named metric for this Metric Filter.
     * <p>
     * Default: avg over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric() {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.MetricFilter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.MetricFilter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.logs.MetricFilterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.logs.MetricFilterProps.Builder();
        }

        /**
         * Pattern to search for log events.
         * <p>
         * @return {@code this}
         * @param filterPattern Pattern to search for log events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPattern(final software.amazon.awscdk.services.logs.IFilterPattern filterPattern) {
            this.props.filterPattern(filterPattern);
            return this;
        }

        /**
         * The name of the metric to emit.
         * <p>
         * @return {@code this}
         * @param metricName The name of the metric to emit. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricName(final java.lang.String metricName) {
            this.props.metricName(metricName);
            return this;
        }

        /**
         * The namespace of the metric to emit.
         * <p>
         * @return {@code this}
         * @param metricNamespace The namespace of the metric to emit. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricNamespace(final java.lang.String metricNamespace) {
            this.props.metricNamespace(metricNamespace);
            return this;
        }

        /**
         * Whether the metric filter is applied on the tranformed logs.
         * <p>
         * This parameter is valid only for log groups that have an active log transformer.
         * If this value is true, the metric filter is applied on the transformed version of the log events instead of the original ingested log events.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param applyOnTransformedLogs Whether the metric filter is applied on the tranformed logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyOnTransformedLogs(final java.lang.Boolean applyOnTransformedLogs) {
            this.props.applyOnTransformedLogs(applyOnTransformedLogs);
            return this;
        }

        /**
         * The value to emit if the pattern does not match a particular event.
         * <p>
         * Default: No metric emitted.
         * <p>
         * @return {@code this}
         * @param defaultValue The value to emit if the pattern does not match a particular event. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultValue(final java.lang.Number defaultValue) {
            this.props.defaultValue(defaultValue);
            return this;
        }

        /**
         * The fields to use as dimensions for the metric.
         * <p>
         * One metric filter can include as many as three dimensions.
         * <p>
         * Default: - No dimensions attached to metrics.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-metricfilter-metrictransformation.html#cfn-logs-metricfilter-metrictransformation-dimensions">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-metricfilter-metrictransformation.html#cfn-logs-metricfilter-metrictransformation-dimensions</a>
         * @param dimensions The fields to use as dimensions for the metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(final java.util.Map<java.lang.String, java.lang.String> dimensions) {
            this.props.dimensions(dimensions);
            return this;
        }

        /**
         * The name of the metric filter.
         * <p>
         * Default: - Cloudformation generated name.
         * <p>
         * @return {@code this}
         * @param filterName The name of the metric filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterName(final java.lang.String filterName) {
            this.props.filterName(filterName);
            return this;
        }

        /**
         * The value to emit for the metric.
         * <p>
         * Can either be a literal number (typically "1"), or the name of a field in the structure
         * to take the value from the matched event. If you are using a field value, the field
         * value must have been matched using the pattern.
         * <p>
         * If you want to specify a field from a matched JSON structure, use '$.fieldName',
         * and make sure the field is in the pattern (if only as '$.fieldName = *').
         * <p>
         * If you want to specify a field from a matched space-delimited structure,
         * use '$fieldName'.
         * <p>
         * Default: "1"
         * <p>
         * @return {@code this}
         * @param metricValue The value to emit for the metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricValue(final java.lang.String metricValue) {
            this.props.metricValue(metricValue);
            return this;
        }

        /**
         * The unit to assign to the metric.
         * <p>
         * Default: - No unit attached to metrics.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-metricfilter-metrictransformation.html#cfn-logs-metricfilter-metrictransformation-unit">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-metricfilter-metrictransformation.html#cfn-logs-metricfilter-metrictransformation-unit</a>
         * @param unit The unit to assign to the metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unit(final software.amazon.awscdk.services.cloudwatch.Unit unit) {
            this.props.unit(unit);
            return this;
        }

        /**
         * The log group to create the filter on.
         * <p>
         * @return {@code this}
         * @param logGroup The log group to create the filter on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.props.logGroup(logGroup);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.MetricFilter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.MetricFilter build() {
            return new software.amazon.awscdk.services.logs.MetricFilter(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
