package software.amazon.awscdk.services.logs;

/**
 * This processor parses a specified field in the original log event into key-value pairs.
 * <p>
 * For more information about this processor including examples, see parseKeyValue in the CloudWatch Logs User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * ParseKeyValueProperty parseKeyValueProperty = ParseKeyValueProperty.builder()
 *         .destination("destination")
 *         .fieldDelimiter(KeyValuePairDelimiter.AMPERSAND)
 *         .keyPrefix("keyPrefix")
 *         .keyValueDelimiter(KeyValueDelimiter.EQUAL)
 *         .nonMatchValue("nonMatchValue")
 *         .overwriteIfExists(false)
 *         .source("source")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:24.222Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.ParseKeyValueProperty")
@software.amazon.jsii.Jsii.Proxy(ParseKeyValueProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ParseKeyValueProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * The destination field to put the extracted key-value pairs into.
     * <p>
     * Default: - Places at the root of the JSON input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestination() {
        return null;
    }

    /**
     * The field delimiter string that is used between key-value pairs in the original log events.
     * <p>
     * Default: KeyValuePairDelimiter.AMPERSAND
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.KeyValuePairDelimiter getFieldDelimiter() {
        return null;
    }

    /**
     * If you want to add a prefix to all transformed keys, specify it here.
     * <p>
     * Default: - No prefix is added to the keys.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyPrefix() {
        return null;
    }

    /**
     * The delimiter string to use between the key and value in each pair in the transformed log event.
     * <p>
     * Default: KeyValueDelimiter.EQUAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.KeyValueDelimiter getKeyValueDelimiter() {
        return null;
    }

    /**
     * A value to insert into the value field in the result, when a key-value pair is not successfully split.
     * <p>
     * Default: - No values is inserted when split is not successful.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNonMatchValue() {
        return null;
    }

    /**
     * Specifies whether to overwrite the value if the destination key already exists.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOverwriteIfExists() {
        return null;
    }

    /**
     * Path to the field in the log event that will be parsed.
     * <p>
     * Use dot notation to access child fields.
     * <p>
     * Default: '@message'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ParseKeyValueProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ParseKeyValueProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ParseKeyValueProperty> {
        java.lang.String destination;
        software.amazon.awscdk.services.logs.KeyValuePairDelimiter fieldDelimiter;
        java.lang.String keyPrefix;
        software.amazon.awscdk.services.logs.KeyValueDelimiter keyValueDelimiter;
        java.lang.String nonMatchValue;
        java.lang.Boolean overwriteIfExists;
        java.lang.String source;

        /**
         * Sets the value of {@link ParseKeyValueProperty#getDestination}
         * @param destination The destination field to put the extracted key-value pairs into.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(java.lang.String destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link ParseKeyValueProperty#getFieldDelimiter}
         * @param fieldDelimiter The field delimiter string that is used between key-value pairs in the original log events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldDelimiter(software.amazon.awscdk.services.logs.KeyValuePairDelimiter fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        /**
         * Sets the value of {@link ParseKeyValueProperty#getKeyPrefix}
         * @param keyPrefix If you want to add a prefix to all transformed keys, specify it here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPrefix(java.lang.String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        /**
         * Sets the value of {@link ParseKeyValueProperty#getKeyValueDelimiter}
         * @param keyValueDelimiter The delimiter string to use between the key and value in each pair in the transformed log event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyValueDelimiter(software.amazon.awscdk.services.logs.KeyValueDelimiter keyValueDelimiter) {
            this.keyValueDelimiter = keyValueDelimiter;
            return this;
        }

        /**
         * Sets the value of {@link ParseKeyValueProperty#getNonMatchValue}
         * @param nonMatchValue A value to insert into the value field in the result, when a key-value pair is not successfully split.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nonMatchValue(java.lang.String nonMatchValue) {
            this.nonMatchValue = nonMatchValue;
            return this;
        }

        /**
         * Sets the value of {@link ParseKeyValueProperty#getOverwriteIfExists}
         * @param overwriteIfExists Specifies whether to overwrite the value if the destination key already exists.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overwriteIfExists(java.lang.Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
            return this;
        }

        /**
         * Sets the value of {@link ParseKeyValueProperty#getSource}
         * @param source Path to the field in the log event that will be parsed.
         *               Use dot notation to access child fields.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ParseKeyValueProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ParseKeyValueProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ParseKeyValueProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParseKeyValueProperty {
        private final java.lang.String destination;
        private final software.amazon.awscdk.services.logs.KeyValuePairDelimiter fieldDelimiter;
        private final java.lang.String keyPrefix;
        private final software.amazon.awscdk.services.logs.KeyValueDelimiter keyValueDelimiter;
        private final java.lang.String nonMatchValue;
        private final java.lang.Boolean overwriteIfExists;
        private final java.lang.String source;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fieldDelimiter = software.amazon.jsii.Kernel.get(this, "fieldDelimiter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.KeyValuePairDelimiter.class));
            this.keyPrefix = software.amazon.jsii.Kernel.get(this, "keyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyValueDelimiter = software.amazon.jsii.Kernel.get(this, "keyValueDelimiter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.KeyValueDelimiter.class));
            this.nonMatchValue = software.amazon.jsii.Kernel.get(this, "nonMatchValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.overwriteIfExists = software.amazon.jsii.Kernel.get(this, "overwriteIfExists", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destination = builder.destination;
            this.fieldDelimiter = builder.fieldDelimiter;
            this.keyPrefix = builder.keyPrefix;
            this.keyValueDelimiter = builder.keyValueDelimiter;
            this.nonMatchValue = builder.nonMatchValue;
            this.overwriteIfExists = builder.overwriteIfExists;
            this.source = builder.source;
        }

        @Override
        public final java.lang.String getDestination() {
            return this.destination;
        }

        @Override
        public final software.amazon.awscdk.services.logs.KeyValuePairDelimiter getFieldDelimiter() {
            return this.fieldDelimiter;
        }

        @Override
        public final java.lang.String getKeyPrefix() {
            return this.keyPrefix;
        }

        @Override
        public final software.amazon.awscdk.services.logs.KeyValueDelimiter getKeyValueDelimiter() {
            return this.keyValueDelimiter;
        }

        @Override
        public final java.lang.String getNonMatchValue() {
            return this.nonMatchValue;
        }

        @Override
        public final java.lang.Boolean getOverwriteIfExists() {
            return this.overwriteIfExists;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDestination() != null) {
                data.set("destination", om.valueToTree(this.getDestination()));
            }
            if (this.getFieldDelimiter() != null) {
                data.set("fieldDelimiter", om.valueToTree(this.getFieldDelimiter()));
            }
            if (this.getKeyPrefix() != null) {
                data.set("keyPrefix", om.valueToTree(this.getKeyPrefix()));
            }
            if (this.getKeyValueDelimiter() != null) {
                data.set("keyValueDelimiter", om.valueToTree(this.getKeyValueDelimiter()));
            }
            if (this.getNonMatchValue() != null) {
                data.set("nonMatchValue", om.valueToTree(this.getNonMatchValue()));
            }
            if (this.getOverwriteIfExists() != null) {
                data.set("overwriteIfExists", om.valueToTree(this.getOverwriteIfExists()));
            }
            if (this.getSource() != null) {
                data.set("source", om.valueToTree(this.getSource()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.ParseKeyValueProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ParseKeyValueProperty.Jsii$Proxy that = (ParseKeyValueProperty.Jsii$Proxy) o;

            if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
            if (this.fieldDelimiter != null ? !this.fieldDelimiter.equals(that.fieldDelimiter) : that.fieldDelimiter != null) return false;
            if (this.keyPrefix != null ? !this.keyPrefix.equals(that.keyPrefix) : that.keyPrefix != null) return false;
            if (this.keyValueDelimiter != null ? !this.keyValueDelimiter.equals(that.keyValueDelimiter) : that.keyValueDelimiter != null) return false;
            if (this.nonMatchValue != null ? !this.nonMatchValue.equals(that.nonMatchValue) : that.nonMatchValue != null) return false;
            if (this.overwriteIfExists != null ? !this.overwriteIfExists.equals(that.overwriteIfExists) : that.overwriteIfExists != null) return false;
            return this.source != null ? this.source.equals(that.source) : that.source == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destination != null ? this.destination.hashCode() : 0;
            result = 31 * result + (this.fieldDelimiter != null ? this.fieldDelimiter.hashCode() : 0);
            result = 31 * result + (this.keyPrefix != null ? this.keyPrefix.hashCode() : 0);
            result = 31 * result + (this.keyValueDelimiter != null ? this.keyValueDelimiter.hashCode() : 0);
            result = 31 * result + (this.nonMatchValue != null ? this.nonMatchValue.hashCode() : 0);
            result = 31 * result + (this.overwriteIfExists != null ? this.overwriteIfExists.hashCode() : 0);
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            return result;
        }
    }
}
