package software.amazon.awscdk.services.logs;

/**
 * This processor adds new key-value pairs to the log event.
 * <p>
 * For more information about this processor including examples, see addKeys in the CloudWatch Logs User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * ProcessorDeleteKeysProperty processorDeleteKeysProperty = ProcessorDeleteKeysProperty.builder()
 *         .withKeys(List.of("withKeys"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:24.224Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.ProcessorDeleteKeysProperty")
@software.amazon.jsii.Jsii.Proxy(ProcessorDeleteKeysProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProcessorDeleteKeysProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of keys to delete.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getWithKeys();

    /**
     * @return a {@link Builder} of {@link ProcessorDeleteKeysProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProcessorDeleteKeysProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProcessorDeleteKeysProperty> {
        java.util.List<java.lang.String> withKeys;

        /**
         * Sets the value of {@link ProcessorDeleteKeysProperty#getWithKeys}
         * @param withKeys A list of keys to delete. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withKeys(java.util.List<java.lang.String> withKeys) {
            this.withKeys = withKeys;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProcessorDeleteKeysProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProcessorDeleteKeysProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProcessorDeleteKeysProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessorDeleteKeysProperty {
        private final java.util.List<java.lang.String> withKeys;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.withKeys = software.amazon.jsii.Kernel.get(this, "withKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.withKeys = java.util.Objects.requireNonNull(builder.withKeys, "withKeys is required");
        }

        @Override
        public final java.util.List<java.lang.String> getWithKeys() {
            return this.withKeys;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("withKeys", om.valueToTree(this.getWithKeys()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.ProcessorDeleteKeysProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProcessorDeleteKeysProperty.Jsii$Proxy that = (ProcessorDeleteKeysProperty.Jsii$Proxy) o;

            return this.withKeys.equals(that.withKeys);
        }

        @Override
        public final int hashCode() {
            int result = this.withKeys.hashCode();
            return result;
        }
    }
}
