package software.amazon.awscdk.services.mediaconnect;

/**
 * Properties for defining a <code>CfnBridge</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnBridgeProps cfnBridgeProps = CfnBridgeProps.builder()
 *         .name("name")
 *         .placementArn("placementArn")
 *         .sources(List.of(BridgeSourceProperty.builder()
 *                 .flowSource(BridgeFlowSourceProperty.builder()
 *                         .flowArn("flowArn")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .flowVpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
 *                                 .vpcInterfaceName("vpcInterfaceName")
 *                                 .build())
 *                         .build())
 *                 .networkSource(BridgeNetworkSourceProperty.builder()
 *                         .multicastIp("multicastIp")
 *                         .name("name")
 *                         .networkName("networkName")
 *                         .port(123)
 *                         .protocol("protocol")
 *                         // the properties below are optional
 *                         .multicastSourceSettings(MulticastSourceSettingsProperty.builder()
 *                                 .multicastSourceIp("multicastSourceIp")
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .egressGatewayBridge(EgressGatewayBridgeProperty.builder()
 *                 .maxBitrate(123)
 *                 .build())
 *         .ingressGatewayBridge(IngressGatewayBridgeProperty.builder()
 *                 .maxBitrate(123)
 *                 .maxOutputs(123)
 *                 .build())
 *         .outputs(List.of(BridgeOutputProperty.builder()
 *                 .networkOutput(BridgeNetworkOutputProperty.builder()
 *                         .ipAddress("ipAddress")
 *                         .name("name")
 *                         .networkName("networkName")
 *                         .port(123)
 *                         .protocol("protocol")
 *                         .ttl(123)
 *                         .build())
 *                 .build()))
 *         .sourceFailoverConfig(FailoverConfigProperty.builder()
 *                 .failoverMode("failoverMode")
 *                 // the properties below are optional
 *                 .sourcePriority(SourcePriorityProperty.builder()
 *                         .primarySource("primarySource")
 *                         .build())
 *                 .state("state")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:24.334Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnBridgeProps")
@software.amazon.jsii.Jsii.Proxy(CfnBridgeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBridgeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the bridge.
     * <p>
     * This name can not be modified after the bridge is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The bridge placement Amazon Resource Number (ARN).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-placementarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-placementarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPlacementArn();

    /**
     * The sources that you want to add to this bridge.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnBridge.BridgeSourceProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-sources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-sources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSources();

    /**
     * An egress bridge is a cloud-to-ground bridge.
     * <p>
     * The content comes from an existing MediaConnect flow and is delivered to your premises.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnBridge.EgressGatewayBridgeProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-egressgatewaybridge">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-egressgatewaybridge</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEgressGatewayBridge() {
        return null;
    }

    /**
     * An ingress bridge is a ground-to-cloud bridge.
     * <p>
     * The content originates at your premises and is delivered to the cloud.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnBridge.IngressGatewayBridgeProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-ingressgatewaybridge">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-ingressgatewaybridge</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIngressGatewayBridge() {
        return null;
    }

    /**
     * The outputs that you want to add to this bridge.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnBridge.BridgeOutputProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-outputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-outputs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOutputs() {
        return null;
    }

    /**
     * The settings for source failover.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnBridge.FailoverConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-sourcefailoverconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-bridge.html#cfn-mediaconnect-bridge-sourcefailoverconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceFailoverConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBridgeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBridgeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBridgeProps> {
        java.lang.String name;
        java.lang.String placementArn;
        java.lang.Object sources;
        java.lang.Object egressGatewayBridge;
        java.lang.Object ingressGatewayBridge;
        java.lang.Object outputs;
        java.lang.Object sourceFailoverConfig;

        /**
         * Sets the value of {@link CfnBridgeProps#getName}
         * @param name The name of the bridge. This parameter is required.
         *             This name can not be modified after the bridge is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeProps#getPlacementArn}
         * @param placementArn The bridge placement Amazon Resource Number (ARN). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementArn(java.lang.String placementArn) {
            this.placementArn = placementArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeProps#getSources}
         * @param sources The sources that you want to add to this bridge. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(software.amazon.awscdk.IResolvable sources) {
            this.sources = sources;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeProps#getSources}
         * @param sources The sources that you want to add to this bridge. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sources(java.util.List<? extends java.lang.Object> sources) {
            this.sources = sources;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeProps#getEgressGatewayBridge}
         * @param egressGatewayBridge An egress bridge is a cloud-to-ground bridge.
         *                            The content comes from an existing MediaConnect flow and is delivered to your premises.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressGatewayBridge(software.amazon.awscdk.IResolvable egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeProps#getEgressGatewayBridge}
         * @param egressGatewayBridge An egress bridge is a cloud-to-ground bridge.
         *                            The content comes from an existing MediaConnect flow and is delivered to your premises.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressGatewayBridge(software.amazon.awscdk.services.mediaconnect.CfnBridge.EgressGatewayBridgeProperty egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeProps#getIngressGatewayBridge}
         * @param ingressGatewayBridge An ingress bridge is a ground-to-cloud bridge.
         *                             The content originates at your premises and is delivered to the cloud.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressGatewayBridge(software.amazon.awscdk.IResolvable ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeProps#getIngressGatewayBridge}
         * @param ingressGatewayBridge An ingress bridge is a ground-to-cloud bridge.
         *                             The content originates at your premises and is delivered to the cloud.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingressGatewayBridge(software.amazon.awscdk.services.mediaconnect.CfnBridge.IngressGatewayBridgeProperty ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeProps#getOutputs}
         * @param outputs The outputs that you want to add to this bridge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(software.amazon.awscdk.IResolvable outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeProps#getOutputs}
         * @param outputs The outputs that you want to add to this bridge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.util.List<? extends java.lang.Object> outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeProps#getSourceFailoverConfig}
         * @param sourceFailoverConfig The settings for source failover.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFailoverConfig(software.amazon.awscdk.IResolvable sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnBridgeProps#getSourceFailoverConfig}
         * @param sourceFailoverConfig The settings for source failover.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFailoverConfig(software.amazon.awscdk.services.mediaconnect.CfnBridge.FailoverConfigProperty sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBridgeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBridgeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBridgeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBridgeProps {
        private final java.lang.String name;
        private final java.lang.String placementArn;
        private final java.lang.Object sources;
        private final java.lang.Object egressGatewayBridge;
        private final java.lang.Object ingressGatewayBridge;
        private final java.lang.Object outputs;
        private final java.lang.Object sourceFailoverConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.placementArn = software.amazon.jsii.Kernel.get(this, "placementArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sources = software.amazon.jsii.Kernel.get(this, "sources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.egressGatewayBridge = software.amazon.jsii.Kernel.get(this, "egressGatewayBridge", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ingressGatewayBridge = software.amazon.jsii.Kernel.get(this, "ingressGatewayBridge", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceFailoverConfig = software.amazon.jsii.Kernel.get(this, "sourceFailoverConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.placementArn = java.util.Objects.requireNonNull(builder.placementArn, "placementArn is required");
            this.sources = java.util.Objects.requireNonNull(builder.sources, "sources is required");
            this.egressGatewayBridge = builder.egressGatewayBridge;
            this.ingressGatewayBridge = builder.ingressGatewayBridge;
            this.outputs = builder.outputs;
            this.sourceFailoverConfig = builder.sourceFailoverConfig;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getPlacementArn() {
            return this.placementArn;
        }

        @Override
        public final java.lang.Object getSources() {
            return this.sources;
        }

        @Override
        public final java.lang.Object getEgressGatewayBridge() {
            return this.egressGatewayBridge;
        }

        @Override
        public final java.lang.Object getIngressGatewayBridge() {
            return this.ingressGatewayBridge;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        public final java.lang.Object getSourceFailoverConfig() {
            return this.sourceFailoverConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("placementArn", om.valueToTree(this.getPlacementArn()));
            data.set("sources", om.valueToTree(this.getSources()));
            if (this.getEgressGatewayBridge() != null) {
                data.set("egressGatewayBridge", om.valueToTree(this.getEgressGatewayBridge()));
            }
            if (this.getIngressGatewayBridge() != null) {
                data.set("ingressGatewayBridge", om.valueToTree(this.getIngressGatewayBridge()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }
            if (this.getSourceFailoverConfig() != null) {
                data.set("sourceFailoverConfig", om.valueToTree(this.getSourceFailoverConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnBridgeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBridgeProps.Jsii$Proxy that = (CfnBridgeProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!placementArn.equals(that.placementArn)) return false;
            if (!sources.equals(that.sources)) return false;
            if (this.egressGatewayBridge != null ? !this.egressGatewayBridge.equals(that.egressGatewayBridge) : that.egressGatewayBridge != null) return false;
            if (this.ingressGatewayBridge != null ? !this.ingressGatewayBridge.equals(that.ingressGatewayBridge) : that.ingressGatewayBridge != null) return false;
            if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) return false;
            return this.sourceFailoverConfig != null ? this.sourceFailoverConfig.equals(that.sourceFailoverConfig) : that.sourceFailoverConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.placementArn.hashCode());
            result = 31 * result + (this.sources.hashCode());
            result = 31 * result + (this.egressGatewayBridge != null ? this.egressGatewayBridge.hashCode() : 0);
            result = 31 * result + (this.ingressGatewayBridge != null ? this.ingressGatewayBridge.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            result = 31 * result + (this.sourceFailoverConfig != null ? this.sourceFailoverConfig.hashCode() : 0);
            return result;
        }
    }
}
