package software.amazon.awscdk.services.mediaconnect;

/**
 * Represents a router input in AWS Elemental MediaConnect that is used to ingest content to be transmitted to router outputs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * Object automatic;
 * Object default_;
 * CfnRouterInput cfnRouterInput = CfnRouterInput.Builder.create(this, "MyCfnRouterInput")
 *         .configuration(RouterInputConfigurationProperty.builder()
 *                 .failover(FailoverRouterInputConfigurationProperty.builder()
 *                         .networkInterfaceArn("networkInterfaceArn")
 *                         .protocolConfigurations(List.of(FailoverRouterInputProtocolConfigurationProperty.builder()
 *                                 .rist(RistRouterInputConfigurationProperty.builder()
 *                                         .port(123)
 *                                         .recoveryLatencyMilliseconds(123)
 *                                         .build())
 *                                 .rtp(RtpRouterInputConfigurationProperty.builder()
 *                                         .port(123)
 *                                         // the properties below are optional
 *                                         .forwardErrorCorrection("forwardErrorCorrection")
 *                                         .build())
 *                                 .srtCaller(SrtCallerRouterInputConfigurationProperty.builder()
 *                                         .minimumLatencyMilliseconds(123)
 *                                         .sourceAddress("sourceAddress")
 *                                         .sourcePort(123)
 *                                         // the properties below are optional
 *                                         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
 *                                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                         .roleArn("roleArn")
 *                                                         .secretArn("secretArn")
 *                                                         .build())
 *                                                 .build())
 *                                         .streamId("streamId")
 *                                         .build())
 *                                 .srtListener(SrtListenerRouterInputConfigurationProperty.builder()
 *                                         .minimumLatencyMilliseconds(123)
 *                                         .port(123)
 *                                         // the properties below are optional
 *                                         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
 *                                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                         .roleArn("roleArn")
 *                                                         .secretArn("secretArn")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .sourcePriorityMode("sourcePriorityMode")
 *                         // the properties below are optional
 *                         .primarySourceIndex(123)
 *                         .build())
 *                 .mediaConnectFlow(MediaConnectFlowRouterInputConfigurationProperty.builder()
 *                         .sourceTransitDecryption(FlowTransitEncryptionProperty.builder()
 *                                 .encryptionKeyConfiguration(FlowTransitEncryptionKeyConfigurationProperty.builder()
 *                                         .automatic(automatic)
 *                                         .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                 .roleArn("roleArn")
 *                                                 .secretArn("secretArn")
 *                                                 .build())
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .encryptionKeyType("encryptionKeyType")
 *                                 .build())
 *                         // the properties below are optional
 *                         .flowArn("flowArn")
 *                         .flowOutputArn("flowOutputArn")
 *                         .build())
 *                 .merge(MergeRouterInputConfigurationProperty.builder()
 *                         .mergeRecoveryWindowMilliseconds(123)
 *                         .networkInterfaceArn("networkInterfaceArn")
 *                         .protocolConfigurations(List.of(MergeRouterInputProtocolConfigurationProperty.builder()
 *                                 .rist(RistRouterInputConfigurationProperty.builder()
 *                                         .port(123)
 *                                         .recoveryLatencyMilliseconds(123)
 *                                         .build())
 *                                 .rtp(RtpRouterInputConfigurationProperty.builder()
 *                                         .port(123)
 *                                         // the properties below are optional
 *                                         .forwardErrorCorrection("forwardErrorCorrection")
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .standard(StandardRouterInputConfigurationProperty.builder()
 *                         .networkInterfaceArn("networkInterfaceArn")
 *                         .protocolConfiguration(RouterInputProtocolConfigurationProperty.builder()
 *                                 .rist(RistRouterInputConfigurationProperty.builder()
 *                                         .port(123)
 *                                         .recoveryLatencyMilliseconds(123)
 *                                         .build())
 *                                 .rtp(RtpRouterInputConfigurationProperty.builder()
 *                                         .port(123)
 *                                         // the properties below are optional
 *                                         .forwardErrorCorrection("forwardErrorCorrection")
 *                                         .build())
 *                                 .srtCaller(SrtCallerRouterInputConfigurationProperty.builder()
 *                                         .minimumLatencyMilliseconds(123)
 *                                         .sourceAddress("sourceAddress")
 *                                         .sourcePort(123)
 *                                         // the properties below are optional
 *                                         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
 *                                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                         .roleArn("roleArn")
 *                                                         .secretArn("secretArn")
 *                                                         .build())
 *                                                 .build())
 *                                         .streamId("streamId")
 *                                         .build())
 *                                 .srtListener(SrtListenerRouterInputConfigurationProperty.builder()
 *                                         .minimumLatencyMilliseconds(123)
 *                                         .port(123)
 *                                         // the properties below are optional
 *                                         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
 *                                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                         .roleArn("roleArn")
 *                                                         .secretArn("secretArn")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .protocol("protocol")
 *                         .build())
 *                 .build())
 *         .maximumBitrate(123)
 *         .name("name")
 *         .routingScope("routingScope")
 *         .tier("tier")
 *         // the properties below are optional
 *         .availabilityZone("availabilityZone")
 *         .maintenanceConfiguration(MaintenanceConfigurationProperty.builder()
 *                 .default(default_)
 *                 .preferredDayTime(PreferredDayTimeMaintenanceConfigurationProperty.builder()
 *                         .day("day")
 *                         .time("time")
 *                         .build())
 *                 .build())
 *         .regionName("regionName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transitEncryption(RouterInputTransitEncryptionProperty.builder()
 *                 .encryptionKeyConfiguration(RouterInputTransitEncryptionKeyConfigurationProperty.builder()
 *                         .automatic(automatic)
 *                         .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .secretArn("secretArn")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .encryptionKeyType("encryptionKeyType")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:24.408Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput")
public class CfnRouterInput extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.mediaconnect.IRouterInputRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnRouterInput(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRouterInput(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::MediaConnect::RouterInput</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRouterInput(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediaconnect.CfnRouterInputProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForRouterInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.mediaconnect.IRouterInputRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.class, "arnForRouterInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnRouterInput.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnRouterInput(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.class, "isCfnRouterInput", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when the router input was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrInputType() {
        return software.amazon.jsii.Kernel.get(this, "attrInputType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP address of the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIpAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of maintenance configuration applied to this router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMaintenanceType() {
        return software.amazon.jsii.Kernel.get(this, "attrMaintenanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of router outputs associated with the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrRoutedOutputs() {
        return software.amazon.jsii.Kernel.get(this, "attrRoutedOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The current state of the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when the router input was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a RouterInput resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.mediaconnect.RouterInputReference getRouterInputRef() {
        return software.amazon.jsii.Kernel.get(this, "routerInputRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.mediaconnect.RouterInputReference.class));
    }

    /**
     * The configuration settings for a router input.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration settings for a router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * The configuration settings for a router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * The maximum bitrate for the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMaximumBitrate() {
        return software.amazon.jsii.Kernel.get(this, "maximumBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum bitrate for the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaximumBitrate(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maximumBitrate", java.util.Objects.requireNonNull(value, "maximumBitrate is required"));
    }

    /**
     * The name of the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Indicates whether the router input is configured for Regional or global routing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoutingScope() {
        return software.amazon.jsii.Kernel.get(this, "routingScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether the router input is configured for Regional or global routing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoutingScope(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "routingScope", java.util.Objects.requireNonNull(value, "routingScope is required"));
    }

    /**
     * The tier level of the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTier() {
        return software.amazon.jsii.Kernel.get(this, "tier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The tier level of the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tier", java.util.Objects.requireNonNull(value, "tier is required"));
    }

    /**
     * The Availability Zone of the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone of the router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", value);
    }

    /**
     * The maintenance configuration settings applied to this router input.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.MaintenanceConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "maintenanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The maintenance configuration settings applied to this router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceConfiguration", value);
    }

    /**
     * The maintenance configuration settings applied to this router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnRouterInput.MaintenanceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceConfiguration", value);
    }

    /**
     * The AWS Region where the router input is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRegionName() {
        return software.amazon.jsii.Kernel.get(this, "regionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Region where the router input is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegionName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "regionName", value);
    }

    /**
     * Key-value pairs that can be used to tag and organize this router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Key-value pairs that can be used to tag and organize this router input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * Encryption information.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputTransitEncryptionProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTransitEncryption() {
        return software.amazon.jsii.Kernel.get(this, "transitEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Encryption information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransitEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "transitEncryption", value);
    }

    /**
     * Encryption information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransitEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputTransitEncryptionProperty value) {
        software.amazon.jsii.Kernel.set(this, "transitEncryption", value);
    }
    /**
     * Configuration settings for a failover router input that allows switching between two input sources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * FailoverRouterInputConfigurationProperty failoverRouterInputConfigurationProperty = FailoverRouterInputConfigurationProperty.builder()
     *         .networkInterfaceArn("networkInterfaceArn")
     *         .protocolConfigurations(List.of(FailoverRouterInputProtocolConfigurationProperty.builder()
     *                 .rist(RistRouterInputConfigurationProperty.builder()
     *                         .port(123)
     *                         .recoveryLatencyMilliseconds(123)
     *                         .build())
     *                 .rtp(RtpRouterInputConfigurationProperty.builder()
     *                         .port(123)
     *                         // the properties below are optional
     *                         .forwardErrorCorrection("forwardErrorCorrection")
     *                         .build())
     *                 .srtCaller(SrtCallerRouterInputConfigurationProperty.builder()
     *                         .minimumLatencyMilliseconds(123)
     *                         .sourceAddress("sourceAddress")
     *                         .sourcePort(123)
     *                         // the properties below are optional
     *                         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                         .roleArn("roleArn")
     *                                         .secretArn("secretArn")
     *                                         .build())
     *                                 .build())
     *                         .streamId("streamId")
     *                         .build())
     *                 .srtListener(SrtListenerRouterInputConfigurationProperty.builder()
     *                         .minimumLatencyMilliseconds(123)
     *                         .port(123)
     *                         // the properties below are optional
     *                         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                         .roleArn("roleArn")
     *                                         .secretArn("secretArn")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .sourcePriorityMode("sourcePriorityMode")
     *         // the properties below are optional
     *         .primarySourceIndex(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.FailoverRouterInputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FailoverRouterInputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FailoverRouterInputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the network interface to use for this failover router input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputconfiguration-networkinterfacearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputconfiguration-networkinterfacearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNetworkInterfaceArn();

        /**
         * A list of exactly two protocol configurations for the failover input sources.
         * <p>
         * Both must use the same protocol type.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.FailoverRouterInputProtocolConfigurationProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputconfiguration-protocolconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputconfiguration-protocolconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getProtocolConfigurations();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputconfiguration-sourceprioritymode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputconfiguration-sourceprioritymode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourcePriorityMode();

        /**
         * The index (0 or 1) that specifies which source in the protocol configurations list is currently active.
         * <p>
         * Used to control which of the two failover sources is currently selected. This field is ignored when sourcePriorityMode is set to NO_PRIORITY
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputconfiguration-primarysourceindex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputconfiguration-primarysourceindex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPrimarySourceIndex() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FailoverRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FailoverRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FailoverRouterInputConfigurationProperty> {
            java.lang.String networkInterfaceArn;
            java.lang.Object protocolConfigurations;
            java.lang.String sourcePriorityMode;
            java.lang.Number primarySourceIndex;

            /**
             * Sets the value of {@link FailoverRouterInputConfigurationProperty#getNetworkInterfaceArn}
             * @param networkInterfaceArn The ARN of the network interface to use for this failover router input. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceArn(java.lang.String networkInterfaceArn) {
                this.networkInterfaceArn = networkInterfaceArn;
                return this;
            }

            /**
             * Sets the value of {@link FailoverRouterInputConfigurationProperty#getProtocolConfigurations}
             * @param protocolConfigurations A list of exactly two protocol configurations for the failover input sources. This parameter is required.
             *                               Both must use the same protocol type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolConfigurations(software.amazon.awscdk.IResolvable protocolConfigurations) {
                this.protocolConfigurations = protocolConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link FailoverRouterInputConfigurationProperty#getProtocolConfigurations}
             * @param protocolConfigurations A list of exactly two protocol configurations for the failover input sources. This parameter is required.
             *                               Both must use the same protocol type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolConfigurations(java.util.List<? extends java.lang.Object> protocolConfigurations) {
                this.protocolConfigurations = protocolConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link FailoverRouterInputConfigurationProperty#getSourcePriorityMode}
             * @param sourcePriorityMode the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePriorityMode(java.lang.String sourcePriorityMode) {
                this.sourcePriorityMode = sourcePriorityMode;
                return this;
            }

            /**
             * Sets the value of {@link FailoverRouterInputConfigurationProperty#getPrimarySourceIndex}
             * @param primarySourceIndex The index (0 or 1) that specifies which source in the protocol configurations list is currently active.
             *                           Used to control which of the two failover sources is currently selected. This field is ignored when sourcePriorityMode is set to NO_PRIORITY
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primarySourceIndex(java.lang.Number primarySourceIndex) {
                this.primarySourceIndex = primarySourceIndex;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FailoverRouterInputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FailoverRouterInputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FailoverRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FailoverRouterInputConfigurationProperty {
            private final java.lang.String networkInterfaceArn;
            private final java.lang.Object protocolConfigurations;
            private final java.lang.String sourcePriorityMode;
            private final java.lang.Number primarySourceIndex;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.networkInterfaceArn = software.amazon.jsii.Kernel.get(this, "networkInterfaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocolConfigurations = software.amazon.jsii.Kernel.get(this, "protocolConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourcePriorityMode = software.amazon.jsii.Kernel.get(this, "sourcePriorityMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.primarySourceIndex = software.amazon.jsii.Kernel.get(this, "primarySourceIndex", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.networkInterfaceArn = java.util.Objects.requireNonNull(builder.networkInterfaceArn, "networkInterfaceArn is required");
                this.protocolConfigurations = java.util.Objects.requireNonNull(builder.protocolConfigurations, "protocolConfigurations is required");
                this.sourcePriorityMode = java.util.Objects.requireNonNull(builder.sourcePriorityMode, "sourcePriorityMode is required");
                this.primarySourceIndex = builder.primarySourceIndex;
            }

            @Override
            public final java.lang.String getNetworkInterfaceArn() {
                return this.networkInterfaceArn;
            }

            @Override
            public final java.lang.Object getProtocolConfigurations() {
                return this.protocolConfigurations;
            }

            @Override
            public final java.lang.String getSourcePriorityMode() {
                return this.sourcePriorityMode;
            }

            @Override
            public final java.lang.Number getPrimarySourceIndex() {
                return this.primarySourceIndex;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("networkInterfaceArn", om.valueToTree(this.getNetworkInterfaceArn()));
                data.set("protocolConfigurations", om.valueToTree(this.getProtocolConfigurations()));
                data.set("sourcePriorityMode", om.valueToTree(this.getSourcePriorityMode()));
                if (this.getPrimarySourceIndex() != null) {
                    data.set("primarySourceIndex", om.valueToTree(this.getPrimarySourceIndex()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.FailoverRouterInputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FailoverRouterInputConfigurationProperty.Jsii$Proxy that = (FailoverRouterInputConfigurationProperty.Jsii$Proxy) o;

                if (!networkInterfaceArn.equals(that.networkInterfaceArn)) return false;
                if (!protocolConfigurations.equals(that.protocolConfigurations)) return false;
                if (!sourcePriorityMode.equals(that.sourcePriorityMode)) return false;
                return this.primarySourceIndex != null ? this.primarySourceIndex.equals(that.primarySourceIndex) : that.primarySourceIndex == null;
            }

            @Override
            public final int hashCode() {
                int result = this.networkInterfaceArn.hashCode();
                result = 31 * result + (this.protocolConfigurations.hashCode());
                result = 31 * result + (this.sourcePriorityMode.hashCode());
                result = 31 * result + (this.primarySourceIndex != null ? this.primarySourceIndex.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * FailoverRouterInputProtocolConfigurationProperty failoverRouterInputProtocolConfigurationProperty = FailoverRouterInputProtocolConfigurationProperty.builder()
     *         .rist(RistRouterInputConfigurationProperty.builder()
     *                 .port(123)
     *                 .recoveryLatencyMilliseconds(123)
     *                 .build())
     *         .rtp(RtpRouterInputConfigurationProperty.builder()
     *                 .port(123)
     *                 // the properties below are optional
     *                 .forwardErrorCorrection("forwardErrorCorrection")
     *                 .build())
     *         .srtCaller(SrtCallerRouterInputConfigurationProperty.builder()
     *                 .minimumLatencyMilliseconds(123)
     *                 .sourceAddress("sourceAddress")
     *                 .sourcePort(123)
     *                 // the properties below are optional
     *                 .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                 .roleArn("roleArn")
     *                                 .secretArn("secretArn")
     *                                 .build())
     *                         .build())
     *                 .streamId("streamId")
     *                 .build())
     *         .srtListener(SrtListenerRouterInputConfigurationProperty.builder()
     *                 .minimumLatencyMilliseconds(123)
     *                 .port(123)
     *                 // the properties below are optional
     *                 .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                 .roleArn("roleArn")
     *                                 .secretArn("secretArn")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.FailoverRouterInputProtocolConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FailoverRouterInputProtocolConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FailoverRouterInputProtocolConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration settings for a router input using the RIST (Reliable Internet Stream Transport) protocol, including the port and recovery latency.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RistRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration-rist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration-rist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRist() {
            return null;
        }

        /**
         * The configuration settings for a Router Input using the RTP (Real-Time Transport Protocol) protocol, including the port and forward error correction state.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RtpRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration-rtp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration-rtp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRtp() {
            return null;
        }

        /**
         * The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in caller mode, including the source address and port, minimum latency, stream ID, and decryption key configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SrtCallerRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration-srtcaller">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration-srtcaller</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSrtCaller() {
            return null;
        }

        /**
         * The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in listener mode, including the port, minimum latency, and decryption key configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SrtListenerRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration-srtlistener">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-failoverrouterinputprotocolconfiguration-srtlistener</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSrtListener() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FailoverRouterInputProtocolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FailoverRouterInputProtocolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FailoverRouterInputProtocolConfigurationProperty> {
            java.lang.Object rist;
            java.lang.Object rtp;
            java.lang.Object srtCaller;
            java.lang.Object srtListener;

            /**
             * Sets the value of {@link FailoverRouterInputProtocolConfigurationProperty#getRist}
             * @param rist The configuration settings for a router input using the RIST (Reliable Internet Stream Transport) protocol, including the port and recovery latency.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rist(software.amazon.awscdk.IResolvable rist) {
                this.rist = rist;
                return this;
            }

            /**
             * Sets the value of {@link FailoverRouterInputProtocolConfigurationProperty#getRist}
             * @param rist The configuration settings for a router input using the RIST (Reliable Internet Stream Transport) protocol, including the port and recovery latency.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rist(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RistRouterInputConfigurationProperty rist) {
                this.rist = rist;
                return this;
            }

            /**
             * Sets the value of {@link FailoverRouterInputProtocolConfigurationProperty#getRtp}
             * @param rtp The configuration settings for a Router Input using the RTP (Real-Time Transport Protocol) protocol, including the port and forward error correction state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rtp(software.amazon.awscdk.IResolvable rtp) {
                this.rtp = rtp;
                return this;
            }

            /**
             * Sets the value of {@link FailoverRouterInputProtocolConfigurationProperty#getRtp}
             * @param rtp The configuration settings for a Router Input using the RTP (Real-Time Transport Protocol) protocol, including the port and forward error correction state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rtp(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RtpRouterInputConfigurationProperty rtp) {
                this.rtp = rtp;
                return this;
            }

            /**
             * Sets the value of {@link FailoverRouterInputProtocolConfigurationProperty#getSrtCaller}
             * @param srtCaller The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in caller mode, including the source address and port, minimum latency, stream ID, and decryption key configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder srtCaller(software.amazon.awscdk.IResolvable srtCaller) {
                this.srtCaller = srtCaller;
                return this;
            }

            /**
             * Sets the value of {@link FailoverRouterInputProtocolConfigurationProperty#getSrtCaller}
             * @param srtCaller The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in caller mode, including the source address and port, minimum latency, stream ID, and decryption key configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder srtCaller(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SrtCallerRouterInputConfigurationProperty srtCaller) {
                this.srtCaller = srtCaller;
                return this;
            }

            /**
             * Sets the value of {@link FailoverRouterInputProtocolConfigurationProperty#getSrtListener}
             * @param srtListener The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in listener mode, including the port, minimum latency, and decryption key configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder srtListener(software.amazon.awscdk.IResolvable srtListener) {
                this.srtListener = srtListener;
                return this;
            }

            /**
             * Sets the value of {@link FailoverRouterInputProtocolConfigurationProperty#getSrtListener}
             * @param srtListener The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in listener mode, including the port, minimum latency, and decryption key configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder srtListener(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SrtListenerRouterInputConfigurationProperty srtListener) {
                this.srtListener = srtListener;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FailoverRouterInputProtocolConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FailoverRouterInputProtocolConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FailoverRouterInputProtocolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FailoverRouterInputProtocolConfigurationProperty {
            private final java.lang.Object rist;
            private final java.lang.Object rtp;
            private final java.lang.Object srtCaller;
            private final java.lang.Object srtListener;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rist = software.amazon.jsii.Kernel.get(this, "rist", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rtp = software.amazon.jsii.Kernel.get(this, "rtp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.srtCaller = software.amazon.jsii.Kernel.get(this, "srtCaller", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.srtListener = software.amazon.jsii.Kernel.get(this, "srtListener", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rist = builder.rist;
                this.rtp = builder.rtp;
                this.srtCaller = builder.srtCaller;
                this.srtListener = builder.srtListener;
            }

            @Override
            public final java.lang.Object getRist() {
                return this.rist;
            }

            @Override
            public final java.lang.Object getRtp() {
                return this.rtp;
            }

            @Override
            public final java.lang.Object getSrtCaller() {
                return this.srtCaller;
            }

            @Override
            public final java.lang.Object getSrtListener() {
                return this.srtListener;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRist() != null) {
                    data.set("rist", om.valueToTree(this.getRist()));
                }
                if (this.getRtp() != null) {
                    data.set("rtp", om.valueToTree(this.getRtp()));
                }
                if (this.getSrtCaller() != null) {
                    data.set("srtCaller", om.valueToTree(this.getSrtCaller()));
                }
                if (this.getSrtListener() != null) {
                    data.set("srtListener", om.valueToTree(this.getSrtListener()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.FailoverRouterInputProtocolConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FailoverRouterInputProtocolConfigurationProperty.Jsii$Proxy that = (FailoverRouterInputProtocolConfigurationProperty.Jsii$Proxy) o;

                if (this.rist != null ? !this.rist.equals(that.rist) : that.rist != null) return false;
                if (this.rtp != null ? !this.rtp.equals(that.rtp) : that.rtp != null) return false;
                if (this.srtCaller != null ? !this.srtCaller.equals(that.srtCaller) : that.srtCaller != null) return false;
                return this.srtListener != null ? this.srtListener.equals(that.srtListener) : that.srtListener == null;
            }

            @Override
            public final int hashCode() {
                int result = this.rist != null ? this.rist.hashCode() : 0;
                result = 31 * result + (this.rtp != null ? this.rtp.hashCode() : 0);
                result = 31 * result + (this.srtCaller != null ? this.srtCaller.hashCode() : 0);
                result = 31 * result + (this.srtListener != null ? this.srtListener.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object automatic;
     * FlowTransitEncryptionKeyConfigurationProperty flowTransitEncryptionKeyConfigurationProperty = FlowTransitEncryptionKeyConfigurationProperty.builder()
     *         .automatic(automatic)
     *         .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .secretArn("secretArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-flowtransitencryptionkeyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-flowtransitencryptionkeyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.FlowTransitEncryptionKeyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowTransitEncryptionKeyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowTransitEncryptionKeyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for automatic encryption key management, where MediaConnect handles key creation and rotation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-flowtransitencryptionkeyconfiguration.html#cfn-mediaconnect-routerinput-flowtransitencryptionkeyconfiguration-automatic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-flowtransitencryptionkeyconfiguration.html#cfn-mediaconnect-routerinput-flowtransitencryptionkeyconfiguration-automatic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomatic() {
            return null;
        }

        /**
         * The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SecretsManagerEncryptionKeyConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-flowtransitencryptionkeyconfiguration.html#cfn-mediaconnect-routerinput-flowtransitencryptionkeyconfiguration-secretsmanager">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-flowtransitencryptionkeyconfiguration.html#cfn-mediaconnect-routerinput-flowtransitencryptionkeyconfiguration-secretsmanager</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecretsManager() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowTransitEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowTransitEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowTransitEncryptionKeyConfigurationProperty> {
            java.lang.Object automatic;
            java.lang.Object secretsManager;

            /**
             * Sets the value of {@link FlowTransitEncryptionKeyConfigurationProperty#getAutomatic}
             * @param automatic Configuration settings for automatic encryption key management, where MediaConnect handles key creation and rotation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automatic(java.lang.Object automatic) {
                this.automatic = automatic;
                return this;
            }

            /**
             * Sets the value of {@link FlowTransitEncryptionKeyConfigurationProperty#getSecretsManager}
             * @param secretsManager The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManager(software.amazon.awscdk.IResolvable secretsManager) {
                this.secretsManager = secretsManager;
                return this;
            }

            /**
             * Sets the value of {@link FlowTransitEncryptionKeyConfigurationProperty#getSecretsManager}
             * @param secretsManager The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManager(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SecretsManagerEncryptionKeyConfigurationProperty secretsManager) {
                this.secretsManager = secretsManager;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowTransitEncryptionKeyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowTransitEncryptionKeyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowTransitEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowTransitEncryptionKeyConfigurationProperty {
            private final java.lang.Object automatic;
            private final java.lang.Object secretsManager;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.automatic = software.amazon.jsii.Kernel.get(this, "automatic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretsManager = software.amazon.jsii.Kernel.get(this, "secretsManager", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.automatic = builder.automatic;
                this.secretsManager = builder.secretsManager;
            }

            @Override
            public final java.lang.Object getAutomatic() {
                return this.automatic;
            }

            @Override
            public final java.lang.Object getSecretsManager() {
                return this.secretsManager;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutomatic() != null) {
                    data.set("automatic", om.valueToTree(this.getAutomatic()));
                }
                if (this.getSecretsManager() != null) {
                    data.set("secretsManager", om.valueToTree(this.getSecretsManager()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.FlowTransitEncryptionKeyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowTransitEncryptionKeyConfigurationProperty.Jsii$Proxy that = (FlowTransitEncryptionKeyConfigurationProperty.Jsii$Proxy) o;

                if (this.automatic != null ? !this.automatic.equals(that.automatic) : that.automatic != null) return false;
                return this.secretsManager != null ? this.secretsManager.equals(that.secretsManager) : that.secretsManager == null;
            }

            @Override
            public final int hashCode() {
                int result = this.automatic != null ? this.automatic.hashCode() : 0;
                result = 31 * result + (this.secretsManager != null ? this.secretsManager.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration that defines how content is encrypted during transit between the MediaConnect router and a MediaConnect flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object automatic;
     * FlowTransitEncryptionProperty flowTransitEncryptionProperty = FlowTransitEncryptionProperty.builder()
     *         .encryptionKeyConfiguration(FlowTransitEncryptionKeyConfigurationProperty.builder()
     *                 .automatic(automatic)
     *                 .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                         .roleArn("roleArn")
     *                         .secretArn("secretArn")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .encryptionKeyType("encryptionKeyType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-flowtransitencryption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-flowtransitencryption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.FlowTransitEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowTransitEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowTransitEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for flow transit encryption keys.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.FlowTransitEncryptionKeyConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-flowtransitencryption.html#cfn-mediaconnect-routerinput-flowtransitencryption-encryptionkeyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-flowtransitencryption.html#cfn-mediaconnect-routerinput-flowtransitencryption-encryptionkeyconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncryptionKeyConfiguration();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-flowtransitencryption.html#cfn-mediaconnect-routerinput-flowtransitencryption-encryptionkeytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-flowtransitencryption.html#cfn-mediaconnect-routerinput-flowtransitencryption-encryptionkeytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowTransitEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowTransitEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowTransitEncryptionProperty> {
            java.lang.Object encryptionKeyConfiguration;
            java.lang.String encryptionKeyType;

            /**
             * Sets the value of {@link FlowTransitEncryptionProperty#getEncryptionKeyConfiguration}
             * @param encryptionKeyConfiguration Configuration settings for flow transit encryption keys. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyConfiguration(software.amazon.awscdk.IResolvable encryptionKeyConfiguration) {
                this.encryptionKeyConfiguration = encryptionKeyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FlowTransitEncryptionProperty#getEncryptionKeyConfiguration}
             * @param encryptionKeyConfiguration Configuration settings for flow transit encryption keys. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyConfiguration(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.FlowTransitEncryptionKeyConfigurationProperty encryptionKeyConfiguration) {
                this.encryptionKeyConfiguration = encryptionKeyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FlowTransitEncryptionProperty#getEncryptionKeyType}
             * @param encryptionKeyType the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyType(java.lang.String encryptionKeyType) {
                this.encryptionKeyType = encryptionKeyType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowTransitEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowTransitEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowTransitEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowTransitEncryptionProperty {
            private final java.lang.Object encryptionKeyConfiguration;
            private final java.lang.String encryptionKeyType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionKeyConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionKeyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionKeyType = software.amazon.jsii.Kernel.get(this, "encryptionKeyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionKeyConfiguration = java.util.Objects.requireNonNull(builder.encryptionKeyConfiguration, "encryptionKeyConfiguration is required");
                this.encryptionKeyType = builder.encryptionKeyType;
            }

            @Override
            public final java.lang.Object getEncryptionKeyConfiguration() {
                return this.encryptionKeyConfiguration;
            }

            @Override
            public final java.lang.String getEncryptionKeyType() {
                return this.encryptionKeyType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionKeyConfiguration", om.valueToTree(this.getEncryptionKeyConfiguration()));
                if (this.getEncryptionKeyType() != null) {
                    data.set("encryptionKeyType", om.valueToTree(this.getEncryptionKeyType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.FlowTransitEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowTransitEncryptionProperty.Jsii$Proxy that = (FlowTransitEncryptionProperty.Jsii$Proxy) o;

                if (!encryptionKeyConfiguration.equals(that.encryptionKeyConfiguration)) return false;
                return this.encryptionKeyType != null ? this.encryptionKeyType.equals(that.encryptionKeyType) : that.encryptionKeyType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionKeyConfiguration.hashCode();
                result = 31 * result + (this.encryptionKeyType != null ? this.encryptionKeyType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object default_;
     * MaintenanceConfigurationProperty maintenanceConfigurationProperty = MaintenanceConfigurationProperty.builder()
     *         .default(default_)
     *         .preferredDayTime(PreferredDayTimeMaintenanceConfigurationProperty.builder()
     *                 .day("day")
     *                 .time("time")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-maintenanceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-maintenanceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.MaintenanceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for default maintenance scheduling.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-maintenanceconfiguration.html#cfn-mediaconnect-routerinput-maintenanceconfiguration-default">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-maintenanceconfiguration.html#cfn-mediaconnect-routerinput-maintenanceconfiguration-default</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValue() {
            return null;
        }

        /**
         * Configuration for preferred day and time maintenance settings.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.PreferredDayTimeMaintenanceConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-maintenanceconfiguration.html#cfn-mediaconnect-routerinput-maintenanceconfiguration-preferreddaytime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-maintenanceconfiguration.html#cfn-mediaconnect-routerinput-maintenanceconfiguration-preferreddaytime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPreferredDayTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceConfigurationProperty> {
            java.lang.Object defaultValue;
            java.lang.Object preferredDayTime;

            /**
             * Sets the value of {@link MaintenanceConfigurationProperty#getDefaultValue}
             * @param defaultValue Configuration settings for default maintenance scheduling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.Object defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceConfigurationProperty#getPreferredDayTime}
             * @param preferredDayTime Configuration for preferred day and time maintenance settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preferredDayTime(software.amazon.awscdk.IResolvable preferredDayTime) {
                this.preferredDayTime = preferredDayTime;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceConfigurationProperty#getPreferredDayTime}
             * @param preferredDayTime Configuration for preferred day and time maintenance settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preferredDayTime(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.PreferredDayTimeMaintenanceConfigurationProperty preferredDayTime) {
                this.preferredDayTime = preferredDayTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceConfigurationProperty {
            private final java.lang.Object defaultValue;
            private final java.lang.Object preferredDayTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "default", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.preferredDayTime = software.amazon.jsii.Kernel.get(this, "preferredDayTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultValue = builder.defaultValue;
                this.preferredDayTime = builder.preferredDayTime;
            }

            @Override
            public final java.lang.Object getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            public final java.lang.Object getPreferredDayTime() {
                return this.preferredDayTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultValue() != null) {
                    data.set("default", om.valueToTree(this.getDefaultValue()));
                }
                if (this.getPreferredDayTime() != null) {
                    data.set("preferredDayTime", om.valueToTree(this.getPreferredDayTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.MaintenanceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceConfigurationProperty.Jsii$Proxy that = (MaintenanceConfigurationProperty.Jsii$Proxy) o;

                if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
                return this.preferredDayTime != null ? this.preferredDayTime.equals(that.preferredDayTime) : that.preferredDayTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultValue != null ? this.defaultValue.hashCode() : 0;
                result = 31 * result + (this.preferredDayTime != null ? this.preferredDayTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for connecting a router input to a flow output.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object automatic;
     * MediaConnectFlowRouterInputConfigurationProperty mediaConnectFlowRouterInputConfigurationProperty = MediaConnectFlowRouterInputConfigurationProperty.builder()
     *         .sourceTransitDecryption(FlowTransitEncryptionProperty.builder()
     *                 .encryptionKeyConfiguration(FlowTransitEncryptionKeyConfigurationProperty.builder()
     *                         .automatic(automatic)
     *                         .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                 .roleArn("roleArn")
     *                                 .secretArn("secretArn")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .encryptionKeyType("encryptionKeyType")
     *                 .build())
     *         // the properties below are optional
     *         .flowArn("flowArn")
     *         .flowOutputArn("flowOutputArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.MediaConnectFlowRouterInputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MediaConnectFlowRouterInputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MediaConnectFlowRouterInputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration that defines how content is encrypted during transit between the MediaConnect router and a MediaConnect flow.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.FlowTransitEncryptionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration.html#cfn-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration-sourcetransitdecryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration.html#cfn-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration-sourcetransitdecryption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceTransitDecryption();

        /**
         * The ARN of the flow to connect to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration.html#cfn-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration-flowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration.html#cfn-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration-flowarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFlowArn() {
            return null;
        }

        /**
         * The ARN of the flow output to connect to this router input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration.html#cfn-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration-flowoutputarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration.html#cfn-mediaconnect-routerinput-mediaconnectflowrouterinputconfiguration-flowoutputarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFlowOutputArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MediaConnectFlowRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MediaConnectFlowRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MediaConnectFlowRouterInputConfigurationProperty> {
            java.lang.Object sourceTransitDecryption;
            java.lang.String flowArn;
            java.lang.String flowOutputArn;

            /**
             * Sets the value of {@link MediaConnectFlowRouterInputConfigurationProperty#getSourceTransitDecryption}
             * @param sourceTransitDecryption The configuration that defines how content is encrypted during transit between the MediaConnect router and a MediaConnect flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTransitDecryption(software.amazon.awscdk.IResolvable sourceTransitDecryption) {
                this.sourceTransitDecryption = sourceTransitDecryption;
                return this;
            }

            /**
             * Sets the value of {@link MediaConnectFlowRouterInputConfigurationProperty#getSourceTransitDecryption}
             * @param sourceTransitDecryption The configuration that defines how content is encrypted during transit between the MediaConnect router and a MediaConnect flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTransitDecryption(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.FlowTransitEncryptionProperty sourceTransitDecryption) {
                this.sourceTransitDecryption = sourceTransitDecryption;
                return this;
            }

            /**
             * Sets the value of {@link MediaConnectFlowRouterInputConfigurationProperty#getFlowArn}
             * @param flowArn The ARN of the flow to connect to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flowArn(java.lang.String flowArn) {
                this.flowArn = flowArn;
                return this;
            }

            /**
             * Sets the value of {@link MediaConnectFlowRouterInputConfigurationProperty#getFlowOutputArn}
             * @param flowOutputArn The ARN of the flow output to connect to this router input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flowOutputArn(java.lang.String flowOutputArn) {
                this.flowOutputArn = flowOutputArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MediaConnectFlowRouterInputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MediaConnectFlowRouterInputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MediaConnectFlowRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MediaConnectFlowRouterInputConfigurationProperty {
            private final java.lang.Object sourceTransitDecryption;
            private final java.lang.String flowArn;
            private final java.lang.String flowOutputArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceTransitDecryption = software.amazon.jsii.Kernel.get(this, "sourceTransitDecryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.flowArn = software.amazon.jsii.Kernel.get(this, "flowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.flowOutputArn = software.amazon.jsii.Kernel.get(this, "flowOutputArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceTransitDecryption = java.util.Objects.requireNonNull(builder.sourceTransitDecryption, "sourceTransitDecryption is required");
                this.flowArn = builder.flowArn;
                this.flowOutputArn = builder.flowOutputArn;
            }

            @Override
            public final java.lang.Object getSourceTransitDecryption() {
                return this.sourceTransitDecryption;
            }

            @Override
            public final java.lang.String getFlowArn() {
                return this.flowArn;
            }

            @Override
            public final java.lang.String getFlowOutputArn() {
                return this.flowOutputArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceTransitDecryption", om.valueToTree(this.getSourceTransitDecryption()));
                if (this.getFlowArn() != null) {
                    data.set("flowArn", om.valueToTree(this.getFlowArn()));
                }
                if (this.getFlowOutputArn() != null) {
                    data.set("flowOutputArn", om.valueToTree(this.getFlowOutputArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.MediaConnectFlowRouterInputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MediaConnectFlowRouterInputConfigurationProperty.Jsii$Proxy that = (MediaConnectFlowRouterInputConfigurationProperty.Jsii$Proxy) o;

                if (!sourceTransitDecryption.equals(that.sourceTransitDecryption)) return false;
                if (this.flowArn != null ? !this.flowArn.equals(that.flowArn) : that.flowArn != null) return false;
                return this.flowOutputArn != null ? this.flowOutputArn.equals(that.flowOutputArn) : that.flowOutputArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceTransitDecryption.hashCode();
                result = 31 * result + (this.flowArn != null ? this.flowArn.hashCode() : 0);
                result = 31 * result + (this.flowOutputArn != null ? this.flowOutputArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for a merge router input that combines two input sources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * MergeRouterInputConfigurationProperty mergeRouterInputConfigurationProperty = MergeRouterInputConfigurationProperty.builder()
     *         .mergeRecoveryWindowMilliseconds(123)
     *         .networkInterfaceArn("networkInterfaceArn")
     *         .protocolConfigurations(List.of(MergeRouterInputProtocolConfigurationProperty.builder()
     *                 .rist(RistRouterInputConfigurationProperty.builder()
     *                         .port(123)
     *                         .recoveryLatencyMilliseconds(123)
     *                         .build())
     *                 .rtp(RtpRouterInputConfigurationProperty.builder()
     *                         .port(123)
     *                         // the properties below are optional
     *                         .forwardErrorCorrection("forwardErrorCorrection")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.MergeRouterInputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MergeRouterInputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MergeRouterInputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time window in milliseconds for merging the two input sources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputconfiguration.html#cfn-mediaconnect-routerinput-mergerouterinputconfiguration-mergerecoverywindowmilliseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputconfiguration.html#cfn-mediaconnect-routerinput-mergerouterinputconfiguration-mergerecoverywindowmilliseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMergeRecoveryWindowMilliseconds();

        /**
         * The ARN of the network interface to use for this merge router input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputconfiguration.html#cfn-mediaconnect-routerinput-mergerouterinputconfiguration-networkinterfacearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputconfiguration.html#cfn-mediaconnect-routerinput-mergerouterinputconfiguration-networkinterfacearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNetworkInterfaceArn();

        /**
         * A list of exactly two protocol configurations for the merge input sources.
         * <p>
         * Both must use the same protocol type.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.MergeRouterInputProtocolConfigurationProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputconfiguration.html#cfn-mediaconnect-routerinput-mergerouterinputconfiguration-protocolconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputconfiguration.html#cfn-mediaconnect-routerinput-mergerouterinputconfiguration-protocolconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getProtocolConfigurations();

        /**
         * @return a {@link Builder} of {@link MergeRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MergeRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MergeRouterInputConfigurationProperty> {
            java.lang.Number mergeRecoveryWindowMilliseconds;
            java.lang.String networkInterfaceArn;
            java.lang.Object protocolConfigurations;

            /**
             * Sets the value of {@link MergeRouterInputConfigurationProperty#getMergeRecoveryWindowMilliseconds}
             * @param mergeRecoveryWindowMilliseconds The time window in milliseconds for merging the two input sources. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mergeRecoveryWindowMilliseconds(java.lang.Number mergeRecoveryWindowMilliseconds) {
                this.mergeRecoveryWindowMilliseconds = mergeRecoveryWindowMilliseconds;
                return this;
            }

            /**
             * Sets the value of {@link MergeRouterInputConfigurationProperty#getNetworkInterfaceArn}
             * @param networkInterfaceArn The ARN of the network interface to use for this merge router input. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceArn(java.lang.String networkInterfaceArn) {
                this.networkInterfaceArn = networkInterfaceArn;
                return this;
            }

            /**
             * Sets the value of {@link MergeRouterInputConfigurationProperty#getProtocolConfigurations}
             * @param protocolConfigurations A list of exactly two protocol configurations for the merge input sources. This parameter is required.
             *                               Both must use the same protocol type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolConfigurations(software.amazon.awscdk.IResolvable protocolConfigurations) {
                this.protocolConfigurations = protocolConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link MergeRouterInputConfigurationProperty#getProtocolConfigurations}
             * @param protocolConfigurations A list of exactly two protocol configurations for the merge input sources. This parameter is required.
             *                               Both must use the same protocol type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolConfigurations(java.util.List<? extends java.lang.Object> protocolConfigurations) {
                this.protocolConfigurations = protocolConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MergeRouterInputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MergeRouterInputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MergeRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MergeRouterInputConfigurationProperty {
            private final java.lang.Number mergeRecoveryWindowMilliseconds;
            private final java.lang.String networkInterfaceArn;
            private final java.lang.Object protocolConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mergeRecoveryWindowMilliseconds = software.amazon.jsii.Kernel.get(this, "mergeRecoveryWindowMilliseconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.networkInterfaceArn = software.amazon.jsii.Kernel.get(this, "networkInterfaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocolConfigurations = software.amazon.jsii.Kernel.get(this, "protocolConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mergeRecoveryWindowMilliseconds = java.util.Objects.requireNonNull(builder.mergeRecoveryWindowMilliseconds, "mergeRecoveryWindowMilliseconds is required");
                this.networkInterfaceArn = java.util.Objects.requireNonNull(builder.networkInterfaceArn, "networkInterfaceArn is required");
                this.protocolConfigurations = java.util.Objects.requireNonNull(builder.protocolConfigurations, "protocolConfigurations is required");
            }

            @Override
            public final java.lang.Number getMergeRecoveryWindowMilliseconds() {
                return this.mergeRecoveryWindowMilliseconds;
            }

            @Override
            public final java.lang.String getNetworkInterfaceArn() {
                return this.networkInterfaceArn;
            }

            @Override
            public final java.lang.Object getProtocolConfigurations() {
                return this.protocolConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mergeRecoveryWindowMilliseconds", om.valueToTree(this.getMergeRecoveryWindowMilliseconds()));
                data.set("networkInterfaceArn", om.valueToTree(this.getNetworkInterfaceArn()));
                data.set("protocolConfigurations", om.valueToTree(this.getProtocolConfigurations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.MergeRouterInputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MergeRouterInputConfigurationProperty.Jsii$Proxy that = (MergeRouterInputConfigurationProperty.Jsii$Proxy) o;

                if (!mergeRecoveryWindowMilliseconds.equals(that.mergeRecoveryWindowMilliseconds)) return false;
                if (!networkInterfaceArn.equals(that.networkInterfaceArn)) return false;
                return this.protocolConfigurations.equals(that.protocolConfigurations);
            }

            @Override
            public final int hashCode() {
                int result = this.mergeRecoveryWindowMilliseconds.hashCode();
                result = 31 * result + (this.networkInterfaceArn.hashCode());
                result = 31 * result + (this.protocolConfigurations.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * MergeRouterInputProtocolConfigurationProperty mergeRouterInputProtocolConfigurationProperty = MergeRouterInputProtocolConfigurationProperty.builder()
     *         .rist(RistRouterInputConfigurationProperty.builder()
     *                 .port(123)
     *                 .recoveryLatencyMilliseconds(123)
     *                 .build())
     *         .rtp(RtpRouterInputConfigurationProperty.builder()
     *                 .port(123)
     *                 // the properties below are optional
     *                 .forwardErrorCorrection("forwardErrorCorrection")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputprotocolconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputprotocolconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.MergeRouterInputProtocolConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MergeRouterInputProtocolConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MergeRouterInputProtocolConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration settings for a router input using the RIST (Reliable Internet Stream Transport) protocol, including the port and recovery latency.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RistRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-mergerouterinputprotocolconfiguration-rist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-mergerouterinputprotocolconfiguration-rist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRist() {
            return null;
        }

        /**
         * The configuration settings for a Router Input using the RTP (Real-Time Transport Protocol) protocol, including the port and forward error correction state.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RtpRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-mergerouterinputprotocolconfiguration-rtp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-mergerouterinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-mergerouterinputprotocolconfiguration-rtp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRtp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MergeRouterInputProtocolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MergeRouterInputProtocolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MergeRouterInputProtocolConfigurationProperty> {
            java.lang.Object rist;
            java.lang.Object rtp;

            /**
             * Sets the value of {@link MergeRouterInputProtocolConfigurationProperty#getRist}
             * @param rist The configuration settings for a router input using the RIST (Reliable Internet Stream Transport) protocol, including the port and recovery latency.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rist(software.amazon.awscdk.IResolvable rist) {
                this.rist = rist;
                return this;
            }

            /**
             * Sets the value of {@link MergeRouterInputProtocolConfigurationProperty#getRist}
             * @param rist The configuration settings for a router input using the RIST (Reliable Internet Stream Transport) protocol, including the port and recovery latency.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rist(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RistRouterInputConfigurationProperty rist) {
                this.rist = rist;
                return this;
            }

            /**
             * Sets the value of {@link MergeRouterInputProtocolConfigurationProperty#getRtp}
             * @param rtp The configuration settings for a Router Input using the RTP (Real-Time Transport Protocol) protocol, including the port and forward error correction state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rtp(software.amazon.awscdk.IResolvable rtp) {
                this.rtp = rtp;
                return this;
            }

            /**
             * Sets the value of {@link MergeRouterInputProtocolConfigurationProperty#getRtp}
             * @param rtp The configuration settings for a Router Input using the RTP (Real-Time Transport Protocol) protocol, including the port and forward error correction state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rtp(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RtpRouterInputConfigurationProperty rtp) {
                this.rtp = rtp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MergeRouterInputProtocolConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MergeRouterInputProtocolConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MergeRouterInputProtocolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MergeRouterInputProtocolConfigurationProperty {
            private final java.lang.Object rist;
            private final java.lang.Object rtp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rist = software.amazon.jsii.Kernel.get(this, "rist", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rtp = software.amazon.jsii.Kernel.get(this, "rtp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rist = builder.rist;
                this.rtp = builder.rtp;
            }

            @Override
            public final java.lang.Object getRist() {
                return this.rist;
            }

            @Override
            public final java.lang.Object getRtp() {
                return this.rtp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRist() != null) {
                    data.set("rist", om.valueToTree(this.getRist()));
                }
                if (this.getRtp() != null) {
                    data.set("rtp", om.valueToTree(this.getRtp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.MergeRouterInputProtocolConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MergeRouterInputProtocolConfigurationProperty.Jsii$Proxy that = (MergeRouterInputProtocolConfigurationProperty.Jsii$Proxy) o;

                if (this.rist != null ? !this.rist.equals(that.rist) : that.rist != null) return false;
                return this.rtp != null ? this.rtp.equals(that.rtp) : that.rtp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.rist != null ? this.rist.hashCode() : 0;
                result = 31 * result + (this.rtp != null ? this.rtp.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for preferred day and time maintenance settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * PreferredDayTimeMaintenanceConfigurationProperty preferredDayTimeMaintenanceConfigurationProperty = PreferredDayTimeMaintenanceConfigurationProperty.builder()
     *         .day("day")
     *         .time("time")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-preferreddaytimemaintenanceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-preferreddaytimemaintenanceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.PreferredDayTimeMaintenanceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PreferredDayTimeMaintenanceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PreferredDayTimeMaintenanceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-preferreddaytimemaintenanceconfiguration.html#cfn-mediaconnect-routerinput-preferreddaytimemaintenanceconfiguration-day">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-preferreddaytimemaintenanceconfiguration.html#cfn-mediaconnect-routerinput-preferreddaytimemaintenanceconfiguration-day</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDay();

        /**
         * The preferred time for maintenance operations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-preferreddaytimemaintenanceconfiguration.html#cfn-mediaconnect-routerinput-preferreddaytimemaintenanceconfiguration-time">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-preferreddaytimemaintenanceconfiguration.html#cfn-mediaconnect-routerinput-preferreddaytimemaintenanceconfiguration-time</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTime();

        /**
         * @return a {@link Builder} of {@link PreferredDayTimeMaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PreferredDayTimeMaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PreferredDayTimeMaintenanceConfigurationProperty> {
            java.lang.String day;
            java.lang.String time;

            /**
             * Sets the value of {@link PreferredDayTimeMaintenanceConfigurationProperty#getDay}
             * @param day the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder day(java.lang.String day) {
                this.day = day;
                return this;
            }

            /**
             * Sets the value of {@link PreferredDayTimeMaintenanceConfigurationProperty#getTime}
             * @param time The preferred time for maintenance operations. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder time(java.lang.String time) {
                this.time = time;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PreferredDayTimeMaintenanceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PreferredDayTimeMaintenanceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PreferredDayTimeMaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PreferredDayTimeMaintenanceConfigurationProperty {
            private final java.lang.String day;
            private final java.lang.String time;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.day = software.amazon.jsii.Kernel.get(this, "day", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.time = software.amazon.jsii.Kernel.get(this, "time", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.day = java.util.Objects.requireNonNull(builder.day, "day is required");
                this.time = java.util.Objects.requireNonNull(builder.time, "time is required");
            }

            @Override
            public final java.lang.String getDay() {
                return this.day;
            }

            @Override
            public final java.lang.String getTime() {
                return this.time;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("day", om.valueToTree(this.getDay()));
                data.set("time", om.valueToTree(this.getTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.PreferredDayTimeMaintenanceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PreferredDayTimeMaintenanceConfigurationProperty.Jsii$Proxy that = (PreferredDayTimeMaintenanceConfigurationProperty.Jsii$Proxy) o;

                if (!day.equals(that.day)) return false;
                return this.time.equals(that.time);
            }

            @Override
            public final int hashCode() {
                int result = this.day.hashCode();
                result = 31 * result + (this.time.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration settings for a router input using the RIST (Reliable Internet Stream Transport) protocol, including the port and recovery latency.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * RistRouterInputConfigurationProperty ristRouterInputConfigurationProperty = RistRouterInputConfigurationProperty.builder()
     *         .port(123)
     *         .recoveryLatencyMilliseconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-ristrouterinputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-ristrouterinputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.RistRouterInputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RistRouterInputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RistRouterInputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The port number used for the RIST protocol in the router input configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-ristrouterinputconfiguration.html#cfn-mediaconnect-routerinput-ristrouterinputconfiguration-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-ristrouterinputconfiguration.html#cfn-mediaconnect-routerinput-ristrouterinputconfiguration-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The recovery latency in milliseconds for the RIST protocol in the router input configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-ristrouterinputconfiguration.html#cfn-mediaconnect-routerinput-ristrouterinputconfiguration-recoverylatencymilliseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-ristrouterinputconfiguration.html#cfn-mediaconnect-routerinput-ristrouterinputconfiguration-recoverylatencymilliseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getRecoveryLatencyMilliseconds();

        /**
         * @return a {@link Builder} of {@link RistRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RistRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RistRouterInputConfigurationProperty> {
            java.lang.Number port;
            java.lang.Number recoveryLatencyMilliseconds;

            /**
             * Sets the value of {@link RistRouterInputConfigurationProperty#getPort}
             * @param port The port number used for the RIST protocol in the router input configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link RistRouterInputConfigurationProperty#getRecoveryLatencyMilliseconds}
             * @param recoveryLatencyMilliseconds The recovery latency in milliseconds for the RIST protocol in the router input configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recoveryLatencyMilliseconds(java.lang.Number recoveryLatencyMilliseconds) {
                this.recoveryLatencyMilliseconds = recoveryLatencyMilliseconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RistRouterInputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RistRouterInputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RistRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RistRouterInputConfigurationProperty {
            private final java.lang.Number port;
            private final java.lang.Number recoveryLatencyMilliseconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.recoveryLatencyMilliseconds = software.amazon.jsii.Kernel.get(this, "recoveryLatencyMilliseconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.recoveryLatencyMilliseconds = java.util.Objects.requireNonNull(builder.recoveryLatencyMilliseconds, "recoveryLatencyMilliseconds is required");
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.Number getRecoveryLatencyMilliseconds() {
                return this.recoveryLatencyMilliseconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("port", om.valueToTree(this.getPort()));
                data.set("recoveryLatencyMilliseconds", om.valueToTree(this.getRecoveryLatencyMilliseconds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.RistRouterInputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RistRouterInputConfigurationProperty.Jsii$Proxy that = (RistRouterInputConfigurationProperty.Jsii$Proxy) o;

                if (!port.equals(that.port)) return false;
                return this.recoveryLatencyMilliseconds.equals(that.recoveryLatencyMilliseconds);
            }

            @Override
            public final int hashCode() {
                int result = this.port.hashCode();
                result = 31 * result + (this.recoveryLatencyMilliseconds.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object automatic;
     * RouterInputConfigurationProperty routerInputConfigurationProperty = RouterInputConfigurationProperty.builder()
     *         .failover(FailoverRouterInputConfigurationProperty.builder()
     *                 .networkInterfaceArn("networkInterfaceArn")
     *                 .protocolConfigurations(List.of(FailoverRouterInputProtocolConfigurationProperty.builder()
     *                         .rist(RistRouterInputConfigurationProperty.builder()
     *                                 .port(123)
     *                                 .recoveryLatencyMilliseconds(123)
     *                                 .build())
     *                         .rtp(RtpRouterInputConfigurationProperty.builder()
     *                                 .port(123)
     *                                 // the properties below are optional
     *                                 .forwardErrorCorrection("forwardErrorCorrection")
     *                                 .build())
     *                         .srtCaller(SrtCallerRouterInputConfigurationProperty.builder()
     *                                 .minimumLatencyMilliseconds(123)
     *                                 .sourceAddress("sourceAddress")
     *                                 .sourcePort(123)
     *                                 // the properties below are optional
     *                                 .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                                         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                                 .roleArn("roleArn")
     *                                                 .secretArn("secretArn")
     *                                                 .build())
     *                                         .build())
     *                                 .streamId("streamId")
     *                                 .build())
     *                         .srtListener(SrtListenerRouterInputConfigurationProperty.builder()
     *                                 .minimumLatencyMilliseconds(123)
     *                                 .port(123)
     *                                 // the properties below are optional
     *                                 .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                                         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                                 .roleArn("roleArn")
     *                                                 .secretArn("secretArn")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build()))
     *                 .sourcePriorityMode("sourcePriorityMode")
     *                 // the properties below are optional
     *                 .primarySourceIndex(123)
     *                 .build())
     *         .mediaConnectFlow(MediaConnectFlowRouterInputConfigurationProperty.builder()
     *                 .sourceTransitDecryption(FlowTransitEncryptionProperty.builder()
     *                         .encryptionKeyConfiguration(FlowTransitEncryptionKeyConfigurationProperty.builder()
     *                                 .automatic(automatic)
     *                                 .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                         .roleArn("roleArn")
     *                                         .secretArn("secretArn")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .encryptionKeyType("encryptionKeyType")
     *                         .build())
     *                 // the properties below are optional
     *                 .flowArn("flowArn")
     *                 .flowOutputArn("flowOutputArn")
     *                 .build())
     *         .merge(MergeRouterInputConfigurationProperty.builder()
     *                 .mergeRecoveryWindowMilliseconds(123)
     *                 .networkInterfaceArn("networkInterfaceArn")
     *                 .protocolConfigurations(List.of(MergeRouterInputProtocolConfigurationProperty.builder()
     *                         .rist(RistRouterInputConfigurationProperty.builder()
     *                                 .port(123)
     *                                 .recoveryLatencyMilliseconds(123)
     *                                 .build())
     *                         .rtp(RtpRouterInputConfigurationProperty.builder()
     *                                 .port(123)
     *                                 // the properties below are optional
     *                                 .forwardErrorCorrection("forwardErrorCorrection")
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .standard(StandardRouterInputConfigurationProperty.builder()
     *                 .networkInterfaceArn("networkInterfaceArn")
     *                 .protocolConfiguration(RouterInputProtocolConfigurationProperty.builder()
     *                         .rist(RistRouterInputConfigurationProperty.builder()
     *                                 .port(123)
     *                                 .recoveryLatencyMilliseconds(123)
     *                                 .build())
     *                         .rtp(RtpRouterInputConfigurationProperty.builder()
     *                                 .port(123)
     *                                 // the properties below are optional
     *                                 .forwardErrorCorrection("forwardErrorCorrection")
     *                                 .build())
     *                         .srtCaller(SrtCallerRouterInputConfigurationProperty.builder()
     *                                 .minimumLatencyMilliseconds(123)
     *                                 .sourceAddress("sourceAddress")
     *                                 .sourcePort(123)
     *                                 // the properties below are optional
     *                                 .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                                         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                                 .roleArn("roleArn")
     *                                                 .secretArn("secretArn")
     *                                                 .build())
     *                                         .build())
     *                                 .streamId("streamId")
     *                                 .build())
     *                         .srtListener(SrtListenerRouterInputConfigurationProperty.builder()
     *                                 .minimumLatencyMilliseconds(123)
     *                                 .port(123)
     *                                 // the properties below are optional
     *                                 .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                                         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                                 .roleArn("roleArn")
     *                                                 .secretArn("secretArn")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .protocol("protocol")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.RouterInputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RouterInputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RouterInputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for a failover router input that allows switching between two input sources.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.FailoverRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputconfiguration.html#cfn-mediaconnect-routerinput-routerinputconfiguration-failover">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputconfiguration.html#cfn-mediaconnect-routerinput-routerinputconfiguration-failover</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailover() {
            return null;
        }

        /**
         * Configuration settings for connecting a router input to a flow output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.MediaConnectFlowRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputconfiguration.html#cfn-mediaconnect-routerinput-routerinputconfiguration-mediaconnectflow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputconfiguration.html#cfn-mediaconnect-routerinput-routerinputconfiguration-mediaconnectflow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMediaConnectFlow() {
            return null;
        }

        /**
         * Configuration settings for a merge router input that combines two input sources.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.MergeRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputconfiguration.html#cfn-mediaconnect-routerinput-routerinputconfiguration-merge">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputconfiguration.html#cfn-mediaconnect-routerinput-routerinputconfiguration-merge</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMerge() {
            return null;
        }

        /**
         * The configuration settings for a standard router input, including the protocol, protocol-specific configuration, network interface, and availability zone.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.StandardRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputconfiguration.html#cfn-mediaconnect-routerinput-routerinputconfiguration-standard">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputconfiguration.html#cfn-mediaconnect-routerinput-routerinputconfiguration-standard</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStandard() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RouterInputConfigurationProperty> {
            java.lang.Object failover;
            java.lang.Object mediaConnectFlow;
            java.lang.Object merge;
            java.lang.Object standard;

            /**
             * Sets the value of {@link RouterInputConfigurationProperty#getFailover}
             * @param failover Configuration settings for a failover router input that allows switching between two input sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failover(software.amazon.awscdk.IResolvable failover) {
                this.failover = failover;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputConfigurationProperty#getFailover}
             * @param failover Configuration settings for a failover router input that allows switching between two input sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failover(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.FailoverRouterInputConfigurationProperty failover) {
                this.failover = failover;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputConfigurationProperty#getMediaConnectFlow}
             * @param mediaConnectFlow Configuration settings for connecting a router input to a flow output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaConnectFlow(software.amazon.awscdk.IResolvable mediaConnectFlow) {
                this.mediaConnectFlow = mediaConnectFlow;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputConfigurationProperty#getMediaConnectFlow}
             * @param mediaConnectFlow Configuration settings for connecting a router input to a flow output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaConnectFlow(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.MediaConnectFlowRouterInputConfigurationProperty mediaConnectFlow) {
                this.mediaConnectFlow = mediaConnectFlow;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputConfigurationProperty#getMerge}
             * @param merge Configuration settings for a merge router input that combines two input sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder merge(software.amazon.awscdk.IResolvable merge) {
                this.merge = merge;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputConfigurationProperty#getMerge}
             * @param merge Configuration settings for a merge router input that combines two input sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder merge(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.MergeRouterInputConfigurationProperty merge) {
                this.merge = merge;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputConfigurationProperty#getStandard}
             * @param standard The configuration settings for a standard router input, including the protocol, protocol-specific configuration, network interface, and availability zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder standard(software.amazon.awscdk.IResolvable standard) {
                this.standard = standard;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputConfigurationProperty#getStandard}
             * @param standard The configuration settings for a standard router input, including the protocol, protocol-specific configuration, network interface, and availability zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder standard(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.StandardRouterInputConfigurationProperty standard) {
                this.standard = standard;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RouterInputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RouterInputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouterInputConfigurationProperty {
            private final java.lang.Object failover;
            private final java.lang.Object mediaConnectFlow;
            private final java.lang.Object merge;
            private final java.lang.Object standard;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failover = software.amazon.jsii.Kernel.get(this, "failover", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mediaConnectFlow = software.amazon.jsii.Kernel.get(this, "mediaConnectFlow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.merge = software.amazon.jsii.Kernel.get(this, "merge", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.standard = software.amazon.jsii.Kernel.get(this, "standard", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failover = builder.failover;
                this.mediaConnectFlow = builder.mediaConnectFlow;
                this.merge = builder.merge;
                this.standard = builder.standard;
            }

            @Override
            public final java.lang.Object getFailover() {
                return this.failover;
            }

            @Override
            public final java.lang.Object getMediaConnectFlow() {
                return this.mediaConnectFlow;
            }

            @Override
            public final java.lang.Object getMerge() {
                return this.merge;
            }

            @Override
            public final java.lang.Object getStandard() {
                return this.standard;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFailover() != null) {
                    data.set("failover", om.valueToTree(this.getFailover()));
                }
                if (this.getMediaConnectFlow() != null) {
                    data.set("mediaConnectFlow", om.valueToTree(this.getMediaConnectFlow()));
                }
                if (this.getMerge() != null) {
                    data.set("merge", om.valueToTree(this.getMerge()));
                }
                if (this.getStandard() != null) {
                    data.set("standard", om.valueToTree(this.getStandard()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.RouterInputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RouterInputConfigurationProperty.Jsii$Proxy that = (RouterInputConfigurationProperty.Jsii$Proxy) o;

                if (this.failover != null ? !this.failover.equals(that.failover) : that.failover != null) return false;
                if (this.mediaConnectFlow != null ? !this.mediaConnectFlow.equals(that.mediaConnectFlow) : that.mediaConnectFlow != null) return false;
                if (this.merge != null ? !this.merge.equals(that.merge) : that.merge != null) return false;
                return this.standard != null ? this.standard.equals(that.standard) : that.standard == null;
            }

            @Override
            public final int hashCode() {
                int result = this.failover != null ? this.failover.hashCode() : 0;
                result = 31 * result + (this.mediaConnectFlow != null ? this.mediaConnectFlow.hashCode() : 0);
                result = 31 * result + (this.merge != null ? this.merge.hashCode() : 0);
                result = 31 * result + (this.standard != null ? this.standard.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * RouterInputProtocolConfigurationProperty routerInputProtocolConfigurationProperty = RouterInputProtocolConfigurationProperty.builder()
     *         .rist(RistRouterInputConfigurationProperty.builder()
     *                 .port(123)
     *                 .recoveryLatencyMilliseconds(123)
     *                 .build())
     *         .rtp(RtpRouterInputConfigurationProperty.builder()
     *                 .port(123)
     *                 // the properties below are optional
     *                 .forwardErrorCorrection("forwardErrorCorrection")
     *                 .build())
     *         .srtCaller(SrtCallerRouterInputConfigurationProperty.builder()
     *                 .minimumLatencyMilliseconds(123)
     *                 .sourceAddress("sourceAddress")
     *                 .sourcePort(123)
     *                 // the properties below are optional
     *                 .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                 .roleArn("roleArn")
     *                                 .secretArn("secretArn")
     *                                 .build())
     *                         .build())
     *                 .streamId("streamId")
     *                 .build())
     *         .srtListener(SrtListenerRouterInputConfigurationProperty.builder()
     *                 .minimumLatencyMilliseconds(123)
     *                 .port(123)
     *                 // the properties below are optional
     *                 .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                 .roleArn("roleArn")
     *                                 .secretArn("secretArn")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputprotocolconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputprotocolconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.RouterInputProtocolConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RouterInputProtocolConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RouterInputProtocolConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration settings for a router input using the RIST (Reliable Internet Stream Transport) protocol, including the port and recovery latency.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RistRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-routerinputprotocolconfiguration-rist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-routerinputprotocolconfiguration-rist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRist() {
            return null;
        }

        /**
         * The configuration settings for a Router Input using the RTP (Real-Time Transport Protocol) protocol, including the port and forward error correction state.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RtpRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-routerinputprotocolconfiguration-rtp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-routerinputprotocolconfiguration-rtp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRtp() {
            return null;
        }

        /**
         * The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in caller mode, including the source address and port, minimum latency, stream ID, and decryption key configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SrtCallerRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-routerinputprotocolconfiguration-srtcaller">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-routerinputprotocolconfiguration-srtcaller</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSrtCaller() {
            return null;
        }

        /**
         * The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in listener mode, including the port, minimum latency, and decryption key configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SrtListenerRouterInputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-routerinputprotocolconfiguration-srtlistener">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputprotocolconfiguration.html#cfn-mediaconnect-routerinput-routerinputprotocolconfiguration-srtlistener</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSrtListener() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RouterInputProtocolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RouterInputProtocolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RouterInputProtocolConfigurationProperty> {
            java.lang.Object rist;
            java.lang.Object rtp;
            java.lang.Object srtCaller;
            java.lang.Object srtListener;

            /**
             * Sets the value of {@link RouterInputProtocolConfigurationProperty#getRist}
             * @param rist The configuration settings for a router input using the RIST (Reliable Internet Stream Transport) protocol, including the port and recovery latency.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rist(software.amazon.awscdk.IResolvable rist) {
                this.rist = rist;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputProtocolConfigurationProperty#getRist}
             * @param rist The configuration settings for a router input using the RIST (Reliable Internet Stream Transport) protocol, including the port and recovery latency.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rist(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RistRouterInputConfigurationProperty rist) {
                this.rist = rist;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputProtocolConfigurationProperty#getRtp}
             * @param rtp The configuration settings for a Router Input using the RTP (Real-Time Transport Protocol) protocol, including the port and forward error correction state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rtp(software.amazon.awscdk.IResolvable rtp) {
                this.rtp = rtp;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputProtocolConfigurationProperty#getRtp}
             * @param rtp The configuration settings for a Router Input using the RTP (Real-Time Transport Protocol) protocol, including the port and forward error correction state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rtp(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RtpRouterInputConfigurationProperty rtp) {
                this.rtp = rtp;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputProtocolConfigurationProperty#getSrtCaller}
             * @param srtCaller The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in caller mode, including the source address and port, minimum latency, stream ID, and decryption key configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder srtCaller(software.amazon.awscdk.IResolvable srtCaller) {
                this.srtCaller = srtCaller;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputProtocolConfigurationProperty#getSrtCaller}
             * @param srtCaller The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in caller mode, including the source address and port, minimum latency, stream ID, and decryption key configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder srtCaller(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SrtCallerRouterInputConfigurationProperty srtCaller) {
                this.srtCaller = srtCaller;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputProtocolConfigurationProperty#getSrtListener}
             * @param srtListener The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in listener mode, including the port, minimum latency, and decryption key configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder srtListener(software.amazon.awscdk.IResolvable srtListener) {
                this.srtListener = srtListener;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputProtocolConfigurationProperty#getSrtListener}
             * @param srtListener The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in listener mode, including the port, minimum latency, and decryption key configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder srtListener(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SrtListenerRouterInputConfigurationProperty srtListener) {
                this.srtListener = srtListener;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RouterInputProtocolConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RouterInputProtocolConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RouterInputProtocolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouterInputProtocolConfigurationProperty {
            private final java.lang.Object rist;
            private final java.lang.Object rtp;
            private final java.lang.Object srtCaller;
            private final java.lang.Object srtListener;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rist = software.amazon.jsii.Kernel.get(this, "rist", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rtp = software.amazon.jsii.Kernel.get(this, "rtp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.srtCaller = software.amazon.jsii.Kernel.get(this, "srtCaller", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.srtListener = software.amazon.jsii.Kernel.get(this, "srtListener", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rist = builder.rist;
                this.rtp = builder.rtp;
                this.srtCaller = builder.srtCaller;
                this.srtListener = builder.srtListener;
            }

            @Override
            public final java.lang.Object getRist() {
                return this.rist;
            }

            @Override
            public final java.lang.Object getRtp() {
                return this.rtp;
            }

            @Override
            public final java.lang.Object getSrtCaller() {
                return this.srtCaller;
            }

            @Override
            public final java.lang.Object getSrtListener() {
                return this.srtListener;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRist() != null) {
                    data.set("rist", om.valueToTree(this.getRist()));
                }
                if (this.getRtp() != null) {
                    data.set("rtp", om.valueToTree(this.getRtp()));
                }
                if (this.getSrtCaller() != null) {
                    data.set("srtCaller", om.valueToTree(this.getSrtCaller()));
                }
                if (this.getSrtListener() != null) {
                    data.set("srtListener", om.valueToTree(this.getSrtListener()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.RouterInputProtocolConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RouterInputProtocolConfigurationProperty.Jsii$Proxy that = (RouterInputProtocolConfigurationProperty.Jsii$Proxy) o;

                if (this.rist != null ? !this.rist.equals(that.rist) : that.rist != null) return false;
                if (this.rtp != null ? !this.rtp.equals(that.rtp) : that.rtp != null) return false;
                if (this.srtCaller != null ? !this.srtCaller.equals(that.srtCaller) : that.srtCaller != null) return false;
                return this.srtListener != null ? this.srtListener.equals(that.srtListener) : that.srtListener == null;
            }

            @Override
            public final int hashCode() {
                int result = this.rist != null ? this.rist.hashCode() : 0;
                result = 31 * result + (this.rtp != null ? this.rtp.hashCode() : 0);
                result = 31 * result + (this.srtCaller != null ? this.srtCaller.hashCode() : 0);
                result = 31 * result + (this.srtListener != null ? this.srtListener.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object automatic;
     * RouterInputTransitEncryptionKeyConfigurationProperty routerInputTransitEncryptionKeyConfigurationProperty = RouterInputTransitEncryptionKeyConfigurationProperty.builder()
     *         .automatic(automatic)
     *         .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .secretArn("secretArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputtransitencryptionkeyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputtransitencryptionkeyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.RouterInputTransitEncryptionKeyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RouterInputTransitEncryptionKeyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RouterInputTransitEncryptionKeyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for automatic encryption key management, where MediaConnect handles key creation and rotation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputtransitencryptionkeyconfiguration.html#cfn-mediaconnect-routerinput-routerinputtransitencryptionkeyconfiguration-automatic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputtransitencryptionkeyconfiguration.html#cfn-mediaconnect-routerinput-routerinputtransitencryptionkeyconfiguration-automatic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomatic() {
            return null;
        }

        /**
         * The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SecretsManagerEncryptionKeyConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputtransitencryptionkeyconfiguration.html#cfn-mediaconnect-routerinput-routerinputtransitencryptionkeyconfiguration-secretsmanager">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputtransitencryptionkeyconfiguration.html#cfn-mediaconnect-routerinput-routerinputtransitencryptionkeyconfiguration-secretsmanager</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecretsManager() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RouterInputTransitEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RouterInputTransitEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RouterInputTransitEncryptionKeyConfigurationProperty> {
            java.lang.Object automatic;
            java.lang.Object secretsManager;

            /**
             * Sets the value of {@link RouterInputTransitEncryptionKeyConfigurationProperty#getAutomatic}
             * @param automatic Configuration settings for automatic encryption key management, where MediaConnect handles key creation and rotation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automatic(java.lang.Object automatic) {
                this.automatic = automatic;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputTransitEncryptionKeyConfigurationProperty#getSecretsManager}
             * @param secretsManager The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManager(software.amazon.awscdk.IResolvable secretsManager) {
                this.secretsManager = secretsManager;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputTransitEncryptionKeyConfigurationProperty#getSecretsManager}
             * @param secretsManager The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManager(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SecretsManagerEncryptionKeyConfigurationProperty secretsManager) {
                this.secretsManager = secretsManager;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RouterInputTransitEncryptionKeyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RouterInputTransitEncryptionKeyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RouterInputTransitEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouterInputTransitEncryptionKeyConfigurationProperty {
            private final java.lang.Object automatic;
            private final java.lang.Object secretsManager;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.automatic = software.amazon.jsii.Kernel.get(this, "automatic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretsManager = software.amazon.jsii.Kernel.get(this, "secretsManager", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.automatic = builder.automatic;
                this.secretsManager = builder.secretsManager;
            }

            @Override
            public final java.lang.Object getAutomatic() {
                return this.automatic;
            }

            @Override
            public final java.lang.Object getSecretsManager() {
                return this.secretsManager;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutomatic() != null) {
                    data.set("automatic", om.valueToTree(this.getAutomatic()));
                }
                if (this.getSecretsManager() != null) {
                    data.set("secretsManager", om.valueToTree(this.getSecretsManager()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.RouterInputTransitEncryptionKeyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RouterInputTransitEncryptionKeyConfigurationProperty.Jsii$Proxy that = (RouterInputTransitEncryptionKeyConfigurationProperty.Jsii$Proxy) o;

                if (this.automatic != null ? !this.automatic.equals(that.automatic) : that.automatic != null) return false;
                return this.secretsManager != null ? this.secretsManager.equals(that.secretsManager) : that.secretsManager == null;
            }

            @Override
            public final int hashCode() {
                int result = this.automatic != null ? this.automatic.hashCode() : 0;
                result = 31 * result + (this.secretsManager != null ? this.secretsManager.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The transit encryption settings for a router input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object automatic;
     * RouterInputTransitEncryptionProperty routerInputTransitEncryptionProperty = RouterInputTransitEncryptionProperty.builder()
     *         .encryptionKeyConfiguration(RouterInputTransitEncryptionKeyConfigurationProperty.builder()
     *                 .automatic(automatic)
     *                 .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                         .roleArn("roleArn")
     *                         .secretArn("secretArn")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .encryptionKeyType("encryptionKeyType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputtransitencryption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputtransitencryption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.RouterInputTransitEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(RouterInputTransitEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RouterInputTransitEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the configuration settings for transit encryption keys.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputTransitEncryptionKeyConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputtransitencryption.html#cfn-mediaconnect-routerinput-routerinputtransitencryption-encryptionkeyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputtransitencryption.html#cfn-mediaconnect-routerinput-routerinputtransitencryption-encryptionkeyconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncryptionKeyConfiguration();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputtransitencryption.html#cfn-mediaconnect-routerinput-routerinputtransitencryption-encryptionkeytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-routerinputtransitencryption.html#cfn-mediaconnect-routerinput-routerinputtransitencryption-encryptionkeytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RouterInputTransitEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RouterInputTransitEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RouterInputTransitEncryptionProperty> {
            java.lang.Object encryptionKeyConfiguration;
            java.lang.String encryptionKeyType;

            /**
             * Sets the value of {@link RouterInputTransitEncryptionProperty#getEncryptionKeyConfiguration}
             * @param encryptionKeyConfiguration Defines the configuration settings for transit encryption keys. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyConfiguration(software.amazon.awscdk.IResolvable encryptionKeyConfiguration) {
                this.encryptionKeyConfiguration = encryptionKeyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputTransitEncryptionProperty#getEncryptionKeyConfiguration}
             * @param encryptionKeyConfiguration Defines the configuration settings for transit encryption keys. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyConfiguration(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputTransitEncryptionKeyConfigurationProperty encryptionKeyConfiguration) {
                this.encryptionKeyConfiguration = encryptionKeyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RouterInputTransitEncryptionProperty#getEncryptionKeyType}
             * @param encryptionKeyType the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyType(java.lang.String encryptionKeyType) {
                this.encryptionKeyType = encryptionKeyType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RouterInputTransitEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RouterInputTransitEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RouterInputTransitEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouterInputTransitEncryptionProperty {
            private final java.lang.Object encryptionKeyConfiguration;
            private final java.lang.String encryptionKeyType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionKeyConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionKeyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionKeyType = software.amazon.jsii.Kernel.get(this, "encryptionKeyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionKeyConfiguration = java.util.Objects.requireNonNull(builder.encryptionKeyConfiguration, "encryptionKeyConfiguration is required");
                this.encryptionKeyType = builder.encryptionKeyType;
            }

            @Override
            public final java.lang.Object getEncryptionKeyConfiguration() {
                return this.encryptionKeyConfiguration;
            }

            @Override
            public final java.lang.String getEncryptionKeyType() {
                return this.encryptionKeyType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionKeyConfiguration", om.valueToTree(this.getEncryptionKeyConfiguration()));
                if (this.getEncryptionKeyType() != null) {
                    data.set("encryptionKeyType", om.valueToTree(this.getEncryptionKeyType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.RouterInputTransitEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RouterInputTransitEncryptionProperty.Jsii$Proxy that = (RouterInputTransitEncryptionProperty.Jsii$Proxy) o;

                if (!encryptionKeyConfiguration.equals(that.encryptionKeyConfiguration)) return false;
                return this.encryptionKeyType != null ? this.encryptionKeyType.equals(that.encryptionKeyType) : that.encryptionKeyType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionKeyConfiguration.hashCode();
                result = 31 * result + (this.encryptionKeyType != null ? this.encryptionKeyType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration settings for a Router Input using the RTP (Real-Time Transport Protocol) protocol, including the port and forward error correction state.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * RtpRouterInputConfigurationProperty rtpRouterInputConfigurationProperty = RtpRouterInputConfigurationProperty.builder()
     *         .port(123)
     *         // the properties below are optional
     *         .forwardErrorCorrection("forwardErrorCorrection")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-rtprouterinputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-rtprouterinputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.RtpRouterInputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RtpRouterInputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RtpRouterInputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The port number used for the RTP protocol in the router input configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-rtprouterinputconfiguration.html#cfn-mediaconnect-routerinput-rtprouterinputconfiguration-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-rtprouterinputconfiguration.html#cfn-mediaconnect-routerinput-rtprouterinputconfiguration-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-rtprouterinputconfiguration.html#cfn-mediaconnect-routerinput-rtprouterinputconfiguration-forwarderrorcorrection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-rtprouterinputconfiguration.html#cfn-mediaconnect-routerinput-rtprouterinputconfiguration-forwarderrorcorrection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getForwardErrorCorrection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RtpRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RtpRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RtpRouterInputConfigurationProperty> {
            java.lang.Number port;
            java.lang.String forwardErrorCorrection;

            /**
             * Sets the value of {@link RtpRouterInputConfigurationProperty#getPort}
             * @param port The port number used for the RTP protocol in the router input configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link RtpRouterInputConfigurationProperty#getForwardErrorCorrection}
             * @param forwardErrorCorrection the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardErrorCorrection(java.lang.String forwardErrorCorrection) {
                this.forwardErrorCorrection = forwardErrorCorrection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RtpRouterInputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RtpRouterInputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RtpRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RtpRouterInputConfigurationProperty {
            private final java.lang.Number port;
            private final java.lang.String forwardErrorCorrection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.forwardErrorCorrection = software.amazon.jsii.Kernel.get(this, "forwardErrorCorrection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.forwardErrorCorrection = builder.forwardErrorCorrection;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getForwardErrorCorrection() {
                return this.forwardErrorCorrection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("port", om.valueToTree(this.getPort()));
                if (this.getForwardErrorCorrection() != null) {
                    data.set("forwardErrorCorrection", om.valueToTree(this.getForwardErrorCorrection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.RtpRouterInputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RtpRouterInputConfigurationProperty.Jsii$Proxy that = (RtpRouterInputConfigurationProperty.Jsii$Proxy) o;

                if (!port.equals(that.port)) return false;
                return this.forwardErrorCorrection != null ? this.forwardErrorCorrection.equals(that.forwardErrorCorrection) : that.forwardErrorCorrection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.port.hashCode();
                result = 31 * result + (this.forwardErrorCorrection != null ? this.forwardErrorCorrection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * SecretsManagerEncryptionKeyConfigurationProperty secretsManagerEncryptionKeyConfigurationProperty = SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *         .roleArn("roleArn")
     *         .secretArn("secretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-secretsmanagerencryptionkeyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-secretsmanagerencryptionkeyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.SecretsManagerEncryptionKeyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SecretsManagerEncryptionKeyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecretsManagerEncryptionKeyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the IAM role assumed by MediaConnect to access the AWS Secrets Manager secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-secretsmanagerencryptionkeyconfiguration.html#cfn-mediaconnect-routerinput-secretsmanagerencryptionkeyconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-secretsmanagerencryptionkeyconfiguration.html#cfn-mediaconnect-routerinput-secretsmanagerencryptionkeyconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The ARN of the AWS Secrets Manager secret used for transit encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-secretsmanagerencryptionkeyconfiguration.html#cfn-mediaconnect-routerinput-secretsmanagerencryptionkeyconfiguration-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-secretsmanagerencryptionkeyconfiguration.html#cfn-mediaconnect-routerinput-secretsmanagerencryptionkeyconfiguration-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * @return a {@link Builder} of {@link SecretsManagerEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecretsManagerEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecretsManagerEncryptionKeyConfigurationProperty> {
            java.lang.String roleArn;
            java.lang.String secretArn;

            /**
             * Sets the value of {@link SecretsManagerEncryptionKeyConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of the IAM role assumed by MediaConnect to access the AWS Secrets Manager secret. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SecretsManagerEncryptionKeyConfigurationProperty#getSecretArn}
             * @param secretArn The ARN of the AWS Secrets Manager secret used for transit encryption. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecretsManagerEncryptionKeyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecretsManagerEncryptionKeyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecretsManagerEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretsManagerEncryptionKeyConfigurationProperty {
            private final java.lang.String roleArn;
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("secretArn", om.valueToTree(this.getSecretArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.SecretsManagerEncryptionKeyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecretsManagerEncryptionKeyConfigurationProperty.Jsii$Proxy that = (SecretsManagerEncryptionKeyConfigurationProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                return this.secretArn.equals(that.secretArn);
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.secretArn.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in caller mode, including the source address and port, minimum latency, stream ID, and decryption key configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * SrtCallerRouterInputConfigurationProperty srtCallerRouterInputConfigurationProperty = SrtCallerRouterInputConfigurationProperty.builder()
     *         .minimumLatencyMilliseconds(123)
     *         .sourceAddress("sourceAddress")
     *         .sourcePort(123)
     *         // the properties below are optional
     *         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                         .roleArn("roleArn")
     *                         .secretArn("secretArn")
     *                         .build())
     *                 .build())
     *         .streamId("streamId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtcallerrouterinputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtcallerrouterinputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.SrtCallerRouterInputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SrtCallerRouterInputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SrtCallerRouterInputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum latency in milliseconds for the SRT protocol in caller mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtcallerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtcallerrouterinputconfiguration-minimumlatencymilliseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtcallerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtcallerrouterinputconfiguration-minimumlatencymilliseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimumLatencyMilliseconds();

        /**
         * The source IP address for the SRT protocol in caller mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtcallerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtcallerrouterinputconfiguration-sourceaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtcallerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtcallerrouterinputconfiguration-sourceaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceAddress();

        /**
         * The source port number for the SRT protocol in caller mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtcallerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtcallerrouterinputconfiguration-sourceport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtcallerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtcallerrouterinputconfiguration-sourceport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSourcePort();

        /**
         * Contains the configuration settings for decrypting SRT streams, including the encryption key details and decryption parameters.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SrtDecryptionConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtcallerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtcallerrouterinputconfiguration-decryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtcallerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtcallerrouterinputconfiguration-decryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecryptionConfiguration() {
            return null;
        }

        /**
         * The stream ID for the SRT protocol in caller mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtcallerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtcallerrouterinputconfiguration-streamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtcallerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtcallerrouterinputconfiguration-streamid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SrtCallerRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SrtCallerRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SrtCallerRouterInputConfigurationProperty> {
            java.lang.Number minimumLatencyMilliseconds;
            java.lang.String sourceAddress;
            java.lang.Number sourcePort;
            java.lang.Object decryptionConfiguration;
            java.lang.String streamId;

            /**
             * Sets the value of {@link SrtCallerRouterInputConfigurationProperty#getMinimumLatencyMilliseconds}
             * @param minimumLatencyMilliseconds The minimum latency in milliseconds for the SRT protocol in caller mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumLatencyMilliseconds(java.lang.Number minimumLatencyMilliseconds) {
                this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
                return this;
            }

            /**
             * Sets the value of {@link SrtCallerRouterInputConfigurationProperty#getSourceAddress}
             * @param sourceAddress The source IP address for the SRT protocol in caller mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceAddress(java.lang.String sourceAddress) {
                this.sourceAddress = sourceAddress;
                return this;
            }

            /**
             * Sets the value of {@link SrtCallerRouterInputConfigurationProperty#getSourcePort}
             * @param sourcePort The source port number for the SRT protocol in caller mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePort(java.lang.Number sourcePort) {
                this.sourcePort = sourcePort;
                return this;
            }

            /**
             * Sets the value of {@link SrtCallerRouterInputConfigurationProperty#getDecryptionConfiguration}
             * @param decryptionConfiguration Contains the configuration settings for decrypting SRT streams, including the encryption key details and decryption parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decryptionConfiguration(software.amazon.awscdk.IResolvable decryptionConfiguration) {
                this.decryptionConfiguration = decryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SrtCallerRouterInputConfigurationProperty#getDecryptionConfiguration}
             * @param decryptionConfiguration Contains the configuration settings for decrypting SRT streams, including the encryption key details and decryption parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decryptionConfiguration(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SrtDecryptionConfigurationProperty decryptionConfiguration) {
                this.decryptionConfiguration = decryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SrtCallerRouterInputConfigurationProperty#getStreamId}
             * @param streamId The stream ID for the SRT protocol in caller mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamId(java.lang.String streamId) {
                this.streamId = streamId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SrtCallerRouterInputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SrtCallerRouterInputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SrtCallerRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SrtCallerRouterInputConfigurationProperty {
            private final java.lang.Number minimumLatencyMilliseconds;
            private final java.lang.String sourceAddress;
            private final java.lang.Number sourcePort;
            private final java.lang.Object decryptionConfiguration;
            private final java.lang.String streamId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.minimumLatencyMilliseconds = software.amazon.jsii.Kernel.get(this, "minimumLatencyMilliseconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sourceAddress = software.amazon.jsii.Kernel.get(this, "sourceAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourcePort = software.amazon.jsii.Kernel.get(this, "sourcePort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.decryptionConfiguration = software.amazon.jsii.Kernel.get(this, "decryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.streamId = software.amazon.jsii.Kernel.get(this, "streamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.minimumLatencyMilliseconds = java.util.Objects.requireNonNull(builder.minimumLatencyMilliseconds, "minimumLatencyMilliseconds is required");
                this.sourceAddress = java.util.Objects.requireNonNull(builder.sourceAddress, "sourceAddress is required");
                this.sourcePort = java.util.Objects.requireNonNull(builder.sourcePort, "sourcePort is required");
                this.decryptionConfiguration = builder.decryptionConfiguration;
                this.streamId = builder.streamId;
            }

            @Override
            public final java.lang.Number getMinimumLatencyMilliseconds() {
                return this.minimumLatencyMilliseconds;
            }

            @Override
            public final java.lang.String getSourceAddress() {
                return this.sourceAddress;
            }

            @Override
            public final java.lang.Number getSourcePort() {
                return this.sourcePort;
            }

            @Override
            public final java.lang.Object getDecryptionConfiguration() {
                return this.decryptionConfiguration;
            }

            @Override
            public final java.lang.String getStreamId() {
                return this.streamId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("minimumLatencyMilliseconds", om.valueToTree(this.getMinimumLatencyMilliseconds()));
                data.set("sourceAddress", om.valueToTree(this.getSourceAddress()));
                data.set("sourcePort", om.valueToTree(this.getSourcePort()));
                if (this.getDecryptionConfiguration() != null) {
                    data.set("decryptionConfiguration", om.valueToTree(this.getDecryptionConfiguration()));
                }
                if (this.getStreamId() != null) {
                    data.set("streamId", om.valueToTree(this.getStreamId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.SrtCallerRouterInputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SrtCallerRouterInputConfigurationProperty.Jsii$Proxy that = (SrtCallerRouterInputConfigurationProperty.Jsii$Proxy) o;

                if (!minimumLatencyMilliseconds.equals(that.minimumLatencyMilliseconds)) return false;
                if (!sourceAddress.equals(that.sourceAddress)) return false;
                if (!sourcePort.equals(that.sourcePort)) return false;
                if (this.decryptionConfiguration != null ? !this.decryptionConfiguration.equals(that.decryptionConfiguration) : that.decryptionConfiguration != null) return false;
                return this.streamId != null ? this.streamId.equals(that.streamId) : that.streamId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.minimumLatencyMilliseconds.hashCode();
                result = 31 * result + (this.sourceAddress.hashCode());
                result = 31 * result + (this.sourcePort.hashCode());
                result = 31 * result + (this.decryptionConfiguration != null ? this.decryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.streamId != null ? this.streamId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the configuration settings for decrypting SRT streams, including the encryption key details and decryption parameters.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * SrtDecryptionConfigurationProperty srtDecryptionConfigurationProperty = SrtDecryptionConfigurationProperty.builder()
     *         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .secretArn("secretArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtdecryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtdecryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.SrtDecryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SrtDecryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SrtDecryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SecretsManagerEncryptionKeyConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtdecryptionconfiguration.html#cfn-mediaconnect-routerinput-srtdecryptionconfiguration-encryptionkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtdecryptionconfiguration.html#cfn-mediaconnect-routerinput-srtdecryptionconfiguration-encryptionkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncryptionKey();

        /**
         * @return a {@link Builder} of {@link SrtDecryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SrtDecryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SrtDecryptionConfigurationProperty> {
            java.lang.Object encryptionKey;

            /**
             * Sets the value of {@link SrtDecryptionConfigurationProperty#getEncryptionKey}
             * @param encryptionKey The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKey(software.amazon.awscdk.IResolvable encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            /**
             * Sets the value of {@link SrtDecryptionConfigurationProperty#getEncryptionKey}
             * @param encryptionKey The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKey(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SecretsManagerEncryptionKeyConfigurationProperty encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SrtDecryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SrtDecryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SrtDecryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SrtDecryptionConfigurationProperty {
            private final java.lang.Object encryptionKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionKey = java.util.Objects.requireNonNull(builder.encryptionKey, "encryptionKey is required");
            }

            @Override
            public final java.lang.Object getEncryptionKey() {
                return this.encryptionKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.SrtDecryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SrtDecryptionConfigurationProperty.Jsii$Proxy that = (SrtDecryptionConfigurationProperty.Jsii$Proxy) o;

                return this.encryptionKey.equals(that.encryptionKey);
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionKey.hashCode();
                return result;
            }
        }
    }
    /**
     * The configuration settings for a router input using the SRT (Secure Reliable Transport) protocol in listener mode, including the port, minimum latency, and decryption key configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * SrtListenerRouterInputConfigurationProperty srtListenerRouterInputConfigurationProperty = SrtListenerRouterInputConfigurationProperty.builder()
     *         .minimumLatencyMilliseconds(123)
     *         .port(123)
     *         // the properties below are optional
     *         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                         .roleArn("roleArn")
     *                         .secretArn("secretArn")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtlistenerrouterinputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtlistenerrouterinputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.SrtListenerRouterInputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SrtListenerRouterInputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SrtListenerRouterInputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum latency in milliseconds for the SRT protocol in listener mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtlistenerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtlistenerrouterinputconfiguration-minimumlatencymilliseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtlistenerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtlistenerrouterinputconfiguration-minimumlatencymilliseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimumLatencyMilliseconds();

        /**
         * The port number for the SRT protocol in listener mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtlistenerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtlistenerrouterinputconfiguration-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtlistenerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtlistenerrouterinputconfiguration-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * Contains the configuration settings for decrypting SRT streams, including the encryption key details and decryption parameters.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SrtDecryptionConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtlistenerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtlistenerrouterinputconfiguration-decryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-srtlistenerrouterinputconfiguration.html#cfn-mediaconnect-routerinput-srtlistenerrouterinputconfiguration-decryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecryptionConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SrtListenerRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SrtListenerRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SrtListenerRouterInputConfigurationProperty> {
            java.lang.Number minimumLatencyMilliseconds;
            java.lang.Number port;
            java.lang.Object decryptionConfiguration;

            /**
             * Sets the value of {@link SrtListenerRouterInputConfigurationProperty#getMinimumLatencyMilliseconds}
             * @param minimumLatencyMilliseconds The minimum latency in milliseconds for the SRT protocol in listener mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumLatencyMilliseconds(java.lang.Number minimumLatencyMilliseconds) {
                this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
                return this;
            }

            /**
             * Sets the value of {@link SrtListenerRouterInputConfigurationProperty#getPort}
             * @param port The port number for the SRT protocol in listener mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link SrtListenerRouterInputConfigurationProperty#getDecryptionConfiguration}
             * @param decryptionConfiguration Contains the configuration settings for decrypting SRT streams, including the encryption key details and decryption parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decryptionConfiguration(software.amazon.awscdk.IResolvable decryptionConfiguration) {
                this.decryptionConfiguration = decryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SrtListenerRouterInputConfigurationProperty#getDecryptionConfiguration}
             * @param decryptionConfiguration Contains the configuration settings for decrypting SRT streams, including the encryption key details and decryption parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decryptionConfiguration(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.SrtDecryptionConfigurationProperty decryptionConfiguration) {
                this.decryptionConfiguration = decryptionConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SrtListenerRouterInputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SrtListenerRouterInputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SrtListenerRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SrtListenerRouterInputConfigurationProperty {
            private final java.lang.Number minimumLatencyMilliseconds;
            private final java.lang.Number port;
            private final java.lang.Object decryptionConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.minimumLatencyMilliseconds = software.amazon.jsii.Kernel.get(this, "minimumLatencyMilliseconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.decryptionConfiguration = software.amazon.jsii.Kernel.get(this, "decryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.minimumLatencyMilliseconds = java.util.Objects.requireNonNull(builder.minimumLatencyMilliseconds, "minimumLatencyMilliseconds is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.decryptionConfiguration = builder.decryptionConfiguration;
            }

            @Override
            public final java.lang.Number getMinimumLatencyMilliseconds() {
                return this.minimumLatencyMilliseconds;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.Object getDecryptionConfiguration() {
                return this.decryptionConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("minimumLatencyMilliseconds", om.valueToTree(this.getMinimumLatencyMilliseconds()));
                data.set("port", om.valueToTree(this.getPort()));
                if (this.getDecryptionConfiguration() != null) {
                    data.set("decryptionConfiguration", om.valueToTree(this.getDecryptionConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.SrtListenerRouterInputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SrtListenerRouterInputConfigurationProperty.Jsii$Proxy that = (SrtListenerRouterInputConfigurationProperty.Jsii$Proxy) o;

                if (!minimumLatencyMilliseconds.equals(that.minimumLatencyMilliseconds)) return false;
                if (!port.equals(that.port)) return false;
                return this.decryptionConfiguration != null ? this.decryptionConfiguration.equals(that.decryptionConfiguration) : that.decryptionConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.minimumLatencyMilliseconds.hashCode();
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.decryptionConfiguration != null ? this.decryptionConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration settings for a standard router input, including the protocol, protocol-specific configuration, network interface, and availability zone.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * StandardRouterInputConfigurationProperty standardRouterInputConfigurationProperty = StandardRouterInputConfigurationProperty.builder()
     *         .networkInterfaceArn("networkInterfaceArn")
     *         .protocolConfiguration(RouterInputProtocolConfigurationProperty.builder()
     *                 .rist(RistRouterInputConfigurationProperty.builder()
     *                         .port(123)
     *                         .recoveryLatencyMilliseconds(123)
     *                         .build())
     *                 .rtp(RtpRouterInputConfigurationProperty.builder()
     *                         .port(123)
     *                         // the properties below are optional
     *                         .forwardErrorCorrection("forwardErrorCorrection")
     *                         .build())
     *                 .srtCaller(SrtCallerRouterInputConfigurationProperty.builder()
     *                         .minimumLatencyMilliseconds(123)
     *                         .sourceAddress("sourceAddress")
     *                         .sourcePort(123)
     *                         // the properties below are optional
     *                         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                         .roleArn("roleArn")
     *                                         .secretArn("secretArn")
     *                                         .build())
     *                                 .build())
     *                         .streamId("streamId")
     *                         .build())
     *                 .srtListener(SrtListenerRouterInputConfigurationProperty.builder()
     *                         .minimumLatencyMilliseconds(123)
     *                         .port(123)
     *                         // the properties below are optional
     *                         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
     *                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                         .roleArn("roleArn")
     *                                         .secretArn("secretArn")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .protocol("protocol")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-standardrouterinputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-standardrouterinputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInput.StandardRouterInputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StandardRouterInputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StandardRouterInputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the network interface associated with the standard router input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-standardrouterinputconfiguration.html#cfn-mediaconnect-routerinput-standardrouterinputconfiguration-networkinterfacearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-standardrouterinputconfiguration.html#cfn-mediaconnect-routerinput-standardrouterinputconfiguration-networkinterfacearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNetworkInterfaceArn();

        /**
         * The protocol configuration settings for a router input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputProtocolConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-standardrouterinputconfiguration.html#cfn-mediaconnect-routerinput-standardrouterinputconfiguration-protocolconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-standardrouterinputconfiguration.html#cfn-mediaconnect-routerinput-standardrouterinputconfiguration-protocolconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getProtocolConfiguration();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-standardrouterinputconfiguration.html#cfn-mediaconnect-routerinput-standardrouterinputconfiguration-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routerinput-standardrouterinputconfiguration.html#cfn-mediaconnect-routerinput-standardrouterinputconfiguration-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StandardRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StandardRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StandardRouterInputConfigurationProperty> {
            java.lang.String networkInterfaceArn;
            java.lang.Object protocolConfiguration;
            java.lang.String protocol;

            /**
             * Sets the value of {@link StandardRouterInputConfigurationProperty#getNetworkInterfaceArn}
             * @param networkInterfaceArn The Amazon Resource Name (ARN) of the network interface associated with the standard router input. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceArn(java.lang.String networkInterfaceArn) {
                this.networkInterfaceArn = networkInterfaceArn;
                return this;
            }

            /**
             * Sets the value of {@link StandardRouterInputConfigurationProperty#getProtocolConfiguration}
             * @param protocolConfiguration The protocol configuration settings for a router input. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolConfiguration(software.amazon.awscdk.IResolvable protocolConfiguration) {
                this.protocolConfiguration = protocolConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StandardRouterInputConfigurationProperty#getProtocolConfiguration}
             * @param protocolConfiguration The protocol configuration settings for a router input. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolConfiguration(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputProtocolConfigurationProperty protocolConfiguration) {
                this.protocolConfiguration = protocolConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StandardRouterInputConfigurationProperty#getProtocol}
             * @param protocol the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StandardRouterInputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StandardRouterInputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StandardRouterInputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StandardRouterInputConfigurationProperty {
            private final java.lang.String networkInterfaceArn;
            private final java.lang.Object protocolConfiguration;
            private final java.lang.String protocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.networkInterfaceArn = software.amazon.jsii.Kernel.get(this, "networkInterfaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocolConfiguration = software.amazon.jsii.Kernel.get(this, "protocolConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.networkInterfaceArn = java.util.Objects.requireNonNull(builder.networkInterfaceArn, "networkInterfaceArn is required");
                this.protocolConfiguration = java.util.Objects.requireNonNull(builder.protocolConfiguration, "protocolConfiguration is required");
                this.protocol = builder.protocol;
            }

            @Override
            public final java.lang.String getNetworkInterfaceArn() {
                return this.networkInterfaceArn;
            }

            @Override
            public final java.lang.Object getProtocolConfiguration() {
                return this.protocolConfiguration;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("networkInterfaceArn", om.valueToTree(this.getNetworkInterfaceArn()));
                data.set("protocolConfiguration", om.valueToTree(this.getProtocolConfiguration()));
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInput.StandardRouterInputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StandardRouterInputConfigurationProperty.Jsii$Proxy that = (StandardRouterInputConfigurationProperty.Jsii$Proxy) o;

                if (!networkInterfaceArn.equals(that.networkInterfaceArn)) return false;
                if (!protocolConfiguration.equals(that.protocolConfiguration)) return false;
                return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
            }

            @Override
            public final int hashCode() {
                int result = this.networkInterfaceArn.hashCode();
                result = 31 * result + (this.protocolConfiguration.hashCode());
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediaconnect.CfnRouterInput> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediaconnect.CfnRouterInputProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediaconnect.CfnRouterInputProps.Builder();
        }

        /**
         * The configuration settings for a router input.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-configuration</a>
         * @param configuration The configuration settings for a router input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }
        /**
         * The configuration settings for a router input.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-configuration</a>
         * @param configuration The configuration settings for a router input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputConfigurationProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * The maximum bitrate for the router input.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-maximumbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-maximumbitrate</a>
         * @param maximumBitrate The maximum bitrate for the router input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumBitrate(final java.lang.Number maximumBitrate) {
            this.props.maximumBitrate(maximumBitrate);
            return this;
        }

        /**
         * The name of the router input.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-name</a>
         * @param name The name of the router input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Indicates whether the router input is configured for Regional or global routing.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-routingscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-routingscope</a>
         * @param routingScope Indicates whether the router input is configured for Regional or global routing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingScope(final java.lang.String routingScope) {
            this.props.routingScope(routingScope);
            return this;
        }

        /**
         * The tier level of the router input.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-tier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-tier</a>
         * @param tier The tier level of the router input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tier(final java.lang.String tier) {
            this.props.tier(tier);
            return this;
        }

        /**
         * The Availability Zone of the router input.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-availabilityzone</a>
         * @param availabilityZone The Availability Zone of the router input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The maintenance configuration settings applied to this router input.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-maintenanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-maintenanceconfiguration</a>
         * @param maintenanceConfiguration The maintenance configuration settings applied to this router input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceConfiguration(final software.amazon.awscdk.IResolvable maintenanceConfiguration) {
            this.props.maintenanceConfiguration(maintenanceConfiguration);
            return this;
        }
        /**
         * The maintenance configuration settings applied to this router input.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-maintenanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-maintenanceconfiguration</a>
         * @param maintenanceConfiguration The maintenance configuration settings applied to this router input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceConfiguration(final software.amazon.awscdk.services.mediaconnect.CfnRouterInput.MaintenanceConfigurationProperty maintenanceConfiguration) {
            this.props.maintenanceConfiguration(maintenanceConfiguration);
            return this;
        }

        /**
         * The AWS Region where the router input is located.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-regionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-regionname</a>
         * @param regionName The AWS Region where the router input is located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionName(final java.lang.String regionName) {
            this.props.regionName(regionName);
            return this;
        }

        /**
         * Key-value pairs that can be used to tag and organize this router input.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-tags</a>
         * @param tags Key-value pairs that can be used to tag and organize this router input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Encryption information.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-transitencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-transitencryption</a>
         * @param transitEncryption Encryption information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryption(final software.amazon.awscdk.IResolvable transitEncryption) {
            this.props.transitEncryption(transitEncryption);
            return this;
        }
        /**
         * Encryption information.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-transitencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-transitencryption</a>
         * @param transitEncryption Encryption information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryption(final software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputTransitEncryptionProperty transitEncryption) {
            this.props.transitEncryption(transitEncryption);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediaconnect.CfnRouterInput build() {
            return new software.amazon.awscdk.services.mediaconnect.CfnRouterInput(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
