package software.amazon.awscdk.services.mediaconnect;

/**
 * Properties for defining a <code>CfnRouterInput</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * Object automatic;
 * Object default_;
 * CfnRouterInputProps cfnRouterInputProps = CfnRouterInputProps.builder()
 *         .configuration(RouterInputConfigurationProperty.builder()
 *                 .failover(FailoverRouterInputConfigurationProperty.builder()
 *                         .networkInterfaceArn("networkInterfaceArn")
 *                         .protocolConfigurations(List.of(FailoverRouterInputProtocolConfigurationProperty.builder()
 *                                 .rist(RistRouterInputConfigurationProperty.builder()
 *                                         .port(123)
 *                                         .recoveryLatencyMilliseconds(123)
 *                                         .build())
 *                                 .rtp(RtpRouterInputConfigurationProperty.builder()
 *                                         .port(123)
 *                                         // the properties below are optional
 *                                         .forwardErrorCorrection("forwardErrorCorrection")
 *                                         .build())
 *                                 .srtCaller(SrtCallerRouterInputConfigurationProperty.builder()
 *                                         .minimumLatencyMilliseconds(123)
 *                                         .sourceAddress("sourceAddress")
 *                                         .sourcePort(123)
 *                                         // the properties below are optional
 *                                         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
 *                                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                         .roleArn("roleArn")
 *                                                         .secretArn("secretArn")
 *                                                         .build())
 *                                                 .build())
 *                                         .streamId("streamId")
 *                                         .build())
 *                                 .srtListener(SrtListenerRouterInputConfigurationProperty.builder()
 *                                         .minimumLatencyMilliseconds(123)
 *                                         .port(123)
 *                                         // the properties below are optional
 *                                         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
 *                                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                         .roleArn("roleArn")
 *                                                         .secretArn("secretArn")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .sourcePriorityMode("sourcePriorityMode")
 *                         // the properties below are optional
 *                         .primarySourceIndex(123)
 *                         .build())
 *                 .mediaConnectFlow(MediaConnectFlowRouterInputConfigurationProperty.builder()
 *                         .sourceTransitDecryption(FlowTransitEncryptionProperty.builder()
 *                                 .encryptionKeyConfiguration(FlowTransitEncryptionKeyConfigurationProperty.builder()
 *                                         .automatic(automatic)
 *                                         .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                 .roleArn("roleArn")
 *                                                 .secretArn("secretArn")
 *                                                 .build())
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .encryptionKeyType("encryptionKeyType")
 *                                 .build())
 *                         // the properties below are optional
 *                         .flowArn("flowArn")
 *                         .flowOutputArn("flowOutputArn")
 *                         .build())
 *                 .merge(MergeRouterInputConfigurationProperty.builder()
 *                         .mergeRecoveryWindowMilliseconds(123)
 *                         .networkInterfaceArn("networkInterfaceArn")
 *                         .protocolConfigurations(List.of(MergeRouterInputProtocolConfigurationProperty.builder()
 *                                 .rist(RistRouterInputConfigurationProperty.builder()
 *                                         .port(123)
 *                                         .recoveryLatencyMilliseconds(123)
 *                                         .build())
 *                                 .rtp(RtpRouterInputConfigurationProperty.builder()
 *                                         .port(123)
 *                                         // the properties below are optional
 *                                         .forwardErrorCorrection("forwardErrorCorrection")
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .standard(StandardRouterInputConfigurationProperty.builder()
 *                         .networkInterfaceArn("networkInterfaceArn")
 *                         .protocolConfiguration(RouterInputProtocolConfigurationProperty.builder()
 *                                 .rist(RistRouterInputConfigurationProperty.builder()
 *                                         .port(123)
 *                                         .recoveryLatencyMilliseconds(123)
 *                                         .build())
 *                                 .rtp(RtpRouterInputConfigurationProperty.builder()
 *                                         .port(123)
 *                                         // the properties below are optional
 *                                         .forwardErrorCorrection("forwardErrorCorrection")
 *                                         .build())
 *                                 .srtCaller(SrtCallerRouterInputConfigurationProperty.builder()
 *                                         .minimumLatencyMilliseconds(123)
 *                                         .sourceAddress("sourceAddress")
 *                                         .sourcePort(123)
 *                                         // the properties below are optional
 *                                         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
 *                                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                         .roleArn("roleArn")
 *                                                         .secretArn("secretArn")
 *                                                         .build())
 *                                                 .build())
 *                                         .streamId("streamId")
 *                                         .build())
 *                                 .srtListener(SrtListenerRouterInputConfigurationProperty.builder()
 *                                         .minimumLatencyMilliseconds(123)
 *                                         .port(123)
 *                                         // the properties below are optional
 *                                         .decryptionConfiguration(SrtDecryptionConfigurationProperty.builder()
 *                                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                         .roleArn("roleArn")
 *                                                         .secretArn("secretArn")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .protocol("protocol")
 *                         .build())
 *                 .build())
 *         .maximumBitrate(123)
 *         .name("name")
 *         .routingScope("routingScope")
 *         .tier("tier")
 *         // the properties below are optional
 *         .availabilityZone("availabilityZone")
 *         .maintenanceConfiguration(MaintenanceConfigurationProperty.builder()
 *                 .default(default_)
 *                 .preferredDayTime(PreferredDayTimeMaintenanceConfigurationProperty.builder()
 *                         .day("day")
 *                         .time("time")
 *                         .build())
 *                 .build())
 *         .regionName("regionName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transitEncryption(RouterInputTransitEncryptionProperty.builder()
 *                 .encryptionKeyConfiguration(RouterInputTransitEncryptionKeyConfigurationProperty.builder()
 *                         .automatic(automatic)
 *                         .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .secretArn("secretArn")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .encryptionKeyType("encryptionKeyType")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:24.420Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterInputProps")
@software.amazon.jsii.Jsii.Proxy(CfnRouterInputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRouterInputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The configuration settings for a router input.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration();

    /**
     * The maximum bitrate for the router input.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-maximumbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-maximumbitrate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaximumBitrate();

    /**
     * The name of the router input.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Indicates whether the router input is configured for Regional or global routing.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-routingscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-routingscope</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoutingScope();

    /**
     * The tier level of the router input.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-tier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-tier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTier();

    /**
     * The Availability Zone of the router input.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-availabilityzone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The maintenance configuration settings applied to this router input.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.MaintenanceConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-maintenanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-maintenanceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceConfiguration() {
        return null;
    }

    /**
     * The AWS Region where the router input is located.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-regionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-regionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegionName() {
        return null;
    }

    /**
     * Key-value pairs that can be used to tag and organize this router input.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Encryption information.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputTransitEncryptionProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-transitencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routerinput.html#cfn-mediaconnect-routerinput-transitencryption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTransitEncryption() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRouterInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRouterInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRouterInputProps> {
        java.lang.Object configuration;
        java.lang.Number maximumBitrate;
        java.lang.String name;
        java.lang.String routingScope;
        java.lang.String tier;
        java.lang.String availabilityZone;
        java.lang.Object maintenanceConfiguration;
        java.lang.String regionName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object transitEncryption;

        /**
         * Sets the value of {@link CfnRouterInputProps#getConfiguration}
         * @param configuration The configuration settings for a router input. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouterInputProps#getConfiguration}
         * @param configuration The configuration settings for a router input. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputConfigurationProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouterInputProps#getMaximumBitrate}
         * @param maximumBitrate The maximum bitrate for the router input. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumBitrate(java.lang.Number maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouterInputProps#getName}
         * @param name The name of the router input. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouterInputProps#getRoutingScope}
         * @param routingScope Indicates whether the router input is configured for Regional or global routing. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingScope(java.lang.String routingScope) {
            this.routingScope = routingScope;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouterInputProps#getTier}
         * @param tier The tier level of the router input. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tier(java.lang.String tier) {
            this.tier = tier;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouterInputProps#getAvailabilityZone}
         * @param availabilityZone The Availability Zone of the router input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouterInputProps#getMaintenanceConfiguration}
         * @param maintenanceConfiguration The maintenance configuration settings applied to this router input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceConfiguration(software.amazon.awscdk.IResolvable maintenanceConfiguration) {
            this.maintenanceConfiguration = maintenanceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouterInputProps#getMaintenanceConfiguration}
         * @param maintenanceConfiguration The maintenance configuration settings applied to this router input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceConfiguration(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.MaintenanceConfigurationProperty maintenanceConfiguration) {
            this.maintenanceConfiguration = maintenanceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouterInputProps#getRegionName}
         * @param regionName The AWS Region where the router input is located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionName(java.lang.String regionName) {
            this.regionName = regionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouterInputProps#getTags}
         * @param tags Key-value pairs that can be used to tag and organize this router input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouterInputProps#getTransitEncryption}
         * @param transitEncryption Encryption information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryption(software.amazon.awscdk.IResolvable transitEncryption) {
            this.transitEncryption = transitEncryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouterInputProps#getTransitEncryption}
         * @param transitEncryption Encryption information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitEncryption(software.amazon.awscdk.services.mediaconnect.CfnRouterInput.RouterInputTransitEncryptionProperty transitEncryption) {
            this.transitEncryption = transitEncryption;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRouterInputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRouterInputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRouterInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRouterInputProps {
        private final java.lang.Object configuration;
        private final java.lang.Number maximumBitrate;
        private final java.lang.String name;
        private final java.lang.String routingScope;
        private final java.lang.String tier;
        private final java.lang.String availabilityZone;
        private final java.lang.Object maintenanceConfiguration;
        private final java.lang.String regionName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object transitEncryption;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maximumBitrate = software.amazon.jsii.Kernel.get(this, "maximumBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.routingScope = software.amazon.jsii.Kernel.get(this, "routingScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tier = software.amazon.jsii.Kernel.get(this, "tier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maintenanceConfiguration = software.amazon.jsii.Kernel.get(this, "maintenanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.regionName = software.amazon.jsii.Kernel.get(this, "regionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.transitEncryption = software.amazon.jsii.Kernel.get(this, "transitEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configuration = java.util.Objects.requireNonNull(builder.configuration, "configuration is required");
            this.maximumBitrate = java.util.Objects.requireNonNull(builder.maximumBitrate, "maximumBitrate is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.routingScope = java.util.Objects.requireNonNull(builder.routingScope, "routingScope is required");
            this.tier = java.util.Objects.requireNonNull(builder.tier, "tier is required");
            this.availabilityZone = builder.availabilityZone;
            this.maintenanceConfiguration = builder.maintenanceConfiguration;
            this.regionName = builder.regionName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.transitEncryption = builder.transitEncryption;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.Number getMaximumBitrate() {
            return this.maximumBitrate;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRoutingScope() {
            return this.routingScope;
        }

        @Override
        public final java.lang.String getTier() {
            return this.tier;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.Object getMaintenanceConfiguration() {
            return this.maintenanceConfiguration;
        }

        @Override
        public final java.lang.String getRegionName() {
            return this.regionName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTransitEncryption() {
            return this.transitEncryption;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configuration", om.valueToTree(this.getConfiguration()));
            data.set("maximumBitrate", om.valueToTree(this.getMaximumBitrate()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("routingScope", om.valueToTree(this.getRoutingScope()));
            data.set("tier", om.valueToTree(this.getTier()));
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getMaintenanceConfiguration() != null) {
                data.set("maintenanceConfiguration", om.valueToTree(this.getMaintenanceConfiguration()));
            }
            if (this.getRegionName() != null) {
                data.set("regionName", om.valueToTree(this.getRegionName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTransitEncryption() != null) {
                data.set("transitEncryption", om.valueToTree(this.getTransitEncryption()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterInputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRouterInputProps.Jsii$Proxy that = (CfnRouterInputProps.Jsii$Proxy) o;

            if (!configuration.equals(that.configuration)) return false;
            if (!maximumBitrate.equals(that.maximumBitrate)) return false;
            if (!name.equals(that.name)) return false;
            if (!routingScope.equals(that.routingScope)) return false;
            if (!tier.equals(that.tier)) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.maintenanceConfiguration != null ? !this.maintenanceConfiguration.equals(that.maintenanceConfiguration) : that.maintenanceConfiguration != null) return false;
            if (this.regionName != null ? !this.regionName.equals(that.regionName) : that.regionName != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.transitEncryption != null ? this.transitEncryption.equals(that.transitEncryption) : that.transitEncryption == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configuration.hashCode();
            result = 31 * result + (this.maximumBitrate.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.routingScope.hashCode());
            result = 31 * result + (this.tier.hashCode());
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.maintenanceConfiguration != null ? this.maintenanceConfiguration.hashCode() : 0);
            result = 31 * result + (this.regionName != null ? this.regionName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.transitEncryption != null ? this.transitEncryption.hashCode() : 0);
            return result;
        }
    }
}
