package software.amazon.awscdk.services.mediaconnect;

/**
 * Represents a router input in AWS Elemental MediaConnect that can be used to egress content transmitted from router inputs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * Object automatic;
 * Object default_;
 * CfnRouterOutput cfnRouterOutput = CfnRouterOutput.Builder.create(this, "MyCfnRouterOutput")
 *         .configuration(RouterOutputConfigurationProperty.builder()
 *                 .mediaConnectFlow(MediaConnectFlowRouterOutputConfigurationProperty.builder()
 *                         .destinationTransitEncryption(FlowTransitEncryptionProperty.builder()
 *                                 .encryptionKeyConfiguration(FlowTransitEncryptionKeyConfigurationProperty.builder()
 *                                         .automatic(automatic)
 *                                         .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                 .roleArn("roleArn")
 *                                                 .secretArn("secretArn")
 *                                                 .build())
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .encryptionKeyType("encryptionKeyType")
 *                                 .build())
 *                         // the properties below are optional
 *                         .flowArn("flowArn")
 *                         .flowSourceArn("flowSourceArn")
 *                         .build())
 *                 .mediaLiveInput(MediaLiveInputRouterOutputConfigurationProperty.builder()
 *                         .destinationTransitEncryption(MediaLiveTransitEncryptionProperty.builder()
 *                                 .encryptionKeyConfiguration(MediaLiveTransitEncryptionKeyConfigurationProperty.builder()
 *                                         .automatic(automatic)
 *                                         .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                 .roleArn("roleArn")
 *                                                 .secretArn("secretArn")
 *                                                 .build())
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .encryptionKeyType("encryptionKeyType")
 *                                 .build())
 *                         // the properties below are optional
 *                         .mediaLiveInputArn("mediaLiveInputArn")
 *                         .mediaLivePipelineId("mediaLivePipelineId")
 *                         .build())
 *                 .standard(StandardRouterOutputConfigurationProperty.builder()
 *                         .networkInterfaceArn("networkInterfaceArn")
 *                         .protocolConfiguration(RouterOutputProtocolConfigurationProperty.builder()
 *                                 .rist(RistRouterOutputConfigurationProperty.builder()
 *                                         .destinationAddress("destinationAddress")
 *                                         .destinationPort(123)
 *                                         .build())
 *                                 .rtp(RtpRouterOutputConfigurationProperty.builder()
 *                                         .destinationAddress("destinationAddress")
 *                                         .destinationPort(123)
 *                                         // the properties below are optional
 *                                         .forwardErrorCorrection("forwardErrorCorrection")
 *                                         .build())
 *                                 .srtCaller(SrtCallerRouterOutputConfigurationProperty.builder()
 *                                         .destinationAddress("destinationAddress")
 *                                         .destinationPort(123)
 *                                         .minimumLatencyMilliseconds(123)
 *                                         // the properties below are optional
 *                                         .encryptionConfiguration(SrtEncryptionConfigurationProperty.builder()
 *                                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                         .roleArn("roleArn")
 *                                                         .secretArn("secretArn")
 *                                                         .build())
 *                                                 .build())
 *                                         .streamId("streamId")
 *                                         .build())
 *                                 .srtListener(SrtListenerRouterOutputConfigurationProperty.builder()
 *                                         .minimumLatencyMilliseconds(123)
 *                                         .port(123)
 *                                         // the properties below are optional
 *                                         .encryptionConfiguration(SrtEncryptionConfigurationProperty.builder()
 *                                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
 *                                                         .roleArn("roleArn")
 *                                                         .secretArn("secretArn")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .protocol("protocol")
 *                         .build())
 *                 .build())
 *         .maximumBitrate(123)
 *         .name("name")
 *         .routingScope("routingScope")
 *         .tier("tier")
 *         // the properties below are optional
 *         .availabilityZone("availabilityZone")
 *         .maintenanceConfiguration(MaintenanceConfigurationProperty.builder()
 *                 .default(default_)
 *                 .preferredDayTime(PreferredDayTimeMaintenanceConfigurationProperty.builder()
 *                         .day("day")
 *                         .time("time")
 *                         .build())
 *                 .build())
 *         .regionName("regionName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:24.425Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput")
public class CfnRouterOutput extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.mediaconnect.IRouterOutputRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnRouterOutput(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRouterOutput(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::MediaConnect::RouterOutput</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRouterOutput(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediaconnect.CfnRouterOutputProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForRouterOutput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.mediaconnect.IRouterOutputRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.class, "arnForRouterOutput", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnRouterOutput.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnRouterOutput(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.class, "isCfnRouterOutput", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when the router output was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP address of the router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIpAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of maintenance configuration applied to this router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMaintenanceType() {
        return software.amazon.jsii.Kernel.get(this, "attrMaintenanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOutputType() {
        return software.amazon.jsii.Kernel.get(this, "attrOutputType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current state of the association between the router output and its input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRoutedState() {
        return software.amazon.jsii.Kernel.get(this, "attrRoutedState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The overall state of the router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when the router output was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a RouterOutput resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.mediaconnect.RouterOutputReference getRouterOutputRef() {
        return software.amazon.jsii.Kernel.get(this, "routerOutputRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.mediaconnect.RouterOutputReference.class));
    }

    /**
     * The configuration settings for a router output.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.RouterOutputConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration settings for a router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * The configuration settings for a router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.RouterOutputConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * The maximum bitrate for the router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMaximumBitrate() {
        return software.amazon.jsii.Kernel.get(this, "maximumBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum bitrate for the router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaximumBitrate(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maximumBitrate", java.util.Objects.requireNonNull(value, "maximumBitrate is required"));
    }

    /**
     * The name of the router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Indicates whether the router output is configured for Regional or global routing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoutingScope() {
        return software.amazon.jsii.Kernel.get(this, "routingScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether the router output is configured for Regional or global routing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoutingScope(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "routingScope", java.util.Objects.requireNonNull(value, "routingScope is required"));
    }

    /**
     * The tier level of the router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTier() {
        return software.amazon.jsii.Kernel.get(this, "tier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The tier level of the router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tier", java.util.Objects.requireNonNull(value, "tier is required"));
    }

    /**
     * The Availability Zone of the router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone of the router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", value);
    }

    /**
     * The maintenance configuration settings applied to this router output.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.MaintenanceConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "maintenanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The maintenance configuration settings applied to this router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceConfiguration", value);
    }

    /**
     * The maintenance configuration settings applied to this router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.MaintenanceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceConfiguration", value);
    }

    /**
     * The AWS Region where the router output is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRegionName() {
        return software.amazon.jsii.Kernel.get(this, "regionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Region where the router output is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegionName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "regionName", value);
    }

    /**
     * Key-value pairs that can be used to tag and organize this router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Key-value pairs that can be used to tag and organize this router output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object automatic;
     * FlowTransitEncryptionKeyConfigurationProperty flowTransitEncryptionKeyConfigurationProperty = FlowTransitEncryptionKeyConfigurationProperty.builder()
     *         .automatic(automatic)
     *         .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .secretArn("secretArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-flowtransitencryptionkeyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-flowtransitencryptionkeyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.FlowTransitEncryptionKeyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowTransitEncryptionKeyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowTransitEncryptionKeyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for automatic encryption key management, where MediaConnect handles key creation and rotation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-flowtransitencryptionkeyconfiguration.html#cfn-mediaconnect-routeroutput-flowtransitencryptionkeyconfiguration-automatic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-flowtransitencryptionkeyconfiguration.html#cfn-mediaconnect-routeroutput-flowtransitencryptionkeyconfiguration-automatic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomatic() {
            return null;
        }

        /**
         * The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SecretsManagerEncryptionKeyConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-flowtransitencryptionkeyconfiguration.html#cfn-mediaconnect-routeroutput-flowtransitencryptionkeyconfiguration-secretsmanager">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-flowtransitencryptionkeyconfiguration.html#cfn-mediaconnect-routeroutput-flowtransitencryptionkeyconfiguration-secretsmanager</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecretsManager() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowTransitEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowTransitEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowTransitEncryptionKeyConfigurationProperty> {
            java.lang.Object automatic;
            java.lang.Object secretsManager;

            /**
             * Sets the value of {@link FlowTransitEncryptionKeyConfigurationProperty#getAutomatic}
             * @param automatic Configuration settings for automatic encryption key management, where MediaConnect handles key creation and rotation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automatic(java.lang.Object automatic) {
                this.automatic = automatic;
                return this;
            }

            /**
             * Sets the value of {@link FlowTransitEncryptionKeyConfigurationProperty#getSecretsManager}
             * @param secretsManager The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManager(software.amazon.awscdk.IResolvable secretsManager) {
                this.secretsManager = secretsManager;
                return this;
            }

            /**
             * Sets the value of {@link FlowTransitEncryptionKeyConfigurationProperty#getSecretsManager}
             * @param secretsManager The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManager(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SecretsManagerEncryptionKeyConfigurationProperty secretsManager) {
                this.secretsManager = secretsManager;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowTransitEncryptionKeyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowTransitEncryptionKeyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowTransitEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowTransitEncryptionKeyConfigurationProperty {
            private final java.lang.Object automatic;
            private final java.lang.Object secretsManager;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.automatic = software.amazon.jsii.Kernel.get(this, "automatic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretsManager = software.amazon.jsii.Kernel.get(this, "secretsManager", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.automatic = builder.automatic;
                this.secretsManager = builder.secretsManager;
            }

            @Override
            public final java.lang.Object getAutomatic() {
                return this.automatic;
            }

            @Override
            public final java.lang.Object getSecretsManager() {
                return this.secretsManager;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutomatic() != null) {
                    data.set("automatic", om.valueToTree(this.getAutomatic()));
                }
                if (this.getSecretsManager() != null) {
                    data.set("secretsManager", om.valueToTree(this.getSecretsManager()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.FlowTransitEncryptionKeyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowTransitEncryptionKeyConfigurationProperty.Jsii$Proxy that = (FlowTransitEncryptionKeyConfigurationProperty.Jsii$Proxy) o;

                if (this.automatic != null ? !this.automatic.equals(that.automatic) : that.automatic != null) return false;
                return this.secretsManager != null ? this.secretsManager.equals(that.secretsManager) : that.secretsManager == null;
            }

            @Override
            public final int hashCode() {
                int result = this.automatic != null ? this.automatic.hashCode() : 0;
                result = 31 * result + (this.secretsManager != null ? this.secretsManager.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration that defines how content is encrypted during transit between the MediaConnect router and a MediaConnect flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object automatic;
     * FlowTransitEncryptionProperty flowTransitEncryptionProperty = FlowTransitEncryptionProperty.builder()
     *         .encryptionKeyConfiguration(FlowTransitEncryptionKeyConfigurationProperty.builder()
     *                 .automatic(automatic)
     *                 .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                         .roleArn("roleArn")
     *                         .secretArn("secretArn")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .encryptionKeyType("encryptionKeyType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-flowtransitencryption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-flowtransitencryption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.FlowTransitEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowTransitEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowTransitEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for flow transit encryption keys.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.FlowTransitEncryptionKeyConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-flowtransitencryption.html#cfn-mediaconnect-routeroutput-flowtransitencryption-encryptionkeyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-flowtransitencryption.html#cfn-mediaconnect-routeroutput-flowtransitencryption-encryptionkeyconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncryptionKeyConfiguration();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-flowtransitencryption.html#cfn-mediaconnect-routeroutput-flowtransitencryption-encryptionkeytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-flowtransitencryption.html#cfn-mediaconnect-routeroutput-flowtransitencryption-encryptionkeytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowTransitEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowTransitEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowTransitEncryptionProperty> {
            java.lang.Object encryptionKeyConfiguration;
            java.lang.String encryptionKeyType;

            /**
             * Sets the value of {@link FlowTransitEncryptionProperty#getEncryptionKeyConfiguration}
             * @param encryptionKeyConfiguration Configuration settings for flow transit encryption keys. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyConfiguration(software.amazon.awscdk.IResolvable encryptionKeyConfiguration) {
                this.encryptionKeyConfiguration = encryptionKeyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FlowTransitEncryptionProperty#getEncryptionKeyConfiguration}
             * @param encryptionKeyConfiguration Configuration settings for flow transit encryption keys. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyConfiguration(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.FlowTransitEncryptionKeyConfigurationProperty encryptionKeyConfiguration) {
                this.encryptionKeyConfiguration = encryptionKeyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FlowTransitEncryptionProperty#getEncryptionKeyType}
             * @param encryptionKeyType the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyType(java.lang.String encryptionKeyType) {
                this.encryptionKeyType = encryptionKeyType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowTransitEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowTransitEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowTransitEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowTransitEncryptionProperty {
            private final java.lang.Object encryptionKeyConfiguration;
            private final java.lang.String encryptionKeyType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionKeyConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionKeyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionKeyType = software.amazon.jsii.Kernel.get(this, "encryptionKeyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionKeyConfiguration = java.util.Objects.requireNonNull(builder.encryptionKeyConfiguration, "encryptionKeyConfiguration is required");
                this.encryptionKeyType = builder.encryptionKeyType;
            }

            @Override
            public final java.lang.Object getEncryptionKeyConfiguration() {
                return this.encryptionKeyConfiguration;
            }

            @Override
            public final java.lang.String getEncryptionKeyType() {
                return this.encryptionKeyType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionKeyConfiguration", om.valueToTree(this.getEncryptionKeyConfiguration()));
                if (this.getEncryptionKeyType() != null) {
                    data.set("encryptionKeyType", om.valueToTree(this.getEncryptionKeyType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.FlowTransitEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowTransitEncryptionProperty.Jsii$Proxy that = (FlowTransitEncryptionProperty.Jsii$Proxy) o;

                if (!encryptionKeyConfiguration.equals(that.encryptionKeyConfiguration)) return false;
                return this.encryptionKeyType != null ? this.encryptionKeyType.equals(that.encryptionKeyType) : that.encryptionKeyType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionKeyConfiguration.hashCode();
                result = 31 * result + (this.encryptionKeyType != null ? this.encryptionKeyType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object default_;
     * MaintenanceConfigurationProperty maintenanceConfigurationProperty = MaintenanceConfigurationProperty.builder()
     *         .default(default_)
     *         .preferredDayTime(PreferredDayTimeMaintenanceConfigurationProperty.builder()
     *                 .day("day")
     *                 .time("time")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-maintenanceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-maintenanceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.MaintenanceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for default maintenance scheduling.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-maintenanceconfiguration.html#cfn-mediaconnect-routeroutput-maintenanceconfiguration-default">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-maintenanceconfiguration.html#cfn-mediaconnect-routeroutput-maintenanceconfiguration-default</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValue() {
            return null;
        }

        /**
         * Configuration for preferred day and time maintenance settings.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.PreferredDayTimeMaintenanceConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-maintenanceconfiguration.html#cfn-mediaconnect-routeroutput-maintenanceconfiguration-preferreddaytime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-maintenanceconfiguration.html#cfn-mediaconnect-routeroutput-maintenanceconfiguration-preferreddaytime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPreferredDayTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceConfigurationProperty> {
            java.lang.Object defaultValue;
            java.lang.Object preferredDayTime;

            /**
             * Sets the value of {@link MaintenanceConfigurationProperty#getDefaultValue}
             * @param defaultValue Configuration settings for default maintenance scheduling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.Object defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceConfigurationProperty#getPreferredDayTime}
             * @param preferredDayTime Configuration for preferred day and time maintenance settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preferredDayTime(software.amazon.awscdk.IResolvable preferredDayTime) {
                this.preferredDayTime = preferredDayTime;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceConfigurationProperty#getPreferredDayTime}
             * @param preferredDayTime Configuration for preferred day and time maintenance settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preferredDayTime(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.PreferredDayTimeMaintenanceConfigurationProperty preferredDayTime) {
                this.preferredDayTime = preferredDayTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceConfigurationProperty {
            private final java.lang.Object defaultValue;
            private final java.lang.Object preferredDayTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "default", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.preferredDayTime = software.amazon.jsii.Kernel.get(this, "preferredDayTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultValue = builder.defaultValue;
                this.preferredDayTime = builder.preferredDayTime;
            }

            @Override
            public final java.lang.Object getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            public final java.lang.Object getPreferredDayTime() {
                return this.preferredDayTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultValue() != null) {
                    data.set("default", om.valueToTree(this.getDefaultValue()));
                }
                if (this.getPreferredDayTime() != null) {
                    data.set("preferredDayTime", om.valueToTree(this.getPreferredDayTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.MaintenanceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceConfigurationProperty.Jsii$Proxy that = (MaintenanceConfigurationProperty.Jsii$Proxy) o;

                if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
                return this.preferredDayTime != null ? this.preferredDayTime.equals(that.preferredDayTime) : that.preferredDayTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultValue != null ? this.defaultValue.hashCode() : 0;
                result = 31 * result + (this.preferredDayTime != null ? this.preferredDayTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for connecting a router output to a MediaConnect flow source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object automatic;
     * MediaConnectFlowRouterOutputConfigurationProperty mediaConnectFlowRouterOutputConfigurationProperty = MediaConnectFlowRouterOutputConfigurationProperty.builder()
     *         .destinationTransitEncryption(FlowTransitEncryptionProperty.builder()
     *                 .encryptionKeyConfiguration(FlowTransitEncryptionKeyConfigurationProperty.builder()
     *                         .automatic(automatic)
     *                         .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                 .roleArn("roleArn")
     *                                 .secretArn("secretArn")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .encryptionKeyType("encryptionKeyType")
     *                 .build())
     *         // the properties below are optional
     *         .flowArn("flowArn")
     *         .flowSourceArn("flowSourceArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.MediaConnectFlowRouterOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MediaConnectFlowRouterOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MediaConnectFlowRouterOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration that defines how content is encrypted during transit between the MediaConnect router and a MediaConnect flow.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.FlowTransitEncryptionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration-destinationtransitencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration-destinationtransitencryption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestinationTransitEncryption();

        /**
         * The ARN of the flow to connect to this router output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration-flowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration-flowarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFlowArn() {
            return null;
        }

        /**
         * The ARN of the flow source to connect to this router output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration-flowsourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-mediaconnectflowrouteroutputconfiguration-flowsourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFlowSourceArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MediaConnectFlowRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MediaConnectFlowRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MediaConnectFlowRouterOutputConfigurationProperty> {
            java.lang.Object destinationTransitEncryption;
            java.lang.String flowArn;
            java.lang.String flowSourceArn;

            /**
             * Sets the value of {@link MediaConnectFlowRouterOutputConfigurationProperty#getDestinationTransitEncryption}
             * @param destinationTransitEncryption The configuration that defines how content is encrypted during transit between the MediaConnect router and a MediaConnect flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationTransitEncryption(software.amazon.awscdk.IResolvable destinationTransitEncryption) {
                this.destinationTransitEncryption = destinationTransitEncryption;
                return this;
            }

            /**
             * Sets the value of {@link MediaConnectFlowRouterOutputConfigurationProperty#getDestinationTransitEncryption}
             * @param destinationTransitEncryption The configuration that defines how content is encrypted during transit between the MediaConnect router and a MediaConnect flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationTransitEncryption(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.FlowTransitEncryptionProperty destinationTransitEncryption) {
                this.destinationTransitEncryption = destinationTransitEncryption;
                return this;
            }

            /**
             * Sets the value of {@link MediaConnectFlowRouterOutputConfigurationProperty#getFlowArn}
             * @param flowArn The ARN of the flow to connect to this router output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flowArn(java.lang.String flowArn) {
                this.flowArn = flowArn;
                return this;
            }

            /**
             * Sets the value of {@link MediaConnectFlowRouterOutputConfigurationProperty#getFlowSourceArn}
             * @param flowSourceArn The ARN of the flow source to connect to this router output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flowSourceArn(java.lang.String flowSourceArn) {
                this.flowSourceArn = flowSourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MediaConnectFlowRouterOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MediaConnectFlowRouterOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MediaConnectFlowRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MediaConnectFlowRouterOutputConfigurationProperty {
            private final java.lang.Object destinationTransitEncryption;
            private final java.lang.String flowArn;
            private final java.lang.String flowSourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationTransitEncryption = software.amazon.jsii.Kernel.get(this, "destinationTransitEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.flowArn = software.amazon.jsii.Kernel.get(this, "flowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.flowSourceArn = software.amazon.jsii.Kernel.get(this, "flowSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationTransitEncryption = java.util.Objects.requireNonNull(builder.destinationTransitEncryption, "destinationTransitEncryption is required");
                this.flowArn = builder.flowArn;
                this.flowSourceArn = builder.flowSourceArn;
            }

            @Override
            public final java.lang.Object getDestinationTransitEncryption() {
                return this.destinationTransitEncryption;
            }

            @Override
            public final java.lang.String getFlowArn() {
                return this.flowArn;
            }

            @Override
            public final java.lang.String getFlowSourceArn() {
                return this.flowSourceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationTransitEncryption", om.valueToTree(this.getDestinationTransitEncryption()));
                if (this.getFlowArn() != null) {
                    data.set("flowArn", om.valueToTree(this.getFlowArn()));
                }
                if (this.getFlowSourceArn() != null) {
                    data.set("flowSourceArn", om.valueToTree(this.getFlowSourceArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.MediaConnectFlowRouterOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MediaConnectFlowRouterOutputConfigurationProperty.Jsii$Proxy that = (MediaConnectFlowRouterOutputConfigurationProperty.Jsii$Proxy) o;

                if (!destinationTransitEncryption.equals(that.destinationTransitEncryption)) return false;
                if (this.flowArn != null ? !this.flowArn.equals(that.flowArn) : that.flowArn != null) return false;
                return this.flowSourceArn != null ? this.flowSourceArn.equals(that.flowSourceArn) : that.flowSourceArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationTransitEncryption.hashCode();
                result = 31 * result + (this.flowArn != null ? this.flowArn.hashCode() : 0);
                result = 31 * result + (this.flowSourceArn != null ? this.flowSourceArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for connecting a router output to a MediaLive input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object automatic;
     * MediaLiveInputRouterOutputConfigurationProperty mediaLiveInputRouterOutputConfigurationProperty = MediaLiveInputRouterOutputConfigurationProperty.builder()
     *         .destinationTransitEncryption(MediaLiveTransitEncryptionProperty.builder()
     *                 .encryptionKeyConfiguration(MediaLiveTransitEncryptionKeyConfigurationProperty.builder()
     *                         .automatic(automatic)
     *                         .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                 .roleArn("roleArn")
     *                                 .secretArn("secretArn")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .encryptionKeyType("encryptionKeyType")
     *                 .build())
     *         // the properties below are optional
     *         .mediaLiveInputArn("mediaLiveInputArn")
     *         .mediaLivePipelineId("mediaLivePipelineId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.MediaLiveInputRouterOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MediaLiveInputRouterOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MediaLiveInputRouterOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption configuration that defines how content is encrypted during transit between MediaConnect Router and MediaLive.
         * <p>
         * This configuration determines whether encryption keys are automatically managed by the service or manually managed through AWS Secrets Manager.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.MediaLiveTransitEncryptionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration-destinationtransitencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration-destinationtransitencryption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestinationTransitEncryption();

        /**
         * The ARN of the MediaLive input to connect to this router output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration-medialiveinputarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration-medialiveinputarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMediaLiveInputArn() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration-medialivepipelineid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-medialiveinputrouteroutputconfiguration-medialivepipelineid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMediaLivePipelineId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MediaLiveInputRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MediaLiveInputRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MediaLiveInputRouterOutputConfigurationProperty> {
            java.lang.Object destinationTransitEncryption;
            java.lang.String mediaLiveInputArn;
            java.lang.String mediaLivePipelineId;

            /**
             * Sets the value of {@link MediaLiveInputRouterOutputConfigurationProperty#getDestinationTransitEncryption}
             * @param destinationTransitEncryption The encryption configuration that defines how content is encrypted during transit between MediaConnect Router and MediaLive. This parameter is required.
             *                                     This configuration determines whether encryption keys are automatically managed by the service or manually managed through AWS Secrets Manager.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationTransitEncryption(software.amazon.awscdk.IResolvable destinationTransitEncryption) {
                this.destinationTransitEncryption = destinationTransitEncryption;
                return this;
            }

            /**
             * Sets the value of {@link MediaLiveInputRouterOutputConfigurationProperty#getDestinationTransitEncryption}
             * @param destinationTransitEncryption The encryption configuration that defines how content is encrypted during transit between MediaConnect Router and MediaLive. This parameter is required.
             *                                     This configuration determines whether encryption keys are automatically managed by the service or manually managed through AWS Secrets Manager.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationTransitEncryption(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.MediaLiveTransitEncryptionProperty destinationTransitEncryption) {
                this.destinationTransitEncryption = destinationTransitEncryption;
                return this;
            }

            /**
             * Sets the value of {@link MediaLiveInputRouterOutputConfigurationProperty#getMediaLiveInputArn}
             * @param mediaLiveInputArn The ARN of the MediaLive input to connect to this router output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaLiveInputArn(java.lang.String mediaLiveInputArn) {
                this.mediaLiveInputArn = mediaLiveInputArn;
                return this;
            }

            /**
             * Sets the value of {@link MediaLiveInputRouterOutputConfigurationProperty#getMediaLivePipelineId}
             * @param mediaLivePipelineId the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaLivePipelineId(java.lang.String mediaLivePipelineId) {
                this.mediaLivePipelineId = mediaLivePipelineId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MediaLiveInputRouterOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MediaLiveInputRouterOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MediaLiveInputRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MediaLiveInputRouterOutputConfigurationProperty {
            private final java.lang.Object destinationTransitEncryption;
            private final java.lang.String mediaLiveInputArn;
            private final java.lang.String mediaLivePipelineId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationTransitEncryption = software.amazon.jsii.Kernel.get(this, "destinationTransitEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mediaLiveInputArn = software.amazon.jsii.Kernel.get(this, "mediaLiveInputArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mediaLivePipelineId = software.amazon.jsii.Kernel.get(this, "mediaLivePipelineId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationTransitEncryption = java.util.Objects.requireNonNull(builder.destinationTransitEncryption, "destinationTransitEncryption is required");
                this.mediaLiveInputArn = builder.mediaLiveInputArn;
                this.mediaLivePipelineId = builder.mediaLivePipelineId;
            }

            @Override
            public final java.lang.Object getDestinationTransitEncryption() {
                return this.destinationTransitEncryption;
            }

            @Override
            public final java.lang.String getMediaLiveInputArn() {
                return this.mediaLiveInputArn;
            }

            @Override
            public final java.lang.String getMediaLivePipelineId() {
                return this.mediaLivePipelineId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationTransitEncryption", om.valueToTree(this.getDestinationTransitEncryption()));
                if (this.getMediaLiveInputArn() != null) {
                    data.set("mediaLiveInputArn", om.valueToTree(this.getMediaLiveInputArn()));
                }
                if (this.getMediaLivePipelineId() != null) {
                    data.set("mediaLivePipelineId", om.valueToTree(this.getMediaLivePipelineId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.MediaLiveInputRouterOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MediaLiveInputRouterOutputConfigurationProperty.Jsii$Proxy that = (MediaLiveInputRouterOutputConfigurationProperty.Jsii$Proxy) o;

                if (!destinationTransitEncryption.equals(that.destinationTransitEncryption)) return false;
                if (this.mediaLiveInputArn != null ? !this.mediaLiveInputArn.equals(that.mediaLiveInputArn) : that.mediaLiveInputArn != null) return false;
                return this.mediaLivePipelineId != null ? this.mediaLivePipelineId.equals(that.mediaLivePipelineId) : that.mediaLivePipelineId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationTransitEncryption.hashCode();
                result = 31 * result + (this.mediaLiveInputArn != null ? this.mediaLiveInputArn.hashCode() : 0);
                result = 31 * result + (this.mediaLivePipelineId != null ? this.mediaLivePipelineId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object automatic;
     * MediaLiveTransitEncryptionKeyConfigurationProperty mediaLiveTransitEncryptionKeyConfigurationProperty = MediaLiveTransitEncryptionKeyConfigurationProperty.builder()
     *         .automatic(automatic)
     *         .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .secretArn("secretArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialivetransitencryptionkeyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialivetransitencryptionkeyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.MediaLiveTransitEncryptionKeyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MediaLiveTransitEncryptionKeyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MediaLiveTransitEncryptionKeyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for automatic encryption key management, where MediaConnect handles key creation and rotation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialivetransitencryptionkeyconfiguration.html#cfn-mediaconnect-routeroutput-medialivetransitencryptionkeyconfiguration-automatic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialivetransitencryptionkeyconfiguration.html#cfn-mediaconnect-routeroutput-medialivetransitencryptionkeyconfiguration-automatic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomatic() {
            return null;
        }

        /**
         * The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SecretsManagerEncryptionKeyConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialivetransitencryptionkeyconfiguration.html#cfn-mediaconnect-routeroutput-medialivetransitencryptionkeyconfiguration-secretsmanager">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialivetransitencryptionkeyconfiguration.html#cfn-mediaconnect-routeroutput-medialivetransitencryptionkeyconfiguration-secretsmanager</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecretsManager() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MediaLiveTransitEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MediaLiveTransitEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MediaLiveTransitEncryptionKeyConfigurationProperty> {
            java.lang.Object automatic;
            java.lang.Object secretsManager;

            /**
             * Sets the value of {@link MediaLiveTransitEncryptionKeyConfigurationProperty#getAutomatic}
             * @param automatic Configuration settings for automatic encryption key management, where MediaConnect handles key creation and rotation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automatic(java.lang.Object automatic) {
                this.automatic = automatic;
                return this;
            }

            /**
             * Sets the value of {@link MediaLiveTransitEncryptionKeyConfigurationProperty#getSecretsManager}
             * @param secretsManager The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManager(software.amazon.awscdk.IResolvable secretsManager) {
                this.secretsManager = secretsManager;
                return this;
            }

            /**
             * Sets the value of {@link MediaLiveTransitEncryptionKeyConfigurationProperty#getSecretsManager}
             * @param secretsManager The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManager(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SecretsManagerEncryptionKeyConfigurationProperty secretsManager) {
                this.secretsManager = secretsManager;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MediaLiveTransitEncryptionKeyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MediaLiveTransitEncryptionKeyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MediaLiveTransitEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MediaLiveTransitEncryptionKeyConfigurationProperty {
            private final java.lang.Object automatic;
            private final java.lang.Object secretsManager;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.automatic = software.amazon.jsii.Kernel.get(this, "automatic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretsManager = software.amazon.jsii.Kernel.get(this, "secretsManager", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.automatic = builder.automatic;
                this.secretsManager = builder.secretsManager;
            }

            @Override
            public final java.lang.Object getAutomatic() {
                return this.automatic;
            }

            @Override
            public final java.lang.Object getSecretsManager() {
                return this.secretsManager;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutomatic() != null) {
                    data.set("automatic", om.valueToTree(this.getAutomatic()));
                }
                if (this.getSecretsManager() != null) {
                    data.set("secretsManager", om.valueToTree(this.getSecretsManager()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.MediaLiveTransitEncryptionKeyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MediaLiveTransitEncryptionKeyConfigurationProperty.Jsii$Proxy that = (MediaLiveTransitEncryptionKeyConfigurationProperty.Jsii$Proxy) o;

                if (this.automatic != null ? !this.automatic.equals(that.automatic) : that.automatic != null) return false;
                return this.secretsManager != null ? this.secretsManager.equals(that.secretsManager) : that.secretsManager == null;
            }

            @Override
            public final int hashCode() {
                int result = this.automatic != null ? this.automatic.hashCode() : 0;
                result = 31 * result + (this.secretsManager != null ? this.secretsManager.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The encryption configuration that defines how content is encrypted during transit between MediaConnect Router and MediaLive.
     * <p>
     * This configuration determines whether encryption keys are automatically managed by the service or manually managed through AWS Secrets Manager.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object automatic;
     * MediaLiveTransitEncryptionProperty mediaLiveTransitEncryptionProperty = MediaLiveTransitEncryptionProperty.builder()
     *         .encryptionKeyConfiguration(MediaLiveTransitEncryptionKeyConfigurationProperty.builder()
     *                 .automatic(automatic)
     *                 .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                         .roleArn("roleArn")
     *                         .secretArn("secretArn")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .encryptionKeyType("encryptionKeyType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialivetransitencryption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialivetransitencryption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.MediaLiveTransitEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(MediaLiveTransitEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MediaLiveTransitEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for the MediaLive transit encryption key.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.MediaLiveTransitEncryptionKeyConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialivetransitencryption.html#cfn-mediaconnect-routeroutput-medialivetransitencryption-encryptionkeyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialivetransitencryption.html#cfn-mediaconnect-routeroutput-medialivetransitencryption-encryptionkeyconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncryptionKeyConfiguration();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialivetransitencryption.html#cfn-mediaconnect-routeroutput-medialivetransitencryption-encryptionkeytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-medialivetransitencryption.html#cfn-mediaconnect-routeroutput-medialivetransitencryption-encryptionkeytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MediaLiveTransitEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MediaLiveTransitEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MediaLiveTransitEncryptionProperty> {
            java.lang.Object encryptionKeyConfiguration;
            java.lang.String encryptionKeyType;

            /**
             * Sets the value of {@link MediaLiveTransitEncryptionProperty#getEncryptionKeyConfiguration}
             * @param encryptionKeyConfiguration Configuration settings for the MediaLive transit encryption key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyConfiguration(software.amazon.awscdk.IResolvable encryptionKeyConfiguration) {
                this.encryptionKeyConfiguration = encryptionKeyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MediaLiveTransitEncryptionProperty#getEncryptionKeyConfiguration}
             * @param encryptionKeyConfiguration Configuration settings for the MediaLive transit encryption key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyConfiguration(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.MediaLiveTransitEncryptionKeyConfigurationProperty encryptionKeyConfiguration) {
                this.encryptionKeyConfiguration = encryptionKeyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MediaLiveTransitEncryptionProperty#getEncryptionKeyType}
             * @param encryptionKeyType the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyType(java.lang.String encryptionKeyType) {
                this.encryptionKeyType = encryptionKeyType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MediaLiveTransitEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MediaLiveTransitEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MediaLiveTransitEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MediaLiveTransitEncryptionProperty {
            private final java.lang.Object encryptionKeyConfiguration;
            private final java.lang.String encryptionKeyType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionKeyConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionKeyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionKeyType = software.amazon.jsii.Kernel.get(this, "encryptionKeyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionKeyConfiguration = java.util.Objects.requireNonNull(builder.encryptionKeyConfiguration, "encryptionKeyConfiguration is required");
                this.encryptionKeyType = builder.encryptionKeyType;
            }

            @Override
            public final java.lang.Object getEncryptionKeyConfiguration() {
                return this.encryptionKeyConfiguration;
            }

            @Override
            public final java.lang.String getEncryptionKeyType() {
                return this.encryptionKeyType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionKeyConfiguration", om.valueToTree(this.getEncryptionKeyConfiguration()));
                if (this.getEncryptionKeyType() != null) {
                    data.set("encryptionKeyType", om.valueToTree(this.getEncryptionKeyType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.MediaLiveTransitEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MediaLiveTransitEncryptionProperty.Jsii$Proxy that = (MediaLiveTransitEncryptionProperty.Jsii$Proxy) o;

                if (!encryptionKeyConfiguration.equals(that.encryptionKeyConfiguration)) return false;
                return this.encryptionKeyType != null ? this.encryptionKeyType.equals(that.encryptionKeyType) : that.encryptionKeyType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionKeyConfiguration.hashCode();
                result = 31 * result + (this.encryptionKeyType != null ? this.encryptionKeyType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for preferred day and time maintenance settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * PreferredDayTimeMaintenanceConfigurationProperty preferredDayTimeMaintenanceConfigurationProperty = PreferredDayTimeMaintenanceConfigurationProperty.builder()
     *         .day("day")
     *         .time("time")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-preferreddaytimemaintenanceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-preferreddaytimemaintenanceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.PreferredDayTimeMaintenanceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PreferredDayTimeMaintenanceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PreferredDayTimeMaintenanceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-preferreddaytimemaintenanceconfiguration.html#cfn-mediaconnect-routeroutput-preferreddaytimemaintenanceconfiguration-day">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-preferreddaytimemaintenanceconfiguration.html#cfn-mediaconnect-routeroutput-preferreddaytimemaintenanceconfiguration-day</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDay();

        /**
         * The preferred time for maintenance operations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-preferreddaytimemaintenanceconfiguration.html#cfn-mediaconnect-routeroutput-preferreddaytimemaintenanceconfiguration-time">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-preferreddaytimemaintenanceconfiguration.html#cfn-mediaconnect-routeroutput-preferreddaytimemaintenanceconfiguration-time</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTime();

        /**
         * @return a {@link Builder} of {@link PreferredDayTimeMaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PreferredDayTimeMaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PreferredDayTimeMaintenanceConfigurationProperty> {
            java.lang.String day;
            java.lang.String time;

            /**
             * Sets the value of {@link PreferredDayTimeMaintenanceConfigurationProperty#getDay}
             * @param day the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder day(java.lang.String day) {
                this.day = day;
                return this;
            }

            /**
             * Sets the value of {@link PreferredDayTimeMaintenanceConfigurationProperty#getTime}
             * @param time The preferred time for maintenance operations. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder time(java.lang.String time) {
                this.time = time;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PreferredDayTimeMaintenanceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PreferredDayTimeMaintenanceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PreferredDayTimeMaintenanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PreferredDayTimeMaintenanceConfigurationProperty {
            private final java.lang.String day;
            private final java.lang.String time;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.day = software.amazon.jsii.Kernel.get(this, "day", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.time = software.amazon.jsii.Kernel.get(this, "time", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.day = java.util.Objects.requireNonNull(builder.day, "day is required");
                this.time = java.util.Objects.requireNonNull(builder.time, "time is required");
            }

            @Override
            public final java.lang.String getDay() {
                return this.day;
            }

            @Override
            public final java.lang.String getTime() {
                return this.time;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("day", om.valueToTree(this.getDay()));
                data.set("time", om.valueToTree(this.getTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.PreferredDayTimeMaintenanceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PreferredDayTimeMaintenanceConfigurationProperty.Jsii$Proxy that = (PreferredDayTimeMaintenanceConfigurationProperty.Jsii$Proxy) o;

                if (!day.equals(that.day)) return false;
                return this.time.equals(that.time);
            }

            @Override
            public final int hashCode() {
                int result = this.day.hashCode();
                result = 31 * result + (this.time.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration settings for a router output using the RIST (Reliable Internet Stream Transport) protocol, including the destination address and port.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * RistRouterOutputConfigurationProperty ristRouterOutputConfigurationProperty = RistRouterOutputConfigurationProperty.builder()
     *         .destinationAddress("destinationAddress")
     *         .destinationPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-ristrouteroutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-ristrouteroutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.RistRouterOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RistRouterOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RistRouterOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination IP address for the RIST protocol in the router output configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-ristrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-ristrouteroutputconfiguration-destinationaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-ristrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-ristrouteroutputconfiguration-destinationaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationAddress();

        /**
         * The destination port number for the RIST protocol in the router output configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-ristrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-ristrouteroutputconfiguration-destinationport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-ristrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-ristrouteroutputconfiguration-destinationport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDestinationPort();

        /**
         * @return a {@link Builder} of {@link RistRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RistRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RistRouterOutputConfigurationProperty> {
            java.lang.String destinationAddress;
            java.lang.Number destinationPort;

            /**
             * Sets the value of {@link RistRouterOutputConfigurationProperty#getDestinationAddress}
             * @param destinationAddress The destination IP address for the RIST protocol in the router output configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationAddress(java.lang.String destinationAddress) {
                this.destinationAddress = destinationAddress;
                return this;
            }

            /**
             * Sets the value of {@link RistRouterOutputConfigurationProperty#getDestinationPort}
             * @param destinationPort The destination port number for the RIST protocol in the router output configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPort(java.lang.Number destinationPort) {
                this.destinationPort = destinationPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RistRouterOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RistRouterOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RistRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RistRouterOutputConfigurationProperty {
            private final java.lang.String destinationAddress;
            private final java.lang.Number destinationPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationAddress = software.amazon.jsii.Kernel.get(this, "destinationAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationPort = software.amazon.jsii.Kernel.get(this, "destinationPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationAddress = java.util.Objects.requireNonNull(builder.destinationAddress, "destinationAddress is required");
                this.destinationPort = java.util.Objects.requireNonNull(builder.destinationPort, "destinationPort is required");
            }

            @Override
            public final java.lang.String getDestinationAddress() {
                return this.destinationAddress;
            }

            @Override
            public final java.lang.Number getDestinationPort() {
                return this.destinationPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationAddress", om.valueToTree(this.getDestinationAddress()));
                data.set("destinationPort", om.valueToTree(this.getDestinationPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.RistRouterOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RistRouterOutputConfigurationProperty.Jsii$Proxy that = (RistRouterOutputConfigurationProperty.Jsii$Proxy) o;

                if (!destinationAddress.equals(that.destinationAddress)) return false;
                return this.destinationPort.equals(that.destinationPort);
            }

            @Override
            public final int hashCode() {
                int result = this.destinationAddress.hashCode();
                result = 31 * result + (this.destinationPort.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * Object automatic;
     * RouterOutputConfigurationProperty routerOutputConfigurationProperty = RouterOutputConfigurationProperty.builder()
     *         .mediaConnectFlow(MediaConnectFlowRouterOutputConfigurationProperty.builder()
     *                 .destinationTransitEncryption(FlowTransitEncryptionProperty.builder()
     *                         .encryptionKeyConfiguration(FlowTransitEncryptionKeyConfigurationProperty.builder()
     *                                 .automatic(automatic)
     *                                 .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                         .roleArn("roleArn")
     *                                         .secretArn("secretArn")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .encryptionKeyType("encryptionKeyType")
     *                         .build())
     *                 // the properties below are optional
     *                 .flowArn("flowArn")
     *                 .flowSourceArn("flowSourceArn")
     *                 .build())
     *         .mediaLiveInput(MediaLiveInputRouterOutputConfigurationProperty.builder()
     *                 .destinationTransitEncryption(MediaLiveTransitEncryptionProperty.builder()
     *                         .encryptionKeyConfiguration(MediaLiveTransitEncryptionKeyConfigurationProperty.builder()
     *                                 .automatic(automatic)
     *                                 .secretsManager(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                         .roleArn("roleArn")
     *                                         .secretArn("secretArn")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .encryptionKeyType("encryptionKeyType")
     *                         .build())
     *                 // the properties below are optional
     *                 .mediaLiveInputArn("mediaLiveInputArn")
     *                 .mediaLivePipelineId("mediaLivePipelineId")
     *                 .build())
     *         .standard(StandardRouterOutputConfigurationProperty.builder()
     *                 .networkInterfaceArn("networkInterfaceArn")
     *                 .protocolConfiguration(RouterOutputProtocolConfigurationProperty.builder()
     *                         .rist(RistRouterOutputConfigurationProperty.builder()
     *                                 .destinationAddress("destinationAddress")
     *                                 .destinationPort(123)
     *                                 .build())
     *                         .rtp(RtpRouterOutputConfigurationProperty.builder()
     *                                 .destinationAddress("destinationAddress")
     *                                 .destinationPort(123)
     *                                 // the properties below are optional
     *                                 .forwardErrorCorrection("forwardErrorCorrection")
     *                                 .build())
     *                         .srtCaller(SrtCallerRouterOutputConfigurationProperty.builder()
     *                                 .destinationAddress("destinationAddress")
     *                                 .destinationPort(123)
     *                                 .minimumLatencyMilliseconds(123)
     *                                 // the properties below are optional
     *                                 .encryptionConfiguration(SrtEncryptionConfigurationProperty.builder()
     *                                         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                                 .roleArn("roleArn")
     *                                                 .secretArn("secretArn")
     *                                                 .build())
     *                                         .build())
     *                                 .streamId("streamId")
     *                                 .build())
     *                         .srtListener(SrtListenerRouterOutputConfigurationProperty.builder()
     *                                 .minimumLatencyMilliseconds(123)
     *                                 .port(123)
     *                                 // the properties below are optional
     *                                 .encryptionConfiguration(SrtEncryptionConfigurationProperty.builder()
     *                                         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                                 .roleArn("roleArn")
     *                                                 .secretArn("secretArn")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .protocol("protocol")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.RouterOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RouterOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RouterOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for connecting a router output to a MediaConnect flow source.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.MediaConnectFlowRouterOutputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputconfiguration-mediaconnectflow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputconfiguration-mediaconnectflow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMediaConnectFlow() {
            return null;
        }

        /**
         * Configuration settings for connecting a router output to a MediaLive input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.MediaLiveInputRouterOutputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputconfiguration-medialiveinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputconfiguration-medialiveinput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMediaLiveInput() {
            return null;
        }

        /**
         * The configuration settings for a standard router output, including the protocol, protocol-specific configuration, network interface, and availability zone.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.StandardRouterOutputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputconfiguration-standard">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputconfiguration-standard</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStandard() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RouterOutputConfigurationProperty> {
            java.lang.Object mediaConnectFlow;
            java.lang.Object mediaLiveInput;
            java.lang.Object standard;

            /**
             * Sets the value of {@link RouterOutputConfigurationProperty#getMediaConnectFlow}
             * @param mediaConnectFlow Configuration settings for connecting a router output to a MediaConnect flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaConnectFlow(software.amazon.awscdk.IResolvable mediaConnectFlow) {
                this.mediaConnectFlow = mediaConnectFlow;
                return this;
            }

            /**
             * Sets the value of {@link RouterOutputConfigurationProperty#getMediaConnectFlow}
             * @param mediaConnectFlow Configuration settings for connecting a router output to a MediaConnect flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaConnectFlow(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.MediaConnectFlowRouterOutputConfigurationProperty mediaConnectFlow) {
                this.mediaConnectFlow = mediaConnectFlow;
                return this;
            }

            /**
             * Sets the value of {@link RouterOutputConfigurationProperty#getMediaLiveInput}
             * @param mediaLiveInput Configuration settings for connecting a router output to a MediaLive input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaLiveInput(software.amazon.awscdk.IResolvable mediaLiveInput) {
                this.mediaLiveInput = mediaLiveInput;
                return this;
            }

            /**
             * Sets the value of {@link RouterOutputConfigurationProperty#getMediaLiveInput}
             * @param mediaLiveInput Configuration settings for connecting a router output to a MediaLive input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaLiveInput(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.MediaLiveInputRouterOutputConfigurationProperty mediaLiveInput) {
                this.mediaLiveInput = mediaLiveInput;
                return this;
            }

            /**
             * Sets the value of {@link RouterOutputConfigurationProperty#getStandard}
             * @param standard The configuration settings for a standard router output, including the protocol, protocol-specific configuration, network interface, and availability zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder standard(software.amazon.awscdk.IResolvable standard) {
                this.standard = standard;
                return this;
            }

            /**
             * Sets the value of {@link RouterOutputConfigurationProperty#getStandard}
             * @param standard The configuration settings for a standard router output, including the protocol, protocol-specific configuration, network interface, and availability zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder standard(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.StandardRouterOutputConfigurationProperty standard) {
                this.standard = standard;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RouterOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RouterOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouterOutputConfigurationProperty {
            private final java.lang.Object mediaConnectFlow;
            private final java.lang.Object mediaLiveInput;
            private final java.lang.Object standard;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mediaConnectFlow = software.amazon.jsii.Kernel.get(this, "mediaConnectFlow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mediaLiveInput = software.amazon.jsii.Kernel.get(this, "mediaLiveInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.standard = software.amazon.jsii.Kernel.get(this, "standard", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mediaConnectFlow = builder.mediaConnectFlow;
                this.mediaLiveInput = builder.mediaLiveInput;
                this.standard = builder.standard;
            }

            @Override
            public final java.lang.Object getMediaConnectFlow() {
                return this.mediaConnectFlow;
            }

            @Override
            public final java.lang.Object getMediaLiveInput() {
                return this.mediaLiveInput;
            }

            @Override
            public final java.lang.Object getStandard() {
                return this.standard;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMediaConnectFlow() != null) {
                    data.set("mediaConnectFlow", om.valueToTree(this.getMediaConnectFlow()));
                }
                if (this.getMediaLiveInput() != null) {
                    data.set("mediaLiveInput", om.valueToTree(this.getMediaLiveInput()));
                }
                if (this.getStandard() != null) {
                    data.set("standard", om.valueToTree(this.getStandard()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.RouterOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RouterOutputConfigurationProperty.Jsii$Proxy that = (RouterOutputConfigurationProperty.Jsii$Proxy) o;

                if (this.mediaConnectFlow != null ? !this.mediaConnectFlow.equals(that.mediaConnectFlow) : that.mediaConnectFlow != null) return false;
                if (this.mediaLiveInput != null ? !this.mediaLiveInput.equals(that.mediaLiveInput) : that.mediaLiveInput != null) return false;
                return this.standard != null ? this.standard.equals(that.standard) : that.standard == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mediaConnectFlow != null ? this.mediaConnectFlow.hashCode() : 0;
                result = 31 * result + (this.mediaLiveInput != null ? this.mediaLiveInput.hashCode() : 0);
                result = 31 * result + (this.standard != null ? this.standard.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * RouterOutputProtocolConfigurationProperty routerOutputProtocolConfigurationProperty = RouterOutputProtocolConfigurationProperty.builder()
     *         .rist(RistRouterOutputConfigurationProperty.builder()
     *                 .destinationAddress("destinationAddress")
     *                 .destinationPort(123)
     *                 .build())
     *         .rtp(RtpRouterOutputConfigurationProperty.builder()
     *                 .destinationAddress("destinationAddress")
     *                 .destinationPort(123)
     *                 // the properties below are optional
     *                 .forwardErrorCorrection("forwardErrorCorrection")
     *                 .build())
     *         .srtCaller(SrtCallerRouterOutputConfigurationProperty.builder()
     *                 .destinationAddress("destinationAddress")
     *                 .destinationPort(123)
     *                 .minimumLatencyMilliseconds(123)
     *                 // the properties below are optional
     *                 .encryptionConfiguration(SrtEncryptionConfigurationProperty.builder()
     *                         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                 .roleArn("roleArn")
     *                                 .secretArn("secretArn")
     *                                 .build())
     *                         .build())
     *                 .streamId("streamId")
     *                 .build())
     *         .srtListener(SrtListenerRouterOutputConfigurationProperty.builder()
     *                 .minimumLatencyMilliseconds(123)
     *                 .port(123)
     *                 // the properties below are optional
     *                 .encryptionConfiguration(SrtEncryptionConfigurationProperty.builder()
     *                         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                 .roleArn("roleArn")
     *                                 .secretArn("secretArn")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputprotocolconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputprotocolconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.RouterOutputProtocolConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RouterOutputProtocolConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RouterOutputProtocolConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration settings for a router output using the RIST (Reliable Internet Stream Transport) protocol, including the destination address and port.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.RistRouterOutputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputprotocolconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputprotocolconfiguration-rist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputprotocolconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputprotocolconfiguration-rist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRist() {
            return null;
        }

        /**
         * The configuration settings for a router output using the RTP (Real-Time Transport Protocol) protocol, including the destination address and port, and forward error correction state.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.RtpRouterOutputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputprotocolconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputprotocolconfiguration-rtp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputprotocolconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputprotocolconfiguration-rtp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRtp() {
            return null;
        }

        /**
         * The configuration settings for a router output using the SRT (Secure Reliable Transport) protocol in caller mode, including the destination address and port, minimum latency, stream ID, and encryption key configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SrtCallerRouterOutputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputprotocolconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputprotocolconfiguration-srtcaller">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputprotocolconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputprotocolconfiguration-srtcaller</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSrtCaller() {
            return null;
        }

        /**
         * The configuration settings for a router output using the SRT (Secure Reliable Transport) protocol in listener mode, including the port, minimum latency, and encryption key configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SrtListenerRouterOutputConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputprotocolconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputprotocolconfiguration-srtlistener">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-routeroutputprotocolconfiguration.html#cfn-mediaconnect-routeroutput-routeroutputprotocolconfiguration-srtlistener</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSrtListener() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RouterOutputProtocolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RouterOutputProtocolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RouterOutputProtocolConfigurationProperty> {
            java.lang.Object rist;
            java.lang.Object rtp;
            java.lang.Object srtCaller;
            java.lang.Object srtListener;

            /**
             * Sets the value of {@link RouterOutputProtocolConfigurationProperty#getRist}
             * @param rist The configuration settings for a router output using the RIST (Reliable Internet Stream Transport) protocol, including the destination address and port.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rist(software.amazon.awscdk.IResolvable rist) {
                this.rist = rist;
                return this;
            }

            /**
             * Sets the value of {@link RouterOutputProtocolConfigurationProperty#getRist}
             * @param rist The configuration settings for a router output using the RIST (Reliable Internet Stream Transport) protocol, including the destination address and port.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rist(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.RistRouterOutputConfigurationProperty rist) {
                this.rist = rist;
                return this;
            }

            /**
             * Sets the value of {@link RouterOutputProtocolConfigurationProperty#getRtp}
             * @param rtp The configuration settings for a router output using the RTP (Real-Time Transport Protocol) protocol, including the destination address and port, and forward error correction state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rtp(software.amazon.awscdk.IResolvable rtp) {
                this.rtp = rtp;
                return this;
            }

            /**
             * Sets the value of {@link RouterOutputProtocolConfigurationProperty#getRtp}
             * @param rtp The configuration settings for a router output using the RTP (Real-Time Transport Protocol) protocol, including the destination address and port, and forward error correction state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rtp(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.RtpRouterOutputConfigurationProperty rtp) {
                this.rtp = rtp;
                return this;
            }

            /**
             * Sets the value of {@link RouterOutputProtocolConfigurationProperty#getSrtCaller}
             * @param srtCaller The configuration settings for a router output using the SRT (Secure Reliable Transport) protocol in caller mode, including the destination address and port, minimum latency, stream ID, and encryption key configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder srtCaller(software.amazon.awscdk.IResolvable srtCaller) {
                this.srtCaller = srtCaller;
                return this;
            }

            /**
             * Sets the value of {@link RouterOutputProtocolConfigurationProperty#getSrtCaller}
             * @param srtCaller The configuration settings for a router output using the SRT (Secure Reliable Transport) protocol in caller mode, including the destination address and port, minimum latency, stream ID, and encryption key configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder srtCaller(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SrtCallerRouterOutputConfigurationProperty srtCaller) {
                this.srtCaller = srtCaller;
                return this;
            }

            /**
             * Sets the value of {@link RouterOutputProtocolConfigurationProperty#getSrtListener}
             * @param srtListener The configuration settings for a router output using the SRT (Secure Reliable Transport) protocol in listener mode, including the port, minimum latency, and encryption key configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder srtListener(software.amazon.awscdk.IResolvable srtListener) {
                this.srtListener = srtListener;
                return this;
            }

            /**
             * Sets the value of {@link RouterOutputProtocolConfigurationProperty#getSrtListener}
             * @param srtListener The configuration settings for a router output using the SRT (Secure Reliable Transport) protocol in listener mode, including the port, minimum latency, and encryption key configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder srtListener(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SrtListenerRouterOutputConfigurationProperty srtListener) {
                this.srtListener = srtListener;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RouterOutputProtocolConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RouterOutputProtocolConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RouterOutputProtocolConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouterOutputProtocolConfigurationProperty {
            private final java.lang.Object rist;
            private final java.lang.Object rtp;
            private final java.lang.Object srtCaller;
            private final java.lang.Object srtListener;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rist = software.amazon.jsii.Kernel.get(this, "rist", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rtp = software.amazon.jsii.Kernel.get(this, "rtp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.srtCaller = software.amazon.jsii.Kernel.get(this, "srtCaller", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.srtListener = software.amazon.jsii.Kernel.get(this, "srtListener", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rist = builder.rist;
                this.rtp = builder.rtp;
                this.srtCaller = builder.srtCaller;
                this.srtListener = builder.srtListener;
            }

            @Override
            public final java.lang.Object getRist() {
                return this.rist;
            }

            @Override
            public final java.lang.Object getRtp() {
                return this.rtp;
            }

            @Override
            public final java.lang.Object getSrtCaller() {
                return this.srtCaller;
            }

            @Override
            public final java.lang.Object getSrtListener() {
                return this.srtListener;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRist() != null) {
                    data.set("rist", om.valueToTree(this.getRist()));
                }
                if (this.getRtp() != null) {
                    data.set("rtp", om.valueToTree(this.getRtp()));
                }
                if (this.getSrtCaller() != null) {
                    data.set("srtCaller", om.valueToTree(this.getSrtCaller()));
                }
                if (this.getSrtListener() != null) {
                    data.set("srtListener", om.valueToTree(this.getSrtListener()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.RouterOutputProtocolConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RouterOutputProtocolConfigurationProperty.Jsii$Proxy that = (RouterOutputProtocolConfigurationProperty.Jsii$Proxy) o;

                if (this.rist != null ? !this.rist.equals(that.rist) : that.rist != null) return false;
                if (this.rtp != null ? !this.rtp.equals(that.rtp) : that.rtp != null) return false;
                if (this.srtCaller != null ? !this.srtCaller.equals(that.srtCaller) : that.srtCaller != null) return false;
                return this.srtListener != null ? this.srtListener.equals(that.srtListener) : that.srtListener == null;
            }

            @Override
            public final int hashCode() {
                int result = this.rist != null ? this.rist.hashCode() : 0;
                result = 31 * result + (this.rtp != null ? this.rtp.hashCode() : 0);
                result = 31 * result + (this.srtCaller != null ? this.srtCaller.hashCode() : 0);
                result = 31 * result + (this.srtListener != null ? this.srtListener.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration settings for a router output using the RTP (Real-Time Transport Protocol) protocol, including the destination address and port, and forward error correction state.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * RtpRouterOutputConfigurationProperty rtpRouterOutputConfigurationProperty = RtpRouterOutputConfigurationProperty.builder()
     *         .destinationAddress("destinationAddress")
     *         .destinationPort(123)
     *         // the properties below are optional
     *         .forwardErrorCorrection("forwardErrorCorrection")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-rtprouteroutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-rtprouteroutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.RtpRouterOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RtpRouterOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RtpRouterOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination IP address for the RTP protocol in the router output configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-rtprouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-rtprouteroutputconfiguration-destinationaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-rtprouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-rtprouteroutputconfiguration-destinationaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationAddress();

        /**
         * The destination port number for the RTP protocol in the router output configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-rtprouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-rtprouteroutputconfiguration-destinationport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-rtprouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-rtprouteroutputconfiguration-destinationport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDestinationPort();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-rtprouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-rtprouteroutputconfiguration-forwarderrorcorrection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-rtprouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-rtprouteroutputconfiguration-forwarderrorcorrection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getForwardErrorCorrection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RtpRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RtpRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RtpRouterOutputConfigurationProperty> {
            java.lang.String destinationAddress;
            java.lang.Number destinationPort;
            java.lang.String forwardErrorCorrection;

            /**
             * Sets the value of {@link RtpRouterOutputConfigurationProperty#getDestinationAddress}
             * @param destinationAddress The destination IP address for the RTP protocol in the router output configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationAddress(java.lang.String destinationAddress) {
                this.destinationAddress = destinationAddress;
                return this;
            }

            /**
             * Sets the value of {@link RtpRouterOutputConfigurationProperty#getDestinationPort}
             * @param destinationPort The destination port number for the RTP protocol in the router output configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPort(java.lang.Number destinationPort) {
                this.destinationPort = destinationPort;
                return this;
            }

            /**
             * Sets the value of {@link RtpRouterOutputConfigurationProperty#getForwardErrorCorrection}
             * @param forwardErrorCorrection the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardErrorCorrection(java.lang.String forwardErrorCorrection) {
                this.forwardErrorCorrection = forwardErrorCorrection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RtpRouterOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RtpRouterOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RtpRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RtpRouterOutputConfigurationProperty {
            private final java.lang.String destinationAddress;
            private final java.lang.Number destinationPort;
            private final java.lang.String forwardErrorCorrection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationAddress = software.amazon.jsii.Kernel.get(this, "destinationAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationPort = software.amazon.jsii.Kernel.get(this, "destinationPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.forwardErrorCorrection = software.amazon.jsii.Kernel.get(this, "forwardErrorCorrection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationAddress = java.util.Objects.requireNonNull(builder.destinationAddress, "destinationAddress is required");
                this.destinationPort = java.util.Objects.requireNonNull(builder.destinationPort, "destinationPort is required");
                this.forwardErrorCorrection = builder.forwardErrorCorrection;
            }

            @Override
            public final java.lang.String getDestinationAddress() {
                return this.destinationAddress;
            }

            @Override
            public final java.lang.Number getDestinationPort() {
                return this.destinationPort;
            }

            @Override
            public final java.lang.String getForwardErrorCorrection() {
                return this.forwardErrorCorrection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationAddress", om.valueToTree(this.getDestinationAddress()));
                data.set("destinationPort", om.valueToTree(this.getDestinationPort()));
                if (this.getForwardErrorCorrection() != null) {
                    data.set("forwardErrorCorrection", om.valueToTree(this.getForwardErrorCorrection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.RtpRouterOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RtpRouterOutputConfigurationProperty.Jsii$Proxy that = (RtpRouterOutputConfigurationProperty.Jsii$Proxy) o;

                if (!destinationAddress.equals(that.destinationAddress)) return false;
                if (!destinationPort.equals(that.destinationPort)) return false;
                return this.forwardErrorCorrection != null ? this.forwardErrorCorrection.equals(that.forwardErrorCorrection) : that.forwardErrorCorrection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationAddress.hashCode();
                result = 31 * result + (this.destinationPort.hashCode());
                result = 31 * result + (this.forwardErrorCorrection != null ? this.forwardErrorCorrection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * SecretsManagerEncryptionKeyConfigurationProperty secretsManagerEncryptionKeyConfigurationProperty = SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *         .roleArn("roleArn")
     *         .secretArn("secretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-secretsmanagerencryptionkeyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-secretsmanagerencryptionkeyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.SecretsManagerEncryptionKeyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SecretsManagerEncryptionKeyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecretsManagerEncryptionKeyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the IAM role assumed by MediaConnect to access the AWS Secrets Manager secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-secretsmanagerencryptionkeyconfiguration.html#cfn-mediaconnect-routeroutput-secretsmanagerencryptionkeyconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-secretsmanagerencryptionkeyconfiguration.html#cfn-mediaconnect-routeroutput-secretsmanagerencryptionkeyconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The ARN of the AWS Secrets Manager secret used for transit encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-secretsmanagerencryptionkeyconfiguration.html#cfn-mediaconnect-routeroutput-secretsmanagerencryptionkeyconfiguration-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-secretsmanagerencryptionkeyconfiguration.html#cfn-mediaconnect-routeroutput-secretsmanagerencryptionkeyconfiguration-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * @return a {@link Builder} of {@link SecretsManagerEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecretsManagerEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecretsManagerEncryptionKeyConfigurationProperty> {
            java.lang.String roleArn;
            java.lang.String secretArn;

            /**
             * Sets the value of {@link SecretsManagerEncryptionKeyConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of the IAM role assumed by MediaConnect to access the AWS Secrets Manager secret. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SecretsManagerEncryptionKeyConfigurationProperty#getSecretArn}
             * @param secretArn The ARN of the AWS Secrets Manager secret used for transit encryption. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecretsManagerEncryptionKeyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecretsManagerEncryptionKeyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecretsManagerEncryptionKeyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretsManagerEncryptionKeyConfigurationProperty {
            private final java.lang.String roleArn;
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("secretArn", om.valueToTree(this.getSecretArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.SecretsManagerEncryptionKeyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecretsManagerEncryptionKeyConfigurationProperty.Jsii$Proxy that = (SecretsManagerEncryptionKeyConfigurationProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                return this.secretArn.equals(that.secretArn);
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.secretArn.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration settings for a router output using the SRT (Secure Reliable Transport) protocol in caller mode, including the destination address and port, minimum latency, stream ID, and encryption key configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * SrtCallerRouterOutputConfigurationProperty srtCallerRouterOutputConfigurationProperty = SrtCallerRouterOutputConfigurationProperty.builder()
     *         .destinationAddress("destinationAddress")
     *         .destinationPort(123)
     *         .minimumLatencyMilliseconds(123)
     *         // the properties below are optional
     *         .encryptionConfiguration(SrtEncryptionConfigurationProperty.builder()
     *                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                         .roleArn("roleArn")
     *                         .secretArn("secretArn")
     *                         .build())
     *                 .build())
     *         .streamId("streamId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.SrtCallerRouterOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SrtCallerRouterOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SrtCallerRouterOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination IP address for the SRT protocol in caller mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration-destinationaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration-destinationaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationAddress();

        /**
         * The destination port number for the SRT protocol in caller mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration-destinationport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration-destinationport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDestinationPort();

        /**
         * The minimum latency in milliseconds for the SRT protocol in caller mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration-minimumlatencymilliseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration-minimumlatencymilliseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimumLatencyMilliseconds();

        /**
         * Contains the configuration settings for encrypting SRT streams, including the encryption key details and encryption parameters.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SrtEncryptionConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration-encryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * The stream ID for the SRT protocol in caller mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration-streamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtcallerrouteroutputconfiguration-streamid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SrtCallerRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SrtCallerRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SrtCallerRouterOutputConfigurationProperty> {
            java.lang.String destinationAddress;
            java.lang.Number destinationPort;
            java.lang.Number minimumLatencyMilliseconds;
            java.lang.Object encryptionConfiguration;
            java.lang.String streamId;

            /**
             * Sets the value of {@link SrtCallerRouterOutputConfigurationProperty#getDestinationAddress}
             * @param destinationAddress The destination IP address for the SRT protocol in caller mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationAddress(java.lang.String destinationAddress) {
                this.destinationAddress = destinationAddress;
                return this;
            }

            /**
             * Sets the value of {@link SrtCallerRouterOutputConfigurationProperty#getDestinationPort}
             * @param destinationPort The destination port number for the SRT protocol in caller mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPort(java.lang.Number destinationPort) {
                this.destinationPort = destinationPort;
                return this;
            }

            /**
             * Sets the value of {@link SrtCallerRouterOutputConfigurationProperty#getMinimumLatencyMilliseconds}
             * @param minimumLatencyMilliseconds The minimum latency in milliseconds for the SRT protocol in caller mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumLatencyMilliseconds(java.lang.Number minimumLatencyMilliseconds) {
                this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
                return this;
            }

            /**
             * Sets the value of {@link SrtCallerRouterOutputConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration Contains the configuration settings for encrypting SRT streams, including the encryption key details and encryption parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SrtCallerRouterOutputConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration Contains the configuration settings for encrypting SRT streams, including the encryption key details and encryption parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SrtEncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SrtCallerRouterOutputConfigurationProperty#getStreamId}
             * @param streamId The stream ID for the SRT protocol in caller mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamId(java.lang.String streamId) {
                this.streamId = streamId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SrtCallerRouterOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SrtCallerRouterOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SrtCallerRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SrtCallerRouterOutputConfigurationProperty {
            private final java.lang.String destinationAddress;
            private final java.lang.Number destinationPort;
            private final java.lang.Number minimumLatencyMilliseconds;
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.String streamId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationAddress = software.amazon.jsii.Kernel.get(this, "destinationAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationPort = software.amazon.jsii.Kernel.get(this, "destinationPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumLatencyMilliseconds = software.amazon.jsii.Kernel.get(this, "minimumLatencyMilliseconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.streamId = software.amazon.jsii.Kernel.get(this, "streamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationAddress = java.util.Objects.requireNonNull(builder.destinationAddress, "destinationAddress is required");
                this.destinationPort = java.util.Objects.requireNonNull(builder.destinationPort, "destinationPort is required");
                this.minimumLatencyMilliseconds = java.util.Objects.requireNonNull(builder.minimumLatencyMilliseconds, "minimumLatencyMilliseconds is required");
                this.encryptionConfiguration = builder.encryptionConfiguration;
                this.streamId = builder.streamId;
            }

            @Override
            public final java.lang.String getDestinationAddress() {
                return this.destinationAddress;
            }

            @Override
            public final java.lang.Number getDestinationPort() {
                return this.destinationPort;
            }

            @Override
            public final java.lang.Number getMinimumLatencyMilliseconds() {
                return this.minimumLatencyMilliseconds;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public final java.lang.String getStreamId() {
                return this.streamId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationAddress", om.valueToTree(this.getDestinationAddress()));
                data.set("destinationPort", om.valueToTree(this.getDestinationPort()));
                data.set("minimumLatencyMilliseconds", om.valueToTree(this.getMinimumLatencyMilliseconds()));
                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }
                if (this.getStreamId() != null) {
                    data.set("streamId", om.valueToTree(this.getStreamId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.SrtCallerRouterOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SrtCallerRouterOutputConfigurationProperty.Jsii$Proxy that = (SrtCallerRouterOutputConfigurationProperty.Jsii$Proxy) o;

                if (!destinationAddress.equals(that.destinationAddress)) return false;
                if (!destinationPort.equals(that.destinationPort)) return false;
                if (!minimumLatencyMilliseconds.equals(that.minimumLatencyMilliseconds)) return false;
                if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
                return this.streamId != null ? this.streamId.equals(that.streamId) : that.streamId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationAddress.hashCode();
                result = 31 * result + (this.destinationPort.hashCode());
                result = 31 * result + (this.minimumLatencyMilliseconds.hashCode());
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.streamId != null ? this.streamId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the configuration settings for encrypting SRT streams, including the encryption key details and encryption parameters.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * SrtEncryptionConfigurationProperty srtEncryptionConfigurationProperty = SrtEncryptionConfigurationProperty.builder()
     *         .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .secretArn("secretArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtencryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtencryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.SrtEncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SrtEncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SrtEncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SecretsManagerEncryptionKeyConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtencryptionconfiguration.html#cfn-mediaconnect-routeroutput-srtencryptionconfiguration-encryptionkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtencryptionconfiguration.html#cfn-mediaconnect-routeroutput-srtencryptionconfiguration-encryptionkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEncryptionKey();

        /**
         * @return a {@link Builder} of {@link SrtEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SrtEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SrtEncryptionConfigurationProperty> {
            java.lang.Object encryptionKey;

            /**
             * Sets the value of {@link SrtEncryptionConfigurationProperty#getEncryptionKey}
             * @param encryptionKey The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKey(software.amazon.awscdk.IResolvable encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            /**
             * Sets the value of {@link SrtEncryptionConfigurationProperty#getEncryptionKey}
             * @param encryptionKey The configuration settings for transit encryption using AWS Secrets Manager, including the secret ARN and role ARN. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKey(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SecretsManagerEncryptionKeyConfigurationProperty encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SrtEncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SrtEncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SrtEncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SrtEncryptionConfigurationProperty {
            private final java.lang.Object encryptionKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionKey = java.util.Objects.requireNonNull(builder.encryptionKey, "encryptionKey is required");
            }

            @Override
            public final java.lang.Object getEncryptionKey() {
                return this.encryptionKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.SrtEncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SrtEncryptionConfigurationProperty.Jsii$Proxy that = (SrtEncryptionConfigurationProperty.Jsii$Proxy) o;

                return this.encryptionKey.equals(that.encryptionKey);
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionKey.hashCode();
                return result;
            }
        }
    }
    /**
     * The configuration settings for a router output using the SRT (Secure Reliable Transport) protocol in listener mode, including the port, minimum latency, and encryption key configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * SrtListenerRouterOutputConfigurationProperty srtListenerRouterOutputConfigurationProperty = SrtListenerRouterOutputConfigurationProperty.builder()
     *         .minimumLatencyMilliseconds(123)
     *         .port(123)
     *         // the properties below are optional
     *         .encryptionConfiguration(SrtEncryptionConfigurationProperty.builder()
     *                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                         .roleArn("roleArn")
     *                         .secretArn("secretArn")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.SrtListenerRouterOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SrtListenerRouterOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SrtListenerRouterOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum latency in milliseconds for the SRT protocol in listener mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration-minimumlatencymilliseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration-minimumlatencymilliseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimumLatencyMilliseconds();

        /**
         * The port number for the SRT protocol in listener mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * Contains the configuration settings for encrypting SRT streams, including the encryption key details and encryption parameters.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SrtEncryptionConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-srtlistenerrouteroutputconfiguration-encryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SrtListenerRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SrtListenerRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SrtListenerRouterOutputConfigurationProperty> {
            java.lang.Number minimumLatencyMilliseconds;
            java.lang.Number port;
            java.lang.Object encryptionConfiguration;

            /**
             * Sets the value of {@link SrtListenerRouterOutputConfigurationProperty#getMinimumLatencyMilliseconds}
             * @param minimumLatencyMilliseconds The minimum latency in milliseconds for the SRT protocol in listener mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumLatencyMilliseconds(java.lang.Number minimumLatencyMilliseconds) {
                this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
                return this;
            }

            /**
             * Sets the value of {@link SrtListenerRouterOutputConfigurationProperty#getPort}
             * @param port The port number for the SRT protocol in listener mode. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link SrtListenerRouterOutputConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration Contains the configuration settings for encrypting SRT streams, including the encryption key details and encryption parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SrtListenerRouterOutputConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration Contains the configuration settings for encrypting SRT streams, including the encryption key details and encryption parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.SrtEncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SrtListenerRouterOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SrtListenerRouterOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SrtListenerRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SrtListenerRouterOutputConfigurationProperty {
            private final java.lang.Number minimumLatencyMilliseconds;
            private final java.lang.Number port;
            private final java.lang.Object encryptionConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.minimumLatencyMilliseconds = software.amazon.jsii.Kernel.get(this, "minimumLatencyMilliseconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.minimumLatencyMilliseconds = java.util.Objects.requireNonNull(builder.minimumLatencyMilliseconds, "minimumLatencyMilliseconds is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.encryptionConfiguration = builder.encryptionConfiguration;
            }

            @Override
            public final java.lang.Number getMinimumLatencyMilliseconds() {
                return this.minimumLatencyMilliseconds;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("minimumLatencyMilliseconds", om.valueToTree(this.getMinimumLatencyMilliseconds()));
                data.set("port", om.valueToTree(this.getPort()));
                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.SrtListenerRouterOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SrtListenerRouterOutputConfigurationProperty.Jsii$Proxy that = (SrtListenerRouterOutputConfigurationProperty.Jsii$Proxy) o;

                if (!minimumLatencyMilliseconds.equals(that.minimumLatencyMilliseconds)) return false;
                if (!port.equals(that.port)) return false;
                return this.encryptionConfiguration != null ? this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.minimumLatencyMilliseconds.hashCode();
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration settings for a standard router output, including the protocol, protocol-specific configuration, network interface, and availability zone.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * StandardRouterOutputConfigurationProperty standardRouterOutputConfigurationProperty = StandardRouterOutputConfigurationProperty.builder()
     *         .networkInterfaceArn("networkInterfaceArn")
     *         .protocolConfiguration(RouterOutputProtocolConfigurationProperty.builder()
     *                 .rist(RistRouterOutputConfigurationProperty.builder()
     *                         .destinationAddress("destinationAddress")
     *                         .destinationPort(123)
     *                         .build())
     *                 .rtp(RtpRouterOutputConfigurationProperty.builder()
     *                         .destinationAddress("destinationAddress")
     *                         .destinationPort(123)
     *                         // the properties below are optional
     *                         .forwardErrorCorrection("forwardErrorCorrection")
     *                         .build())
     *                 .srtCaller(SrtCallerRouterOutputConfigurationProperty.builder()
     *                         .destinationAddress("destinationAddress")
     *                         .destinationPort(123)
     *                         .minimumLatencyMilliseconds(123)
     *                         // the properties below are optional
     *                         .encryptionConfiguration(SrtEncryptionConfigurationProperty.builder()
     *                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                         .roleArn("roleArn")
     *                                         .secretArn("secretArn")
     *                                         .build())
     *                                 .build())
     *                         .streamId("streamId")
     *                         .build())
     *                 .srtListener(SrtListenerRouterOutputConfigurationProperty.builder()
     *                         .minimumLatencyMilliseconds(123)
     *                         .port(123)
     *                         // the properties below are optional
     *                         .encryptionConfiguration(SrtEncryptionConfigurationProperty.builder()
     *                                 .encryptionKey(SecretsManagerEncryptionKeyConfigurationProperty.builder()
     *                                         .roleArn("roleArn")
     *                                         .secretArn("secretArn")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .protocol("protocol")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-standardrouteroutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-standardrouteroutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.StandardRouterOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StandardRouterOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StandardRouterOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the network interface associated with the standard router output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-standardrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-standardrouteroutputconfiguration-networkinterfacearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-standardrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-standardrouteroutputconfiguration-networkinterfacearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNetworkInterfaceArn();

        /**
         * The protocol configuration settings for a router output.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.RouterOutputProtocolConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-standardrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-standardrouteroutputconfiguration-protocolconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-standardrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-standardrouteroutputconfiguration-protocolconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getProtocolConfiguration();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-standardrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-standardrouteroutputconfiguration-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-routeroutput-standardrouteroutputconfiguration.html#cfn-mediaconnect-routeroutput-standardrouteroutputconfiguration-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StandardRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StandardRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StandardRouterOutputConfigurationProperty> {
            java.lang.String networkInterfaceArn;
            java.lang.Object protocolConfiguration;
            java.lang.String protocol;

            /**
             * Sets the value of {@link StandardRouterOutputConfigurationProperty#getNetworkInterfaceArn}
             * @param networkInterfaceArn The Amazon Resource Name (ARN) of the network interface associated with the standard router output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceArn(java.lang.String networkInterfaceArn) {
                this.networkInterfaceArn = networkInterfaceArn;
                return this;
            }

            /**
             * Sets the value of {@link StandardRouterOutputConfigurationProperty#getProtocolConfiguration}
             * @param protocolConfiguration The protocol configuration settings for a router output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolConfiguration(software.amazon.awscdk.IResolvable protocolConfiguration) {
                this.protocolConfiguration = protocolConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StandardRouterOutputConfigurationProperty#getProtocolConfiguration}
             * @param protocolConfiguration The protocol configuration settings for a router output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocolConfiguration(software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.RouterOutputProtocolConfigurationProperty protocolConfiguration) {
                this.protocolConfiguration = protocolConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StandardRouterOutputConfigurationProperty#getProtocol}
             * @param protocol the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StandardRouterOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StandardRouterOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StandardRouterOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StandardRouterOutputConfigurationProperty {
            private final java.lang.String networkInterfaceArn;
            private final java.lang.Object protocolConfiguration;
            private final java.lang.String protocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.networkInterfaceArn = software.amazon.jsii.Kernel.get(this, "networkInterfaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocolConfiguration = software.amazon.jsii.Kernel.get(this, "protocolConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.networkInterfaceArn = java.util.Objects.requireNonNull(builder.networkInterfaceArn, "networkInterfaceArn is required");
                this.protocolConfiguration = java.util.Objects.requireNonNull(builder.protocolConfiguration, "protocolConfiguration is required");
                this.protocol = builder.protocol;
            }

            @Override
            public final java.lang.String getNetworkInterfaceArn() {
                return this.networkInterfaceArn;
            }

            @Override
            public final java.lang.Object getProtocolConfiguration() {
                return this.protocolConfiguration;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("networkInterfaceArn", om.valueToTree(this.getNetworkInterfaceArn()));
                data.set("protocolConfiguration", om.valueToTree(this.getProtocolConfiguration()));
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnRouterOutput.StandardRouterOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StandardRouterOutputConfigurationProperty.Jsii$Proxy that = (StandardRouterOutputConfigurationProperty.Jsii$Proxy) o;

                if (!networkInterfaceArn.equals(that.networkInterfaceArn)) return false;
                if (!protocolConfiguration.equals(that.protocolConfiguration)) return false;
                return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
            }

            @Override
            public final int hashCode() {
                int result = this.networkInterfaceArn.hashCode();
                result = 31 * result + (this.protocolConfiguration.hashCode());
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediaconnect.CfnRouterOutput> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediaconnect.CfnRouterOutputProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediaconnect.CfnRouterOutputProps.Builder();
        }

        /**
         * The configuration settings for a router output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-configuration</a>
         * @param configuration The configuration settings for a router output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }
        /**
         * The configuration settings for a router output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-configuration</a>
         * @param configuration The configuration settings for a router output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.RouterOutputConfigurationProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * The maximum bitrate for the router output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-maximumbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-maximumbitrate</a>
         * @param maximumBitrate The maximum bitrate for the router output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumBitrate(final java.lang.Number maximumBitrate) {
            this.props.maximumBitrate(maximumBitrate);
            return this;
        }

        /**
         * The name of the router output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-name</a>
         * @param name The name of the router output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Indicates whether the router output is configured for Regional or global routing.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-routingscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-routingscope</a>
         * @param routingScope Indicates whether the router output is configured for Regional or global routing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingScope(final java.lang.String routingScope) {
            this.props.routingScope(routingScope);
            return this;
        }

        /**
         * The tier level of the router output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-tier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-tier</a>
         * @param tier The tier level of the router output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tier(final java.lang.String tier) {
            this.props.tier(tier);
            return this;
        }

        /**
         * The Availability Zone of the router output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-availabilityzone</a>
         * @param availabilityZone The Availability Zone of the router output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The maintenance configuration settings applied to this router output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-maintenanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-maintenanceconfiguration</a>
         * @param maintenanceConfiguration The maintenance configuration settings applied to this router output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceConfiguration(final software.amazon.awscdk.IResolvable maintenanceConfiguration) {
            this.props.maintenanceConfiguration(maintenanceConfiguration);
            return this;
        }
        /**
         * The maintenance configuration settings applied to this router output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-maintenanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-maintenanceconfiguration</a>
         * @param maintenanceConfiguration The maintenance configuration settings applied to this router output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceConfiguration(final software.amazon.awscdk.services.mediaconnect.CfnRouterOutput.MaintenanceConfigurationProperty maintenanceConfiguration) {
            this.props.maintenanceConfiguration(maintenanceConfiguration);
            return this;
        }

        /**
         * The AWS Region where the router output is located.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-regionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-regionname</a>
         * @param regionName The AWS Region where the router output is located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionName(final java.lang.String regionName) {
            this.props.regionName(regionName);
            return this;
        }

        /**
         * Key-value pairs that can be used to tag and organize this router output.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-routeroutput.html#cfn-mediaconnect-routeroutput-tags</a>
         * @param tags Key-value pairs that can be used to tag and organize this router output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mediaconnect.CfnRouterOutput}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediaconnect.CfnRouterOutput build() {
            return new software.amazon.awscdk.services.mediaconnect.CfnRouterOutput(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
