package software.amazon.awscdk.services.networkmanager;

/**
 * Creates a VPC attachment on an edge location of a core network.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnVpcAttachment cfnVpcAttachment = CfnVpcAttachment.Builder.create(this, "MyCfnVpcAttachment")
 *         .coreNetworkId("coreNetworkId")
 *         .subnetArns(List.of("subnetArns"))
 *         .vpcArn("vpcArn")
 *         // the properties below are optional
 *         .options(VpcOptionsProperty.builder()
 *                 .applianceModeSupport(false)
 *                 .dnsSupport(false)
 *                 .ipv6Support(false)
 *                 .securityGroupReferencingSupport(false)
 *                 .build())
 *         .proposedNetworkFunctionGroupChange(ProposedNetworkFunctionGroupChangeProperty.builder()
 *                 .attachmentPolicyRuleNumber(123)
 *                 .networkFunctionGroupName("networkFunctionGroupName")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .proposedSegmentChange(ProposedSegmentChangeProperty.builder()
 *                 .attachmentPolicyRuleNumber(123)
 *                 .segmentName("segmentName")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:25.088Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnVpcAttachment")
public class CfnVpcAttachment extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.networkmanager.IVpcAttachmentRef, software.amazon.awscdk.ITaggable {

    protected CfnVpcAttachment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVpcAttachment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::NetworkManager::VpcAttachment</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVpcAttachment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.networkmanager.CfnVpcAttachmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForVpcAttachment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.networkmanager.IVpcAttachmentRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.class, "arnForVpcAttachment", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Creates a new IVpcAttachmentRef from a attachmentId.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attachmentId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.networkmanager.IVpcAttachmentRef fromAttachmentId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String attachmentId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.class, "fromAttachmentId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.networkmanager.IVpcAttachmentRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attachmentId, "attachmentId is required") });
    }

    /**
     * Checks whether the given object is a CfnVpcAttachment.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnVpcAttachment(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.class, "isCfnVpcAttachment", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the VPC attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAttachmentId() {
        return software.amazon.jsii.Kernel.get(this, "attrAttachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The policy rule number associated with the attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrAttachmentPolicyRuleNumber() {
        return software.amazon.jsii.Kernel.get(this, "attrAttachmentPolicyRuleNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The type of attachment.
     * <p>
     * This will be <code>VPC</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAttachmentType() {
        return software.amazon.jsii.Kernel.get(this, "attrAttachmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the core network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCoreNetworkArn() {
        return software.amazon.jsii.Kernel.get(this, "attrCoreNetworkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when the VPC attachment was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Region where the core network edge is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEdgeLocation() {
        return software.amazon.jsii.Kernel.get(this, "attrEdgeLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Errors from the last modification of the attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrLastModificationErrors() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrLastModificationErrors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The name of the network function group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrNetworkFunctionGroupName() {
        return software.amazon.jsii.Kernel.get(this, "attrNetworkFunctionGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the VPC attachment owner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOwnerAccountId() {
        return software.amazon.jsii.Kernel.get(this, "attrOwnerAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The resource ARN for the VPC attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the attachment's segment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSegmentName() {
        return software.amazon.jsii.Kernel.get(this, "attrSegmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the attachment.
     * <p>
     * This can be: <code>REJECTED</code> | <code>PENDING_ATTACHMENT_ACCEPTANCE</code> | <code>CREATING</code> | <code>FAILED</code> | <code>AVAILABLE</code> | <code>UPDATING</code> | <code>PENDING_NETWORK_UPDATE</code> | <code>PENDING_TAG_ACCEPTANCE</code> | <code>DELETING</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when the VPC attachment was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A reference to a VpcAttachment resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.networkmanager.VpcAttachmentReference getVpcAttachmentRef() {
        return software.amazon.jsii.Kernel.get(this, "vpcAttachmentRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.networkmanager.VpcAttachmentReference.class));
    }

    /**
     * The core network ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCoreNetworkId() {
        return software.amazon.jsii.Kernel.get(this, "coreNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The core network ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCoreNetworkId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "coreNetworkId", java.util.Objects.requireNonNull(value, "coreNetworkId is required"));
    }

    /**
     * The subnet ARNs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "subnetArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The subnet ARNs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetArns(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subnetArns", java.util.Objects.requireNonNull(value, "subnetArns is required"));
    }

    /**
     * The ARN of the VPC attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcArn() {
        return software.amazon.jsii.Kernel.get(this, "vpcArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the VPC attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcArn", java.util.Objects.requireNonNull(value, "vpcArn is required"));
    }

    /**
     * Options for creating the VPC attachment.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.VpcOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
        return software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Options for creating the VPC attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "options", value);
    }

    /**
     * Options for creating the VPC attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.VpcOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "options", value);
    }

    /**
     * Describes proposed changes to a network function group.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.ProposedNetworkFunctionGroupChangeProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProposedNetworkFunctionGroupChange() {
        return software.amazon.jsii.Kernel.get(this, "proposedNetworkFunctionGroupChange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes proposed changes to a network function group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProposedNetworkFunctionGroupChange(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "proposedNetworkFunctionGroupChange", value);
    }

    /**
     * Describes proposed changes to a network function group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProposedNetworkFunctionGroupChange(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.ProposedNetworkFunctionGroupChangeProperty value) {
        software.amazon.jsii.Kernel.set(this, "proposedNetworkFunctionGroupChange", value);
    }

    /**
     * Describes a proposed segment change.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.ProposedSegmentChangeProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProposedSegmentChange() {
        return software.amazon.jsii.Kernel.get(this, "proposedSegmentChange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes a proposed segment change.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProposedSegmentChange(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "proposedSegmentChange", value);
    }

    /**
     * Describes a proposed segment change.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProposedSegmentChange(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.ProposedSegmentChangeProperty value) {
        software.amazon.jsii.Kernel.set(this, "proposedSegmentChange", value);
    }

    /**
     * The tags associated with the VPC attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags associated with the VPC attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Describes proposed changes to a network function group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkmanager.*;
     * ProposedNetworkFunctionGroupChangeProperty proposedNetworkFunctionGroupChangeProperty = ProposedNetworkFunctionGroupChangeProperty.builder()
     *         .attachmentPolicyRuleNumber(123)
     *         .networkFunctionGroupName("networkFunctionGroupName")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposednetworkfunctiongroupchange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposednetworkfunctiongroupchange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnVpcAttachment.ProposedNetworkFunctionGroupChangeProperty")
    @software.amazon.jsii.Jsii.Proxy(ProposedNetworkFunctionGroupChangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProposedNetworkFunctionGroupChangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The proposed new attachment policy rule number for the network function group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposednetworkfunctiongroupchange.html#cfn-networkmanager-vpcattachment-proposednetworkfunctiongroupchange-attachmentpolicyrulenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposednetworkfunctiongroupchange.html#cfn-networkmanager-vpcattachment-proposednetworkfunctiongroupchange-attachmentpolicyrulenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAttachmentPolicyRuleNumber() {
            return null;
        }

        /**
         * The proposed name change for the network function group name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposednetworkfunctiongroupchange.html#cfn-networkmanager-vpcattachment-proposednetworkfunctiongroupchange-networkfunctiongroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposednetworkfunctiongroupchange.html#cfn-networkmanager-vpcattachment-proposednetworkfunctiongroupchange-networkfunctiongroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkFunctionGroupName() {
            return null;
        }

        /**
         * The list of proposed changes to the key-value tags associated with the network function group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposednetworkfunctiongroupchange.html#cfn-networkmanager-vpcattachment-proposednetworkfunctiongroupchange-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposednetworkfunctiongroupchange.html#cfn-networkmanager-vpcattachment-proposednetworkfunctiongroupchange-tags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProposedNetworkFunctionGroupChangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProposedNetworkFunctionGroupChangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProposedNetworkFunctionGroupChangeProperty> {
            java.lang.Number attachmentPolicyRuleNumber;
            java.lang.String networkFunctionGroupName;
            java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Sets the value of {@link ProposedNetworkFunctionGroupChangeProperty#getAttachmentPolicyRuleNumber}
             * @param attachmentPolicyRuleNumber The proposed new attachment policy rule number for the network function group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachmentPolicyRuleNumber(java.lang.Number attachmentPolicyRuleNumber) {
                this.attachmentPolicyRuleNumber = attachmentPolicyRuleNumber;
                return this;
            }

            /**
             * Sets the value of {@link ProposedNetworkFunctionGroupChangeProperty#getNetworkFunctionGroupName}
             * @param networkFunctionGroupName The proposed name change for the network function group name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkFunctionGroupName(java.lang.String networkFunctionGroupName) {
                this.networkFunctionGroupName = networkFunctionGroupName;
                return this;
            }

            /**
             * Sets the value of {@link ProposedNetworkFunctionGroupChangeProperty#getTags}
             * @param tags The list of proposed changes to the key-value tags associated with the network function group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProposedNetworkFunctionGroupChangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProposedNetworkFunctionGroupChangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProposedNetworkFunctionGroupChangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProposedNetworkFunctionGroupChangeProperty {
            private final java.lang.Number attachmentPolicyRuleNumber;
            private final java.lang.String networkFunctionGroupName;
            private final java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attachmentPolicyRuleNumber = software.amazon.jsii.Kernel.get(this, "attachmentPolicyRuleNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.networkFunctionGroupName = software.amazon.jsii.Kernel.get(this, "networkFunctionGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attachmentPolicyRuleNumber = builder.attachmentPolicyRuleNumber;
                this.networkFunctionGroupName = builder.networkFunctionGroupName;
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.Number getAttachmentPolicyRuleNumber() {
                return this.attachmentPolicyRuleNumber;
            }

            @Override
            public final java.lang.String getNetworkFunctionGroupName() {
                return this.networkFunctionGroupName;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttachmentPolicyRuleNumber() != null) {
                    data.set("attachmentPolicyRuleNumber", om.valueToTree(this.getAttachmentPolicyRuleNumber()));
                }
                if (this.getNetworkFunctionGroupName() != null) {
                    data.set("networkFunctionGroupName", om.valueToTree(this.getNetworkFunctionGroupName()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnVpcAttachment.ProposedNetworkFunctionGroupChangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProposedNetworkFunctionGroupChangeProperty.Jsii$Proxy that = (ProposedNetworkFunctionGroupChangeProperty.Jsii$Proxy) o;

                if (this.attachmentPolicyRuleNumber != null ? !this.attachmentPolicyRuleNumber.equals(that.attachmentPolicyRuleNumber) : that.attachmentPolicyRuleNumber != null) return false;
                if (this.networkFunctionGroupName != null ? !this.networkFunctionGroupName.equals(that.networkFunctionGroupName) : that.networkFunctionGroupName != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attachmentPolicyRuleNumber != null ? this.attachmentPolicyRuleNumber.hashCode() : 0;
                result = 31 * result + (this.networkFunctionGroupName != null ? this.networkFunctionGroupName.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a proposed segment change.
     * <p>
     * In some cases, the segment change must first be evaluated and accepted.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkmanager.*;
     * ProposedSegmentChangeProperty proposedSegmentChangeProperty = ProposedSegmentChangeProperty.builder()
     *         .attachmentPolicyRuleNumber(123)
     *         .segmentName("segmentName")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposedsegmentchange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposedsegmentchange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnVpcAttachment.ProposedSegmentChangeProperty")
    @software.amazon.jsii.Jsii.Proxy(ProposedSegmentChangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProposedSegmentChangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The rule number in the policy document that applies to this change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposedsegmentchange.html#cfn-networkmanager-vpcattachment-proposedsegmentchange-attachmentpolicyrulenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposedsegmentchange.html#cfn-networkmanager-vpcattachment-proposedsegmentchange-attachmentpolicyrulenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAttachmentPolicyRuleNumber() {
            return null;
        }

        /**
         * The name of the segment to change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposedsegmentchange.html#cfn-networkmanager-vpcattachment-proposedsegmentchange-segmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposedsegmentchange.html#cfn-networkmanager-vpcattachment-proposedsegmentchange-segmentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSegmentName() {
            return null;
        }

        /**
         * The list of key-value tags that changed for the segment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposedsegmentchange.html#cfn-networkmanager-vpcattachment-proposedsegmentchange-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-proposedsegmentchange.html#cfn-networkmanager-vpcattachment-proposedsegmentchange-tags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProposedSegmentChangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProposedSegmentChangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProposedSegmentChangeProperty> {
            java.lang.Number attachmentPolicyRuleNumber;
            java.lang.String segmentName;
            java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Sets the value of {@link ProposedSegmentChangeProperty#getAttachmentPolicyRuleNumber}
             * @param attachmentPolicyRuleNumber The rule number in the policy document that applies to this change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachmentPolicyRuleNumber(java.lang.Number attachmentPolicyRuleNumber) {
                this.attachmentPolicyRuleNumber = attachmentPolicyRuleNumber;
                return this;
            }

            /**
             * Sets the value of {@link ProposedSegmentChangeProperty#getSegmentName}
             * @param segmentName The name of the segment to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentName(java.lang.String segmentName) {
                this.segmentName = segmentName;
                return this;
            }

            /**
             * Sets the value of {@link ProposedSegmentChangeProperty#getTags}
             * @param tags The list of key-value tags that changed for the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProposedSegmentChangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProposedSegmentChangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProposedSegmentChangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProposedSegmentChangeProperty {
            private final java.lang.Number attachmentPolicyRuleNumber;
            private final java.lang.String segmentName;
            private final java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attachmentPolicyRuleNumber = software.amazon.jsii.Kernel.get(this, "attachmentPolicyRuleNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.segmentName = software.amazon.jsii.Kernel.get(this, "segmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attachmentPolicyRuleNumber = builder.attachmentPolicyRuleNumber;
                this.segmentName = builder.segmentName;
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.Number getAttachmentPolicyRuleNumber() {
                return this.attachmentPolicyRuleNumber;
            }

            @Override
            public final java.lang.String getSegmentName() {
                return this.segmentName;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttachmentPolicyRuleNumber() != null) {
                    data.set("attachmentPolicyRuleNumber", om.valueToTree(this.getAttachmentPolicyRuleNumber()));
                }
                if (this.getSegmentName() != null) {
                    data.set("segmentName", om.valueToTree(this.getSegmentName()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnVpcAttachment.ProposedSegmentChangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProposedSegmentChangeProperty.Jsii$Proxy that = (ProposedSegmentChangeProperty.Jsii$Proxy) o;

                if (this.attachmentPolicyRuleNumber != null ? !this.attachmentPolicyRuleNumber.equals(that.attachmentPolicyRuleNumber) : that.attachmentPolicyRuleNumber != null) return false;
                if (this.segmentName != null ? !this.segmentName.equals(that.segmentName) : that.segmentName != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attachmentPolicyRuleNumber != null ? this.attachmentPolicyRuleNumber.hashCode() : 0;
                result = 31 * result + (this.segmentName != null ? this.segmentName.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the VPC options.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.networkmanager.*;
     * VpcOptionsProperty vpcOptionsProperty = VpcOptionsProperty.builder()
     *         .applianceModeSupport(false)
     *         .dnsSupport(false)
     *         .ipv6Support(false)
     *         .securityGroupReferencingSupport(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-vpcoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-vpcoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnVpcAttachment.VpcOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether appliance mode is supported.
         * <p>
         * If enabled, traffic flow between a source and destination use the same Availability Zone for the VPC attachment for the lifetime of that flow. The default value is <code>false</code> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-vpcoptions.html#cfn-networkmanager-vpcattachment-vpcoptions-appliancemodesupport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-vpcoptions.html#cfn-networkmanager-vpcattachment-vpcoptions-appliancemodesupport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApplianceModeSupport() {
            return null;
        }

        /**
         * Indicates whether DNS is supported.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - true
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-vpcoptions.html#cfn-networkmanager-vpcattachment-vpcoptions-dnssupport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-vpcoptions.html#cfn-networkmanager-vpcattachment-vpcoptions-dnssupport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDnsSupport() {
            return null;
        }

        /**
         * Indicates whether IPv6 is supported.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-vpcoptions.html#cfn-networkmanager-vpcattachment-vpcoptions-ipv6support">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-vpcoptions.html#cfn-networkmanager-vpcattachment-vpcoptions-ipv6support</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Support() {
            return null;
        }

        /**
         * Indicates whether security group referencing is enabled for this VPC attachment.
         * <p>
         * The default is <code>true</code> . However, at the core network policy-level the default is set to <code>false</code> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - true
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-vpcoptions.html#cfn-networkmanager-vpcattachment-vpcoptions-securitygroupreferencingsupport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-networkmanager-vpcattachment-vpcoptions.html#cfn-networkmanager-vpcattachment-vpcoptions-securitygroupreferencingsupport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityGroupReferencingSupport() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcOptionsProperty> {
            java.lang.Object applianceModeSupport;
            java.lang.Object dnsSupport;
            java.lang.Object ipv6Support;
            java.lang.Object securityGroupReferencingSupport;

            /**
             * Sets the value of {@link VpcOptionsProperty#getApplianceModeSupport}
             * @param applianceModeSupport Indicates whether appliance mode is supported.
             *                             If enabled, traffic flow between a source and destination use the same Availability Zone for the VPC attachment for the lifetime of that flow. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applianceModeSupport(java.lang.Boolean applianceModeSupport) {
                this.applianceModeSupport = applianceModeSupport;
                return this;
            }

            /**
             * Sets the value of {@link VpcOptionsProperty#getApplianceModeSupport}
             * @param applianceModeSupport Indicates whether appliance mode is supported.
             *                             If enabled, traffic flow between a source and destination use the same Availability Zone for the VPC attachment for the lifetime of that flow. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applianceModeSupport(software.amazon.awscdk.IResolvable applianceModeSupport) {
                this.applianceModeSupport = applianceModeSupport;
                return this;
            }

            /**
             * Sets the value of {@link VpcOptionsProperty#getDnsSupport}
             * @param dnsSupport Indicates whether DNS is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsSupport(java.lang.Boolean dnsSupport) {
                this.dnsSupport = dnsSupport;
                return this;
            }

            /**
             * Sets the value of {@link VpcOptionsProperty#getDnsSupport}
             * @param dnsSupport Indicates whether DNS is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsSupport(software.amazon.awscdk.IResolvable dnsSupport) {
                this.dnsSupport = dnsSupport;
                return this;
            }

            /**
             * Sets the value of {@link VpcOptionsProperty#getIpv6Support}
             * @param ipv6Support Indicates whether IPv6 is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Support(java.lang.Boolean ipv6Support) {
                this.ipv6Support = ipv6Support;
                return this;
            }

            /**
             * Sets the value of {@link VpcOptionsProperty#getIpv6Support}
             * @param ipv6Support Indicates whether IPv6 is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Support(software.amazon.awscdk.IResolvable ipv6Support) {
                this.ipv6Support = ipv6Support;
                return this;
            }

            /**
             * Sets the value of {@link VpcOptionsProperty#getSecurityGroupReferencingSupport}
             * @param securityGroupReferencingSupport Indicates whether security group referencing is enabled for this VPC attachment.
             *                                        The default is <code>true</code> . However, at the core network policy-level the default is set to <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupReferencingSupport(java.lang.Boolean securityGroupReferencingSupport) {
                this.securityGroupReferencingSupport = securityGroupReferencingSupport;
                return this;
            }

            /**
             * Sets the value of {@link VpcOptionsProperty#getSecurityGroupReferencingSupport}
             * @param securityGroupReferencingSupport Indicates whether security group referencing is enabled for this VPC attachment.
             *                                        The default is <code>true</code> . However, at the core network policy-level the default is set to <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupReferencingSupport(software.amazon.awscdk.IResolvable securityGroupReferencingSupport) {
                this.securityGroupReferencingSupport = securityGroupReferencingSupport;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcOptionsProperty {
            private final java.lang.Object applianceModeSupport;
            private final java.lang.Object dnsSupport;
            private final java.lang.Object ipv6Support;
            private final java.lang.Object securityGroupReferencingSupport;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applianceModeSupport = software.amazon.jsii.Kernel.get(this, "applianceModeSupport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dnsSupport = software.amazon.jsii.Kernel.get(this, "dnsSupport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ipv6Support = software.amazon.jsii.Kernel.get(this, "ipv6Support", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityGroupReferencingSupport = software.amazon.jsii.Kernel.get(this, "securityGroupReferencingSupport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applianceModeSupport = builder.applianceModeSupport;
                this.dnsSupport = builder.dnsSupport;
                this.ipv6Support = builder.ipv6Support;
                this.securityGroupReferencingSupport = builder.securityGroupReferencingSupport;
            }

            @Override
            public final java.lang.Object getApplianceModeSupport() {
                return this.applianceModeSupport;
            }

            @Override
            public final java.lang.Object getDnsSupport() {
                return this.dnsSupport;
            }

            @Override
            public final java.lang.Object getIpv6Support() {
                return this.ipv6Support;
            }

            @Override
            public final java.lang.Object getSecurityGroupReferencingSupport() {
                return this.securityGroupReferencingSupport;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplianceModeSupport() != null) {
                    data.set("applianceModeSupport", om.valueToTree(this.getApplianceModeSupport()));
                }
                if (this.getDnsSupport() != null) {
                    data.set("dnsSupport", om.valueToTree(this.getDnsSupport()));
                }
                if (this.getIpv6Support() != null) {
                    data.set("ipv6Support", om.valueToTree(this.getIpv6Support()));
                }
                if (this.getSecurityGroupReferencingSupport() != null) {
                    data.set("securityGroupReferencingSupport", om.valueToTree(this.getSecurityGroupReferencingSupport()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnVpcAttachment.VpcOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcOptionsProperty.Jsii$Proxy that = (VpcOptionsProperty.Jsii$Proxy) o;

                if (this.applianceModeSupport != null ? !this.applianceModeSupport.equals(that.applianceModeSupport) : that.applianceModeSupport != null) return false;
                if (this.dnsSupport != null ? !this.dnsSupport.equals(that.dnsSupport) : that.dnsSupport != null) return false;
                if (this.ipv6Support != null ? !this.ipv6Support.equals(that.ipv6Support) : that.ipv6Support != null) return false;
                return this.securityGroupReferencingSupport != null ? this.securityGroupReferencingSupport.equals(that.securityGroupReferencingSupport) : that.securityGroupReferencingSupport == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applianceModeSupport != null ? this.applianceModeSupport.hashCode() : 0;
                result = 31 * result + (this.dnsSupport != null ? this.dnsSupport.hashCode() : 0);
                result = 31 * result + (this.ipv6Support != null ? this.ipv6Support.hashCode() : 0);
                result = 31 * result + (this.securityGroupReferencingSupport != null ? this.securityGroupReferencingSupport.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.networkmanager.CfnVpcAttachment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.networkmanager.CfnVpcAttachment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.networkmanager.CfnVpcAttachmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.networkmanager.CfnVpcAttachmentProps.Builder();
        }

        /**
         * The core network ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-corenetworkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-corenetworkid</a>
         * @param coreNetworkId The core network ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreNetworkId(final java.lang.String coreNetworkId) {
            this.props.coreNetworkId(coreNetworkId);
            return this;
        }

        /**
         * The subnet ARNs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-subnetarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-subnetarns</a>
         * @param subnetArns The subnet ARNs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetArns(final java.util.List<java.lang.String> subnetArns) {
            this.props.subnetArns(subnetArns);
            return this;
        }

        /**
         * The ARN of the VPC attachment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-vpcarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-vpcarn</a>
         * @param vpcArn The ARN of the VPC attachment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcArn(final java.lang.String vpcArn) {
            this.props.vpcArn(vpcArn);
            return this;
        }

        /**
         * Options for creating the VPC attachment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-options</a>
         * @param options Options for creating the VPC attachment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(final software.amazon.awscdk.IResolvable options) {
            this.props.options(options);
            return this;
        }
        /**
         * Options for creating the VPC attachment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-options</a>
         * @param options Options for creating the VPC attachment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(final software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.VpcOptionsProperty options) {
            this.props.options(options);
            return this;
        }

        /**
         * Describes proposed changes to a network function group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-proposednetworkfunctiongroupchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-proposednetworkfunctiongroupchange</a>
         * @param proposedNetworkFunctionGroupChange Describes proposed changes to a network function group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedNetworkFunctionGroupChange(final software.amazon.awscdk.IResolvable proposedNetworkFunctionGroupChange) {
            this.props.proposedNetworkFunctionGroupChange(proposedNetworkFunctionGroupChange);
            return this;
        }
        /**
         * Describes proposed changes to a network function group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-proposednetworkfunctiongroupchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-proposednetworkfunctiongroupchange</a>
         * @param proposedNetworkFunctionGroupChange Describes proposed changes to a network function group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedNetworkFunctionGroupChange(final software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.ProposedNetworkFunctionGroupChangeProperty proposedNetworkFunctionGroupChange) {
            this.props.proposedNetworkFunctionGroupChange(proposedNetworkFunctionGroupChange);
            return this;
        }

        /**
         * Describes a proposed segment change.
         * <p>
         * In some cases, the segment change must first be evaluated and accepted.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-proposedsegmentchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-proposedsegmentchange</a>
         * @param proposedSegmentChange Describes a proposed segment change. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedSegmentChange(final software.amazon.awscdk.IResolvable proposedSegmentChange) {
            this.props.proposedSegmentChange(proposedSegmentChange);
            return this;
        }
        /**
         * Describes a proposed segment change.
         * <p>
         * In some cases, the segment change must first be evaluated and accepted.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-proposedsegmentchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-proposedsegmentchange</a>
         * @param proposedSegmentChange Describes a proposed segment change. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedSegmentChange(final software.amazon.awscdk.services.networkmanager.CfnVpcAttachment.ProposedSegmentChangeProperty proposedSegmentChange) {
            this.props.proposedSegmentChange(proposedSegmentChange);
            return this;
        }

        /**
         * The tags associated with the VPC attachment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-vpcattachment.html#cfn-networkmanager-vpcattachment-tags</a>
         * @param tags The tags associated with the VPC attachment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.networkmanager.CfnVpcAttachment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.networkmanager.CfnVpcAttachment build() {
            return new software.amazon.awscdk.services.networkmanager.CfnVpcAttachment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
