package software.amazon.awscdk.services.notifications;

/**
 * Properties for defining a <code>CfnOrganizationalUnitAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.notifications.*;
 * CfnOrganizationalUnitAssociationProps cfnOrganizationalUnitAssociationProps = CfnOrganizationalUnitAssociationProps.builder()
 *         .notificationConfigurationArn("notificationConfigurationArn")
 *         .organizationalUnitId("organizationalUnitId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-organizationalunitassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-organizationalunitassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:25.130Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_notifications.CfnOrganizationalUnitAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnOrganizationalUnitAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnOrganizationalUnitAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * ARN identifier of the NotificationConfiguration.
     * <p>
     * Example: arn:aws:notifications::123456789012:configuration/a01jes88qxwkbj05xv9c967pgm1
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-organizationalunitassociation.html#cfn-notifications-organizationalunitassociation-notificationconfigurationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-organizationalunitassociation.html#cfn-notifications-organizationalunitassociation-notificationconfigurationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNotificationConfigurationArn();

    /**
     * The ID of the organizational unit.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-organizationalunitassociation.html#cfn-notifications-organizationalunitassociation-organizationalunitid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-notifications-organizationalunitassociation.html#cfn-notifications-organizationalunitassociation-organizationalunitid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOrganizationalUnitId();

    /**
     * @return a {@link Builder} of {@link CfnOrganizationalUnitAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnOrganizationalUnitAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnOrganizationalUnitAssociationProps> {
        java.lang.String notificationConfigurationArn;
        java.lang.String organizationalUnitId;

        /**
         * Sets the value of {@link CfnOrganizationalUnitAssociationProps#getNotificationConfigurationArn}
         * @param notificationConfigurationArn ARN identifier of the NotificationConfiguration. This parameter is required.
         *                                     Example: arn:aws:notifications::123456789012:configuration/a01jes88qxwkbj05xv9c967pgm1
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfigurationArn(java.lang.String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnOrganizationalUnitAssociationProps#getOrganizationalUnitId}
         * @param organizationalUnitId The ID of the organizational unit. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationalUnitId(java.lang.String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnOrganizationalUnitAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnOrganizationalUnitAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnOrganizationalUnitAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnOrganizationalUnitAssociationProps {
        private final java.lang.String notificationConfigurationArn;
        private final java.lang.String organizationalUnitId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.notificationConfigurationArn = software.amazon.jsii.Kernel.get(this, "notificationConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.organizationalUnitId = software.amazon.jsii.Kernel.get(this, "organizationalUnitId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.notificationConfigurationArn = java.util.Objects.requireNonNull(builder.notificationConfigurationArn, "notificationConfigurationArn is required");
            this.organizationalUnitId = java.util.Objects.requireNonNull(builder.organizationalUnitId, "organizationalUnitId is required");
        }

        @Override
        public final java.lang.String getNotificationConfigurationArn() {
            return this.notificationConfigurationArn;
        }

        @Override
        public final java.lang.String getOrganizationalUnitId() {
            return this.organizationalUnitId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("notificationConfigurationArn", om.valueToTree(this.getNotificationConfigurationArn()));
            data.set("organizationalUnitId", om.valueToTree(this.getOrganizationalUnitId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_notifications.CfnOrganizationalUnitAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnOrganizationalUnitAssociationProps.Jsii$Proxy that = (CfnOrganizationalUnitAssociationProps.Jsii$Proxy) o;

            if (!notificationConfigurationArn.equals(that.notificationConfigurationArn)) return false;
            return this.organizationalUnitId.equals(that.organizationalUnitId);
        }

        @Override
        public final int hashCode() {
            int result = this.notificationConfigurationArn.hashCode();
            result = 31 * result + (this.organizationalUnitId.hashCode());
            return result;
        }
    }
}
