package software.amazon.awscdk.services.odb;

/**
 * The <code>AWS::ODB::CloudExadataInfrastructure</code> resource creates an Exadata infrastructure.
 * <p>
 * An Exadata infrastructure provides the underlying compute and storage resources for Oracle Database workloads.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.odb.*;
 * CfnCloudExadataInfrastructure cfnCloudExadataInfrastructure = CfnCloudExadataInfrastructure.Builder.create(this, "MyCfnCloudExadataInfrastructure")
 *         .availabilityZone("availabilityZone")
 *         .availabilityZoneId("availabilityZoneId")
 *         .computeCount(123)
 *         .customerContactsToSendToOci(List.of(CustomerContactProperty.builder()
 *                 .email("email")
 *                 .build()))
 *         .databaseServerType("databaseServerType")
 *         .displayName("displayName")
 *         .maintenanceWindow(MaintenanceWindowProperty.builder()
 *                 .customActionTimeoutInMins(123)
 *                 .daysOfWeek(List.of("daysOfWeek"))
 *                 .hoursOfDay(List.of(123))
 *                 .isCustomActionTimeoutEnabled(false)
 *                 .leadTimeInWeeks(123)
 *                 .months(List.of("months"))
 *                 .patchingMode("patchingMode")
 *                 .preference("preference")
 *                 .weeksOfMonth(List.of(123))
 *                 .build())
 *         .shape("shape")
 *         .storageCount(123)
 *         .storageServerType("storageServerType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:25.170Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnCloudExadataInfrastructure")
public class CfnCloudExadataInfrastructure extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.odb.ICloudExadataInfrastructureRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnCloudExadataInfrastructure(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCloudExadataInfrastructure(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::ODB::CloudExadataInfrastructure</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCloudExadataInfrastructure(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructureProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::ODB::CloudExadataInfrastructure</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCloudExadataInfrastructure(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForCloudExadataInfrastructure(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.odb.ICloudExadataInfrastructureRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure.class, "arnForCloudExadataInfrastructure", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnCloudExadataInfrastructure.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnCloudExadataInfrastructure(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure.class, "isCfnCloudExadataInfrastructure", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The number of storage servers requested for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrActivatedStorageCount() {
        return software.amazon.jsii.Kernel.get(this, "attrActivatedStorageCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of storage servers requested for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrAdditionalStorageCount() {
        return software.amazon.jsii.Kernel.get(this, "attrAdditionalStorageCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of available storage, in gigabytes (GB), for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrAvailableStorageSizeInGBs() {
        return software.amazon.jsii.Kernel.get(this, "attrAvailableStorageSizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The Amazon Resource Name (ARN) for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCloudExadataInfrastructureArn() {
        return software.amazon.jsii.Kernel.get(this, "attrCloudExadataInfrastructureArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCloudExadataInfrastructureId() {
        return software.amazon.jsii.Kernel.get(this, "attrCloudExadataInfrastructureId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The OCI model compute model used when you create or clone an instance: ECPU or OCPU.
     * <p>
     * An ECPU is an abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on the physical core of a processor with hyper-threading enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrComputeModel() {
        return software.amazon.jsii.Kernel.get(this, "attrComputeModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The total number of CPU cores that are allocated to the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrCpuCount() {
        return software.amazon.jsii.Kernel.get(this, "attrCpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The size of the Exadata infrastructure's data disk group, in terabytes (TB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrDataStorageSizeInTBs() {
        return software.amazon.jsii.Kernel.get(this, "attrDataStorageSizeInTBs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The size of the Exadata infrastructure's local node storage, in gigabytes (GB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrDbNodeStorageSizeInGBs() {
        return software.amazon.jsii.Kernel.get(this, "attrDbNodeStorageSizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The list of database server identifiers for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrDbServerIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrDbServerIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The software version of the database servers (dom0) in the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDbServerVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrDbServerVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The total number of CPU cores available on the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrMaxCpuCount() {
        return software.amazon.jsii.Kernel.get(this, "attrMaxCpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The total amount of data disk group storage, in terabytes (TB), that's available on the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrMaxDataStorageInTBs() {
        return software.amazon.jsii.Kernel.get(this, "attrMaxDataStorageInTBs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The total amount of local node storage, in gigabytes (GB), that's available on the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrMaxDbNodeStorageSizeInGBs() {
        return software.amazon.jsii.Kernel.get(this, "attrMaxDbNodeStorageSizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The total amount of memory, in gigabytes (GB), that's available on the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrMaxMemoryInGBs() {
        return software.amazon.jsii.Kernel.get(this, "attrMaxMemoryInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of memory, in gigabytes (GB), that's allocated on the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrMemorySizeInGBs() {
        return software.amazon.jsii.Kernel.get(this, "attrMemorySizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The OCID of the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOcid() {
        return software.amazon.jsii.Kernel.get(this, "attrOcid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the OCI resource anchor for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOciResourceAnchorName() {
        return software.amazon.jsii.Kernel.get(this, "attrOciResourceAnchorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The HTTPS link to the Exadata infrastructure in OCI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOciUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrOciUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The software version of the storage servers on the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStorageServerVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrStorageServerVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The total amount of storage, in gigabytes (GB), on the the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrTotalStorageSizeInGBs() {
        return software.amazon.jsii.Kernel.get(this, "attrTotalStorageSizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a CloudExadataInfrastructure resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.odb.CloudExadataInfrastructureReference getCloudExadataInfrastructureRef() {
        return software.amazon.jsii.Kernel.get(this, "cloudExadataInfrastructureRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.odb.CloudExadataInfrastructureReference.class));
    }

    /**
     * The name of the Availability Zone (AZ) where the Exadata infrastructure is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Availability Zone (AZ) where the Exadata infrastructure is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", value);
    }

    /**
     * The AZ ID of the AZ where the Exadata infrastructure is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneId() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AZ ID of the AZ where the Exadata infrastructure is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZoneId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZoneId", value);
    }

    /**
     * The number of database servers for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getComputeCount() {
        return software.amazon.jsii.Kernel.get(this, "computeCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of database servers for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComputeCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "computeCount", value);
    }

    /**
     * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata infrastructure.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure.CustomerContactProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomerContactsToSendToOci() {
        return software.amazon.jsii.Kernel.get(this, "customerContactsToSendToOci", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomerContactsToSendToOci(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customerContactsToSendToOci", value);
    }

    /**
     * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomerContactsToSendToOci(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure.CustomerContactProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure.CustomerContactProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "customerContactsToSendToOci", value);
    }

    /**
     * The database server model type of the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatabaseServerType() {
        return software.amazon.jsii.Kernel.get(this, "databaseServerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The database server model type of the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseServerType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseServerType", value);
    }

    /**
     * The user-friendly name for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user-friendly name for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", value);
    }

    /**
     * The scheduling details for the maintenance window.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure.MaintenanceWindowProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "maintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The scheduling details for the maintenance window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceWindow(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceWindow", value);
    }

    /**
     * The scheduling details for the maintenance window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceWindow(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure.MaintenanceWindowProperty value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceWindow", value);
    }

    /**
     * The model name of the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getShape() {
        return software.amazon.jsii.Kernel.get(this, "shape", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The model name of the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setShape(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "shape", value);
    }

    /**
     * The number of storage servers that are activated for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getStorageCount() {
        return software.amazon.jsii.Kernel.get(this, "storageCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of storage servers that are activated for the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "storageCount", value);
    }

    /**
     * The storage server model type of the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStorageServerType() {
        return software.amazon.jsii.Kernel.get(this, "storageServerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The storage server model type of the Exadata infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageServerType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "storageServerType", value);
    }

    /**
     * Tags to assign to the Exadata Infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Tags to assign to the Exadata Infrastructure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * A contact to receive notification from Oracle about maintenance updates for a specific Exadata infrastructure.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.odb.*;
     * CustomerContactProperty customerContactProperty = CustomerContactProperty.builder()
     *         .email("email")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-customercontact.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-customercontact.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnCloudExadataInfrastructure.CustomerContactProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomerContactProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomerContactProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The email address of the contact.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-customercontact.html#cfn-odb-cloudexadatainfrastructure-customercontact-email">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-customercontact.html#cfn-odb-cloudexadatainfrastructure-customercontact-email</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmail() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomerContactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomerContactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomerContactProperty> {
            java.lang.String email;

            /**
             * Sets the value of {@link CustomerContactProperty#getEmail}
             * @param email The email address of the contact.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder email(java.lang.String email) {
                this.email = email;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomerContactProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomerContactProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomerContactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomerContactProperty {
            private final java.lang.String email;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.email = builder.email;
            }

            @Override
            public final java.lang.String getEmail() {
                return this.email;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEmail() != null) {
                    data.set("email", om.valueToTree(this.getEmail()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnCloudExadataInfrastructure.CustomerContactProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomerContactProperty.Jsii$Proxy that = (CustomerContactProperty.Jsii$Proxy) o;

                return this.email != null ? this.email.equals(that.email) : that.email == null;
            }

            @Override
            public final int hashCode() {
                int result = this.email != null ? this.email.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The scheduling details for the maintenance window.
     * <p>
     * Patching and system updates take place during the maintenance window.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.odb.*;
     * MaintenanceWindowProperty maintenanceWindowProperty = MaintenanceWindowProperty.builder()
     *         .customActionTimeoutInMins(123)
     *         .daysOfWeek(List.of("daysOfWeek"))
     *         .hoursOfDay(List.of(123))
     *         .isCustomActionTimeoutEnabled(false)
     *         .leadTimeInWeeks(123)
     *         .months(List.of("months"))
     *         .patchingMode("patchingMode")
     *         .preference("preference")
     *         .weeksOfMonth(List.of(123))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnCloudExadataInfrastructure.MaintenanceWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The custom action timeout in minutes for the maintenance window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-customactiontimeoutinmins">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-customactiontimeoutinmins</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCustomActionTimeoutInMins() {
            return null;
        }

        /**
         * The days of the week when maintenance can be performed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-daysofweek">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-daysofweek</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDaysOfWeek() {
            return null;
        }

        /**
         * The hours of the day when maintenance can be performed.
         * <p>
         * Returns union: either List<{@link java.lang.Number}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-hoursofday">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-hoursofday</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHoursOfDay() {
            return null;
        }

        /**
         * Indicates whether custom action timeout is enabled for the maintenance window.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-iscustomactiontimeoutenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-iscustomactiontimeoutenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsCustomActionTimeoutEnabled() {
            return null;
        }

        /**
         * The lead time in weeks before the maintenance window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-leadtimeinweeks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-leadtimeinweeks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLeadTimeInWeeks() {
            return null;
        }

        /**
         * The months when maintenance can be performed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-months">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-months</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMonths() {
            return null;
        }

        /**
         * The patching mode for the maintenance window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-patchingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-patchingmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPatchingMode() {
            return null;
        }

        /**
         * The preference for the maintenance window scheduling.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-preference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-preference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreference() {
            return null;
        }

        /**
         * The weeks of the month when maintenance can be performed.
         * <p>
         * Returns union: either List<{@link java.lang.Number}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-weeksofmonth">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudexadatainfrastructure-maintenancewindow.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow-weeksofmonth</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWeeksOfMonth() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceWindowProperty> {
            java.lang.Number customActionTimeoutInMins;
            java.util.List<java.lang.String> daysOfWeek;
            java.lang.Object hoursOfDay;
            java.lang.Object isCustomActionTimeoutEnabled;
            java.lang.Number leadTimeInWeeks;
            java.util.List<java.lang.String> months;
            java.lang.String patchingMode;
            java.lang.String preference;
            java.lang.Object weeksOfMonth;

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getCustomActionTimeoutInMins}
             * @param customActionTimeoutInMins The custom action timeout in minutes for the maintenance window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customActionTimeoutInMins(java.lang.Number customActionTimeoutInMins) {
                this.customActionTimeoutInMins = customActionTimeoutInMins;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getDaysOfWeek}
             * @param daysOfWeek The days of the week when maintenance can be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder daysOfWeek(java.util.List<java.lang.String> daysOfWeek) {
                this.daysOfWeek = daysOfWeek;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getHoursOfDay}
             * @param hoursOfDay The hours of the day when maintenance can be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hoursOfDay(java.util.List<? extends java.lang.Number> hoursOfDay) {
                this.hoursOfDay = hoursOfDay;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getHoursOfDay}
             * @param hoursOfDay The hours of the day when maintenance can be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hoursOfDay(software.amazon.awscdk.IResolvable hoursOfDay) {
                this.hoursOfDay = hoursOfDay;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getIsCustomActionTimeoutEnabled}
             * @param isCustomActionTimeoutEnabled Indicates whether custom action timeout is enabled for the maintenance window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isCustomActionTimeoutEnabled(java.lang.Boolean isCustomActionTimeoutEnabled) {
                this.isCustomActionTimeoutEnabled = isCustomActionTimeoutEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getIsCustomActionTimeoutEnabled}
             * @param isCustomActionTimeoutEnabled Indicates whether custom action timeout is enabled for the maintenance window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isCustomActionTimeoutEnabled(software.amazon.awscdk.IResolvable isCustomActionTimeoutEnabled) {
                this.isCustomActionTimeoutEnabled = isCustomActionTimeoutEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getLeadTimeInWeeks}
             * @param leadTimeInWeeks The lead time in weeks before the maintenance window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leadTimeInWeeks(java.lang.Number leadTimeInWeeks) {
                this.leadTimeInWeeks = leadTimeInWeeks;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getMonths}
             * @param months The months when maintenance can be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder months(java.util.List<java.lang.String> months) {
                this.months = months;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getPatchingMode}
             * @param patchingMode The patching mode for the maintenance window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patchingMode(java.lang.String patchingMode) {
                this.patchingMode = patchingMode;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getPreference}
             * @param preference The preference for the maintenance window scheduling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preference(java.lang.String preference) {
                this.preference = preference;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getWeeksOfMonth}
             * @param weeksOfMonth The weeks of the month when maintenance can be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weeksOfMonth(java.util.List<? extends java.lang.Number> weeksOfMonth) {
                this.weeksOfMonth = weeksOfMonth;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getWeeksOfMonth}
             * @param weeksOfMonth The weeks of the month when maintenance can be performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weeksOfMonth(software.amazon.awscdk.IResolvable weeksOfMonth) {
                this.weeksOfMonth = weeksOfMonth;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceWindowProperty {
            private final java.lang.Number customActionTimeoutInMins;
            private final java.util.List<java.lang.String> daysOfWeek;
            private final java.lang.Object hoursOfDay;
            private final java.lang.Object isCustomActionTimeoutEnabled;
            private final java.lang.Number leadTimeInWeeks;
            private final java.util.List<java.lang.String> months;
            private final java.lang.String patchingMode;
            private final java.lang.String preference;
            private final java.lang.Object weeksOfMonth;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customActionTimeoutInMins = software.amazon.jsii.Kernel.get(this, "customActionTimeoutInMins", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.daysOfWeek = software.amazon.jsii.Kernel.get(this, "daysOfWeek", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.hoursOfDay = software.amazon.jsii.Kernel.get(this, "hoursOfDay", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isCustomActionTimeoutEnabled = software.amazon.jsii.Kernel.get(this, "isCustomActionTimeoutEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.leadTimeInWeeks = software.amazon.jsii.Kernel.get(this, "leadTimeInWeeks", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.months = software.amazon.jsii.Kernel.get(this, "months", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.patchingMode = software.amazon.jsii.Kernel.get(this, "patchingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.preference = software.amazon.jsii.Kernel.get(this, "preference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weeksOfMonth = software.amazon.jsii.Kernel.get(this, "weeksOfMonth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customActionTimeoutInMins = builder.customActionTimeoutInMins;
                this.daysOfWeek = builder.daysOfWeek;
                this.hoursOfDay = builder.hoursOfDay;
                this.isCustomActionTimeoutEnabled = builder.isCustomActionTimeoutEnabled;
                this.leadTimeInWeeks = builder.leadTimeInWeeks;
                this.months = builder.months;
                this.patchingMode = builder.patchingMode;
                this.preference = builder.preference;
                this.weeksOfMonth = builder.weeksOfMonth;
            }

            @Override
            public final java.lang.Number getCustomActionTimeoutInMins() {
                return this.customActionTimeoutInMins;
            }

            @Override
            public final java.util.List<java.lang.String> getDaysOfWeek() {
                return this.daysOfWeek;
            }

            @Override
            public final java.lang.Object getHoursOfDay() {
                return this.hoursOfDay;
            }

            @Override
            public final java.lang.Object getIsCustomActionTimeoutEnabled() {
                return this.isCustomActionTimeoutEnabled;
            }

            @Override
            public final java.lang.Number getLeadTimeInWeeks() {
                return this.leadTimeInWeeks;
            }

            @Override
            public final java.util.List<java.lang.String> getMonths() {
                return this.months;
            }

            @Override
            public final java.lang.String getPatchingMode() {
                return this.patchingMode;
            }

            @Override
            public final java.lang.String getPreference() {
                return this.preference;
            }

            @Override
            public final java.lang.Object getWeeksOfMonth() {
                return this.weeksOfMonth;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomActionTimeoutInMins() != null) {
                    data.set("customActionTimeoutInMins", om.valueToTree(this.getCustomActionTimeoutInMins()));
                }
                if (this.getDaysOfWeek() != null) {
                    data.set("daysOfWeek", om.valueToTree(this.getDaysOfWeek()));
                }
                if (this.getHoursOfDay() != null) {
                    data.set("hoursOfDay", om.valueToTree(this.getHoursOfDay()));
                }
                if (this.getIsCustomActionTimeoutEnabled() != null) {
                    data.set("isCustomActionTimeoutEnabled", om.valueToTree(this.getIsCustomActionTimeoutEnabled()));
                }
                if (this.getLeadTimeInWeeks() != null) {
                    data.set("leadTimeInWeeks", om.valueToTree(this.getLeadTimeInWeeks()));
                }
                if (this.getMonths() != null) {
                    data.set("months", om.valueToTree(this.getMonths()));
                }
                if (this.getPatchingMode() != null) {
                    data.set("patchingMode", om.valueToTree(this.getPatchingMode()));
                }
                if (this.getPreference() != null) {
                    data.set("preference", om.valueToTree(this.getPreference()));
                }
                if (this.getWeeksOfMonth() != null) {
                    data.set("weeksOfMonth", om.valueToTree(this.getWeeksOfMonth()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnCloudExadataInfrastructure.MaintenanceWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceWindowProperty.Jsii$Proxy that = (MaintenanceWindowProperty.Jsii$Proxy) o;

                if (this.customActionTimeoutInMins != null ? !this.customActionTimeoutInMins.equals(that.customActionTimeoutInMins) : that.customActionTimeoutInMins != null) return false;
                if (this.daysOfWeek != null ? !this.daysOfWeek.equals(that.daysOfWeek) : that.daysOfWeek != null) return false;
                if (this.hoursOfDay != null ? !this.hoursOfDay.equals(that.hoursOfDay) : that.hoursOfDay != null) return false;
                if (this.isCustomActionTimeoutEnabled != null ? !this.isCustomActionTimeoutEnabled.equals(that.isCustomActionTimeoutEnabled) : that.isCustomActionTimeoutEnabled != null) return false;
                if (this.leadTimeInWeeks != null ? !this.leadTimeInWeeks.equals(that.leadTimeInWeeks) : that.leadTimeInWeeks != null) return false;
                if (this.months != null ? !this.months.equals(that.months) : that.months != null) return false;
                if (this.patchingMode != null ? !this.patchingMode.equals(that.patchingMode) : that.patchingMode != null) return false;
                if (this.preference != null ? !this.preference.equals(that.preference) : that.preference != null) return false;
                return this.weeksOfMonth != null ? this.weeksOfMonth.equals(that.weeksOfMonth) : that.weeksOfMonth == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customActionTimeoutInMins != null ? this.customActionTimeoutInMins.hashCode() : 0;
                result = 31 * result + (this.daysOfWeek != null ? this.daysOfWeek.hashCode() : 0);
                result = 31 * result + (this.hoursOfDay != null ? this.hoursOfDay.hashCode() : 0);
                result = 31 * result + (this.isCustomActionTimeoutEnabled != null ? this.isCustomActionTimeoutEnabled.hashCode() : 0);
                result = 31 * result + (this.leadTimeInWeeks != null ? this.leadTimeInWeeks.hashCode() : 0);
                result = 31 * result + (this.months != null ? this.months.hashCode() : 0);
                result = 31 * result + (this.patchingMode != null ? this.patchingMode.hashCode() : 0);
                result = 31 * result + (this.preference != null ? this.preference.hashCode() : 0);
                result = 31 * result + (this.weeksOfMonth != null ? this.weeksOfMonth.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructureProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the Availability Zone (AZ) where the Exadata infrastructure is located.
         * <p>
         * Required when creating an Exadata infrastructure. Specify either AvailabilityZone or AvailabilityZoneId to define the location of the infrastructure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-availabilityzone</a>
         * @param availabilityZone The name of the Availability Zone (AZ) where the Exadata infrastructure is located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props().availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The AZ ID of the AZ where the Exadata infrastructure is located.
         * <p>
         * Required when creating an Exadata infrastructure. Specify either AvailabilityZone or AvailabilityZoneId to define the location of the infrastructure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-availabilityzoneid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-availabilityzoneid</a>
         * @param availabilityZoneId The AZ ID of the AZ where the Exadata infrastructure is located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneId(final java.lang.String availabilityZoneId) {
            this.props().availabilityZoneId(availabilityZoneId);
            return this;
        }

        /**
         * The number of database servers for the Exadata infrastructure.
         * <p>
         * Required when creating an Exadata infrastructure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-computecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-computecount</a>
         * @param computeCount The number of database servers for the Exadata infrastructure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeCount(final java.lang.Number computeCount) {
            this.props().computeCount(computeCount);
            return this;
        }

        /**
         * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata infrastructure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-customercontactstosendtooci">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-customercontactstosendtooci</a>
         * @param customerContactsToSendToOci The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata infrastructure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerContactsToSendToOci(final software.amazon.awscdk.IResolvable customerContactsToSendToOci) {
            this.props().customerContactsToSendToOci(customerContactsToSendToOci);
            return this;
        }
        /**
         * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata infrastructure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-customercontactstosendtooci">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-customercontactstosendtooci</a>
         * @param customerContactsToSendToOci The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata infrastructure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerContactsToSendToOci(final java.util.List<? extends java.lang.Object> customerContactsToSendToOci) {
            this.props().customerContactsToSendToOci(customerContactsToSendToOci);
            return this;
        }

        /**
         * The database server model type of the Exadata infrastructure.
         * <p>
         * For the list of valid model names, use the <code>ListDbSystemShapes</code> operation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-databaseservertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-databaseservertype</a>
         * @param databaseServerType The database server model type of the Exadata infrastructure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseServerType(final java.lang.String databaseServerType) {
            this.props().databaseServerType(databaseServerType);
            return this;
        }

        /**
         * The user-friendly name for the Exadata infrastructure.
         * <p>
         * Required when creating an Exadata infrastructure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-displayname</a>
         * @param displayName The user-friendly name for the Exadata infrastructure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props().displayName(displayName);
            return this;
        }

        /**
         * The scheduling details for the maintenance window.
         * <p>
         * Patching and system updates take place during the maintenance window.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow</a>
         * @param maintenanceWindow The scheduling details for the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindow(final software.amazon.awscdk.IResolvable maintenanceWindow) {
            this.props().maintenanceWindow(maintenanceWindow);
            return this;
        }
        /**
         * The scheduling details for the maintenance window.
         * <p>
         * Patching and system updates take place during the maintenance window.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-maintenancewindow</a>
         * @param maintenanceWindow The scheduling details for the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindow(final software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure.MaintenanceWindowProperty maintenanceWindow) {
            this.props().maintenanceWindow(maintenanceWindow);
            return this;
        }

        /**
         * The model name of the Exadata infrastructure.
         * <p>
         * Required when creating an Exadata infrastructure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-shape">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-shape</a>
         * @param shape The model name of the Exadata infrastructure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shape(final java.lang.String shape) {
            this.props().shape(shape);
            return this;
        }

        /**
         * The number of storage servers that are activated for the Exadata infrastructure.
         * <p>
         * Required when creating an Exadata infrastructure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-storagecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-storagecount</a>
         * @param storageCount The number of storage servers that are activated for the Exadata infrastructure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageCount(final java.lang.Number storageCount) {
            this.props().storageCount(storageCount);
            return this;
        }

        /**
         * The storage server model type of the Exadata infrastructure.
         * <p>
         * For the list of valid model names, use the <code>ListDbSystemShapes</code> operation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-storageservertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-storageservertype</a>
         * @param storageServerType The storage server model type of the Exadata infrastructure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageServerType(final java.lang.String storageServerType) {
            this.props().storageServerType(storageServerType);
            return this;
        }

        /**
         * Tags to assign to the Exadata Infrastructure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudexadatainfrastructure.html#cfn-odb-cloudexadatainfrastructure-tags</a>
         * @param tags Tags to assign to the Exadata Infrastructure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure build() {
            return new software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructure(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructureProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.odb.CfnCloudExadataInfrastructureProps.Builder();
            }
            return this.props;
        }
    }
}
