package software.amazon.awscdk.services.odb;

/**
 * The <code>AWS::ODB::CloudVmCluster</code> resource creates a VM cluster on the specified Exadata infrastructure in the Oracle Database.
 * <p>
 * A VM cluster provides the compute resources for Oracle Database workloads.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.odb.*;
 * CfnCloudVmCluster cfnCloudVmCluster = CfnCloudVmCluster.Builder.create(this, "MyCfnCloudVmCluster")
 *         .cloudExadataInfrastructureId("cloudExadataInfrastructureId")
 *         .clusterName("clusterName")
 *         .cpuCoreCount(123)
 *         .dataCollectionOptions(DataCollectionOptionsProperty.builder()
 *                 .isDiagnosticsEventsEnabled(false)
 *                 .isHealthMonitoringEnabled(false)
 *                 .isIncidentLogsEnabled(false)
 *                 .build())
 *         .dataStorageSizeInTBs(123)
 *         .dbNodes(List.of(DbNodeProperty.builder()
 *                 .dbServerId("dbServerId")
 *                 // the properties below are optional
 *                 .backupIpId("backupIpId")
 *                 .backupVnic2Id("backupVnic2Id")
 *                 .cpuCoreCount(123)
 *                 .dbNodeArn("dbNodeArn")
 *                 .dbNodeId("dbNodeId")
 *                 .dbNodeStorageSizeInGBs(123)
 *                 .dbSystemId("dbSystemId")
 *                 .hostIpId("hostIpId")
 *                 .hostname("hostname")
 *                 .memorySizeInGBs(123)
 *                 .ocid("ocid")
 *                 .status("status")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .vnic2Id("vnic2Id")
 *                 .vnicId("vnicId")
 *                 .build()))
 *         .dbNodeStorageSizeInGBs(123)
 *         .dbServers(List.of("dbServers"))
 *         .displayName("displayName")
 *         .giVersion("giVersion")
 *         .hostname("hostname")
 *         .isLocalBackupEnabled(false)
 *         .isSparseDiskgroupEnabled(false)
 *         .licenseModel("licenseModel")
 *         .memorySizeInGBs(123)
 *         .odbNetworkId("odbNetworkId")
 *         .scanListenerPortTcp(123)
 *         .sshPublicKeys(List.of("sshPublicKeys"))
 *         .systemVersion("systemVersion")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeZone("timeZone")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:25.174Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnCloudVmCluster")
public class CfnCloudVmCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.odb.ICloudVmClusterRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnCloudVmCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCloudVmCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.odb.CfnCloudVmCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::ODB::CloudVmCluster</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCloudVmCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.odb.CfnCloudVmClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::ODB::CloudVmCluster</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCloudVmCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForCloudVmCluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.odb.ICloudVmClusterRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.odb.CfnCloudVmCluster.class, "arnForCloudVmCluster", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnCloudVmCluster.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnCloudVmCluster(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.odb.CfnCloudVmCluster.class, "isCfnCloudVmCluster", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCloudVmClusterArn() {
        return software.amazon.jsii.Kernel.get(this, "attrCloudVmClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCloudVmClusterId() {
        return software.amazon.jsii.Kernel.get(this, "attrCloudVmClusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The OCI model compute model used when you create or clone an instance: ECPU or OCPU.
     * <p>
     * An ECPU is an abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on the physical core of a processor with hyper-threading enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrComputeModel() {
        return software.amazon.jsii.Kernel.get(this, "attrComputeModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of redundancy configured for the VM cluster.
     * <p>
     * <code>NORMAL</code> is 2-way redundancy. <code>HIGH</code> is 3-way redundancy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDiskRedundancy() {
        return software.amazon.jsii.Kernel.get(this, "attrDiskRedundancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain of the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomain() {
        return software.amazon.jsii.Kernel.get(this, "attrDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number configured for the listener on the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrListenerPort() {
        return software.amazon.jsii.Kernel.get(this, "attrListenerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of nodes in the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrNodeCount() {
        return software.amazon.jsii.Kernel.get(this, "attrNodeCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The OCID of the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOcid() {
        return software.amazon.jsii.Kernel.get(this, "attrOcid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the OCI resource anchor for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOciResourceAnchorName() {
        return software.amazon.jsii.Kernel.get(this, "attrOciResourceAnchorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The HTTPS link to the VM cluster in OCI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOciUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrOciUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The FQDN of the DNS record for the Single Client Access Name (SCAN) IP addresses that are associated with the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrScanDnsName() {
        return software.amazon.jsii.Kernel.get(this, "attrScanDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The OCID of the SCAN IP addresses that are associated with the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrScanIpIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrScanIpIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The hardware model name of the Exadata infrastructure that's running the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrShape() {
        return software.amazon.jsii.Kernel.get(this, "attrShape", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The amount of local node storage, in gigabytes (GB), that's allocated to the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrStorageSizeInGBs() {
        return software.amazon.jsii.Kernel.get(this, "attrStorageSizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The virtual IP (VIP) addresses that are associated with the VM cluster.
     * <p>
     * Oracle's Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the VM cluster to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrVipIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrVipIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a CloudVmCluster resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.odb.CloudVmClusterReference getCloudVmClusterRef() {
        return software.amazon.jsii.Kernel.get(this, "cloudVmClusterRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.odb.CloudVmClusterReference.class));
    }

    /**
     * The unique identifier of the Exadata infrastructure that this VM cluster belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCloudExadataInfrastructureId() {
        return software.amazon.jsii.Kernel.get(this, "cloudExadataInfrastructureId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the Exadata infrastructure that this VM cluster belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloudExadataInfrastructureId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cloudExadataInfrastructureId", value);
    }

    /**
     * The name of the Grid Infrastructure (GI) cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Grid Infrastructure (GI) cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterName", value);
    }

    /**
     * The number of CPU cores enabled on the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getCpuCoreCount() {
        return software.amazon.jsii.Kernel.get(this, "cpuCoreCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of CPU cores enabled on the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCpuCoreCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "cpuCoreCount", value);
    }

    /**
     * The set of diagnostic collection options enabled for the VM cluster.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.odb.CfnCloudVmCluster.DataCollectionOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataCollectionOptions() {
        return software.amazon.jsii.Kernel.get(this, "dataCollectionOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The set of diagnostic collection options enabled for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataCollectionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataCollectionOptions", value);
    }

    /**
     * The set of diagnostic collection options enabled for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataCollectionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.odb.CfnCloudVmCluster.DataCollectionOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataCollectionOptions", value);
    }

    /**
     * The size of the data disk group, in terabytes (TB), that's allocated for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDataStorageSizeInTBs() {
        return software.amazon.jsii.Kernel.get(this, "dataStorageSizeInTBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The size of the data disk group, in terabytes (TB), that's allocated for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataStorageSizeInTBs(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "dataStorageSizeInTBs", value);
    }

    /**
     * The DB nodes that are implicitly created and managed as part of this VM Cluster.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.odb.CfnCloudVmCluster.DbNodeProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDbNodes() {
        return software.amazon.jsii.Kernel.get(this, "dbNodes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The DB nodes that are implicitly created and managed as part of this VM Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbNodes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dbNodes", value);
    }

    /**
     * The DB nodes that are implicitly created and managed as part of this VM Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbNodes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.odb.CfnCloudVmCluster.DbNodeProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.odb.CfnCloudVmCluster.DbNodeProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "dbNodes", value);
    }

    /**
     * The amount of local node storage, in gigabytes (GB), that's allocated for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDbNodeStorageSizeInGBs() {
        return software.amazon.jsii.Kernel.get(this, "dbNodeStorageSizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of local node storage, in gigabytes (GB), that's allocated for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbNodeStorageSizeInGBs(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "dbNodeStorageSizeInGBs", value);
    }

    /**
     * The list of database servers for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbServers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dbServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of database servers for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbServers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "dbServers", value);
    }

    /**
     * The user-friendly name for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user-friendly name for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", value);
    }

    /**
     * The software version of the Oracle Grid Infrastructure (GI) for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGiVersion() {
        return software.amazon.jsii.Kernel.get(this, "giVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The software version of the Oracle Grid Infrastructure (GI) for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGiVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "giVersion", value);
    }

    /**
     * The host name for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHostname() {
        return software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The host name for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostname(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "hostname", value);
    }

    /**
     * Specifies whether database backups to local Exadata storage are enabled for the VM cluster.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIsLocalBackupEnabled() {
        return software.amazon.jsii.Kernel.get(this, "isLocalBackupEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether database backups to local Exadata storage are enabled for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsLocalBackupEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isLocalBackupEnabled", value);
    }

    /**
     * Specifies whether database backups to local Exadata storage are enabled for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsLocalBackupEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isLocalBackupEnabled", value);
    }

    /**
     * Specifies whether the VM cluster is configured with a sparse disk group.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIsSparseDiskgroupEnabled() {
        return software.amazon.jsii.Kernel.get(this, "isSparseDiskgroupEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the VM cluster is configured with a sparse disk group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsSparseDiskgroupEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isSparseDiskgroupEnabled", value);
    }

    /**
     * Specifies whether the VM cluster is configured with a sparse disk group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsSparseDiskgroupEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isSparseDiskgroupEnabled", value);
    }

    /**
     * The Oracle license model applied to the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLicenseModel() {
        return software.amazon.jsii.Kernel.get(this, "licenseModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Oracle license model applied to the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLicenseModel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "licenseModel", value);
    }

    /**
     * The amount of memory, in gigabytes (GB), that's allocated for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMemorySizeInGBs() {
        return software.amazon.jsii.Kernel.get(this, "memorySizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of memory, in gigabytes (GB), that's allocated for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemorySizeInGBs(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "memorySizeInGBs", value);
    }

    /**
     * The unique identifier of the ODB network for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOdbNetworkId() {
        return software.amazon.jsii.Kernel.get(this, "odbNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the ODB network for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOdbNetworkId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "odbNetworkId", value);
    }

    /**
     * The port number for TCP connections to the single client access name (SCAN) listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getScanListenerPortTcp() {
        return software.amazon.jsii.Kernel.get(this, "scanListenerPortTcp", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port number for TCP connections to the single client access name (SCAN) listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScanListenerPortTcp(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "scanListenerPortTcp", value);
    }

    /**
     * The public key portion of one or more key pairs used for SSH access to the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSshPublicKeys() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "sshPublicKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The public key portion of one or more key pairs used for SSH access to the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSshPublicKeys(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "sshPublicKeys", value);
    }

    /**
     * The operating system version of the image chosen for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSystemVersion() {
        return software.amazon.jsii.Kernel.get(this, "systemVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The operating system version of the image chosen for the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSystemVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "systemVersion", value);
    }

    /**
     * Tags to assign to the Vm Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Tags to assign to the Vm Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The time zone of the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
        return software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time zone of the VM cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "timeZone", value);
    }
    /**
     * Information about the data collection options enabled for a VM cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.odb.*;
     * DataCollectionOptionsProperty dataCollectionOptionsProperty = DataCollectionOptionsProperty.builder()
     *         .isDiagnosticsEventsEnabled(false)
     *         .isHealthMonitoringEnabled(false)
     *         .isIncidentLogsEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-datacollectionoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-datacollectionoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnCloudVmCluster.DataCollectionOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DataCollectionOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataCollectionOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether diagnostic collection is enabled for the VM cluster.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-datacollectionoptions.html#cfn-odb-cloudvmcluster-datacollectionoptions-isdiagnosticseventsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-datacollectionoptions.html#cfn-odb-cloudvmcluster-datacollectionoptions-isdiagnosticseventsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsDiagnosticsEventsEnabled() {
            return null;
        }

        /**
         * Specifies whether health monitoring is enabled for the VM cluster.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-datacollectionoptions.html#cfn-odb-cloudvmcluster-datacollectionoptions-ishealthmonitoringenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-datacollectionoptions.html#cfn-odb-cloudvmcluster-datacollectionoptions-ishealthmonitoringenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsHealthMonitoringEnabled() {
            return null;
        }

        /**
         * Specifies whether incident logs are enabled for the VM cluster.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-datacollectionoptions.html#cfn-odb-cloudvmcluster-datacollectionoptions-isincidentlogsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-datacollectionoptions.html#cfn-odb-cloudvmcluster-datacollectionoptions-isincidentlogsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsIncidentLogsEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataCollectionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataCollectionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataCollectionOptionsProperty> {
            java.lang.Object isDiagnosticsEventsEnabled;
            java.lang.Object isHealthMonitoringEnabled;
            java.lang.Object isIncidentLogsEnabled;

            /**
             * Sets the value of {@link DataCollectionOptionsProperty#getIsDiagnosticsEventsEnabled}
             * @param isDiagnosticsEventsEnabled Specifies whether diagnostic collection is enabled for the VM cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isDiagnosticsEventsEnabled(java.lang.Boolean isDiagnosticsEventsEnabled) {
                this.isDiagnosticsEventsEnabled = isDiagnosticsEventsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DataCollectionOptionsProperty#getIsDiagnosticsEventsEnabled}
             * @param isDiagnosticsEventsEnabled Specifies whether diagnostic collection is enabled for the VM cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isDiagnosticsEventsEnabled(software.amazon.awscdk.IResolvable isDiagnosticsEventsEnabled) {
                this.isDiagnosticsEventsEnabled = isDiagnosticsEventsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DataCollectionOptionsProperty#getIsHealthMonitoringEnabled}
             * @param isHealthMonitoringEnabled Specifies whether health monitoring is enabled for the VM cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isHealthMonitoringEnabled(java.lang.Boolean isHealthMonitoringEnabled) {
                this.isHealthMonitoringEnabled = isHealthMonitoringEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DataCollectionOptionsProperty#getIsHealthMonitoringEnabled}
             * @param isHealthMonitoringEnabled Specifies whether health monitoring is enabled for the VM cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isHealthMonitoringEnabled(software.amazon.awscdk.IResolvable isHealthMonitoringEnabled) {
                this.isHealthMonitoringEnabled = isHealthMonitoringEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DataCollectionOptionsProperty#getIsIncidentLogsEnabled}
             * @param isIncidentLogsEnabled Specifies whether incident logs are enabled for the VM cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isIncidentLogsEnabled(java.lang.Boolean isIncidentLogsEnabled) {
                this.isIncidentLogsEnabled = isIncidentLogsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DataCollectionOptionsProperty#getIsIncidentLogsEnabled}
             * @param isIncidentLogsEnabled Specifies whether incident logs are enabled for the VM cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isIncidentLogsEnabled(software.amazon.awscdk.IResolvable isIncidentLogsEnabled) {
                this.isIncidentLogsEnabled = isIncidentLogsEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataCollectionOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataCollectionOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataCollectionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataCollectionOptionsProperty {
            private final java.lang.Object isDiagnosticsEventsEnabled;
            private final java.lang.Object isHealthMonitoringEnabled;
            private final java.lang.Object isIncidentLogsEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isDiagnosticsEventsEnabled = software.amazon.jsii.Kernel.get(this, "isDiagnosticsEventsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isHealthMonitoringEnabled = software.amazon.jsii.Kernel.get(this, "isHealthMonitoringEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isIncidentLogsEnabled = software.amazon.jsii.Kernel.get(this, "isIncidentLogsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isDiagnosticsEventsEnabled = builder.isDiagnosticsEventsEnabled;
                this.isHealthMonitoringEnabled = builder.isHealthMonitoringEnabled;
                this.isIncidentLogsEnabled = builder.isIncidentLogsEnabled;
            }

            @Override
            public final java.lang.Object getIsDiagnosticsEventsEnabled() {
                return this.isDiagnosticsEventsEnabled;
            }

            @Override
            public final java.lang.Object getIsHealthMonitoringEnabled() {
                return this.isHealthMonitoringEnabled;
            }

            @Override
            public final java.lang.Object getIsIncidentLogsEnabled() {
                return this.isIncidentLogsEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIsDiagnosticsEventsEnabled() != null) {
                    data.set("isDiagnosticsEventsEnabled", om.valueToTree(this.getIsDiagnosticsEventsEnabled()));
                }
                if (this.getIsHealthMonitoringEnabled() != null) {
                    data.set("isHealthMonitoringEnabled", om.valueToTree(this.getIsHealthMonitoringEnabled()));
                }
                if (this.getIsIncidentLogsEnabled() != null) {
                    data.set("isIncidentLogsEnabled", om.valueToTree(this.getIsIncidentLogsEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnCloudVmCluster.DataCollectionOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataCollectionOptionsProperty.Jsii$Proxy that = (DataCollectionOptionsProperty.Jsii$Proxy) o;

                if (this.isDiagnosticsEventsEnabled != null ? !this.isDiagnosticsEventsEnabled.equals(that.isDiagnosticsEventsEnabled) : that.isDiagnosticsEventsEnabled != null) return false;
                if (this.isHealthMonitoringEnabled != null ? !this.isHealthMonitoringEnabled.equals(that.isHealthMonitoringEnabled) : that.isHealthMonitoringEnabled != null) return false;
                return this.isIncidentLogsEnabled != null ? this.isIncidentLogsEnabled.equals(that.isIncidentLogsEnabled) : that.isIncidentLogsEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.isDiagnosticsEventsEnabled != null ? this.isDiagnosticsEventsEnabled.hashCode() : 0;
                result = 31 * result + (this.isHealthMonitoringEnabled != null ? this.isHealthMonitoringEnabled.hashCode() : 0);
                result = 31 * result + (this.isIncidentLogsEnabled != null ? this.isIncidentLogsEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a DB node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.odb.*;
     * DbNodeProperty dbNodeProperty = DbNodeProperty.builder()
     *         .dbServerId("dbServerId")
     *         // the properties below are optional
     *         .backupIpId("backupIpId")
     *         .backupVnic2Id("backupVnic2Id")
     *         .cpuCoreCount(123)
     *         .dbNodeArn("dbNodeArn")
     *         .dbNodeId("dbNodeId")
     *         .dbNodeStorageSizeInGBs(123)
     *         .dbSystemId("dbSystemId")
     *         .hostIpId("hostIpId")
     *         .hostname("hostname")
     *         .memorySizeInGBs(123)
     *         .ocid("ocid")
     *         .status("status")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .vnic2Id("vnic2Id")
     *         .vnicId("vnicId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnCloudVmCluster.DbNodeProperty")
    @software.amazon.jsii.Jsii.Proxy(DbNodeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DbNodeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of the Db server that is associated with the DB node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-dbserverid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-dbserverid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDbServerId();

        /**
         * The Oracle Cloud ID (OCID) of the backup IP address that's associated with the DB node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-backupipid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-backupipid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBackupIpId() {
            return null;
        }

        /**
         * The OCID of the second backup VNIC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-backupvnic2id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-backupvnic2id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBackupVnic2Id() {
            return null;
        }

        /**
         * Number of CPU cores enabled on the DB node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-cpucorecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-cpucorecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCpuCoreCount() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the DB node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-dbnodearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-dbnodearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDbNodeArn() {
            return null;
        }

        /**
         * The unique identifier of the DB node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-dbnodeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-dbnodeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDbNodeId() {
            return null;
        }

        /**
         * The amount of local node storage, in gigabytes (GBs), that's allocated on the DB node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-dbnodestoragesizeingbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-dbnodestoragesizeingbs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDbNodeStorageSizeInGBs() {
            return null;
        }

        /**
         * The OCID of the DB system.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-dbsystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-dbsystemid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDbSystemId() {
            return null;
        }

        /**
         * The OCID of the host IP address that's associated with the DB node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-hostipid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-hostipid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostIpId() {
            return null;
        }

        /**
         * The host name for the DB node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-hostname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-hostname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostname() {
            return null;
        }

        /**
         * The allocated memory in GBs on the DB node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-memorysizeingbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-memorysizeingbs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemorySizeInGBs() {
            return null;
        }

        /**
         * The OCID of the DB node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-ocid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-ocid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOcid() {
            return null;
        }

        /**
         * The current status of the DB node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-tags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return null;
        }

        /**
         * The OCID of the second VNIC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-vnic2id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-vnic2id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVnic2Id() {
            return null;
        }

        /**
         * The OCID of the VNIC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-vnicid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-cloudvmcluster-dbnode.html#cfn-odb-cloudvmcluster-dbnode-vnicid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVnicId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DbNodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DbNodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DbNodeProperty> {
            java.lang.String dbServerId;
            java.lang.String backupIpId;
            java.lang.String backupVnic2Id;
            java.lang.Number cpuCoreCount;
            java.lang.String dbNodeArn;
            java.lang.String dbNodeId;
            java.lang.Number dbNodeStorageSizeInGBs;
            java.lang.String dbSystemId;
            java.lang.String hostIpId;
            java.lang.String hostname;
            java.lang.Number memorySizeInGBs;
            java.lang.String ocid;
            java.lang.String status;
            java.util.List<software.amazon.awscdk.CfnTag> tags;
            java.lang.String vnic2Id;
            java.lang.String vnicId;

            /**
             * Sets the value of {@link DbNodeProperty#getDbServerId}
             * @param dbServerId The unique identifier of the Db server that is associated with the DB node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbServerId(java.lang.String dbServerId) {
                this.dbServerId = dbServerId;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getBackupIpId}
             * @param backupIpId The Oracle Cloud ID (OCID) of the backup IP address that's associated with the DB node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backupIpId(java.lang.String backupIpId) {
                this.backupIpId = backupIpId;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getBackupVnic2Id}
             * @param backupVnic2Id The OCID of the second backup VNIC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backupVnic2Id(java.lang.String backupVnic2Id) {
                this.backupVnic2Id = backupVnic2Id;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getCpuCoreCount}
             * @param cpuCoreCount Number of CPU cores enabled on the DB node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuCoreCount(java.lang.Number cpuCoreCount) {
                this.cpuCoreCount = cpuCoreCount;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getDbNodeArn}
             * @param dbNodeArn The Amazon Resource Name (ARN) of the DB node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbNodeArn(java.lang.String dbNodeArn) {
                this.dbNodeArn = dbNodeArn;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getDbNodeId}
             * @param dbNodeId The unique identifier of the DB node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbNodeId(java.lang.String dbNodeId) {
                this.dbNodeId = dbNodeId;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getDbNodeStorageSizeInGBs}
             * @param dbNodeStorageSizeInGBs The amount of local node storage, in gigabytes (GBs), that's allocated on the DB node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbNodeStorageSizeInGBs(java.lang.Number dbNodeStorageSizeInGBs) {
                this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getDbSystemId}
             * @param dbSystemId The OCID of the DB system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbSystemId(java.lang.String dbSystemId) {
                this.dbSystemId = dbSystemId;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getHostIpId}
             * @param hostIpId The OCID of the host IP address that's associated with the DB node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostIpId(java.lang.String hostIpId) {
                this.hostIpId = hostIpId;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getHostname}
             * @param hostname The host name for the DB node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostname(java.lang.String hostname) {
                this.hostname = hostname;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getMemorySizeInGBs}
             * @param memorySizeInGBs The allocated memory in GBs on the DB node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memorySizeInGBs(java.lang.Number memorySizeInGBs) {
                this.memorySizeInGBs = memorySizeInGBs;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getOcid}
             * @param ocid The OCID of the DB node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ocid(java.lang.String ocid) {
                this.ocid = ocid;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getStatus}
             * @param status The current status of the DB node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getTags}
             * @param tags the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getVnic2Id}
             * @param vnic2Id The OCID of the second VNIC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vnic2Id(java.lang.String vnic2Id) {
                this.vnic2Id = vnic2Id;
                return this;
            }

            /**
             * Sets the value of {@link DbNodeProperty#getVnicId}
             * @param vnicId The OCID of the VNIC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vnicId(java.lang.String vnicId) {
                this.vnicId = vnicId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DbNodeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DbNodeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DbNodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DbNodeProperty {
            private final java.lang.String dbServerId;
            private final java.lang.String backupIpId;
            private final java.lang.String backupVnic2Id;
            private final java.lang.Number cpuCoreCount;
            private final java.lang.String dbNodeArn;
            private final java.lang.String dbNodeId;
            private final java.lang.Number dbNodeStorageSizeInGBs;
            private final java.lang.String dbSystemId;
            private final java.lang.String hostIpId;
            private final java.lang.String hostname;
            private final java.lang.Number memorySizeInGBs;
            private final java.lang.String ocid;
            private final java.lang.String status;
            private final java.util.List<software.amazon.awscdk.CfnTag> tags;
            private final java.lang.String vnic2Id;
            private final java.lang.String vnicId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dbServerId = software.amazon.jsii.Kernel.get(this, "dbServerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.backupIpId = software.amazon.jsii.Kernel.get(this, "backupIpId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.backupVnic2Id = software.amazon.jsii.Kernel.get(this, "backupVnic2Id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cpuCoreCount = software.amazon.jsii.Kernel.get(this, "cpuCoreCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dbNodeArn = software.amazon.jsii.Kernel.get(this, "dbNodeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dbNodeId = software.amazon.jsii.Kernel.get(this, "dbNodeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dbNodeStorageSizeInGBs = software.amazon.jsii.Kernel.get(this, "dbNodeStorageSizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dbSystemId = software.amazon.jsii.Kernel.get(this, "dbSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostIpId = software.amazon.jsii.Kernel.get(this, "hostIpId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memorySizeInGBs = software.amazon.jsii.Kernel.get(this, "memorySizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ocid = software.amazon.jsii.Kernel.get(this, "ocid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
                this.vnic2Id = software.amazon.jsii.Kernel.get(this, "vnic2Id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vnicId = software.amazon.jsii.Kernel.get(this, "vnicId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dbServerId = java.util.Objects.requireNonNull(builder.dbServerId, "dbServerId is required");
                this.backupIpId = builder.backupIpId;
                this.backupVnic2Id = builder.backupVnic2Id;
                this.cpuCoreCount = builder.cpuCoreCount;
                this.dbNodeArn = builder.dbNodeArn;
                this.dbNodeId = builder.dbNodeId;
                this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
                this.dbSystemId = builder.dbSystemId;
                this.hostIpId = builder.hostIpId;
                this.hostname = builder.hostname;
                this.memorySizeInGBs = builder.memorySizeInGBs;
                this.ocid = builder.ocid;
                this.status = builder.status;
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
                this.vnic2Id = builder.vnic2Id;
                this.vnicId = builder.vnicId;
            }

            @Override
            public final java.lang.String getDbServerId() {
                return this.dbServerId;
            }

            @Override
            public final java.lang.String getBackupIpId() {
                return this.backupIpId;
            }

            @Override
            public final java.lang.String getBackupVnic2Id() {
                return this.backupVnic2Id;
            }

            @Override
            public final java.lang.Number getCpuCoreCount() {
                return this.cpuCoreCount;
            }

            @Override
            public final java.lang.String getDbNodeArn() {
                return this.dbNodeArn;
            }

            @Override
            public final java.lang.String getDbNodeId() {
                return this.dbNodeId;
            }

            @Override
            public final java.lang.Number getDbNodeStorageSizeInGBs() {
                return this.dbNodeStorageSizeInGBs;
            }

            @Override
            public final java.lang.String getDbSystemId() {
                return this.dbSystemId;
            }

            @Override
            public final java.lang.String getHostIpId() {
                return this.hostIpId;
            }

            @Override
            public final java.lang.String getHostname() {
                return this.hostname;
            }

            @Override
            public final java.lang.Number getMemorySizeInGBs() {
                return this.memorySizeInGBs;
            }

            @Override
            public final java.lang.String getOcid() {
                return this.ocid;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            public final java.lang.String getVnic2Id() {
                return this.vnic2Id;
            }

            @Override
            public final java.lang.String getVnicId() {
                return this.vnicId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dbServerId", om.valueToTree(this.getDbServerId()));
                if (this.getBackupIpId() != null) {
                    data.set("backupIpId", om.valueToTree(this.getBackupIpId()));
                }
                if (this.getBackupVnic2Id() != null) {
                    data.set("backupVnic2Id", om.valueToTree(this.getBackupVnic2Id()));
                }
                if (this.getCpuCoreCount() != null) {
                    data.set("cpuCoreCount", om.valueToTree(this.getCpuCoreCount()));
                }
                if (this.getDbNodeArn() != null) {
                    data.set("dbNodeArn", om.valueToTree(this.getDbNodeArn()));
                }
                if (this.getDbNodeId() != null) {
                    data.set("dbNodeId", om.valueToTree(this.getDbNodeId()));
                }
                if (this.getDbNodeStorageSizeInGBs() != null) {
                    data.set("dbNodeStorageSizeInGBs", om.valueToTree(this.getDbNodeStorageSizeInGBs()));
                }
                if (this.getDbSystemId() != null) {
                    data.set("dbSystemId", om.valueToTree(this.getDbSystemId()));
                }
                if (this.getHostIpId() != null) {
                    data.set("hostIpId", om.valueToTree(this.getHostIpId()));
                }
                if (this.getHostname() != null) {
                    data.set("hostname", om.valueToTree(this.getHostname()));
                }
                if (this.getMemorySizeInGBs() != null) {
                    data.set("memorySizeInGBs", om.valueToTree(this.getMemorySizeInGBs()));
                }
                if (this.getOcid() != null) {
                    data.set("ocid", om.valueToTree(this.getOcid()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }
                if (this.getVnic2Id() != null) {
                    data.set("vnic2Id", om.valueToTree(this.getVnic2Id()));
                }
                if (this.getVnicId() != null) {
                    data.set("vnicId", om.valueToTree(this.getVnicId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnCloudVmCluster.DbNodeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DbNodeProperty.Jsii$Proxy that = (DbNodeProperty.Jsii$Proxy) o;

                if (!dbServerId.equals(that.dbServerId)) return false;
                if (this.backupIpId != null ? !this.backupIpId.equals(that.backupIpId) : that.backupIpId != null) return false;
                if (this.backupVnic2Id != null ? !this.backupVnic2Id.equals(that.backupVnic2Id) : that.backupVnic2Id != null) return false;
                if (this.cpuCoreCount != null ? !this.cpuCoreCount.equals(that.cpuCoreCount) : that.cpuCoreCount != null) return false;
                if (this.dbNodeArn != null ? !this.dbNodeArn.equals(that.dbNodeArn) : that.dbNodeArn != null) return false;
                if (this.dbNodeId != null ? !this.dbNodeId.equals(that.dbNodeId) : that.dbNodeId != null) return false;
                if (this.dbNodeStorageSizeInGBs != null ? !this.dbNodeStorageSizeInGBs.equals(that.dbNodeStorageSizeInGBs) : that.dbNodeStorageSizeInGBs != null) return false;
                if (this.dbSystemId != null ? !this.dbSystemId.equals(that.dbSystemId) : that.dbSystemId != null) return false;
                if (this.hostIpId != null ? !this.hostIpId.equals(that.hostIpId) : that.hostIpId != null) return false;
                if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
                if (this.memorySizeInGBs != null ? !this.memorySizeInGBs.equals(that.memorySizeInGBs) : that.memorySizeInGBs != null) return false;
                if (this.ocid != null ? !this.ocid.equals(that.ocid) : that.ocid != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
                if (this.vnic2Id != null ? !this.vnic2Id.equals(that.vnic2Id) : that.vnic2Id != null) return false;
                return this.vnicId != null ? this.vnicId.equals(that.vnicId) : that.vnicId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dbServerId.hashCode();
                result = 31 * result + (this.backupIpId != null ? this.backupIpId.hashCode() : 0);
                result = 31 * result + (this.backupVnic2Id != null ? this.backupVnic2Id.hashCode() : 0);
                result = 31 * result + (this.cpuCoreCount != null ? this.cpuCoreCount.hashCode() : 0);
                result = 31 * result + (this.dbNodeArn != null ? this.dbNodeArn.hashCode() : 0);
                result = 31 * result + (this.dbNodeId != null ? this.dbNodeId.hashCode() : 0);
                result = 31 * result + (this.dbNodeStorageSizeInGBs != null ? this.dbNodeStorageSizeInGBs.hashCode() : 0);
                result = 31 * result + (this.dbSystemId != null ? this.dbSystemId.hashCode() : 0);
                result = 31 * result + (this.hostIpId != null ? this.hostIpId.hashCode() : 0);
                result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
                result = 31 * result + (this.memorySizeInGBs != null ? this.memorySizeInGBs.hashCode() : 0);
                result = 31 * result + (this.ocid != null ? this.ocid.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                result = 31 * result + (this.vnic2Id != null ? this.vnic2Id.hashCode() : 0);
                result = 31 * result + (this.vnicId != null ? this.vnicId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.odb.CfnCloudVmCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.odb.CfnCloudVmCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.odb.CfnCloudVmClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The unique identifier of the Exadata infrastructure that this VM cluster belongs to.
         * <p>
         * Required when creating a VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-cloudexadatainfrastructureid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-cloudexadatainfrastructureid</a>
         * @param cloudExadataInfrastructureId The unique identifier of the Exadata infrastructure that this VM cluster belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudExadataInfrastructureId(final java.lang.String cloudExadataInfrastructureId) {
            this.props().cloudExadataInfrastructureId(cloudExadataInfrastructureId);
            return this;
        }

        /**
         * The name of the Grid Infrastructure (GI) cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-clustername</a>
         * @param clusterName The name of the Grid Infrastructure (GI) cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props().clusterName(clusterName);
            return this;
        }

        /**
         * The number of CPU cores enabled on the VM cluster.
         * <p>
         * Required when creating a VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-cpucorecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-cpucorecount</a>
         * @param cpuCoreCount The number of CPU cores enabled on the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuCoreCount(final java.lang.Number cpuCoreCount) {
            this.props().cpuCoreCount(cpuCoreCount);
            return this;
        }

        /**
         * The set of diagnostic collection options enabled for the VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-datacollectionoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-datacollectionoptions</a>
         * @param dataCollectionOptions The set of diagnostic collection options enabled for the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCollectionOptions(final software.amazon.awscdk.IResolvable dataCollectionOptions) {
            this.props().dataCollectionOptions(dataCollectionOptions);
            return this;
        }
        /**
         * The set of diagnostic collection options enabled for the VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-datacollectionoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-datacollectionoptions</a>
         * @param dataCollectionOptions The set of diagnostic collection options enabled for the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCollectionOptions(final software.amazon.awscdk.services.odb.CfnCloudVmCluster.DataCollectionOptionsProperty dataCollectionOptions) {
            this.props().dataCollectionOptions(dataCollectionOptions);
            return this;
        }

        /**
         * The size of the data disk group, in terabytes (TB), that's allocated for the VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-datastoragesizeintbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-datastoragesizeintbs</a>
         * @param dataStorageSizeInTBs The size of the data disk group, in terabytes (TB), that's allocated for the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataStorageSizeInTBs(final java.lang.Number dataStorageSizeInTBs) {
            this.props().dataStorageSizeInTBs(dataStorageSizeInTBs);
            return this;
        }

        /**
         * The DB nodes that are implicitly created and managed as part of this VM Cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-dbnodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-dbnodes</a>
         * @param dbNodes The DB nodes that are implicitly created and managed as part of this VM Cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbNodes(final software.amazon.awscdk.IResolvable dbNodes) {
            this.props().dbNodes(dbNodes);
            return this;
        }
        /**
         * The DB nodes that are implicitly created and managed as part of this VM Cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-dbnodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-dbnodes</a>
         * @param dbNodes The DB nodes that are implicitly created and managed as part of this VM Cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbNodes(final java.util.List<? extends java.lang.Object> dbNodes) {
            this.props().dbNodes(dbNodes);
            return this;
        }

        /**
         * The amount of local node storage, in gigabytes (GB), that's allocated for the VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-dbnodestoragesizeingbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-dbnodestoragesizeingbs</a>
         * @param dbNodeStorageSizeInGBs The amount of local node storage, in gigabytes (GB), that's allocated for the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbNodeStorageSizeInGBs(final java.lang.Number dbNodeStorageSizeInGBs) {
            this.props().dbNodeStorageSizeInGBs(dbNodeStorageSizeInGBs);
            return this;
        }

        /**
         * The list of database servers for the VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-dbservers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-dbservers</a>
         * @param dbServers The list of database servers for the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbServers(final java.util.List<java.lang.String> dbServers) {
            this.props().dbServers(dbServers);
            return this;
        }

        /**
         * The user-friendly name for the VM cluster.
         * <p>
         * Required when creating a VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-displayname</a>
         * @param displayName The user-friendly name for the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props().displayName(displayName);
            return this;
        }

        /**
         * The software version of the Oracle Grid Infrastructure (GI) for the VM cluster.
         * <p>
         * Required when creating a VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-giversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-giversion</a>
         * @param giVersion The software version of the Oracle Grid Infrastructure (GI) for the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder giVersion(final java.lang.String giVersion) {
            this.props().giVersion(giVersion);
            return this;
        }

        /**
         * The host name for the VM cluster.
         * <p>
         * Required when creating a VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-hostname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-hostname</a>
         * @param hostname The host name for the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostname(final java.lang.String hostname) {
            this.props().hostname(hostname);
            return this;
        }

        /**
         * Specifies whether database backups to local Exadata storage are enabled for the VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-islocalbackupenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-islocalbackupenabled</a>
         * @param isLocalBackupEnabled Specifies whether database backups to local Exadata storage are enabled for the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isLocalBackupEnabled(final java.lang.Boolean isLocalBackupEnabled) {
            this.props().isLocalBackupEnabled(isLocalBackupEnabled);
            return this;
        }
        /**
         * Specifies whether database backups to local Exadata storage are enabled for the VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-islocalbackupenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-islocalbackupenabled</a>
         * @param isLocalBackupEnabled Specifies whether database backups to local Exadata storage are enabled for the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isLocalBackupEnabled(final software.amazon.awscdk.IResolvable isLocalBackupEnabled) {
            this.props().isLocalBackupEnabled(isLocalBackupEnabled);
            return this;
        }

        /**
         * Specifies whether the VM cluster is configured with a sparse disk group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-issparsediskgroupenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-issparsediskgroupenabled</a>
         * @param isSparseDiskgroupEnabled Specifies whether the VM cluster is configured with a sparse disk group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isSparseDiskgroupEnabled(final java.lang.Boolean isSparseDiskgroupEnabled) {
            this.props().isSparseDiskgroupEnabled(isSparseDiskgroupEnabled);
            return this;
        }
        /**
         * Specifies whether the VM cluster is configured with a sparse disk group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-issparsediskgroupenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-issparsediskgroupenabled</a>
         * @param isSparseDiskgroupEnabled Specifies whether the VM cluster is configured with a sparse disk group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isSparseDiskgroupEnabled(final software.amazon.awscdk.IResolvable isSparseDiskgroupEnabled) {
            this.props().isSparseDiskgroupEnabled(isSparseDiskgroupEnabled);
            return this;
        }

        /**
         * The Oracle license model applied to the VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-licensemodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-licensemodel</a>
         * @param licenseModel The Oracle license model applied to the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseModel(final java.lang.String licenseModel) {
            this.props().licenseModel(licenseModel);
            return this;
        }

        /**
         * The amount of memory, in gigabytes (GB), that's allocated for the VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-memorysizeingbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-memorysizeingbs</a>
         * @param memorySizeInGBs The amount of memory, in gigabytes (GB), that's allocated for the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySizeInGBs(final java.lang.Number memorySizeInGBs) {
            this.props().memorySizeInGBs(memorySizeInGBs);
            return this;
        }

        /**
         * The unique identifier of the ODB network for the VM cluster.
         * <p>
         * Required when creating a VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-odbnetworkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-odbnetworkid</a>
         * @param odbNetworkId The unique identifier of the ODB network for the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder odbNetworkId(final java.lang.String odbNetworkId) {
            this.props().odbNetworkId(odbNetworkId);
            return this;
        }

        /**
         * The port number for TCP connections to the single client access name (SCAN) listener.
         * <p>
         * Valid values: <code>1024–8999</code> with the following exceptions: <code>2484</code> , <code>6100</code> , <code>6200</code> , <code>7060</code> , <code>7070</code> , <code>7085</code> , and <code>7879</code>
         * <p>
         * Default: <code>1521</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-scanlistenerporttcp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-scanlistenerporttcp</a>
         * @param scanListenerPortTcp The port number for TCP connections to the single client access name (SCAN) listener. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scanListenerPortTcp(final java.lang.Number scanListenerPortTcp) {
            this.props().scanListenerPortTcp(scanListenerPortTcp);
            return this;
        }

        /**
         * The public key portion of one or more key pairs used for SSH access to the VM cluster.
         * <p>
         * Required when creating a VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-sshpublickeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-sshpublickeys</a>
         * @param sshPublicKeys The public key portion of one or more key pairs used for SSH access to the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sshPublicKeys(final java.util.List<java.lang.String> sshPublicKeys) {
            this.props().sshPublicKeys(sshPublicKeys);
            return this;
        }

        /**
         * The operating system version of the image chosen for the VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-systemversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-systemversion</a>
         * @param systemVersion The operating system version of the image chosen for the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder systemVersion(final java.lang.String systemVersion) {
            this.props().systemVersion(systemVersion);
            return this;
        }

        /**
         * Tags to assign to the Vm Cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-tags</a>
         * @param tags Tags to assign to the Vm Cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The time zone of the VM cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-timezone</a>
         * @param timeZone The time zone of the VM cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeZone(final java.lang.String timeZone) {
            this.props().timeZone(timeZone);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.odb.CfnCloudVmCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.odb.CfnCloudVmCluster build() {
            return new software.amazon.awscdk.services.odb.CfnCloudVmCluster(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.odb.CfnCloudVmClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.odb.CfnCloudVmClusterProps.Builder();
            }
            return this.props;
        }
    }
}
