package software.amazon.awscdk.services.odb;

/**
 * The <code>AWS::ODB::OdbNetwork</code> resource creates an ODB network.
 * <p>
 * An ODB network provides the networking foundation for Oracle Database resources.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.odb.*;
 * CfnOdbNetwork cfnOdbNetwork = CfnOdbNetwork.Builder.create(this, "MyCfnOdbNetwork")
 *         .availabilityZone("availabilityZone")
 *         .availabilityZoneId("availabilityZoneId")
 *         .backupSubnetCidr("backupSubnetCidr")
 *         .clientSubnetCidr("clientSubnetCidr")
 *         .customDomainName("customDomainName")
 *         .defaultDnsPrefix("defaultDnsPrefix")
 *         .deleteAssociatedResources(false)
 *         .displayName("displayName")
 *         .s3Access("s3Access")
 *         .s3PolicyDocument("s3PolicyDocument")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .zeroEtlAccess("zeroEtlAccess")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:25.179Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnOdbNetwork")
public class CfnOdbNetwork extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.odb.IOdbNetworkRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnOdbNetwork(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnOdbNetwork(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.odb.CfnOdbNetwork.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::ODB::OdbNetwork</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnOdbNetwork(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.odb.CfnOdbNetworkProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::ODB::OdbNetwork</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnOdbNetwork(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForOdbNetwork(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.odb.IOdbNetworkRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.odb.CfnOdbNetwork.class, "arnForOdbNetwork", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnOdbNetwork.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnOdbNetwork(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.odb.CfnOdbNetwork.class, "isCfnOdbNetwork", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The managed services configuration for the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrManagedServices() {
        return software.amazon.jsii.Kernel.get(this, "attrManagedServices", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The unique identifier of the OCI network anchor for the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOciNetworkAnchorId() {
        return software.amazon.jsii.Kernel.get(this, "attrOciNetworkAnchorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the OCI resource anchor that's associated with the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOciResourceAnchorName() {
        return software.amazon.jsii.Kernel.get(this, "attrOciResourceAnchorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL for the VCN that's associated with the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOciVcnUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrOciVcnUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOdbNetworkArn() {
        return software.amazon.jsii.Kernel.get(this, "attrOdbNetworkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOdbNetworkId() {
        return software.amazon.jsii.Kernel.get(this, "attrOdbNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a OdbNetwork resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.odb.OdbNetworkReference getOdbNetworkRef() {
        return software.amazon.jsii.Kernel.get(this, "odbNetworkRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.odb.OdbNetworkReference.class));
    }

    /**
     * The Availability Zone (AZ) where the ODB network is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone (AZ) where the ODB network is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", value);
    }

    /**
     * The AZ ID of the AZ where the ODB network is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneId() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AZ ID of the AZ where the ODB network is located.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZoneId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZoneId", value);
    }

    /**
     * The CIDR range of the backup subnet in the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBackupSubnetCidr() {
        return software.amazon.jsii.Kernel.get(this, "backupSubnetCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CIDR range of the backup subnet in the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupSubnetCidr(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "backupSubnetCidr", value);
    }

    /**
     * The CIDR range of the client subnet in the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClientSubnetCidr() {
        return software.amazon.jsii.Kernel.get(this, "clientSubnetCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CIDR range of the client subnet in the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientSubnetCidr(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clientSubnetCidr", value);
    }

    /**
     * The domain name for the resources in the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomDomainName() {
        return software.amazon.jsii.Kernel.get(this, "customDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain name for the resources in the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomDomainName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customDomainName", value);
    }

    /**
     * The DNS prefix to the default DNS domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultDnsPrefix() {
        return software.amazon.jsii.Kernel.get(this, "defaultDnsPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DNS prefix to the default DNS domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultDnsPrefix(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultDnsPrefix", value);
    }

    /**
     * Specifies whether to delete associated OCI networking resources along with the ODB network.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeleteAssociatedResources() {
        return software.amazon.jsii.Kernel.get(this, "deleteAssociatedResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to delete associated OCI networking resources along with the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeleteAssociatedResources(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deleteAssociatedResources", value);
    }

    /**
     * Specifies whether to delete associated OCI networking resources along with the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeleteAssociatedResources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deleteAssociatedResources", value);
    }

    /**
     * The user-friendly name of the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user-friendly name of the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", value);
    }

    /**
     * The configuration for Amazon S3 access from the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getS3Access() {
        return software.amazon.jsii.Kernel.get(this, "s3Access", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The configuration for Amazon S3 access from the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Access(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "s3Access", value);
    }

    /**
     * Specifies the endpoint policy for Amazon S3 access from the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getS3PolicyDocument() {
        return software.amazon.jsii.Kernel.get(this, "s3PolicyDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the endpoint policy for Amazon S3 access from the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3PolicyDocument(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "s3PolicyDocument", value);
    }

    /**
     * Tags to assign to the Odb Network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Tags to assign to the Odb Network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The configuration for Zero-ETL access from the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getZeroEtlAccess() {
        return software.amazon.jsii.Kernel.get(this, "zeroEtlAccess", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The configuration for Zero-ETL access from the ODB network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setZeroEtlAccess(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "zeroEtlAccess", value);
    }
    /**
     * The configuration for managed Amazon S3 backup access from the ODB network.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.odb.*;
     * ManagedS3BackupAccessProperty managedS3BackupAccessProperty = ManagedS3BackupAccessProperty.builder()
     *         .ipv4Addresses(List.of("ipv4Addresses"))
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-manageds3backupaccess.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-manageds3backupaccess.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnOdbNetwork.ManagedS3BackupAccessProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedS3BackupAccessProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedS3BackupAccessProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IPv4 addresses for the managed Amazon S3 backup access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-manageds3backupaccess.html#cfn-odb-odbnetwork-manageds3backupaccess-ipv4addresses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-manageds3backupaccess.html#cfn-odb-odbnetwork-manageds3backupaccess-ipv4addresses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpv4Addresses() {
            return null;
        }

        /**
         * The status of the managed Amazon S3 backup access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-manageds3backupaccess.html#cfn-odb-odbnetwork-manageds3backupaccess-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-manageds3backupaccess.html#cfn-odb-odbnetwork-manageds3backupaccess-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedS3BackupAccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedS3BackupAccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedS3BackupAccessProperty> {
            java.util.List<java.lang.String> ipv4Addresses;
            java.lang.String status;

            /**
             * Sets the value of {@link ManagedS3BackupAccessProperty#getIpv4Addresses}
             * @param ipv4Addresses The IPv4 addresses for the managed Amazon S3 backup access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv4Addresses(java.util.List<java.lang.String> ipv4Addresses) {
                this.ipv4Addresses = ipv4Addresses;
                return this;
            }

            /**
             * Sets the value of {@link ManagedS3BackupAccessProperty#getStatus}
             * @param status The status of the managed Amazon S3 backup access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedS3BackupAccessProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedS3BackupAccessProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedS3BackupAccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedS3BackupAccessProperty {
            private final java.util.List<java.lang.String> ipv4Addresses;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipv4Addresses = software.amazon.jsii.Kernel.get(this, "ipv4Addresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipv4Addresses = builder.ipv4Addresses;
                this.status = builder.status;
            }

            @Override
            public final java.util.List<java.lang.String> getIpv4Addresses() {
                return this.ipv4Addresses;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIpv4Addresses() != null) {
                    data.set("ipv4Addresses", om.valueToTree(this.getIpv4Addresses()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnOdbNetwork.ManagedS3BackupAccessProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedS3BackupAccessProperty.Jsii$Proxy that = (ManagedS3BackupAccessProperty.Jsii$Proxy) o;

                if (this.ipv4Addresses != null ? !this.ipv4Addresses.equals(that.ipv4Addresses) : that.ipv4Addresses != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ipv4Addresses != null ? this.ipv4Addresses.hashCode() : 0;
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The managed services configuration for the ODB network.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.odb.*;
     * ManagedServicesProperty managedServicesProperty = ManagedServicesProperty.builder()
     *         .managedS3BackupAccess(ManagedS3BackupAccessProperty.builder()
     *                 .ipv4Addresses(List.of("ipv4Addresses"))
     *                 .status("status")
     *                 .build())
     *         .managedServicesIpv4Cidrs(List.of("managedServicesIpv4Cidrs"))
     *         .resourceGatewayArn("resourceGatewayArn")
     *         .s3Access(S3AccessProperty.builder()
     *                 .domainName("domainName")
     *                 .ipv4Addresses(List.of("ipv4Addresses"))
     *                 .s3PolicyDocument("s3PolicyDocument")
     *                 .status("status")
     *                 .build())
     *         .serviceNetworkArn("serviceNetworkArn")
     *         .serviceNetworkEndpoint(ServiceNetworkEndpointProperty.builder()
     *                 .vpcEndpointId("vpcEndpointId")
     *                 .vpcEndpointType("vpcEndpointType")
     *                 .build())
     *         .zeroEtlAccess(ZeroEtlAccessProperty.builder()
     *                 .cidr("cidr")
     *                 .status("status")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnOdbNetwork.ManagedServicesProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedServicesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedServicesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The managed Amazon S3 backup access configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.odb.CfnOdbNetwork.ManagedS3BackupAccessProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-manageds3backupaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-manageds3backupaccess</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedS3BackupAccess() {
            return null;
        }

        /**
         * The IPv4 CIDR blocks for the managed services.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-managedservicesipv4cidrs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-managedservicesipv4cidrs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getManagedServicesIpv4Cidrs() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the resource gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-resourcegatewayarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-resourcegatewayarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceGatewayArn() {
            return null;
        }

        /**
         * The Amazon S3 access configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.odb.CfnOdbNetwork.S3AccessProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-s3access">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-s3access</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Access() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the service network.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-servicenetworkarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-servicenetworkarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceNetworkArn() {
            return null;
        }

        /**
         * The service network endpoint configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.odb.CfnOdbNetwork.ServiceNetworkEndpointProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-servicenetworkendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-servicenetworkendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceNetworkEndpoint() {
            return null;
        }

        /**
         * The Zero-ETL access configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.odb.CfnOdbNetwork.ZeroEtlAccessProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-zeroetlaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-managedservices.html#cfn-odb-odbnetwork-managedservices-zeroetlaccess</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZeroEtlAccess() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedServicesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedServicesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedServicesProperty> {
            java.lang.Object managedS3BackupAccess;
            java.util.List<java.lang.String> managedServicesIpv4Cidrs;
            java.lang.String resourceGatewayArn;
            java.lang.Object s3Access;
            java.lang.String serviceNetworkArn;
            java.lang.Object serviceNetworkEndpoint;
            java.lang.Object zeroEtlAccess;

            /**
             * Sets the value of {@link ManagedServicesProperty#getManagedS3BackupAccess}
             * @param managedS3BackupAccess The managed Amazon S3 backup access configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedS3BackupAccess(software.amazon.awscdk.IResolvable managedS3BackupAccess) {
                this.managedS3BackupAccess = managedS3BackupAccess;
                return this;
            }

            /**
             * Sets the value of {@link ManagedServicesProperty#getManagedS3BackupAccess}
             * @param managedS3BackupAccess The managed Amazon S3 backup access configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedS3BackupAccess(software.amazon.awscdk.services.odb.CfnOdbNetwork.ManagedS3BackupAccessProperty managedS3BackupAccess) {
                this.managedS3BackupAccess = managedS3BackupAccess;
                return this;
            }

            /**
             * Sets the value of {@link ManagedServicesProperty#getManagedServicesIpv4Cidrs}
             * @param managedServicesIpv4Cidrs The IPv4 CIDR blocks for the managed services.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedServicesIpv4Cidrs(java.util.List<java.lang.String> managedServicesIpv4Cidrs) {
                this.managedServicesIpv4Cidrs = managedServicesIpv4Cidrs;
                return this;
            }

            /**
             * Sets the value of {@link ManagedServicesProperty#getResourceGatewayArn}
             * @param resourceGatewayArn The Amazon Resource Name (ARN) of the resource gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceGatewayArn(java.lang.String resourceGatewayArn) {
                this.resourceGatewayArn = resourceGatewayArn;
                return this;
            }

            /**
             * Sets the value of {@link ManagedServicesProperty#getS3Access}
             * @param s3Access The Amazon S3 access configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Access(software.amazon.awscdk.IResolvable s3Access) {
                this.s3Access = s3Access;
                return this;
            }

            /**
             * Sets the value of {@link ManagedServicesProperty#getS3Access}
             * @param s3Access The Amazon S3 access configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Access(software.amazon.awscdk.services.odb.CfnOdbNetwork.S3AccessProperty s3Access) {
                this.s3Access = s3Access;
                return this;
            }

            /**
             * Sets the value of {@link ManagedServicesProperty#getServiceNetworkArn}
             * @param serviceNetworkArn The Amazon Resource Name (ARN) of the service network.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNetworkArn(java.lang.String serviceNetworkArn) {
                this.serviceNetworkArn = serviceNetworkArn;
                return this;
            }

            /**
             * Sets the value of {@link ManagedServicesProperty#getServiceNetworkEndpoint}
             * @param serviceNetworkEndpoint The service network endpoint configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNetworkEndpoint(software.amazon.awscdk.IResolvable serviceNetworkEndpoint) {
                this.serviceNetworkEndpoint = serviceNetworkEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link ManagedServicesProperty#getServiceNetworkEndpoint}
             * @param serviceNetworkEndpoint The service network endpoint configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNetworkEndpoint(software.amazon.awscdk.services.odb.CfnOdbNetwork.ServiceNetworkEndpointProperty serviceNetworkEndpoint) {
                this.serviceNetworkEndpoint = serviceNetworkEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link ManagedServicesProperty#getZeroEtlAccess}
             * @param zeroEtlAccess The Zero-ETL access configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zeroEtlAccess(software.amazon.awscdk.IResolvable zeroEtlAccess) {
                this.zeroEtlAccess = zeroEtlAccess;
                return this;
            }

            /**
             * Sets the value of {@link ManagedServicesProperty#getZeroEtlAccess}
             * @param zeroEtlAccess The Zero-ETL access configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zeroEtlAccess(software.amazon.awscdk.services.odb.CfnOdbNetwork.ZeroEtlAccessProperty zeroEtlAccess) {
                this.zeroEtlAccess = zeroEtlAccess;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedServicesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedServicesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedServicesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedServicesProperty {
            private final java.lang.Object managedS3BackupAccess;
            private final java.util.List<java.lang.String> managedServicesIpv4Cidrs;
            private final java.lang.String resourceGatewayArn;
            private final java.lang.Object s3Access;
            private final java.lang.String serviceNetworkArn;
            private final java.lang.Object serviceNetworkEndpoint;
            private final java.lang.Object zeroEtlAccess;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.managedS3BackupAccess = software.amazon.jsii.Kernel.get(this, "managedS3BackupAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.managedServicesIpv4Cidrs = software.amazon.jsii.Kernel.get(this, "managedServicesIpv4Cidrs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.resourceGatewayArn = software.amazon.jsii.Kernel.get(this, "resourceGatewayArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Access = software.amazon.jsii.Kernel.get(this, "s3Access", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceNetworkArn = software.amazon.jsii.Kernel.get(this, "serviceNetworkArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceNetworkEndpoint = software.amazon.jsii.Kernel.get(this, "serviceNetworkEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.zeroEtlAccess = software.amazon.jsii.Kernel.get(this, "zeroEtlAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.managedS3BackupAccess = builder.managedS3BackupAccess;
                this.managedServicesIpv4Cidrs = builder.managedServicesIpv4Cidrs;
                this.resourceGatewayArn = builder.resourceGatewayArn;
                this.s3Access = builder.s3Access;
                this.serviceNetworkArn = builder.serviceNetworkArn;
                this.serviceNetworkEndpoint = builder.serviceNetworkEndpoint;
                this.zeroEtlAccess = builder.zeroEtlAccess;
            }

            @Override
            public final java.lang.Object getManagedS3BackupAccess() {
                return this.managedS3BackupAccess;
            }

            @Override
            public final java.util.List<java.lang.String> getManagedServicesIpv4Cidrs() {
                return this.managedServicesIpv4Cidrs;
            }

            @Override
            public final java.lang.String getResourceGatewayArn() {
                return this.resourceGatewayArn;
            }

            @Override
            public final java.lang.Object getS3Access() {
                return this.s3Access;
            }

            @Override
            public final java.lang.String getServiceNetworkArn() {
                return this.serviceNetworkArn;
            }

            @Override
            public final java.lang.Object getServiceNetworkEndpoint() {
                return this.serviceNetworkEndpoint;
            }

            @Override
            public final java.lang.Object getZeroEtlAccess() {
                return this.zeroEtlAccess;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getManagedS3BackupAccess() != null) {
                    data.set("managedS3BackupAccess", om.valueToTree(this.getManagedS3BackupAccess()));
                }
                if (this.getManagedServicesIpv4Cidrs() != null) {
                    data.set("managedServicesIpv4Cidrs", om.valueToTree(this.getManagedServicesIpv4Cidrs()));
                }
                if (this.getResourceGatewayArn() != null) {
                    data.set("resourceGatewayArn", om.valueToTree(this.getResourceGatewayArn()));
                }
                if (this.getS3Access() != null) {
                    data.set("s3Access", om.valueToTree(this.getS3Access()));
                }
                if (this.getServiceNetworkArn() != null) {
                    data.set("serviceNetworkArn", om.valueToTree(this.getServiceNetworkArn()));
                }
                if (this.getServiceNetworkEndpoint() != null) {
                    data.set("serviceNetworkEndpoint", om.valueToTree(this.getServiceNetworkEndpoint()));
                }
                if (this.getZeroEtlAccess() != null) {
                    data.set("zeroEtlAccess", om.valueToTree(this.getZeroEtlAccess()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnOdbNetwork.ManagedServicesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedServicesProperty.Jsii$Proxy that = (ManagedServicesProperty.Jsii$Proxy) o;

                if (this.managedS3BackupAccess != null ? !this.managedS3BackupAccess.equals(that.managedS3BackupAccess) : that.managedS3BackupAccess != null) return false;
                if (this.managedServicesIpv4Cidrs != null ? !this.managedServicesIpv4Cidrs.equals(that.managedServicesIpv4Cidrs) : that.managedServicesIpv4Cidrs != null) return false;
                if (this.resourceGatewayArn != null ? !this.resourceGatewayArn.equals(that.resourceGatewayArn) : that.resourceGatewayArn != null) return false;
                if (this.s3Access != null ? !this.s3Access.equals(that.s3Access) : that.s3Access != null) return false;
                if (this.serviceNetworkArn != null ? !this.serviceNetworkArn.equals(that.serviceNetworkArn) : that.serviceNetworkArn != null) return false;
                if (this.serviceNetworkEndpoint != null ? !this.serviceNetworkEndpoint.equals(that.serviceNetworkEndpoint) : that.serviceNetworkEndpoint != null) return false;
                return this.zeroEtlAccess != null ? this.zeroEtlAccess.equals(that.zeroEtlAccess) : that.zeroEtlAccess == null;
            }

            @Override
            public final int hashCode() {
                int result = this.managedS3BackupAccess != null ? this.managedS3BackupAccess.hashCode() : 0;
                result = 31 * result + (this.managedServicesIpv4Cidrs != null ? this.managedServicesIpv4Cidrs.hashCode() : 0);
                result = 31 * result + (this.resourceGatewayArn != null ? this.resourceGatewayArn.hashCode() : 0);
                result = 31 * result + (this.s3Access != null ? this.s3Access.hashCode() : 0);
                result = 31 * result + (this.serviceNetworkArn != null ? this.serviceNetworkArn.hashCode() : 0);
                result = 31 * result + (this.serviceNetworkEndpoint != null ? this.serviceNetworkEndpoint.hashCode() : 0);
                result = 31 * result + (this.zeroEtlAccess != null ? this.zeroEtlAccess.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for Amazon S3 access from the ODB network.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.odb.*;
     * S3AccessProperty s3AccessProperty = S3AccessProperty.builder()
     *         .domainName("domainName")
     *         .ipv4Addresses(List.of("ipv4Addresses"))
     *         .s3PolicyDocument("s3PolicyDocument")
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-s3access.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-s3access.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnOdbNetwork.S3AccessProperty")
    @software.amazon.jsii.Jsii.Proxy(S3AccessProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3AccessProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The domain name for the Amazon S3 access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-s3access.html#cfn-odb-odbnetwork-s3access-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-s3access.html#cfn-odb-odbnetwork-s3access-domainname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
            return null;
        }

        /**
         * The IPv4 addresses for the Amazon S3 access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-s3access.html#cfn-odb-odbnetwork-s3access-ipv4addresses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-s3access.html#cfn-odb-odbnetwork-s3access-ipv4addresses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpv4Addresses() {
            return null;
        }

        /**
         * The endpoint policy for the Amazon S3 access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-s3access.html#cfn-odb-odbnetwork-s3access-s3policydocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-s3access.html#cfn-odb-odbnetwork-s3access-s3policydocument</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3PolicyDocument() {
            return null;
        }

        /**
         * The status of the Amazon S3 access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-s3access.html#cfn-odb-odbnetwork-s3access-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-s3access.html#cfn-odb-odbnetwork-s3access-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3AccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3AccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3AccessProperty> {
            java.lang.String domainName;
            java.util.List<java.lang.String> ipv4Addresses;
            java.lang.String s3PolicyDocument;
            java.lang.String status;

            /**
             * Sets the value of {@link S3AccessProperty#getDomainName}
             * @param domainName The domain name for the Amazon S3 access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link S3AccessProperty#getIpv4Addresses}
             * @param ipv4Addresses The IPv4 addresses for the Amazon S3 access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv4Addresses(java.util.List<java.lang.String> ipv4Addresses) {
                this.ipv4Addresses = ipv4Addresses;
                return this;
            }

            /**
             * Sets the value of {@link S3AccessProperty#getS3PolicyDocument}
             * @param s3PolicyDocument The endpoint policy for the Amazon S3 access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3PolicyDocument(java.lang.String s3PolicyDocument) {
                this.s3PolicyDocument = s3PolicyDocument;
                return this;
            }

            /**
             * Sets the value of {@link S3AccessProperty#getStatus}
             * @param status The status of the Amazon S3 access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3AccessProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3AccessProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3AccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3AccessProperty {
            private final java.lang.String domainName;
            private final java.util.List<java.lang.String> ipv4Addresses;
            private final java.lang.String s3PolicyDocument;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipv4Addresses = software.amazon.jsii.Kernel.get(this, "ipv4Addresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.s3PolicyDocument = software.amazon.jsii.Kernel.get(this, "s3PolicyDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = builder.domainName;
                this.ipv4Addresses = builder.ipv4Addresses;
                this.s3PolicyDocument = builder.s3PolicyDocument;
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public final java.util.List<java.lang.String> getIpv4Addresses() {
                return this.ipv4Addresses;
            }

            @Override
            public final java.lang.String getS3PolicyDocument() {
                return this.s3PolicyDocument;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDomainName() != null) {
                    data.set("domainName", om.valueToTree(this.getDomainName()));
                }
                if (this.getIpv4Addresses() != null) {
                    data.set("ipv4Addresses", om.valueToTree(this.getIpv4Addresses()));
                }
                if (this.getS3PolicyDocument() != null) {
                    data.set("s3PolicyDocument", om.valueToTree(this.getS3PolicyDocument()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnOdbNetwork.S3AccessProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3AccessProperty.Jsii$Proxy that = (S3AccessProperty.Jsii$Proxy) o;

                if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
                if (this.ipv4Addresses != null ? !this.ipv4Addresses.equals(that.ipv4Addresses) : that.ipv4Addresses != null) return false;
                if (this.s3PolicyDocument != null ? !this.s3PolicyDocument.equals(that.s3PolicyDocument) : that.s3PolicyDocument != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainName != null ? this.domainName.hashCode() : 0;
                result = 31 * result + (this.ipv4Addresses != null ? this.ipv4Addresses.hashCode() : 0);
                result = 31 * result + (this.s3PolicyDocument != null ? this.s3PolicyDocument.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for a service network endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.odb.*;
     * ServiceNetworkEndpointProperty serviceNetworkEndpointProperty = ServiceNetworkEndpointProperty.builder()
     *         .vpcEndpointId("vpcEndpointId")
     *         .vpcEndpointType("vpcEndpointType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-servicenetworkendpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-servicenetworkendpoint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnOdbNetwork.ServiceNetworkEndpointProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceNetworkEndpointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceNetworkEndpointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the VPC endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-servicenetworkendpoint.html#cfn-odb-odbnetwork-servicenetworkendpoint-vpcendpointid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-servicenetworkendpoint.html#cfn-odb-odbnetwork-servicenetworkendpoint-vpcendpointid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointId() {
            return null;
        }

        /**
         * The type of the VPC endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-servicenetworkendpoint.html#cfn-odb-odbnetwork-servicenetworkendpoint-vpcendpointtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-servicenetworkendpoint.html#cfn-odb-odbnetwork-servicenetworkendpoint-vpcendpointtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceNetworkEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceNetworkEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceNetworkEndpointProperty> {
            java.lang.String vpcEndpointId;
            java.lang.String vpcEndpointType;

            /**
             * Sets the value of {@link ServiceNetworkEndpointProperty#getVpcEndpointId}
             * @param vpcEndpointId The identifier of the VPC endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpointId(java.lang.String vpcEndpointId) {
                this.vpcEndpointId = vpcEndpointId;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNetworkEndpointProperty#getVpcEndpointType}
             * @param vpcEndpointType The type of the VPC endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpointType(java.lang.String vpcEndpointType) {
                this.vpcEndpointType = vpcEndpointType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceNetworkEndpointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceNetworkEndpointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceNetworkEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceNetworkEndpointProperty {
            private final java.lang.String vpcEndpointId;
            private final java.lang.String vpcEndpointType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.vpcEndpointId = software.amazon.jsii.Kernel.get(this, "vpcEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcEndpointType = software.amazon.jsii.Kernel.get(this, "vpcEndpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.vpcEndpointId = builder.vpcEndpointId;
                this.vpcEndpointType = builder.vpcEndpointType;
            }

            @Override
            public final java.lang.String getVpcEndpointId() {
                return this.vpcEndpointId;
            }

            @Override
            public final java.lang.String getVpcEndpointType() {
                return this.vpcEndpointType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVpcEndpointId() != null) {
                    data.set("vpcEndpointId", om.valueToTree(this.getVpcEndpointId()));
                }
                if (this.getVpcEndpointType() != null) {
                    data.set("vpcEndpointType", om.valueToTree(this.getVpcEndpointType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnOdbNetwork.ServiceNetworkEndpointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceNetworkEndpointProperty.Jsii$Proxy that = (ServiceNetworkEndpointProperty.Jsii$Proxy) o;

                if (this.vpcEndpointId != null ? !this.vpcEndpointId.equals(that.vpcEndpointId) : that.vpcEndpointId != null) return false;
                return this.vpcEndpointType != null ? this.vpcEndpointType.equals(that.vpcEndpointType) : that.vpcEndpointType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.vpcEndpointId != null ? this.vpcEndpointId.hashCode() : 0;
                result = 31 * result + (this.vpcEndpointType != null ? this.vpcEndpointType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for Zero-ETL access from the ODB network.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.odb.*;
     * ZeroEtlAccessProperty zeroEtlAccessProperty = ZeroEtlAccessProperty.builder()
     *         .cidr("cidr")
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-zeroetlaccess.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-zeroetlaccess.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnOdbNetwork.ZeroEtlAccessProperty")
    @software.amazon.jsii.Jsii.Proxy(ZeroEtlAccessProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZeroEtlAccessProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CIDR block for the Zero-ETL access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-zeroetlaccess.html#cfn-odb-odbnetwork-zeroetlaccess-cidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-zeroetlaccess.html#cfn-odb-odbnetwork-zeroetlaccess-cidr</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCidr() {
            return null;
        }

        /**
         * The status of the Zero-ETL access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-zeroetlaccess.html#cfn-odb-odbnetwork-zeroetlaccess-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-odb-odbnetwork-zeroetlaccess.html#cfn-odb-odbnetwork-zeroetlaccess-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ZeroEtlAccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZeroEtlAccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZeroEtlAccessProperty> {
            java.lang.String cidr;
            java.lang.String status;

            /**
             * Sets the value of {@link ZeroEtlAccessProperty#getCidr}
             * @param cidr The CIDR block for the Zero-ETL access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidr(java.lang.String cidr) {
                this.cidr = cidr;
                return this;
            }

            /**
             * Sets the value of {@link ZeroEtlAccessProperty#getStatus}
             * @param status The status of the Zero-ETL access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZeroEtlAccessProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZeroEtlAccessProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZeroEtlAccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZeroEtlAccessProperty {
            private final java.lang.String cidr;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cidr = builder.cidr;
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getCidr() {
                return this.cidr;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCidr() != null) {
                    data.set("cidr", om.valueToTree(this.getCidr()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnOdbNetwork.ZeroEtlAccessProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZeroEtlAccessProperty.Jsii$Proxy that = (ZeroEtlAccessProperty.Jsii$Proxy) o;

                if (this.cidr != null ? !this.cidr.equals(that.cidr) : that.cidr != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cidr != null ? this.cidr.hashCode() : 0;
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.odb.CfnOdbNetwork}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.odb.CfnOdbNetwork> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.odb.CfnOdbNetworkProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The Availability Zone (AZ) where the ODB network is located.
         * <p>
         * Required when creating an ODB network. Specify either AvailabilityZone or AvailabilityZoneId to define the location of the network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-availabilityzone</a>
         * @param availabilityZone The Availability Zone (AZ) where the ODB network is located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props().availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The AZ ID of the AZ where the ODB network is located.
         * <p>
         * Required when creating an ODB network. Specify either AvailabilityZone or AvailabilityZoneId to define the location of the network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-availabilityzoneid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-availabilityzoneid</a>
         * @param availabilityZoneId The AZ ID of the AZ where the ODB network is located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneId(final java.lang.String availabilityZoneId) {
            this.props().availabilityZoneId(availabilityZoneId);
            return this;
        }

        /**
         * The CIDR range of the backup subnet in the ODB network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-backupsubnetcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-backupsubnetcidr</a>
         * @param backupSubnetCidr The CIDR range of the backup subnet in the ODB network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupSubnetCidr(final java.lang.String backupSubnetCidr) {
            this.props().backupSubnetCidr(backupSubnetCidr);
            return this;
        }

        /**
         * The CIDR range of the client subnet in the ODB network.
         * <p>
         * Required when creating an ODB network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-clientsubnetcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-clientsubnetcidr</a>
         * @param clientSubnetCidr The CIDR range of the client subnet in the ODB network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSubnetCidr(final java.lang.String clientSubnetCidr) {
            this.props().clientSubnetCidr(clientSubnetCidr);
            return this;
        }

        /**
         * The domain name for the resources in the ODB network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-customdomainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-customdomainname</a>
         * @param customDomainName The domain name for the resources in the ODB network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDomainName(final java.lang.String customDomainName) {
            this.props().customDomainName(customDomainName);
            return this;
        }

        /**
         * The DNS prefix to the default DNS domain name.
         * <p>
         * The default DNS domain name is oraclevcn.com.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-defaultdnsprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-defaultdnsprefix</a>
         * @param defaultDnsPrefix The DNS prefix to the default DNS domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultDnsPrefix(final java.lang.String defaultDnsPrefix) {
            this.props().defaultDnsPrefix(defaultDnsPrefix);
            return this;
        }

        /**
         * Specifies whether to delete associated OCI networking resources along with the ODB network.
         * <p>
         * Required when creating an ODB network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-deleteassociatedresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-deleteassociatedresources</a>
         * @param deleteAssociatedResources Specifies whether to delete associated OCI networking resources along with the ODB network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAssociatedResources(final java.lang.Boolean deleteAssociatedResources) {
            this.props().deleteAssociatedResources(deleteAssociatedResources);
            return this;
        }
        /**
         * Specifies whether to delete associated OCI networking resources along with the ODB network.
         * <p>
         * Required when creating an ODB network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-deleteassociatedresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-deleteassociatedresources</a>
         * @param deleteAssociatedResources Specifies whether to delete associated OCI networking resources along with the ODB network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAssociatedResources(final software.amazon.awscdk.IResolvable deleteAssociatedResources) {
            this.props().deleteAssociatedResources(deleteAssociatedResources);
            return this;
        }

        /**
         * The user-friendly name of the ODB network.
         * <p>
         * Required when creating an ODB network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-displayname</a>
         * @param displayName The user-friendly name of the ODB network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props().displayName(displayName);
            return this;
        }

        /**
         * The configuration for Amazon S3 access from the ODB network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-s3access">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-s3access</a>
         * @param s3Access The configuration for Amazon S3 access from the ODB network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Access(final java.lang.String s3Access) {
            this.props().s3Access(s3Access);
            return this;
        }

        /**
         * Specifies the endpoint policy for Amazon S3 access from the ODB network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-s3policydocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-s3policydocument</a>
         * @param s3PolicyDocument Specifies the endpoint policy for Amazon S3 access from the ODB network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3PolicyDocument(final java.lang.String s3PolicyDocument) {
            this.props().s3PolicyDocument(s3PolicyDocument);
            return this;
        }

        /**
         * Tags to assign to the Odb Network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-tags</a>
         * @param tags Tags to assign to the Odb Network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The configuration for Zero-ETL access from the ODB network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-zeroetlaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-odbnetwork.html#cfn-odb-odbnetwork-zeroetlaccess</a>
         * @param zeroEtlAccess The configuration for Zero-ETL access from the ODB network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zeroEtlAccess(final java.lang.String zeroEtlAccess) {
            this.props().zeroEtlAccess(zeroEtlAccess);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.odb.CfnOdbNetwork}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.odb.CfnOdbNetwork build() {
            return new software.amazon.awscdk.services.odb.CfnOdbNetwork(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.odb.CfnOdbNetworkProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.odb.CfnOdbNetworkProps.Builder();
            }
            return this.props;
        }
    }
}
