package software.amazon.awscdk.services.omics;

/**
 * Properties for defining a <code>CfnWorkflowVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.omics.*;
 * CfnWorkflowVersionProps cfnWorkflowVersionProps = CfnWorkflowVersionProps.builder()
 *         .versionName("versionName")
 *         .workflowId("workflowId")
 *         // the properties below are optional
 *         .accelerators("accelerators")
 *         .containerRegistryMap(ContainerRegistryMapProperty.builder()
 *                 .imageMappings(List.of(ImageMappingProperty.builder()
 *                         .destinationImage("destinationImage")
 *                         .sourceImage("sourceImage")
 *                         .build()))
 *                 .registryMappings(List.of(RegistryMappingProperty.builder()
 *                         .ecrAccountId("ecrAccountId")
 *                         .ecrRepositoryPrefix("ecrRepositoryPrefix")
 *                         .upstreamRegistryUrl("upstreamRegistryUrl")
 *                         .upstreamRepositoryPrefix("upstreamRepositoryPrefix")
 *                         .build()))
 *                 .build())
 *         .containerRegistryMapUri("containerRegistryMapUri")
 *         .definitionRepository(DefinitionRepositoryProperty.builder()
 *                 .connectionArn("connectionArn")
 *                 .excludeFilePatterns(List.of("excludeFilePatterns"))
 *                 .fullRepositoryId("fullRepositoryId")
 *                 .sourceReference(SourceReferenceProperty.builder()
 *                         .type("type")
 *                         .value("value")
 *                         .build())
 *                 .build())
 *         .definitionUri("definitionUri")
 *         .description("description")
 *         .engine("engine")
 *         .main("main")
 *         .parameterTemplate(Map.of(
 *                 "parameterTemplateKey", WorkflowParameterProperty.builder()
 *                         .description("description")
 *                         .optional(false)
 *                         .build()))
 *         .parameterTemplatePath("parameterTemplatePath")
 *         .readmeMarkdown("readmeMarkdown")
 *         .readmePath("readmePath")
 *         .readmeUri("readmeUri")
 *         .storageCapacity(123)
 *         .storageType("storageType")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .workflowBucketOwnerId("workflowBucketOwnerId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:25.221Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.CfnWorkflowVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnWorkflowVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWorkflowVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the workflow version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-versionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-versionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVersionName();

    /**
     * The workflow's ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-workflowid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-workflowid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkflowId();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-accelerators">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-accelerators</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccelerators() {
        return null;
    }

    /**
     * Use a container registry map to specify mappings between the ECR private repository and one or more upstream registries.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html">Container images</a> in the <em>AWS HealthOmics User Guide</em> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.omics.CfnWorkflowVersion.ContainerRegistryMapProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-containerregistrymap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-containerregistrymap</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContainerRegistryMap() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-containerregistrymapuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-containerregistrymapuri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContainerRegistryMapUri() {
        return null;
    }

    /**
     * Contains information about a source code repository that hosts the workflow definition files.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.omics.CfnWorkflowVersion.DefinitionRepositoryProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-definitionrepository">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-definitionrepository</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionRepository() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-definitionuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-definitionuri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefinitionUri() {
        return null;
    }

    /**
     * The description of the workflow version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-engine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-main">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-main</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMain() {
        return null;
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.omics.CfnWorkflowVersion.WorkflowParameterProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-parametertemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-parametertemplate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameterTemplate() {
        return null;
    }

    /**
     * Path to the primary workflow parameter template JSON file inside the repository.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-parametertemplatepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-parametertemplatepath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getParameterTemplatePath() {
        return null;
    }

    /**
     * The markdown content for the workflow's README file.
     * <p>
     * This provides documentation and usage information for users of the workflow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-readmemarkdown">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-readmemarkdown</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReadmeMarkdown() {
        return null;
    }

    /**
     * The path to the workflow README markdown file within the repository.
     * <p>
     * This file provides documentation and usage information for the workflow. If not specified, the README.md file from the root directory of the repository will be used.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-readmepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-readmepath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReadmePath() {
        return null;
    }

    /**
     * The S3 URI of the README file for the workflow.
     * <p>
     * This file provides documentation and usage information for the workflow. The S3 URI must begin with s3://USER-OWNED-BUCKET/. The requester must have access to the S3 bucket and object. The max README content length is 500 KiB.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-readmeuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-readmeuri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReadmeUri() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-storagecapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-storagecapacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStorageCapacity() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-storagetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-storagetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return null;
    }

    /**
     * A map of resource tags.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-workflowbucketownerid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-workflowbucketownerid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkflowBucketOwnerId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWorkflowVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWorkflowVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWorkflowVersionProps> {
        java.lang.String versionName;
        java.lang.String workflowId;
        java.lang.String accelerators;
        java.lang.Object containerRegistryMap;
        java.lang.String containerRegistryMapUri;
        java.lang.Object definitionRepository;
        java.lang.String definitionUri;
        java.lang.String description;
        java.lang.String engine;
        java.lang.String main;
        java.lang.Object parameterTemplate;
        java.lang.String parameterTemplatePath;
        java.lang.String readmeMarkdown;
        java.lang.String readmePath;
        java.lang.String readmeUri;
        java.lang.Number storageCapacity;
        java.lang.String storageType;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.String workflowBucketOwnerId;

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getVersionName}
         * @param versionName The name of the workflow version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionName(java.lang.String versionName) {
            this.versionName = versionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getWorkflowId}
         * @param workflowId The workflow's ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowId(java.lang.String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getAccelerators}
         * @param accelerators the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerators(java.lang.String accelerators) {
            this.accelerators = accelerators;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getContainerRegistryMap}
         * @param containerRegistryMap Use a container registry map to specify mappings between the ECR private repository and one or more upstream registries.
         *                             For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html">Container images</a> in the <em>AWS HealthOmics User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerRegistryMap(software.amazon.awscdk.IResolvable containerRegistryMap) {
            this.containerRegistryMap = containerRegistryMap;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getContainerRegistryMap}
         * @param containerRegistryMap Use a container registry map to specify mappings between the ECR private repository and one or more upstream registries.
         *                             For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html">Container images</a> in the <em>AWS HealthOmics User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerRegistryMap(software.amazon.awscdk.services.omics.CfnWorkflowVersion.ContainerRegistryMapProperty containerRegistryMap) {
            this.containerRegistryMap = containerRegistryMap;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getContainerRegistryMapUri}
         * @param containerRegistryMapUri the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerRegistryMapUri(java.lang.String containerRegistryMapUri) {
            this.containerRegistryMapUri = containerRegistryMapUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getDefinitionRepository}
         * @param definitionRepository Contains information about a source code repository that hosts the workflow definition files.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionRepository(software.amazon.awscdk.IResolvable definitionRepository) {
            this.definitionRepository = definitionRepository;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getDefinitionRepository}
         * @param definitionRepository Contains information about a source code repository that hosts the workflow definition files.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionRepository(software.amazon.awscdk.services.omics.CfnWorkflowVersion.DefinitionRepositoryProperty definitionRepository) {
            this.definitionRepository = definitionRepository;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getDefinitionUri}
         * @param definitionUri the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(java.lang.String definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getDescription}
         * @param description The description of the workflow version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getEngine}
         * @param engine the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getMain}
         * @param main the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder main(java.lang.String main) {
            this.main = main;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getParameterTemplate}
         * @param parameterTemplate the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterTemplate(software.amazon.awscdk.IResolvable parameterTemplate) {
            this.parameterTemplate = parameterTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getParameterTemplate}
         * @param parameterTemplate the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterTemplate(java.util.Map<java.lang.String, ? extends java.lang.Object> parameterTemplate) {
            this.parameterTemplate = parameterTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getParameterTemplatePath}
         * @param parameterTemplatePath Path to the primary workflow parameter template JSON file inside the repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterTemplatePath(java.lang.String parameterTemplatePath) {
            this.parameterTemplatePath = parameterTemplatePath;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getReadmeMarkdown}
         * @param readmeMarkdown The markdown content for the workflow's README file.
         *                       This provides documentation and usage information for users of the workflow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readmeMarkdown(java.lang.String readmeMarkdown) {
            this.readmeMarkdown = readmeMarkdown;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getReadmePath}
         * @param readmePath The path to the workflow README markdown file within the repository.
         *                   This file provides documentation and usage information for the workflow. If not specified, the README.md file from the root directory of the repository will be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readmePath(java.lang.String readmePath) {
            this.readmePath = readmePath;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getReadmeUri}
         * @param readmeUri The S3 URI of the README file for the workflow.
         *                  This file provides documentation and usage information for the workflow. The S3 URI must begin with s3://USER-OWNED-BUCKET/. The requester must have access to the S3 bucket and object. The max README content length is 500 KiB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readmeUri(java.lang.String readmeUri) {
            this.readmeUri = readmeUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getStorageCapacity}
         * @param storageCapacity the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageCapacity(java.lang.Number storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getStorageType}
         * @param storageType the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(java.lang.String storageType) {
            this.storageType = storageType;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getTags}
         * @param tags A map of resource tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnWorkflowVersionProps#getWorkflowBucketOwnerId}
         * @param workflowBucketOwnerId the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowBucketOwnerId(java.lang.String workflowBucketOwnerId) {
            this.workflowBucketOwnerId = workflowBucketOwnerId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWorkflowVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWorkflowVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWorkflowVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWorkflowVersionProps {
        private final java.lang.String versionName;
        private final java.lang.String workflowId;
        private final java.lang.String accelerators;
        private final java.lang.Object containerRegistryMap;
        private final java.lang.String containerRegistryMapUri;
        private final java.lang.Object definitionRepository;
        private final java.lang.String definitionUri;
        private final java.lang.String description;
        private final java.lang.String engine;
        private final java.lang.String main;
        private final java.lang.Object parameterTemplate;
        private final java.lang.String parameterTemplatePath;
        private final java.lang.String readmeMarkdown;
        private final java.lang.String readmePath;
        private final java.lang.String readmeUri;
        private final java.lang.Number storageCapacity;
        private final java.lang.String storageType;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.String workflowBucketOwnerId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.versionName = software.amazon.jsii.Kernel.get(this, "versionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workflowId = software.amazon.jsii.Kernel.get(this, "workflowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accelerators = software.amazon.jsii.Kernel.get(this, "accelerators", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.containerRegistryMap = software.amazon.jsii.Kernel.get(this, "containerRegistryMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.containerRegistryMapUri = software.amazon.jsii.Kernel.get(this, "containerRegistryMapUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.definitionRepository = software.amazon.jsii.Kernel.get(this, "definitionRepository", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.definitionUri = software.amazon.jsii.Kernel.get(this, "definitionUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.main = software.amazon.jsii.Kernel.get(this, "main", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameterTemplate = software.amazon.jsii.Kernel.get(this, "parameterTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.parameterTemplatePath = software.amazon.jsii.Kernel.get(this, "parameterTemplatePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readmeMarkdown = software.amazon.jsii.Kernel.get(this, "readmeMarkdown", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readmePath = software.amazon.jsii.Kernel.get(this, "readmePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readmeUri = software.amazon.jsii.Kernel.get(this, "readmeUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storageCapacity = software.amazon.jsii.Kernel.get(this, "storageCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.storageType = software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.workflowBucketOwnerId = software.amazon.jsii.Kernel.get(this, "workflowBucketOwnerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.versionName = java.util.Objects.requireNonNull(builder.versionName, "versionName is required");
            this.workflowId = java.util.Objects.requireNonNull(builder.workflowId, "workflowId is required");
            this.accelerators = builder.accelerators;
            this.containerRegistryMap = builder.containerRegistryMap;
            this.containerRegistryMapUri = builder.containerRegistryMapUri;
            this.definitionRepository = builder.definitionRepository;
            this.definitionUri = builder.definitionUri;
            this.description = builder.description;
            this.engine = builder.engine;
            this.main = builder.main;
            this.parameterTemplate = builder.parameterTemplate;
            this.parameterTemplatePath = builder.parameterTemplatePath;
            this.readmeMarkdown = builder.readmeMarkdown;
            this.readmePath = builder.readmePath;
            this.readmeUri = builder.readmeUri;
            this.storageCapacity = builder.storageCapacity;
            this.storageType = builder.storageType;
            this.tags = builder.tags;
            this.workflowBucketOwnerId = builder.workflowBucketOwnerId;
        }

        @Override
        public final java.lang.String getVersionName() {
            return this.versionName;
        }

        @Override
        public final java.lang.String getWorkflowId() {
            return this.workflowId;
        }

        @Override
        public final java.lang.String getAccelerators() {
            return this.accelerators;
        }

        @Override
        public final java.lang.Object getContainerRegistryMap() {
            return this.containerRegistryMap;
        }

        @Override
        public final java.lang.String getContainerRegistryMapUri() {
            return this.containerRegistryMapUri;
        }

        @Override
        public final java.lang.Object getDefinitionRepository() {
            return this.definitionRepository;
        }

        @Override
        public final java.lang.String getDefinitionUri() {
            return this.definitionUri;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.String getMain() {
            return this.main;
        }

        @Override
        public final java.lang.Object getParameterTemplate() {
            return this.parameterTemplate;
        }

        @Override
        public final java.lang.String getParameterTemplatePath() {
            return this.parameterTemplatePath;
        }

        @Override
        public final java.lang.String getReadmeMarkdown() {
            return this.readmeMarkdown;
        }

        @Override
        public final java.lang.String getReadmePath() {
            return this.readmePath;
        }

        @Override
        public final java.lang.String getReadmeUri() {
            return this.readmeUri;
        }

        @Override
        public final java.lang.Number getStorageCapacity() {
            return this.storageCapacity;
        }

        @Override
        public final java.lang.String getStorageType() {
            return this.storageType;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getWorkflowBucketOwnerId() {
            return this.workflowBucketOwnerId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("versionName", om.valueToTree(this.getVersionName()));
            data.set("workflowId", om.valueToTree(this.getWorkflowId()));
            if (this.getAccelerators() != null) {
                data.set("accelerators", om.valueToTree(this.getAccelerators()));
            }
            if (this.getContainerRegistryMap() != null) {
                data.set("containerRegistryMap", om.valueToTree(this.getContainerRegistryMap()));
            }
            if (this.getContainerRegistryMapUri() != null) {
                data.set("containerRegistryMapUri", om.valueToTree(this.getContainerRegistryMapUri()));
            }
            if (this.getDefinitionRepository() != null) {
                data.set("definitionRepository", om.valueToTree(this.getDefinitionRepository()));
            }
            if (this.getDefinitionUri() != null) {
                data.set("definitionUri", om.valueToTree(this.getDefinitionUri()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEngine() != null) {
                data.set("engine", om.valueToTree(this.getEngine()));
            }
            if (this.getMain() != null) {
                data.set("main", om.valueToTree(this.getMain()));
            }
            if (this.getParameterTemplate() != null) {
                data.set("parameterTemplate", om.valueToTree(this.getParameterTemplate()));
            }
            if (this.getParameterTemplatePath() != null) {
                data.set("parameterTemplatePath", om.valueToTree(this.getParameterTemplatePath()));
            }
            if (this.getReadmeMarkdown() != null) {
                data.set("readmeMarkdown", om.valueToTree(this.getReadmeMarkdown()));
            }
            if (this.getReadmePath() != null) {
                data.set("readmePath", om.valueToTree(this.getReadmePath()));
            }
            if (this.getReadmeUri() != null) {
                data.set("readmeUri", om.valueToTree(this.getReadmeUri()));
            }
            if (this.getStorageCapacity() != null) {
                data.set("storageCapacity", om.valueToTree(this.getStorageCapacity()));
            }
            if (this.getStorageType() != null) {
                data.set("storageType", om.valueToTree(this.getStorageType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWorkflowBucketOwnerId() != null) {
                data.set("workflowBucketOwnerId", om.valueToTree(this.getWorkflowBucketOwnerId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_omics.CfnWorkflowVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWorkflowVersionProps.Jsii$Proxy that = (CfnWorkflowVersionProps.Jsii$Proxy) o;

            if (!versionName.equals(that.versionName)) return false;
            if (!workflowId.equals(that.workflowId)) return false;
            if (this.accelerators != null ? !this.accelerators.equals(that.accelerators) : that.accelerators != null) return false;
            if (this.containerRegistryMap != null ? !this.containerRegistryMap.equals(that.containerRegistryMap) : that.containerRegistryMap != null) return false;
            if (this.containerRegistryMapUri != null ? !this.containerRegistryMapUri.equals(that.containerRegistryMapUri) : that.containerRegistryMapUri != null) return false;
            if (this.definitionRepository != null ? !this.definitionRepository.equals(that.definitionRepository) : that.definitionRepository != null) return false;
            if (this.definitionUri != null ? !this.definitionUri.equals(that.definitionUri) : that.definitionUri != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.engine != null ? !this.engine.equals(that.engine) : that.engine != null) return false;
            if (this.main != null ? !this.main.equals(that.main) : that.main != null) return false;
            if (this.parameterTemplate != null ? !this.parameterTemplate.equals(that.parameterTemplate) : that.parameterTemplate != null) return false;
            if (this.parameterTemplatePath != null ? !this.parameterTemplatePath.equals(that.parameterTemplatePath) : that.parameterTemplatePath != null) return false;
            if (this.readmeMarkdown != null ? !this.readmeMarkdown.equals(that.readmeMarkdown) : that.readmeMarkdown != null) return false;
            if (this.readmePath != null ? !this.readmePath.equals(that.readmePath) : that.readmePath != null) return false;
            if (this.readmeUri != null ? !this.readmeUri.equals(that.readmeUri) : that.readmeUri != null) return false;
            if (this.storageCapacity != null ? !this.storageCapacity.equals(that.storageCapacity) : that.storageCapacity != null) return false;
            if (this.storageType != null ? !this.storageType.equals(that.storageType) : that.storageType != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.workflowBucketOwnerId != null ? this.workflowBucketOwnerId.equals(that.workflowBucketOwnerId) : that.workflowBucketOwnerId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.versionName.hashCode();
            result = 31 * result + (this.workflowId.hashCode());
            result = 31 * result + (this.accelerators != null ? this.accelerators.hashCode() : 0);
            result = 31 * result + (this.containerRegistryMap != null ? this.containerRegistryMap.hashCode() : 0);
            result = 31 * result + (this.containerRegistryMapUri != null ? this.containerRegistryMapUri.hashCode() : 0);
            result = 31 * result + (this.definitionRepository != null ? this.definitionRepository.hashCode() : 0);
            result = 31 * result + (this.definitionUri != null ? this.definitionUri.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
            result = 31 * result + (this.main != null ? this.main.hashCode() : 0);
            result = 31 * result + (this.parameterTemplate != null ? this.parameterTemplate.hashCode() : 0);
            result = 31 * result + (this.parameterTemplatePath != null ? this.parameterTemplatePath.hashCode() : 0);
            result = 31 * result + (this.readmeMarkdown != null ? this.readmeMarkdown.hashCode() : 0);
            result = 31 * result + (this.readmePath != null ? this.readmePath.hashCode() : 0);
            result = 31 * result + (this.readmeUri != null ? this.readmeUri.hashCode() : 0);
            result = 31 * result + (this.storageCapacity != null ? this.storageCapacity.hashCode() : 0);
            result = 31 * result + (this.storageType != null ? this.storageType.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.workflowBucketOwnerId != null ? this.workflowBucketOwnerId.hashCode() : 0);
            return result;
        }
    }
}
