package software.amazon.awscdk.services.opensearchservice;

/**
 * Configuration for node options in OpenSearch domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opensearchservice.*;
 * NodeOptions nodeOptions = NodeOptions.builder()
 *         .nodeConfig(NodeConfig.builder()
 *                 .count(123)
 *                 .enabled(false)
 *                 .type("type")
 *                 .build())
 *         .nodeType(NodeType.COORDINATOR)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:25.331Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.NodeOptions")
@software.amazon.jsii.Jsii.Proxy(NodeOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NodeOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Configuration for the node type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.NodeConfig getNodeConfig();

    /**
     * The type of node.
     * <p>
     * Currently only 'coordinator' is supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.NodeType getNodeType();

    /**
     * @return a {@link Builder} of {@link NodeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NodeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NodeOptions> {
        software.amazon.awscdk.services.opensearchservice.NodeConfig nodeConfig;
        software.amazon.awscdk.services.opensearchservice.NodeType nodeType;

        /**
         * Sets the value of {@link NodeOptions#getNodeConfig}
         * @param nodeConfig Configuration for the node type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeConfig(software.amazon.awscdk.services.opensearchservice.NodeConfig nodeConfig) {
            this.nodeConfig = nodeConfig;
            return this;
        }

        /**
         * Sets the value of {@link NodeOptions#getNodeType}
         * @param nodeType The type of node. This parameter is required.
         *                 Currently only 'coordinator' is supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeType(software.amazon.awscdk.services.opensearchservice.NodeType nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NodeOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NodeOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NodeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeOptions {
        private final software.amazon.awscdk.services.opensearchservice.NodeConfig nodeConfig;
        private final software.amazon.awscdk.services.opensearchservice.NodeType nodeType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.nodeConfig = software.amazon.jsii.Kernel.get(this, "nodeConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.NodeConfig.class));
            this.nodeType = software.amazon.jsii.Kernel.get(this, "nodeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.NodeType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.nodeConfig = java.util.Objects.requireNonNull(builder.nodeConfig, "nodeConfig is required");
            this.nodeType = java.util.Objects.requireNonNull(builder.nodeType, "nodeType is required");
        }

        @Override
        public final software.amazon.awscdk.services.opensearchservice.NodeConfig getNodeConfig() {
            return this.nodeConfig;
        }

        @Override
        public final software.amazon.awscdk.services.opensearchservice.NodeType getNodeType() {
            return this.nodeType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("nodeConfig", om.valueToTree(this.getNodeConfig()));
            data.set("nodeType", om.valueToTree(this.getNodeType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.NodeOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NodeOptions.Jsii$Proxy that = (NodeOptions.Jsii$Proxy) o;

            if (!nodeConfig.equals(that.nodeConfig)) return false;
            return this.nodeType.equals(that.nodeType);
        }

        @Override
        public final int hashCode() {
            int result = this.nodeConfig.hashCode();
            result = 31 * result + (this.nodeType.hashCode());
            return result;
        }
    }
}
