package software.amazon.awscdk.services.pcaconnectorad;

/**
 * Create a group access control entry.
 * <p>
 * Allow or deny Active Directory groups from enrolling and/or autoenrolling with the template based on the group security identifiers (SIDs).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pcaconnectorad.*;
 * CfnTemplateGroupAccessControlEntry cfnTemplateGroupAccessControlEntry = CfnTemplateGroupAccessControlEntry.Builder.create(this, "MyCfnTemplateGroupAccessControlEntry")
 *         .accessRights(AccessRightsProperty.builder()
 *                 .autoEnroll("autoEnroll")
 *                 .enroll("enroll")
 *                 .build())
 *         .groupDisplayName("groupDisplayName")
 *         // the properties below are optional
 *         .groupSecurityIdentifier("groupSecurityIdentifier")
 *         .templateArn("templateArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:25.483Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplateGroupAccessControlEntry")
public class CfnTemplateGroupAccessControlEntry extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.pcaconnectorad.ITemplateGroupAccessControlEntryRef {

    protected CfnTemplateGroupAccessControlEntry(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTemplateGroupAccessControlEntry(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntry.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::PCAConnectorAD::TemplateGroupAccessControlEntry</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTemplateGroupAccessControlEntry(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Checks whether the given object is a CfnTemplateGroupAccessControlEntry.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnTemplateGroupAccessControlEntry(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntry.class, "isCfnTemplateGroupAccessControlEntry", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a TemplateGroupAccessControlEntry resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.pcaconnectorad.TemplateGroupAccessControlEntryReference getTemplateGroupAccessControlEntryRef() {
        return software.amazon.jsii.Kernel.get(this, "templateGroupAccessControlEntryRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.pcaconnectorad.TemplateGroupAccessControlEntryReference.class));
    }

    /**
     * Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntry.AccessRightsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAccessRights() {
        return software.amazon.jsii.Kernel.get(this, "accessRights", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessRights(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "accessRights", java.util.Objects.requireNonNull(value, "accessRights is required"));
    }

    /**
     * Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessRights(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntry.AccessRightsProperty value) {
        software.amazon.jsii.Kernel.set(this, "accessRights", java.util.Objects.requireNonNull(value, "accessRights is required"));
    }

    /**
     * Name of the Active Directory group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getGroupDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "groupDisplayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of the Active Directory group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupDisplayName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "groupDisplayName", java.util.Objects.requireNonNull(value, "groupDisplayName is required"));
    }

    /**
     * Security identifier (SID) of the group object from Active Directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGroupSecurityIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "groupSecurityIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Security identifier (SID) of the group object from Active Directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupSecurityIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "groupSecurityIdentifier", value);
    }

    /**
     * The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTemplateArn() {
        return software.amazon.jsii.Kernel.get(this, "templateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateArn", value);
    }
    /**
     * Allow or deny permissions for an Active Directory group to enroll or autoenroll certificates for a template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pcaconnectorad.*;
     * AccessRightsProperty accessRightsProperty = AccessRightsProperty.builder()
     *         .autoEnroll("autoEnroll")
     *         .enroll("enroll")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-templategroupaccesscontrolentry-accessrights.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-templategroupaccesscontrolentry-accessrights.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pcaconnectorad.CfnTemplateGroupAccessControlEntry.AccessRightsProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessRightsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessRightsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Allow or deny an Active Directory group from autoenrolling certificates issued against a template.
         * <p>
         * The Active Directory group must be allowed to enroll to allow autoenrollment
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-templategroupaccesscontrolentry-accessrights.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-accessrights-autoenroll">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-templategroupaccesscontrolentry-accessrights.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-accessrights-autoenroll</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAutoEnroll() {
            return null;
        }

        /**
         * Allow or deny an Active Directory group from enrolling certificates issued against a template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-templategroupaccesscontrolentry-accessrights.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-accessrights-enroll">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pcaconnectorad-templategroupaccesscontrolentry-accessrights.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-accessrights-enroll</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEnroll() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessRightsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessRightsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessRightsProperty> {
            java.lang.String autoEnroll;
            java.lang.String enroll;

            /**
             * Sets the value of {@link AccessRightsProperty#getAutoEnroll}
             * @param autoEnroll Allow or deny an Active Directory group from autoenrolling certificates issued against a template.
             *                   The Active Directory group must be allowed to enroll to allow autoenrollment
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoEnroll(java.lang.String autoEnroll) {
                this.autoEnroll = autoEnroll;
                return this;
            }

            /**
             * Sets the value of {@link AccessRightsProperty#getEnroll}
             * @param enroll Allow or deny an Active Directory group from enrolling certificates issued against a template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enroll(java.lang.String enroll) {
                this.enroll = enroll;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessRightsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessRightsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessRightsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessRightsProperty {
            private final java.lang.String autoEnroll;
            private final java.lang.String enroll;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoEnroll = software.amazon.jsii.Kernel.get(this, "autoEnroll", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enroll = software.amazon.jsii.Kernel.get(this, "enroll", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoEnroll = builder.autoEnroll;
                this.enroll = builder.enroll;
            }

            @Override
            public final java.lang.String getAutoEnroll() {
                return this.autoEnroll;
            }

            @Override
            public final java.lang.String getEnroll() {
                return this.enroll;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoEnroll() != null) {
                    data.set("autoEnroll", om.valueToTree(this.getAutoEnroll()));
                }
                if (this.getEnroll() != null) {
                    data.set("enroll", om.valueToTree(this.getEnroll()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pcaconnectorad.CfnTemplateGroupAccessControlEntry.AccessRightsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessRightsProperty.Jsii$Proxy that = (AccessRightsProperty.Jsii$Proxy) o;

                if (this.autoEnroll != null ? !this.autoEnroll.equals(that.autoEnroll) : that.autoEnroll != null) return false;
                return this.enroll != null ? this.enroll.equals(that.enroll) : that.enroll == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoEnroll != null ? this.autoEnroll.hashCode() : 0;
                result = 31 * result + (this.enroll != null ? this.enroll.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntry}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntry> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntryProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntryProps.Builder();
        }

        /**
         * Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-accessrights">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-accessrights</a>
         * @param accessRights Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRights(final software.amazon.awscdk.IResolvable accessRights) {
            this.props.accessRights(accessRights);
            return this;
        }
        /**
         * Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-accessrights">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-accessrights</a>
         * @param accessRights Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessRights(final software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntry.AccessRightsProperty accessRights) {
            this.props.accessRights(accessRights);
            return this;
        }

        /**
         * Name of the Active Directory group.
         * <p>
         * This name does not need to match the group name in Active Directory.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-groupdisplayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-groupdisplayname</a>
         * @param groupDisplayName Name of the Active Directory group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupDisplayName(final java.lang.String groupDisplayName) {
            this.props.groupDisplayName(groupDisplayName);
            return this;
        }

        /**
         * Security identifier (SID) of the group object from Active Directory.
         * <p>
         * The SID starts with "S-".
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-groupsecurityidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-groupsecurityidentifier</a>
         * @param groupSecurityIdentifier Security identifier (SID) of the group object from Active Directory. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupSecurityIdentifier(final java.lang.String groupSecurityIdentifier) {
            this.props.groupSecurityIdentifier(groupSecurityIdentifier);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-templatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pcaconnectorad-templategroupaccesscontrolentry.html#cfn-pcaconnectorad-templategroupaccesscontrolentry-templatearn</a>
         * @param templateArn The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateArn(final java.lang.String templateArn) {
            this.props.templateArn(templateArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntry}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntry build() {
            return new software.amazon.awscdk.services.pcaconnectorad.CfnTemplateGroupAccessControlEntry(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
