package software.amazon.awscdk.services.rds;

/**
 * The type returned from the <code>IClusterEngine.bindToCluster</code> method.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * ParameterGroup parameterGroup;
 * ClusterEngineConfig clusterEngineConfig = ClusterEngineConfig.builder()
 *         .features(ClusterEngineFeatures.builder()
 *                 .s3Export("s3Export")
 *                 .s3Import("s3Import")
 *                 .serverlessV2AutoPauseSupported(false)
 *                 .build())
 *         .parameterGroup(parameterGroup)
 *         .port(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:27.948Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ClusterEngineConfig")
@software.amazon.jsii.Jsii.Proxy(ClusterEngineConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClusterEngineConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Features supported by the database engine.
     * <p>
     * Default: - no features
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html">https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.ClusterEngineFeatures getFeatures() {
        return null;
    }

    /**
     * The ParameterGroup to use for the cluster.
     * <p>
     * Default: - no ParameterGroup will be used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IParameterGroup getParameterGroup() {
        return null;
    }

    /**
     * The port to use for this cluster, unless the customer specified the port directly.
     * <p>
     * Default: - use the default port for clusters (3306)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClusterEngineConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterEngineConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterEngineConfig> {
        software.amazon.awscdk.services.rds.ClusterEngineFeatures features;
        software.amazon.awscdk.services.rds.IParameterGroup parameterGroup;
        java.lang.Number port;

        /**
         * Sets the value of {@link ClusterEngineConfig#getFeatures}
         * @param features Features supported by the database engine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder features(software.amazon.awscdk.services.rds.ClusterEngineFeatures features) {
            this.features = features;
            return this;
        }

        /**
         * Sets the value of {@link ClusterEngineConfig#getParameterGroup}
         * @param parameterGroup The ParameterGroup to use for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterGroup(software.amazon.awscdk.services.rds.IParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        /**
         * Sets the value of {@link ClusterEngineConfig#getPort}
         * @param port The port to use for this cluster, unless the customer specified the port directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterEngineConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClusterEngineConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClusterEngineConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterEngineConfig {
        private final software.amazon.awscdk.services.rds.ClusterEngineFeatures features;
        private final software.amazon.awscdk.services.rds.IParameterGroup parameterGroup;
        private final java.lang.Number port;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.features = software.amazon.jsii.Kernel.get(this, "features", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ClusterEngineFeatures.class));
            this.parameterGroup = software.amazon.jsii.Kernel.get(this, "parameterGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IParameterGroup.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.features = builder.features;
            this.parameterGroup = builder.parameterGroup;
            this.port = builder.port;
        }

        @Override
        public final software.amazon.awscdk.services.rds.ClusterEngineFeatures getFeatures() {
            return this.features;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IParameterGroup getParameterGroup() {
            return this.parameterGroup;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFeatures() != null) {
                data.set("features", om.valueToTree(this.getFeatures()));
            }
            if (this.getParameterGroup() != null) {
                data.set("parameterGroup", om.valueToTree(this.getParameterGroup()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.ClusterEngineConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterEngineConfig.Jsii$Proxy that = (ClusterEngineConfig.Jsii$Proxy) o;

            if (this.features != null ? !this.features.equals(that.features) : that.features != null) return false;
            if (this.parameterGroup != null ? !this.parameterGroup.equals(that.parameterGroup) : that.parameterGroup != null) return false;
            return this.port != null ? this.port.equals(that.port) : that.port == null;
        }

        @Override
        public final int hashCode() {
            int result = this.features != null ? this.features.hashCode() : 0;
            result = 31 * result + (this.parameterGroup != null ? this.parameterGroup.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            return result;
        }
    }
}
