package software.amazon.awscdk.services.rds;

/**
 * Create an RDS Aurora Cluster Instance.
 * <p>
 * You can create either provisioned or
 * serverless v2 instances.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster myCluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder().version(AuroraMysqlEngineVersion.VER_2_08_1).build()))
 *         .writer(ClusterInstance.provisioned("writer", ProvisionedClusterInstanceProps.builder()
 *                 .instanceType(InstanceType.of(InstanceClass.R6G, InstanceSize.XLARGE4))
 *                 .build()))
 *         .serverlessV2MinCapacity(6.5)
 *         .serverlessV2MaxCapacity(64)
 *         .readers(List.of(ClusterInstance.serverlessV2("reader1", ServerlessV2ClusterInstanceProps.builder().scaleWithWriter(true).build()), ClusterInstance.serverlessV2("reader2")))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:27.949Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ClusterInstance")
public class ClusterInstance extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.rds.IClusterInstance {

    protected ClusterInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ClusterInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Add a provisioned instance to the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * ClusterInstance.provisioned("ClusterInstance", ProvisionedClusterInstanceProps.builder()
     *         .instanceType(InstanceType.of(InstanceClass.R6G, InstanceSize.XLARGE4))
     *         .build());
     * </pre></blockquote>
     * <p>
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IClusterInstance provisioned(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.ProvisionedClusterInstanceProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.ClusterInstance.class, "provisioned", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterInstance.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Add a provisioned instance to the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * ClusterInstance.provisioned("ClusterInstance", ProvisionedClusterInstanceProps.builder()
     *         .instanceType(InstanceType.of(InstanceClass.R6G, InstanceSize.XLARGE4))
     *         .build());
     * </pre></blockquote>
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IClusterInstance provisioned(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.ClusterInstance.class, "provisioned", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterInstance.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Add a serverless v2 instance to the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * ClusterInstance.serverlessV2("ClusterInstance", ServerlessV2ClusterInstanceProps.builder()
     *         .scaleWithWriter(true)
     *         .build());
     * </pre></blockquote>
     * <p>
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IClusterInstance serverlessV2(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.ServerlessV2ClusterInstanceProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.ClusterInstance.class, "serverlessV2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterInstance.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Add a serverless v2 instance to the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * ClusterInstance.serverlessV2("ClusterInstance", ServerlessV2ClusterInstanceProps.builder()
     *         .scaleWithWriter(true)
     *         .build());
     * </pre></blockquote>
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IClusterInstance serverlessV2(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.ClusterInstance.class, "serverlessV2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterInstance.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Add the ClusterInstance to the cluster.
     * <p>
     * @param scope This parameter is required.
     * @param cluster This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IAuroraClusterInstance bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseCluster cluster, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ClusterInstanceBindOptions props) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IAuroraClusterInstance.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(cluster, "cluster is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }
}
