package software.amazon.awscdk.services.rds;

/**
 * Interface representing a database instance (as opposed to cluster) engine.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:28.057Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.IInstanceEngine")
@software.amazon.jsii.Jsii.Proxy(IInstanceEngine.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IInstanceEngine extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.rds.IEngine {

    /**
     * The application used by this engine to perform rotation for a multi-user scenario.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getMultiUserRotationApplication();

    /**
     * The application used by this engine to perform rotation for a single-user scenario.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getSingleUserRotationApplication();

    /**
     * Whether this engine supports automatic backups of a read replica instance.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSupportsReadReplicaBackups() {
        return null;
    }

    /**
     * Method called when the engine is used to create a new instance.
     * <p>
     * @param scope This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.InstanceEngineConfig bindToInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.InstanceEngineBindOptions options);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.rds.IInstanceEngine.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The type of the engine, for example "mysql".
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getEngineType() {
            return software.amazon.jsii.Kernel.get(this, "engineType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The default name of the master database user if one was not provided explicitly.
         * <p>
         * The global default of 'admin' will be used if this is <code>undefined</code>.
         * Note that 'admin' is a reserved word in PostgreSQL and cannot be used.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getDefaultUsername() {
            return software.amazon.jsii.Kernel.get(this, "defaultUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The family this engine belongs to, like "MYSQL", or "POSTGRESQL".
         * <p>
         * This property is used when creating a Database Proxy.
         * Most engines don't belong to any family
         * (and because of that, you can't create Database Proxies for their Clusters or Instances).
         * <p>
         * Default: - the engine doesn't belong to any family
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getEngineFamily() {
            return software.amazon.jsii.Kernel.get(this, "engineFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The exact version of the engine that is used, for example "5.1.42".
         * <p>
         * Default: - use the default version for this engine type
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.EngineVersion getEngineVersion() {
            return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.EngineVersion.class));
        }

        /**
         * The family to use for ParameterGroups using this engine.
         * <p>
         * This is usually equal to "<engineType><engineMajorVersion>",
         * but can sometimes be a variation of that.
         * You can pass this property when creating new ParameterGroup.
         * <p>
         * Default: - the ParameterGroup family is not known
         * (which means the major version of the engine is also not known)
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getParameterGroupFamily() {
            return software.amazon.jsii.Kernel.get(this, "parameterGroupFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The application used by this engine to perform rotation for a multi-user scenario.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getMultiUserRotationApplication() {
            return software.amazon.jsii.Kernel.get(this, "multiUserRotationApplication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        }

        /**
         * The application used by this engine to perform rotation for a single-user scenario.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getSingleUserRotationApplication() {
            return software.amazon.jsii.Kernel.get(this, "singleUserRotationApplication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        }

        /**
         * Whether this engine supports automatic backups of a read replica instance.
         * <p>
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getSupportsReadReplicaBackups() {
            return software.amazon.jsii.Kernel.get(this, "supportsReadReplicaBackups", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Method called when the engine is used to create a new instance.
         * <p>
         * @param scope This parameter is required.
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.InstanceEngineConfig bindToInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.InstanceEngineBindOptions options) {
            return software.amazon.jsii.Kernel.call(this, "bindToInstance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.InstanceEngineConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }
    }

    /**
     * Internal default implementation for {@link IInstanceEngine}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IInstanceEngine, software.amazon.awscdk.services.rds.IEngine.Jsii$Default {

        /**
         * The type of the engine, for example "mysql".
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getEngineType() {
            return software.amazon.jsii.Kernel.get(this, "engineType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The default name of the master database user if one was not provided explicitly.
         * <p>
         * The global default of 'admin' will be used if this is <code>undefined</code>.
         * Note that 'admin' is a reserved word in PostgreSQL and cannot be used.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultUsername() {
            return software.amazon.jsii.Kernel.get(this, "defaultUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The family this engine belongs to, like "MYSQL", or "POSTGRESQL".
         * <p>
         * This property is used when creating a Database Proxy.
         * Most engines don't belong to any family
         * (and because of that, you can't create Database Proxies for their Clusters or Instances).
         * <p>
         * Default: - the engine doesn't belong to any family
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEngineFamily() {
            return software.amazon.jsii.Kernel.get(this, "engineFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The exact version of the engine that is used, for example "5.1.42".
         * <p>
         * Default: - use the default version for this engine type
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.EngineVersion getEngineVersion() {
            return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.EngineVersion.class));
        }

        /**
         * The family to use for ParameterGroups using this engine.
         * <p>
         * This is usually equal to "<engineType><engineMajorVersion>",
         * but can sometimes be a variation of that.
         * You can pass this property when creating new ParameterGroup.
         * <p>
         * Default: - the ParameterGroup family is not known
         * (which means the major version of the engine is also not known)
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParameterGroupFamily() {
            return software.amazon.jsii.Kernel.get(this, "parameterGroupFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The application used by this engine to perform rotation for a multi-user scenario.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getMultiUserRotationApplication() {
            return software.amazon.jsii.Kernel.get(this, "multiUserRotationApplication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        }

        /**
         * The application used by this engine to perform rotation for a single-user scenario.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getSingleUserRotationApplication() {
            return software.amazon.jsii.Kernel.get(this, "singleUserRotationApplication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
        }

        /**
         * Whether this engine supports automatic backups of a read replica instance.
         * <p>
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getSupportsReadReplicaBackups() {
            return software.amazon.jsii.Kernel.get(this, "supportsReadReplicaBackups", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Method called when the engine is used to create a new instance.
         * <p>
         * @param scope This parameter is required.
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.InstanceEngineConfig bindToInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.InstanceEngineBindOptions options) {
            return software.amazon.jsii.Kernel.call(this, "bindToInstance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.InstanceEngineConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(options, "options is required") });
        }
    }
}
