package software.amazon.awscdk.services.rds;

/**
 * A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Secret[] secrets;
 * DatabaseInstance dbInstance;
 * DatabaseProxy proxy = dbInstance.addProxy("Proxy", DatabaseProxyOptions.builder()
 *         .secrets(secrets)
 *         .vpc(vpc)
 *         .build());
 * // Add a reader endpoint
 * proxy.addEndpoint("ProxyEndpoint", DatabaseProxyEndpointOptions.builder()
 *         .vpc(vpc)
 *         .targetRole(ProxyEndpointTargetRole.READ_ONLY)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:28.096Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ProxyEndpointTargetRole")
public enum ProxyEndpointTargetRole {
    /**
     * The proxy endpoint can be used for both read and write operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    READ_WRITE,
    /**
     * The proxy endpoint can be used only for read operations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    READ_ONLY,
}
