package software.amazon.awscdk.services.refactorspaces;

/**
 * Properties for defining a <code>CfnRoute</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.refactorspaces.*;
 * CfnRouteProps cfnRouteProps = CfnRouteProps.builder()
 *         .applicationIdentifier("applicationIdentifier")
 *         .environmentIdentifier("environmentIdentifier")
 *         .routeType("routeType")
 *         .serviceIdentifier("serviceIdentifier")
 *         // the properties below are optional
 *         .defaultRoute(DefaultRouteInputProperty.builder()
 *                 .activationState("activationState")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .uriPathRoute(UriPathRouteInputProperty.builder()
 *                 .activationState("activationState")
 *                 // the properties below are optional
 *                 .appendSourcePath(false)
 *                 .includeChildPaths(false)
 *                 .methods(List.of("methods"))
 *                 .sourcePath("sourcePath")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:28.208Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_refactorspaces.CfnRouteProps")
@software.amazon.jsii.Jsii.Proxy(CfnRouteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRouteProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier of the application.
     * <p>
     * Returns union: either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.refactorspaces.IApplicationRef}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-applicationidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-applicationidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getApplicationIdentifier();

    /**
     * The unique identifier of the environment.
     * <p>
     * Returns union: either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.refactorspaces.IEnvironmentRef}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-environmentidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-environmentidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getEnvironmentIdentifier();

    /**
     * The route type of the route.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-routetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-routetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteType();

    /**
     * The unique identifier of the service.
     * <p>
     * Returns union: either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.refactorspaces.IServiceRef}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-serviceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-serviceidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getServiceIdentifier();

    /**
     * Configuration for the default route type.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.refactorspaces.CfnRoute.DefaultRouteInputProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-defaultroute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-defaultroute</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultRoute() {
        return null;
    }

    /**
     * The tags assigned to the route.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The configuration for the URI path route type.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.refactorspaces.CfnRoute.UriPathRouteInputProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-uripathroute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-refactorspaces-route.html#cfn-refactorspaces-route-uripathroute</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUriPathRoute() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRouteProps> {
        java.lang.Object applicationIdentifier;
        java.lang.Object environmentIdentifier;
        java.lang.String routeType;
        java.lang.Object serviceIdentifier;
        java.lang.Object defaultRoute;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object uriPathRoute;

        /**
         * Sets the value of {@link CfnRouteProps#getApplicationIdentifier}
         * @param applicationIdentifier The unique identifier of the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationIdentifier(java.lang.String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getApplicationIdentifier}
         * @param applicationIdentifier The unique identifier of the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationIdentifier(software.amazon.awscdk.interfaces.refactorspaces.IApplicationRef applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getEnvironmentIdentifier}
         * @param environmentIdentifier The unique identifier of the environment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentIdentifier(java.lang.String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getEnvironmentIdentifier}
         * @param environmentIdentifier The unique identifier of the environment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentIdentifier(software.amazon.awscdk.interfaces.refactorspaces.IEnvironmentRef environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getRouteType}
         * @param routeType The route type of the route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeType(java.lang.String routeType) {
            this.routeType = routeType;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getServiceIdentifier}
         * @param serviceIdentifier The unique identifier of the service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceIdentifier(java.lang.String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getServiceIdentifier}
         * @param serviceIdentifier The unique identifier of the service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceIdentifier(software.amazon.awscdk.interfaces.refactorspaces.IServiceRef serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getDefaultRoute}
         * @param defaultRoute Configuration for the default route type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRoute(software.amazon.awscdk.IResolvable defaultRoute) {
            this.defaultRoute = defaultRoute;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getDefaultRoute}
         * @param defaultRoute Configuration for the default route type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRoute(software.amazon.awscdk.services.refactorspaces.CfnRoute.DefaultRouteInputProperty defaultRoute) {
            this.defaultRoute = defaultRoute;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getTags}
         * @param tags The tags assigned to the route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getUriPathRoute}
         * @param uriPathRoute The configuration for the URI path route type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uriPathRoute(software.amazon.awscdk.IResolvable uriPathRoute) {
            this.uriPathRoute = uriPathRoute;
            return this;
        }

        /**
         * Sets the value of {@link CfnRouteProps#getUriPathRoute}
         * @param uriPathRoute The configuration for the URI path route type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uriPathRoute(software.amazon.awscdk.services.refactorspaces.CfnRoute.UriPathRouteInputProperty uriPathRoute) {
            this.uriPathRoute = uriPathRoute;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRouteProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRouteProps {
        private final java.lang.Object applicationIdentifier;
        private final java.lang.Object environmentIdentifier;
        private final java.lang.String routeType;
        private final java.lang.Object serviceIdentifier;
        private final java.lang.Object defaultRoute;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object uriPathRoute;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationIdentifier = software.amazon.jsii.Kernel.get(this, "applicationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.environmentIdentifier = software.amazon.jsii.Kernel.get(this, "environmentIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.routeType = software.amazon.jsii.Kernel.get(this, "routeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceIdentifier = software.amazon.jsii.Kernel.get(this, "serviceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.defaultRoute = software.amazon.jsii.Kernel.get(this, "defaultRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.uriPathRoute = software.amazon.jsii.Kernel.get(this, "uriPathRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationIdentifier = java.util.Objects.requireNonNull(builder.applicationIdentifier, "applicationIdentifier is required");
            this.environmentIdentifier = java.util.Objects.requireNonNull(builder.environmentIdentifier, "environmentIdentifier is required");
            this.routeType = java.util.Objects.requireNonNull(builder.routeType, "routeType is required");
            this.serviceIdentifier = java.util.Objects.requireNonNull(builder.serviceIdentifier, "serviceIdentifier is required");
            this.defaultRoute = builder.defaultRoute;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.uriPathRoute = builder.uriPathRoute;
        }

        @Override
        public final java.lang.Object getApplicationIdentifier() {
            return this.applicationIdentifier;
        }

        @Override
        public final java.lang.Object getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        @Override
        public final java.lang.String getRouteType() {
            return this.routeType;
        }

        @Override
        public final java.lang.Object getServiceIdentifier() {
            return this.serviceIdentifier;
        }

        @Override
        public final java.lang.Object getDefaultRoute() {
            return this.defaultRoute;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getUriPathRoute() {
            return this.uriPathRoute;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationIdentifier", om.valueToTree(this.getApplicationIdentifier()));
            data.set("environmentIdentifier", om.valueToTree(this.getEnvironmentIdentifier()));
            data.set("routeType", om.valueToTree(this.getRouteType()));
            data.set("serviceIdentifier", om.valueToTree(this.getServiceIdentifier()));
            if (this.getDefaultRoute() != null) {
                data.set("defaultRoute", om.valueToTree(this.getDefaultRoute()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUriPathRoute() != null) {
                data.set("uriPathRoute", om.valueToTree(this.getUriPathRoute()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_refactorspaces.CfnRouteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRouteProps.Jsii$Proxy that = (CfnRouteProps.Jsii$Proxy) o;

            if (!applicationIdentifier.equals(that.applicationIdentifier)) return false;
            if (!environmentIdentifier.equals(that.environmentIdentifier)) return false;
            if (!routeType.equals(that.routeType)) return false;
            if (!serviceIdentifier.equals(that.serviceIdentifier)) return false;
            if (this.defaultRoute != null ? !this.defaultRoute.equals(that.defaultRoute) : that.defaultRoute != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.uriPathRoute != null ? this.uriPathRoute.equals(that.uriPathRoute) : that.uriPathRoute == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationIdentifier.hashCode();
            result = 31 * result + (this.environmentIdentifier.hashCode());
            result = 31 * result + (this.routeType.hashCode());
            result = 31 * result + (this.serviceIdentifier.hashCode());
            result = 31 * result + (this.defaultRoute != null ? this.defaultRoute.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.uriPathRoute != null ? this.uriPathRoute.hashCode() : 0);
            return result;
        }
    }
}
