package software.amazon.awscdk.services.route53;

/**
 * Continents for geolocation routing.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HostedZone myZone;
 * // continent
 * // continent
 * ARecord.Builder.create(this, "ARecordGeoLocationContinent")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("1.2.3.0", "5.6.7.0"))
 *         .geoLocation(GeoLocation.continent(Continent.EUROPE))
 *         .build();
 * // country
 * // country
 * ARecord.Builder.create(this, "ARecordGeoLocationCountry")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("1.2.3.1", "5.6.7.1"))
 *         .geoLocation(GeoLocation.country("DE"))
 *         .build();
 * // subdivision
 * // subdivision
 * ARecord.Builder.create(this, "ARecordGeoLocationSubDividion")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("1.2.3.2", "5.6.7.2"))
 *         .geoLocation(GeoLocation.subdivision("WA"))
 *         .build();
 * // default (wildcard record if no specific record is found)
 * // default (wildcard record if no specific record is found)
 * ARecord.Builder.create(this, "ARecordGeoLocationDefault")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("1.2.3.3", "5.6.7.3"))
 *         .geoLocation(GeoLocation.default())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:28.417Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.Continent")
public enum Continent {
    /**
     * Africa.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AFRICA,
    /**
     * Antarctica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ANTARCTICA,
    /**
     * Asia.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ASIA,
    /**
     * Europe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EUROPE,
    /**
     * Oceania.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OCEANIA,
    /**
     * North America.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NORTH_AMERICA,
    /**
     * South America.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SOUTH_AMERICA,
}
