package software.amazon.awscdk.services.route53;

/**
 * Collection of grant methods for a INamedHostedZoneRef.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * INamedHostedZoneRef namedHostedZoneRef;
 * HostedZoneGrants hostedZoneGrants = HostedZoneGrants.fromHostedZone(namedHostedZoneRef);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:28.436Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.HostedZoneGrants")
public class HostedZoneGrants extends software.amazon.jsii.JsiiObject {

    protected HostedZoneGrants(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HostedZoneGrants(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates grants for INamedHostedZoneRef.
     * <p>
     * @param hostedZone This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.HostedZoneGrants fromHostedZone(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.INamedHostedZoneRef hostedZone) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.HostedZoneGrants.class, "fromHostedZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.HostedZoneGrants.class), new Object[] { java.util.Objects.requireNonNull(hostedZone, "hostedZone is required") });
    }

    /**
     * Grant permissions to add delegation records to this zone.
     * <p>
     * @param grantee This parameter is required.
     * @param delegationOptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant delegation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.GrantDelegationOptions delegationOptions) {
        return software.amazon.jsii.Kernel.call(this, "delegation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), delegationOptions });
    }

    /**
     * Grant permissions to add delegation records to this zone.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant delegation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "delegation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }
}
