package software.amazon.awscdk.services.route53;

/**
 * Base properties of an SVCB ServiceMode record value.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * Alpn alpn;
 * SvcbRecordServiceModeProps svcbRecordServiceModeProps = SvcbRecordServiceModeProps.builder()
 *         .alpn(List.of(alpn))
 *         .ipv4hint(List.of("ipv4hint"))
 *         .ipv6hint(List.of("ipv6hint"))
 *         .mandatory(List.of("mandatory"))
 *         .noDefaultAlpn(false)
 *         .port(123)
 *         .priority(123)
 *         .targetName("targetName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:28.478Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.SvcbRecordServiceModeProps")
@software.amazon.jsii.Jsii.Proxy(SvcbRecordServiceModeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SvcbRecordServiceModeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates the set of Application-Layer Protocol Negotiation (ALPN) protocol identifiers and associated transport protocols supported by this service endpoint.
     * <p>
     * Default: - No ALPN protocol identifiers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.route53.Alpn> getAlpn() {
        return null;
    }

    /**
     * Conveys that clients may use to reach the service.
     * <p>
     * Default: - No hints.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpv4hint() {
        return null;
    }

    /**
     * Conveys that clients may use to reach the service.
     * <p>
     * Default: - No hints.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpv6hint() {
        return null;
    }

    /**
     * Indicates mandatory keys.
     * <p>
     * Default: - No mandatory keys
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMandatory() {
        return null;
    }

    /**
     * Indicates no default ALPN protocol identifiers.
     * <p>
     * The <code>alpn</code> parameter must be supplied together.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getNoDefaultAlpn() {
        return null;
    }

    /**
     * The alternative port number.
     * <p>
     * Default: - Use the default port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * The priority.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * The domain name of the alternative endpoint.
     * <p>
     * Default: '.' - The record name of the record itself
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTargetName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SvcbRecordServiceModeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SvcbRecordServiceModeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SvcbRecordServiceModeProps> {
        java.util.List<software.amazon.awscdk.services.route53.Alpn> alpn;
        java.util.List<java.lang.String> ipv4Hint;
        java.util.List<java.lang.String> ipv6Hint;
        java.util.List<java.lang.String> mandatory;
        java.lang.Boolean noDefaultAlpn;
        java.lang.Number port;
        java.lang.Number priority;
        java.lang.String targetName;

        /**
         * Sets the value of {@link SvcbRecordServiceModeProps#getAlpn}
         * @param alpn Indicates the set of Application-Layer Protocol Negotiation (ALPN) protocol identifiers and associated transport protocols supported by this service endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder alpn(java.util.List<? extends software.amazon.awscdk.services.route53.Alpn> alpn) {
            this.alpn = (java.util.List<software.amazon.awscdk.services.route53.Alpn>)alpn;
            return this;
        }

        /**
         * Sets the value of {@link SvcbRecordServiceModeProps#getIpv4Hint}
         * @param ipv4Hint Conveys that clients may use to reach the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv4Hint(java.util.List<java.lang.String> ipv4Hint) {
            this.ipv4Hint = ipv4Hint;
            return this;
        }

        /**
         * Sets the value of {@link SvcbRecordServiceModeProps#getIpv6Hint}
         * @param ipv6Hint Conveys that clients may use to reach the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Hint(java.util.List<java.lang.String> ipv6Hint) {
            this.ipv6Hint = ipv6Hint;
            return this;
        }

        /**
         * Sets the value of {@link SvcbRecordServiceModeProps#getMandatory}
         * @param mandatory Indicates mandatory keys.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mandatory(java.util.List<java.lang.String> mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        /**
         * Sets the value of {@link SvcbRecordServiceModeProps#getNoDefaultAlpn}
         * @param noDefaultAlpn Indicates no default ALPN protocol identifiers.
         *                      The <code>alpn</code> parameter must be supplied together.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder noDefaultAlpn(java.lang.Boolean noDefaultAlpn) {
            this.noDefaultAlpn = noDefaultAlpn;
            return this;
        }

        /**
         * Sets the value of {@link SvcbRecordServiceModeProps#getPort}
         * @param port The alternative port number.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link SvcbRecordServiceModeProps#getPriority}
         * @param priority The priority.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link SvcbRecordServiceModeProps#getTargetName}
         * @param targetName The domain name of the alternative endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetName(java.lang.String targetName) {
            this.targetName = targetName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SvcbRecordServiceModeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SvcbRecordServiceModeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SvcbRecordServiceModeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SvcbRecordServiceModeProps {
        private final java.util.List<software.amazon.awscdk.services.route53.Alpn> alpn;
        private final java.util.List<java.lang.String> ipv4Hint;
        private final java.util.List<java.lang.String> ipv6Hint;
        private final java.util.List<java.lang.String> mandatory;
        private final java.lang.Boolean noDefaultAlpn;
        private final java.lang.Number port;
        private final java.lang.Number priority;
        private final java.lang.String targetName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alpn = software.amazon.jsii.Kernel.get(this, "alpn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.Alpn.class)));
            this.ipv4Hint = software.amazon.jsii.Kernel.get(this, "ipv4hint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ipv6Hint = software.amazon.jsii.Kernel.get(this, "ipv6hint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.mandatory = software.amazon.jsii.Kernel.get(this, "mandatory", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.noDefaultAlpn = software.amazon.jsii.Kernel.get(this, "noDefaultAlpn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.targetName = software.amazon.jsii.Kernel.get(this, "targetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alpn = (java.util.List<software.amazon.awscdk.services.route53.Alpn>)builder.alpn;
            this.ipv4Hint = builder.ipv4Hint;
            this.ipv6Hint = builder.ipv6Hint;
            this.mandatory = builder.mandatory;
            this.noDefaultAlpn = builder.noDefaultAlpn;
            this.port = builder.port;
            this.priority = builder.priority;
            this.targetName = builder.targetName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.route53.Alpn> getAlpn() {
            return this.alpn;
        }

        @Override
        public final java.util.List<java.lang.String> getIpv4hint() {
            return this.ipv4Hint;
        }

        @Override
        public final java.util.List<java.lang.String> getIpv6hint() {
            return this.ipv6Hint;
        }

        @Override
        public final java.util.List<java.lang.String> getMandatory() {
            return this.mandatory;
        }

        @Override
        public final java.lang.Boolean getNoDefaultAlpn() {
            return this.noDefaultAlpn;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final java.lang.String getTargetName() {
            return this.targetName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAlpn() != null) {
                data.set("alpn", om.valueToTree(this.getAlpn()));
            }
            if (this.getIpv4hint() != null) {
                data.set("ipv4hint", om.valueToTree(this.getIpv4hint()));
            }
            if (this.getIpv6hint() != null) {
                data.set("ipv6hint", om.valueToTree(this.getIpv6hint()));
            }
            if (this.getMandatory() != null) {
                data.set("mandatory", om.valueToTree(this.getMandatory()));
            }
            if (this.getNoDefaultAlpn() != null) {
                data.set("noDefaultAlpn", om.valueToTree(this.getNoDefaultAlpn()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }
            if (this.getTargetName() != null) {
                data.set("targetName", om.valueToTree(this.getTargetName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.SvcbRecordServiceModeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SvcbRecordServiceModeProps.Jsii$Proxy that = (SvcbRecordServiceModeProps.Jsii$Proxy) o;

            if (this.alpn != null ? !this.alpn.equals(that.alpn) : that.alpn != null) return false;
            if (this.ipv4Hint != null ? !this.ipv4Hint.equals(that.ipv4Hint) : that.ipv4Hint != null) return false;
            if (this.ipv6Hint != null ? !this.ipv6Hint.equals(that.ipv6Hint) : that.ipv6Hint != null) return false;
            if (this.mandatory != null ? !this.mandatory.equals(that.mandatory) : that.mandatory != null) return false;
            if (this.noDefaultAlpn != null ? !this.noDefaultAlpn.equals(that.noDefaultAlpn) : that.noDefaultAlpn != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
            return this.targetName != null ? this.targetName.equals(that.targetName) : that.targetName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alpn != null ? this.alpn.hashCode() : 0;
            result = 31 * result + (this.ipv4Hint != null ? this.ipv4Hint.hashCode() : 0);
            result = 31 * result + (this.ipv6Hint != null ? this.ipv6Hint.hashCode() : 0);
            result = 31 * result + (this.mandatory != null ? this.mandatory.hashCode() : 0);
            result = 31 * result + (this.noDefaultAlpn != null ? this.noDefaultAlpn.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            result = 31 * result + (this.targetName != null ? this.targetName.hashCode() : 0);
            return result;
        }
    }
}
