package software.amazon.awscdk.services.rtbfabric;

/**
 * Properties for defining a <code>CfnInboundExternalLink</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rtbfabric.*;
 * CfnInboundExternalLinkProps cfnInboundExternalLinkProps = CfnInboundExternalLinkProps.builder()
 *         .gatewayId("gatewayId")
 *         .linkLogSettings(LinkLogSettingsProperty.builder()
 *                 .applicationLogs(ApplicationLogsProperty.builder()
 *                         .linkApplicationLogSampling(LinkApplicationLogSamplingProperty.builder()
 *                                 .errorLog(123)
 *                                 .filterLog(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .linkAttributes(LinkAttributesProperty.builder()
 *                 .customerProvidedId("customerProvidedId")
 *                 .responderErrorMasking(List.of(ResponderErrorMaskingForHttpCodeProperty.builder()
 *                         .action("action")
 *                         .httpCode("httpCode")
 *                         .loggingTypes(List.of("loggingTypes"))
 *                         // the properties below are optional
 *                         .responseLoggingPercentage(123)
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-inboundexternallink.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-inboundexternallink.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:28.575Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rtbfabric.CfnInboundExternalLinkProps")
@software.amazon.jsii.Jsii.Proxy(CfnInboundExternalLinkProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInboundExternalLinkProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-inboundexternallink.html#cfn-rtbfabric-inboundexternallink-gatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-inboundexternallink.html#cfn-rtbfabric-inboundexternallink-gatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGatewayId();

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.rtbfabric.CfnInboundExternalLink.LinkLogSettingsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-inboundexternallink.html#cfn-rtbfabric-inboundexternallink-linklogsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-inboundexternallink.html#cfn-rtbfabric-inboundexternallink-linklogsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLinkLogSettings();

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.rtbfabric.CfnInboundExternalLink.LinkAttributesProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-inboundexternallink.html#cfn-rtbfabric-inboundexternallink-linkattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-inboundexternallink.html#cfn-rtbfabric-inboundexternallink-linkattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLinkAttributes() {
        return null;
    }

    /**
     * Tags to assign to the Link.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-inboundexternallink.html#cfn-rtbfabric-inboundexternallink-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rtbfabric-inboundexternallink.html#cfn-rtbfabric-inboundexternallink-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInboundExternalLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInboundExternalLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInboundExternalLinkProps> {
        java.lang.String gatewayId;
        java.lang.Object linkLogSettings;
        java.lang.Object linkAttributes;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnInboundExternalLinkProps#getGatewayId}
         * @param gatewayId the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayId(java.lang.String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInboundExternalLinkProps#getLinkLogSettings}
         * @param linkLogSettings the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkLogSettings(software.amazon.awscdk.IResolvable linkLogSettings) {
            this.linkLogSettings = linkLogSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnInboundExternalLinkProps#getLinkLogSettings}
         * @param linkLogSettings the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkLogSettings(software.amazon.awscdk.services.rtbfabric.CfnInboundExternalLink.LinkLogSettingsProperty linkLogSettings) {
            this.linkLogSettings = linkLogSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnInboundExternalLinkProps#getLinkAttributes}
         * @param linkAttributes the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkAttributes(software.amazon.awscdk.IResolvable linkAttributes) {
            this.linkAttributes = linkAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnInboundExternalLinkProps#getLinkAttributes}
         * @param linkAttributes the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linkAttributes(software.amazon.awscdk.services.rtbfabric.CfnInboundExternalLink.LinkAttributesProperty linkAttributes) {
            this.linkAttributes = linkAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnInboundExternalLinkProps#getTags}
         * @param tags Tags to assign to the Link.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInboundExternalLinkProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInboundExternalLinkProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInboundExternalLinkProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInboundExternalLinkProps {
        private final java.lang.String gatewayId;
        private final java.lang.Object linkLogSettings;
        private final java.lang.Object linkAttributes;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.gatewayId = software.amazon.jsii.Kernel.get(this, "gatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.linkLogSettings = software.amazon.jsii.Kernel.get(this, "linkLogSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.linkAttributes = software.amazon.jsii.Kernel.get(this, "linkAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.gatewayId = java.util.Objects.requireNonNull(builder.gatewayId, "gatewayId is required");
            this.linkLogSettings = java.util.Objects.requireNonNull(builder.linkLogSettings, "linkLogSettings is required");
            this.linkAttributes = builder.linkAttributes;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final java.lang.Object getLinkLogSettings() {
            return this.linkLogSettings;
        }

        @Override
        public final java.lang.Object getLinkAttributes() {
            return this.linkAttributes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("gatewayId", om.valueToTree(this.getGatewayId()));
            data.set("linkLogSettings", om.valueToTree(this.getLinkLogSettings()));
            if (this.getLinkAttributes() != null) {
                data.set("linkAttributes", om.valueToTree(this.getLinkAttributes()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rtbfabric.CfnInboundExternalLinkProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInboundExternalLinkProps.Jsii$Proxy that = (CfnInboundExternalLinkProps.Jsii$Proxy) o;

            if (!gatewayId.equals(that.gatewayId)) return false;
            if (!linkLogSettings.equals(that.linkLogSettings)) return false;
            if (this.linkAttributes != null ? !this.linkAttributes.equals(that.linkAttributes) : that.linkAttributes != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.gatewayId.hashCode();
            result = 31 * result + (this.linkLogSettings.hashCode());
            result = 31 * result + (this.linkAttributes != null ? this.linkAttributes.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
