package software.amazon.awscdk.services.rum;

/**
 * Properties for defining a <code>CfnAppMonitor</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rum.*;
 * CfnAppMonitorProps cfnAppMonitorProps = CfnAppMonitorProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .appMonitorConfiguration(AppMonitorConfigurationProperty.builder()
 *                 .allowCookies(false)
 *                 .enableXRay(false)
 *                 .excludedPages(List.of("excludedPages"))
 *                 .favoritePages(List.of("favoritePages"))
 *                 .guestRoleArn("guestRoleArn")
 *                 .identityPoolId("identityPoolId")
 *                 .includedPages(List.of("includedPages"))
 *                 .metricDestinations(List.of(MetricDestinationProperty.builder()
 *                         .destination("destination")
 *                         // the properties below are optional
 *                         .destinationArn("destinationArn")
 *                         .iamRoleArn("iamRoleArn")
 *                         .metricDefinitions(List.of(MetricDefinitionProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .dimensionKeys(Map.of(
 *                                         "dimensionKeysKey", "dimensionKeys"))
 *                                 .eventPattern("eventPattern")
 *                                 .namespace("namespace")
 *                                 .unitLabel("unitLabel")
 *                                 .valueKey("valueKey")
 *                                 .build()))
 *                         .build()))
 *                 .sessionSampleRate(123)
 *                 .telemetries(List.of("telemetries"))
 *                 .build())
 *         .customEvents(CustomEventsProperty.builder()
 *                 .status("status")
 *                 .build())
 *         .cwLogEnabled(false)
 *         .deobfuscationConfiguration(DeobfuscationConfigurationProperty.builder()
 *                 .javaScriptSourceMaps(JavaScriptSourceMapsProperty.builder()
 *                         .status("status")
 *                         // the properties below are optional
 *                         .s3Uri("s3Uri")
 *                         .build())
 *                 .build())
 *         .domain("domain")
 *         .domainList(List.of("domainList"))
 *         .platform("platform")
 *         .resourcePolicy(ResourcePolicyProperty.builder()
 *                 .policyDocument("policyDocument")
 *                 // the properties below are optional
 *                 .policyRevisionId("policyRevisionId")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:28.617Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rum.CfnAppMonitorProps")
@software.amazon.jsii.Jsii.Proxy(CfnAppMonitorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAppMonitorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A name for the app monitor.
     * <p>
     * This parameter is required.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A structure that contains much of the configuration data for the app monitor.
     * <p>
     * If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code> , you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to AWS</a> .
     * <p>
     * If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.rum.CfnAppMonitor.AppMonitorConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-appmonitorconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-appmonitorconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAppMonitorConfiguration() {
        return null;
    }

    /**
     * Specifies whether this app monitor allows the web client to define and send custom events.
     * <p>
     * If you omit this parameter, custom events are <code>DISABLED</code> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.rum.CfnAppMonitor.CustomEventsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-customevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-customevents</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomEvents() {
        return null;
    }

    /**
     * Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
     * <p>
     * This parameter specifies whether CloudWatch RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
     * <p>
     * If you omit this parameter, the default is <code>false</code> .
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-cwlogenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-cwlogenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCwLogEnabled() {
        return null;
    }

    /**
     * A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.rum.CfnAppMonitor.DeobfuscationConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-deobfuscationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-deobfuscationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeobfuscationConfiguration() {
        return null;
    }

    /**
     * The top-level internet domain name for which your application has administrative authority.
     * <p>
     * This parameter or the <code>DomainList</code> parameter is required.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-domain</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return null;
    }

    /**
     * List the domain names for which your application has administrative authority. This parameter or the <code>Domain</code> parameter is required.
     * <p>
     * You can have a minimum of 1 and a maximum of 5 <code>Domain</code> under <code>DomainList</code> . Each <code>Domain</code> must be a minimum length of 1 and a maximum of 253 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-domainlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-domainlist</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDomainList() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-platform">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-platform</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlatform() {
        return null;
    }

    /**
     * Use this structure to assign a resource-based policy to a CloudWatch RUM app monitor to control access to it.
     * <p>
     * Each app monitor can have one resource-based policy. The maximum size of the policy is 4 KB. To learn more about using resource policies with RUM, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html">Using resource-based policies with CloudWatch RUM</a> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.rum.CfnAppMonitor.ResourcePolicyProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-resourcepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-resourcepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResourcePolicy() {
        return null;
    }

    /**
     * Assigns one or more tags (key-value pairs) to the app monitor.
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * <p>
     * You can associate as many as 50 tags with an app monitor.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAppMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAppMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAppMonitorProps> {
        java.lang.String name;
        java.lang.Object appMonitorConfiguration;
        java.lang.Object customEvents;
        java.lang.Object cwLogEnabled;
        java.lang.Object deobfuscationConfiguration;
        java.lang.String domain;
        java.util.List<java.lang.String> domainList;
        java.lang.String platform;
        java.lang.Object resourcePolicy;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAppMonitorProps#getName}
         * @param name A name for the app monitor. This parameter is required.
         *             This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getAppMonitorConfiguration}
         * @param appMonitorConfiguration A structure that contains much of the configuration data for the app monitor.
         *                                If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code> , you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to AWS</a> .
         *                                <p>
         *                                If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appMonitorConfiguration(software.amazon.awscdk.IResolvable appMonitorConfiguration) {
            this.appMonitorConfiguration = appMonitorConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getAppMonitorConfiguration}
         * @param appMonitorConfiguration A structure that contains much of the configuration data for the app monitor.
         *                                If you are using Amazon Cognito for authorization, you must include this structure in your request, and it must include the ID of the Amazon Cognito identity pool to use for authorization. If you don't include <code>AppMonitorConfiguration</code> , you must set up your own authorization method. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-get-started-authorization.html">Authorize your application to send data to AWS</a> .
         *                                <p>
         *                                If you omit this argument, the sample rate used for CloudWatch RUM is set to 10% of the user sessions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appMonitorConfiguration(software.amazon.awscdk.services.rum.CfnAppMonitor.AppMonitorConfigurationProperty appMonitorConfiguration) {
            this.appMonitorConfiguration = appMonitorConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getCustomEvents}
         * @param customEvents Specifies whether this app monitor allows the web client to define and send custom events.
         *                     If you omit this parameter, custom events are <code>DISABLED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customEvents(software.amazon.awscdk.IResolvable customEvents) {
            this.customEvents = customEvents;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getCustomEvents}
         * @param customEvents Specifies whether this app monitor allows the web client to define and send custom events.
         *                     If you omit this parameter, custom events are <code>DISABLED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customEvents(software.amazon.awscdk.services.rum.CfnAppMonitor.CustomEventsProperty customEvents) {
            this.customEvents = customEvents;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getCwLogEnabled}
         * @param cwLogEnabled Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
         *                     This parameter specifies whether CloudWatch RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
         *                     <p>
         *                     If you omit this parameter, the default is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cwLogEnabled(java.lang.Boolean cwLogEnabled) {
            this.cwLogEnabled = cwLogEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getCwLogEnabled}
         * @param cwLogEnabled Data collected by CloudWatch RUM is kept by RUM for 30 days and then deleted.
         *                     This parameter specifies whether CloudWatch RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges.
         *                     <p>
         *                     If you omit this parameter, the default is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cwLogEnabled(software.amazon.awscdk.IResolvable cwLogEnabled) {
            this.cwLogEnabled = cwLogEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getDeobfuscationConfiguration}
         * @param deobfuscationConfiguration A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deobfuscationConfiguration(software.amazon.awscdk.IResolvable deobfuscationConfiguration) {
            this.deobfuscationConfiguration = deobfuscationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getDeobfuscationConfiguration}
         * @param deobfuscationConfiguration A structure that contains the configuration for how an app monitor can deobfuscate stack traces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deobfuscationConfiguration(software.amazon.awscdk.services.rum.CfnAppMonitor.DeobfuscationConfigurationProperty deobfuscationConfiguration) {
            this.deobfuscationConfiguration = deobfuscationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getDomain}
         * @param domain The top-level internet domain name for which your application has administrative authority.
         *               This parameter or the <code>DomainList</code> parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getDomainList}
         * @param domainList List the domain names for which your application has administrative authority. This parameter or the <code>Domain</code> parameter is required.
         *                   You can have a minimum of 1 and a maximum of 5 <code>Domain</code> under <code>DomainList</code> . Each <code>Domain</code> must be a minimum length of 1 and a maximum of 253 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainList(java.util.List<java.lang.String> domainList) {
            this.domainList = domainList;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getPlatform}
         * @param platform the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platform(java.lang.String platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getResourcePolicy}
         * @param resourcePolicy Use this structure to assign a resource-based policy to a CloudWatch RUM app monitor to control access to it.
         *                       Each app monitor can have one resource-based policy. The maximum size of the policy is 4 KB. To learn more about using resource policies with RUM, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html">Using resource-based policies with CloudWatch RUM</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePolicy(software.amazon.awscdk.IResolvable resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getResourcePolicy}
         * @param resourcePolicy Use this structure to assign a resource-based policy to a CloudWatch RUM app monitor to control access to it.
         *                       Each app monitor can have one resource-based policy. The maximum size of the policy is 4 KB. To learn more about using resource policies with RUM, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-resource-policies.html">Using resource-based policies with CloudWatch RUM</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePolicy(software.amazon.awscdk.services.rum.CfnAppMonitor.ResourcePolicyProperty resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppMonitorProps#getTags}
         * @param tags Assigns one or more tags (key-value pairs) to the app monitor.
         *             Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         *             <p>
         *             Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
         *             <p>
         *             You can associate as many as 50 tags with an app monitor.
         *             <p>
         *             For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAppMonitorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAppMonitorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAppMonitorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAppMonitorProps {
        private final java.lang.String name;
        private final java.lang.Object appMonitorConfiguration;
        private final java.lang.Object customEvents;
        private final java.lang.Object cwLogEnabled;
        private final java.lang.Object deobfuscationConfiguration;
        private final java.lang.String domain;
        private final java.util.List<java.lang.String> domainList;
        private final java.lang.String platform;
        private final java.lang.Object resourcePolicy;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.appMonitorConfiguration = software.amazon.jsii.Kernel.get(this, "appMonitorConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customEvents = software.amazon.jsii.Kernel.get(this, "customEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cwLogEnabled = software.amazon.jsii.Kernel.get(this, "cwLogEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deobfuscationConfiguration = software.amazon.jsii.Kernel.get(this, "deobfuscationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainList = software.amazon.jsii.Kernel.get(this, "domainList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourcePolicy = software.amazon.jsii.Kernel.get(this, "resourcePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.appMonitorConfiguration = builder.appMonitorConfiguration;
            this.customEvents = builder.customEvents;
            this.cwLogEnabled = builder.cwLogEnabled;
            this.deobfuscationConfiguration = builder.deobfuscationConfiguration;
            this.domain = builder.domain;
            this.domainList = builder.domainList;
            this.platform = builder.platform;
            this.resourcePolicy = builder.resourcePolicy;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getAppMonitorConfiguration() {
            return this.appMonitorConfiguration;
        }

        @Override
        public final java.lang.Object getCustomEvents() {
            return this.customEvents;
        }

        @Override
        public final java.lang.Object getCwLogEnabled() {
            return this.cwLogEnabled;
        }

        @Override
        public final java.lang.Object getDeobfuscationConfiguration() {
            return this.deobfuscationConfiguration;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final java.util.List<java.lang.String> getDomainList() {
            return this.domainList;
        }

        @Override
        public final java.lang.String getPlatform() {
            return this.platform;
        }

        @Override
        public final java.lang.Object getResourcePolicy() {
            return this.resourcePolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getAppMonitorConfiguration() != null) {
                data.set("appMonitorConfiguration", om.valueToTree(this.getAppMonitorConfiguration()));
            }
            if (this.getCustomEvents() != null) {
                data.set("customEvents", om.valueToTree(this.getCustomEvents()));
            }
            if (this.getCwLogEnabled() != null) {
                data.set("cwLogEnabled", om.valueToTree(this.getCwLogEnabled()));
            }
            if (this.getDeobfuscationConfiguration() != null) {
                data.set("deobfuscationConfiguration", om.valueToTree(this.getDeobfuscationConfiguration()));
            }
            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getDomainList() != null) {
                data.set("domainList", om.valueToTree(this.getDomainList()));
            }
            if (this.getPlatform() != null) {
                data.set("platform", om.valueToTree(this.getPlatform()));
            }
            if (this.getResourcePolicy() != null) {
                data.set("resourcePolicy", om.valueToTree(this.getResourcePolicy()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rum.CfnAppMonitorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAppMonitorProps.Jsii$Proxy that = (CfnAppMonitorProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.appMonitorConfiguration != null ? !this.appMonitorConfiguration.equals(that.appMonitorConfiguration) : that.appMonitorConfiguration != null) return false;
            if (this.customEvents != null ? !this.customEvents.equals(that.customEvents) : that.customEvents != null) return false;
            if (this.cwLogEnabled != null ? !this.cwLogEnabled.equals(that.cwLogEnabled) : that.cwLogEnabled != null) return false;
            if (this.deobfuscationConfiguration != null ? !this.deobfuscationConfiguration.equals(that.deobfuscationConfiguration) : that.deobfuscationConfiguration != null) return false;
            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.domainList != null ? !this.domainList.equals(that.domainList) : that.domainList != null) return false;
            if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) return false;
            if (this.resourcePolicy != null ? !this.resourcePolicy.equals(that.resourcePolicy) : that.resourcePolicy != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.appMonitorConfiguration != null ? this.appMonitorConfiguration.hashCode() : 0);
            result = 31 * result + (this.customEvents != null ? this.customEvents.hashCode() : 0);
            result = 31 * result + (this.cwLogEnabled != null ? this.cwLogEnabled.hashCode() : 0);
            result = 31 * result + (this.deobfuscationConfiguration != null ? this.deobfuscationConfiguration.hashCode() : 0);
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.domainList != null ? this.domainList.hashCode() : 0);
            result = 31 * result + (this.platform != null ? this.platform.hashCode() : 0);
            result = 31 * result + (this.resourcePolicy != null ? this.resourcePolicy.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
