package software.amazon.awscdk.services.s3;

/**
 * Collection of grant methods for a Bucket.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:28.656Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.BucketGrants")
public class BucketGrants extends software.amazon.jsii.JsiiObject {

    protected BucketGrants(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BucketGrants(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant delete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
        return software.amazon.jsii.Kernel.call(this, "delete", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), objectsKeyPattern });
    }

    /**
     * Grants s3:DeleteObject* permission to an IAM principal for objects in this bucket.
     * <p>
     * @param grantee The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant delete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "delete", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Allows unrestricted access to objects from this bucket.
     * <p>
     * IMPORTANT: This permission allows anyone to perform actions on S3 objects
     * in this bucket, which is useful for when you configure your bucket as a
     * website and want everyone to be able to read objects in the bucket without
     * needing to authenticate.
     * <p>
     * Without arguments, this method will grant read ("s3:GetObject") access to
     * all objects ("*") in the bucket.
     * <p>
     * The method returns the <code>iam.Grant</code> object, which can then be modified
     * as needed. For example, you can add a condition that will restrict access only
     * to an IPv4 range like this:
     * <p>
     * <blockquote><pre>
     * const grant = bucket.grantPublicAccess();
     * grant.resourceStatement!.addCondition(‘IpAddress’, { “aws:SourceIp”: “54.240.143.0/24” });
     * </pre></blockquote>
     * <p>
     * Note that if this <code>IBucket</code> refers to an existing bucket, possibly not
     * managed by CloudFormation, this method will have no effect, since it's
     * impossible to modify the policy of an existing bucket.
     * <p>
     * @param keyPrefix the prefix of S3 object keys (e.g. <code>home/*</code>). Default is "*".
     * @param allowedActions the set of S3 actions to allow. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant publicAccess(final @org.jetbrains.annotations.Nullable java.lang.String keyPrefix, final @org.jetbrains.annotations.NotNull java.lang.String... allowedActions) {
        return software.amazon.jsii.Kernel.call(this, "publicAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { keyPrefix }), java.util.Arrays.<Object>stream(allowedActions)).toArray(Object[]::new));
    }

    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * <p>
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant put(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
        return software.amazon.jsii.Kernel.call(this, "put", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grants s3:PutObject* and s3:Abort* permissions for this bucket to an IAM principal.
     * <p>
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant put(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "put", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grants s3:PutObjectAcl and s3:PutObjectVersionAcl permissions for this bucket to an IAM principal.
     * <p>
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant putAcl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.String objectsKeyPattern) {
        return software.amazon.jsii.Kernel.call(this, "putAcl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grants s3:PutObjectAcl and s3:PutObjectVersionAcl permissions for this bucket to an IAM principal.
     * <p>
     * If encryption is used, permission to use the key to encrypt the contents
     * of written files will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant putAcl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "putAcl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant read(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
        return software.amazon.jsii.Kernel.call(this, "read", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grant read permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant read(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "read", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant read and write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant readWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
        return software.amazon.jsii.Kernel.call(this, "readWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grant read and write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant readWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "readWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Grant replication permission to a principal. This method allows the principal to perform replication operations on this bucket.
     * <p>
     * Note that when calling this function for source or destination buckets that support KMS encryption,
     * you need to specify the KMS key for encryption and the KMS key for decryption, respectively.
     * <p>
     * @param identity The principal to grant replication permission to. This parameter is required.
     * @param props The properties of the replication source and destination buckets. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant replicationPermission(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.GrantReplicationPermissionProps props) {
        return software.amazon.jsii.Kernel.call(this, "replicationPermission", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Grant write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     * @param allowedActionPatterns
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant write(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> allowedActionPatterns) {
        return software.amazon.jsii.Kernel.call(this, "write", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern, allowedActionPatterns });
    }

    /**
     * Grant write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     * @param objectsKeyPattern Restrict the permission to a certain key pattern (default '*').
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant write(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.Nullable java.lang.Object objectsKeyPattern) {
        return software.amazon.jsii.Kernel.call(this, "write", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), objectsKeyPattern });
    }

    /**
     * Grant write permissions for this bucket and it's contents to an IAM principal (Role/Group/User).
     * <p>
     * If encryption is used, permission to use the key to decrypt the contents
     * of the bucket will also be granted to the same principal.
     * <p>
     * @param identity The principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant write(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "write", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }
}
