package software.amazon.awscdk.services.s3.deployment;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function myLambdaFunction;
 * Bucket destinationBucket;
 * //(Optional) if provided, the resulting processed file would be uploaded to the destinationBucket under the destinationKey name.
 * String destinationKey;
 * Role role;
 * DeployTimeSubstitutedFile.Builder.create(this, "MyFile")
 *         .source("my-file.yaml")
 *         .destinationKey(destinationKey)
 *         .destinationBucket(destinationBucket)
 *         .substitutions(Map.of(
 *                 "variableName", myLambdaFunction.getFunctionName()))
 *         .role(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:28.850Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_deployment.DeployTimeSubstitutedFileProps")
@software.amazon.jsii.Jsii.Proxy(DeployTimeSubstitutedFileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeployTimeSubstitutedFileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The S3 bucket to sync the contents of the zip file to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getDestinationBucket();

    /**
     * Path to the user's local file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSource();

    /**
     * User-defined substitutions to make in the file.
     * <p>
     * Placeholders in the user's local file must be specified with double curly
     * brackets and spaces. For example, if you use the key 'xxxx' in the file,
     * it must be written as: {{ xxxx }} to be recognized by the construct as a
     * substitution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getSubstitutions();

    /**
     * The object key in the destination bucket where the processed file would be written to.
     * <p>
     * Default: - Fingerprint of the file content would be used as object key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationKey() {
        return null;
    }

    /**
     * Execution role associated with this function.
     * <p>
     * Default: - A role is automatically created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DeployTimeSubstitutedFileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeployTimeSubstitutedFileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeployTimeSubstitutedFileProps> {
        software.amazon.awscdk.services.s3.IBucket destinationBucket;
        java.lang.String source;
        java.util.Map<java.lang.String, java.lang.String> substitutions;
        java.lang.String destinationKey;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link DeployTimeSubstitutedFileProps#getDestinationBucket}
         * @param destinationBucket The S3 bucket to sync the contents of the zip file to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationBucket(software.amazon.awscdk.services.s3.IBucket destinationBucket) {
            this.destinationBucket = destinationBucket;
            return this;
        }

        /**
         * Sets the value of {@link DeployTimeSubstitutedFileProps#getSource}
         * @param source Path to the user's local file. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link DeployTimeSubstitutedFileProps#getSubstitutions}
         * @param substitutions User-defined substitutions to make in the file. This parameter is required.
         *                      Placeholders in the user's local file must be specified with double curly
         *                      brackets and spaces. For example, if you use the key 'xxxx' in the file,
         *                      it must be written as: {{ xxxx }} to be recognized by the construct as a
         *                      substitution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder substitutions(java.util.Map<java.lang.String, java.lang.String> substitutions) {
            this.substitutions = substitutions;
            return this;
        }

        /**
         * Sets the value of {@link DeployTimeSubstitutedFileProps#getDestinationKey}
         * @param destinationKey The object key in the destination bucket where the processed file would be written to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationKey(java.lang.String destinationKey) {
            this.destinationKey = destinationKey;
            return this;
        }

        /**
         * Sets the value of {@link DeployTimeSubstitutedFileProps#getRole}
         * @param role Execution role associated with this function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeployTimeSubstitutedFileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeployTimeSubstitutedFileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeployTimeSubstitutedFileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeployTimeSubstitutedFileProps {
        private final software.amazon.awscdk.services.s3.IBucket destinationBucket;
        private final java.lang.String source;
        private final java.util.Map<java.lang.String, java.lang.String> substitutions;
        private final java.lang.String destinationKey;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationBucket = software.amazon.jsii.Kernel.get(this, "destinationBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.substitutions = software.amazon.jsii.Kernel.get(this, "substitutions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.destinationKey = software.amazon.jsii.Kernel.get(this, "destinationKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationBucket = java.util.Objects.requireNonNull(builder.destinationBucket, "destinationBucket is required");
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.substitutions = java.util.Objects.requireNonNull(builder.substitutions, "substitutions is required");
            this.destinationKey = builder.destinationKey;
            this.role = builder.role;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getDestinationBucket() {
            return this.destinationBucket;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final java.lang.String getDestinationKey() {
            return this.destinationKey;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationBucket", om.valueToTree(this.getDestinationBucket()));
            data.set("source", om.valueToTree(this.getSource()));
            data.set("substitutions", om.valueToTree(this.getSubstitutions()));
            if (this.getDestinationKey() != null) {
                data.set("destinationKey", om.valueToTree(this.getDestinationKey()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3_deployment.DeployTimeSubstitutedFileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeployTimeSubstitutedFileProps.Jsii$Proxy that = (DeployTimeSubstitutedFileProps.Jsii$Proxy) o;

            if (!destinationBucket.equals(that.destinationBucket)) return false;
            if (!source.equals(that.source)) return false;
            if (!substitutions.equals(that.substitutions)) return false;
            if (this.destinationKey != null ? !this.destinationKey.equals(that.destinationKey) : that.destinationKey != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinationBucket.hashCode();
            result = 31 * result + (this.source.hashCode());
            result = 31 * result + (this.substitutions.hashCode());
            result = 31 * result + (this.destinationKey != null ? this.destinationKey.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
