package software.amazon.awscdk.services.s3express;

/**
 * Properties for defining a <code>CfnAccessPoint</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3express.*;
 * Object policy;
 * CfnAccessPointProps cfnAccessPointProps = CfnAccessPointProps.builder()
 *         .bucket("bucket")
 *         // the properties below are optional
 *         .bucketAccountId("bucketAccountId")
 *         .name("name")
 *         .policy(policy)
 *         .publicAccessBlockConfiguration(PublicAccessBlockConfigurationProperty.builder()
 *                 .blockPublicAcls(false)
 *                 .blockPublicPolicy(false)
 *                 .ignorePublicAcls(false)
 *                 .restrictPublicBuckets(false)
 *                 .build())
 *         .scope(ScopeProperty.builder()
 *                 .permissions(List.of("permissions"))
 *                 .prefixes(List.of("prefixes"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcConfiguration(VpcConfigurationProperty.builder()
 *                 .vpcId("vpcId")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:28.860Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3express.CfnAccessPointProps")
@software.amazon.jsii.Jsii.Proxy(CfnAccessPointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAccessPointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the bucket that you want to associate the access point with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-bucket</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucket();

    /**
     * The AWS account ID that owns the bucket associated with this access point.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-bucketaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-bucketaccountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketAccountId() {
        return null;
    }

    /**
     * An access point name consists of a base name you provide, followed by the zoneID ( AWS Local Zone) followed by the prefix <code>--xa-s3</code> .
     * <p>
     * For example, accesspointname--zoneID--xa-s3.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The access point policy associated with the specified access point.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-policy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-policy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicy() {
        return null;
    }

    /**
     * Public access is blocked by default to access points for directory buckets.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.s3express.CfnAccessPoint.PublicAccessBlockConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-publicaccessblockconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-publicaccessblockconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPublicAccessBlockConfiguration() {
        return null;
    }

    /**
     * You can use the access point scope to restrict access to specific prefixes, API operations, or a combination of both.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-directory-buckets-manage-scope.html">Manage the scope of your access points for directory buckets.</a>
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.s3express.CfnAccessPoint.ScopeProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-scope</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScope() {
        return null;
    }

    /**
     * An array of tags that you can apply to access points.
     * <p>
     * Tags are key-value pairs of metadata used to categorize your access points and control access. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/tagging.html#using-tags-for-abac">Using tags for attribute-based access control (ABAC)</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.s3express.CfnAccessPoint.VpcConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-vpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-accesspoint.html#cfn-s3express-accesspoint-vpcconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAccessPointProps> {
        java.lang.String bucket;
        java.lang.String bucketAccountId;
        java.lang.String name;
        java.lang.Object policy;
        java.lang.Object publicAccessBlockConfiguration;
        java.lang.Object scope;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object vpcConfiguration;

        /**
         * Sets the value of {@link CfnAccessPointProps#getBucket}
         * @param bucket The name of the bucket that you want to associate the access point with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(java.lang.String bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getBucketAccountId}
         * @param bucketAccountId The AWS account ID that owns the bucket associated with this access point.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketAccountId(java.lang.String bucketAccountId) {
            this.bucketAccountId = bucketAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getName}
         * @param name An access point name consists of a base name you provide, followed by the zoneID ( AWS Local Zone) followed by the prefix <code>--xa-s3</code> .
         *             For example, accesspointname--zoneID--xa-s3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getPolicy}
         * @param policy The access point policy associated with the specified access point.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(java.lang.Object policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getPublicAccessBlockConfiguration}
         * @param publicAccessBlockConfiguration Public access is blocked by default to access points for directory buckets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(software.amazon.awscdk.IResolvable publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getPublicAccessBlockConfiguration}
         * @param publicAccessBlockConfiguration Public access is blocked by default to access points for directory buckets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(software.amazon.awscdk.services.s3express.CfnAccessPoint.PublicAccessBlockConfigurationProperty publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getScope}
         * @param scope You can use the access point scope to restrict access to specific prefixes, API operations, or a combination of both.
         *              For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-directory-buckets-manage-scope.html">Manage the scope of your access points for directory buckets.</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(software.amazon.awscdk.IResolvable scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getScope}
         * @param scope You can use the access point scope to restrict access to specific prefixes, API operations, or a combination of both.
         *              For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-directory-buckets-manage-scope.html">Manage the scope of your access points for directory buckets.</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(software.amazon.awscdk.services.s3express.CfnAccessPoint.ScopeProperty scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getTags}
         * @param tags An array of tags that you can apply to access points.
         *             Tags are key-value pairs of metadata used to categorize your access points and control access. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/tagging.html#using-tags-for-abac">Using tags for attribute-based access control (ABAC)</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getVpcConfiguration}
         * @param vpcConfiguration If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getVpcConfiguration}
         * @param vpcConfiguration If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(software.amazon.awscdk.services.s3express.CfnAccessPoint.VpcConfigurationProperty vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAccessPointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAccessPointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAccessPointProps {
        private final java.lang.String bucket;
        private final java.lang.String bucketAccountId;
        private final java.lang.String name;
        private final java.lang.Object policy;
        private final java.lang.Object publicAccessBlockConfiguration;
        private final java.lang.Object scope;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object vpcConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketAccountId = software.amazon.jsii.Kernel.get(this, "bucketAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.publicAccessBlockConfiguration = software.amazon.jsii.Kernel.get(this, "publicAccessBlockConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.bucketAccountId = builder.bucketAccountId;
            this.name = builder.name;
            this.policy = builder.policy;
            this.publicAccessBlockConfiguration = builder.publicAccessBlockConfiguration;
            this.scope = builder.scope;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpcConfiguration = builder.vpcConfiguration;
        }

        @Override
        public final java.lang.String getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.String getBucketAccountId() {
            return this.bucketAccountId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getPolicy() {
            return this.policy;
        }

        @Override
        public final java.lang.Object getPublicAccessBlockConfiguration() {
            return this.publicAccessBlockConfiguration;
        }

        @Override
        public final java.lang.Object getScope() {
            return this.scope;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVpcConfiguration() {
            return this.vpcConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            if (this.getBucketAccountId() != null) {
                data.set("bucketAccountId", om.valueToTree(this.getBucketAccountId()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getPublicAccessBlockConfiguration() != null) {
                data.set("publicAccessBlockConfiguration", om.valueToTree(this.getPublicAccessBlockConfiguration()));
            }
            if (this.getScope() != null) {
                data.set("scope", om.valueToTree(this.getScope()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcConfiguration() != null) {
                data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3express.CfnAccessPointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAccessPointProps.Jsii$Proxy that = (CfnAccessPointProps.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            if (this.bucketAccountId != null ? !this.bucketAccountId.equals(that.bucketAccountId) : that.bucketAccountId != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.publicAccessBlockConfiguration != null ? !this.publicAccessBlockConfiguration.equals(that.publicAccessBlockConfiguration) : that.publicAccessBlockConfiguration != null) return false;
            if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.bucketAccountId != null ? this.bucketAccountId.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.publicAccessBlockConfiguration != null ? this.publicAccessBlockConfiguration.hashCode() : 0);
            result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
            return result;
        }
    }
}
