package software.amazon.awscdk.services.s3express;

/**
 * The <code>AWS::S3Express::DirectoryBucket</code> resource defines an Amazon S3 directory bucket in the same AWS Region where you create the AWS CloudFormation stack.
 * <p>
 * To control how AWS CloudFormation handles the bucket when the stack is deleted, you can set a deletion policy for your bucket. You can choose to <em>retain</em> the bucket or to <em>delete</em> the bucket. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html">DeletionPolicy attribute</a> .
 * <p>
 * <blockquote>
 * <p>
 * You can only delete empty buckets. Deletion fails for buckets that have contents.
 * <p>
 * </blockquote>
 * <p>
 * <ul>
 * <li><strong>Permissions</strong> - The required permissions for CloudFormation to use are based on the operations that are performed on the stack.</li>
 * <li>Create</li>
 * <li>s3express:CreateBucket</li>
 * <li>s3express:ListAllMyDirectoryBuckets</li>
 * <li>Read</li>
 * <li>s3express:ListAllMyDirectoryBuckets</li>
 * <li>ec2:DescribeAvailabilityZones</li>
 * <li>Delete</li>
 * <li>s3express:DeleteBucket</li>
 * <li>s3express:ListAllMyDirectoryBuckets</li>
 * <li>List</li>
 * <li>s3express:ListAllMyDirectoryBuckets</li>
 * <li>PutBucketEncryption</li>
 * <li>s3express:PutEncryptionConfiguration</li>
 * <li>To set a directory bucket default encryption with SSE-KMS, you must also have the kms:GenerateDataKey and kms:Decrypt permissions in IAM identity-based policies and AWS KMS key policies for the target AWS KMS key.</li>
 * <li>GetBucketEncryption</li>
 * <li>s3express:GetBucketEncryption</li>
 * <li>DeleteBucketEncryption</li>
 * <li>s3express:PutEncryptionConfiguration</li>
 * </ul>
 * <p>
 * The following operations are related to <code>AWS::S3Express::DirectoryBucket</code> :
 * <p>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html">CreateBucket</a></li>
 * <li><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListDirectoryBuckets.html">ListDirectoryBuckets</a></li>
 * <li><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html">DeleteBucket</a></li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3express.*;
 * CfnDirectoryBucket cfnDirectoryBucket = CfnDirectoryBucket.Builder.create(this, "MyCfnDirectoryBucket")
 *         .dataRedundancy("dataRedundancy")
 *         .locationName("locationName")
 *         // the properties below are optional
 *         .bucketEncryption(BucketEncryptionProperty.builder()
 *                 .serverSideEncryptionConfiguration(List.of(ServerSideEncryptionRuleProperty.builder()
 *                         .bucketKeyEnabled(false)
 *                         .serverSideEncryptionByDefault(ServerSideEncryptionByDefaultProperty.builder()
 *                                 .sseAlgorithm("sseAlgorithm")
 *                                 // the properties below are optional
 *                                 .kmsMasterKeyId("kmsMasterKeyId")
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .bucketName("bucketName")
 *         .lifecycleConfiguration(LifecycleConfigurationProperty.builder()
 *                 .rules(List.of(RuleProperty.builder()
 *                         .status("status")
 *                         // the properties below are optional
 *                         .abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty.builder()
 *                                 .daysAfterInitiation(123)
 *                                 .build())
 *                         .expirationInDays(123)
 *                         .id("id")
 *                         .objectSizeGreaterThan("objectSizeGreaterThan")
 *                         .objectSizeLessThan("objectSizeLessThan")
 *                         .prefix("prefix")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:28.863Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3express.CfnDirectoryBucket")
public class CfnDirectoryBucket extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.s3express.IDirectoryBucketRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnDirectoryBucket(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDirectoryBucket(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3express.CfnDirectoryBucket.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::S3Express::DirectoryBucket</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDirectoryBucket(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3express.CfnDirectoryBucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForDirectoryBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.s3express.IDirectoryBucketRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3express.CfnDirectoryBucket.class, "arnForDirectoryBucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Creates a new IDirectoryBucketRef from a bucketName.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param bucketName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.s3express.IDirectoryBucketRef fromBucketName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String bucketName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3express.CfnDirectoryBucket.class, "fromBucketName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.s3express.IDirectoryBucketRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(bucketName, "bucketName is required") });
    }

    /**
     * Creates a new IDirectoryBucketRef from an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.s3express.IDirectoryBucketRef fromDirectoryBucketArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3express.CfnDirectoryBucket.class, "fromDirectoryBucketArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.s3express.IDirectoryBucketRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Checks whether the given object is a CfnDirectoryBucket.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnDirectoryBucket(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3express.CfnDirectoryBucket.class, "isCfnDirectoryBucket", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) of the specified bucket.
     * <p>
     * Example: <code>arn:aws:s3express: *us-west-2* : *account_id* :bucket/ *bucket_base_name* -- *usw2-az1* --x-s3</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the code for the Availability Zone or the Local Zone where the directory bucket was created.
     * <p>
     * Example value for an Availability Zone code: <em>us-east-1f</em>
     * <p>
     * <blockquote>
     * <p>
     * An Availability Zone code might not represent the same physical location for different AWS accounts. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-Endpoints.html">Availability Zones and Regions</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAvailabilityZoneName() {
        return software.amazon.jsii.Kernel.get(this, "attrAvailabilityZoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a DirectoryBucket resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.s3express.DirectoryBucketReference getDirectoryBucketRef() {
        return software.amazon.jsii.Kernel.get(this, "directoryBucketRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.s3express.DirectoryBucketReference.class));
    }

    /**
     * The number of Zone (Availability Zone or Local Zone) that's used for redundancy for the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDataRedundancy() {
        return software.amazon.jsii.Kernel.get(this, "dataRedundancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of Zone (Availability Zone or Local Zone) that's used for redundancy for the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataRedundancy(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataRedundancy", java.util.Objects.requireNonNull(value, "dataRedundancy is required"));
    }

    /**
     * The name of the location where the bucket will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLocationName() {
        return software.amazon.jsii.Kernel.get(this, "locationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the location where the bucket will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocationName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "locationName", java.util.Objects.requireNonNull(value, "locationName is required"));
    }

    /**
     * Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS).
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.s3express.CfnDirectoryBucket.BucketEncryptionProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBucketEncryption() {
        return software.amazon.jsii.Kernel.get(this, "bucketEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bucketEncryption", value);
    }

    /**
     * Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3express.CfnDirectoryBucket.BucketEncryptionProperty value) {
        software.amazon.jsii.Kernel.set(this, "bucketEncryption", value);
    }

    /**
     * A name for the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
        return software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "bucketName", value);
    }

    /**
     * Container for lifecycle rules.
     * <p>
     * You can add as many as 1000 rules.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.s3express.CfnDirectoryBucket.LifecycleConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLifecycleConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "lifecycleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Container for lifecycle rules.
     * <p>
     * You can add as many as 1000 rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecycleConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lifecycleConfiguration", value);
    }

    /**
     * Container for lifecycle rules.
     * <p>
     * You can add as many as 1000 rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecycleConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3express.CfnDirectoryBucket.LifecycleConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "lifecycleConfiguration", value);
    }

    /**
     * An array of tags that you can apply to the S3 directory bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of tags that you can apply to the S3 directory bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Configuration</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3express.*;
     * AbortIncompleteMultipartUploadProperty abortIncompleteMultipartUploadProperty = AbortIncompleteMultipartUploadProperty.builder()
     *         .daysAfterInitiation(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-abortincompletemultipartupload.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-abortincompletemultipartupload.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3express.CfnDirectoryBucket.AbortIncompleteMultipartUploadProperty")
    @software.amazon.jsii.Jsii.Proxy(AbortIncompleteMultipartUploadProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AbortIncompleteMultipartUploadProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-abortincompletemultipartupload.html#cfn-s3express-directorybucket-abortincompletemultipartupload-daysafterinitiation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-abortincompletemultipartupload.html#cfn-s3express-directorybucket-abortincompletemultipartupload-daysafterinitiation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDaysAfterInitiation();

        /**
         * @return a {@link Builder} of {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AbortIncompleteMultipartUploadProperty> {
            java.lang.Number daysAfterInitiation;

            /**
             * Sets the value of {@link AbortIncompleteMultipartUploadProperty#getDaysAfterInitiation}
             * @param daysAfterInitiation Specifies the number of days after which Amazon S3 aborts an incomplete multipart upload. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder daysAfterInitiation(java.lang.Number daysAfterInitiation) {
                this.daysAfterInitiation = daysAfterInitiation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AbortIncompleteMultipartUploadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AbortIncompleteMultipartUploadProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AbortIncompleteMultipartUploadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AbortIncompleteMultipartUploadProperty {
            private final java.lang.Number daysAfterInitiation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.daysAfterInitiation = software.amazon.jsii.Kernel.get(this, "daysAfterInitiation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.daysAfterInitiation = java.util.Objects.requireNonNull(builder.daysAfterInitiation, "daysAfterInitiation is required");
            }

            @Override
            public final java.lang.Number getDaysAfterInitiation() {
                return this.daysAfterInitiation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("daysAfterInitiation", om.valueToTree(this.getDaysAfterInitiation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3express.CfnDirectoryBucket.AbortIncompleteMultipartUploadProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AbortIncompleteMultipartUploadProperty.Jsii$Proxy that = (AbortIncompleteMultipartUploadProperty.Jsii$Proxy) o;

                return this.daysAfterInitiation.equals(that.daysAfterInitiation);
            }

            @Override
            public final int hashCode() {
                int result = this.daysAfterInitiation.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS).
     * <p>
     * For information about default encryption for directory buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-bucket-encryption.html">Setting and monitoring default encryption for directory buckets</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3express.*;
     * BucketEncryptionProperty bucketEncryptionProperty = BucketEncryptionProperty.builder()
     *         .serverSideEncryptionConfiguration(List.of(ServerSideEncryptionRuleProperty.builder()
     *                 .bucketKeyEnabled(false)
     *                 .serverSideEncryptionByDefault(ServerSideEncryptionByDefaultProperty.builder()
     *                         .sseAlgorithm("sseAlgorithm")
     *                         // the properties below are optional
     *                         .kmsMasterKeyId("kmsMasterKeyId")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-bucketencryption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-bucketencryption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3express.CfnDirectoryBucket.BucketEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(BucketEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BucketEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the default server-side-encryption configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.s3express.CfnDirectoryBucket.ServerSideEncryptionRuleProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-bucketencryption.html#cfn-s3express-directorybucket-bucketencryption-serversideencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-bucketencryption.html#cfn-s3express-directorybucket-bucketencryption-serversideencryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getServerSideEncryptionConfiguration();

        /**
         * @return a {@link Builder} of {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BucketEncryptionProperty> {
            java.lang.Object serverSideEncryptionConfiguration;

            /**
             * Sets the value of {@link BucketEncryptionProperty#getServerSideEncryptionConfiguration}
             * @param serverSideEncryptionConfiguration Specifies the default server-side-encryption configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionConfiguration(software.amazon.awscdk.IResolvable serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link BucketEncryptionProperty#getServerSideEncryptionConfiguration}
             * @param serverSideEncryptionConfiguration Specifies the default server-side-encryption configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionConfiguration(java.util.List<? extends java.lang.Object> serverSideEncryptionConfiguration) {
                this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BucketEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BucketEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BucketEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketEncryptionProperty {
            private final java.lang.Object serverSideEncryptionConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serverSideEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serverSideEncryptionConfiguration = java.util.Objects.requireNonNull(builder.serverSideEncryptionConfiguration, "serverSideEncryptionConfiguration is required");
            }

            @Override
            public final java.lang.Object getServerSideEncryptionConfiguration() {
                return this.serverSideEncryptionConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("serverSideEncryptionConfiguration", om.valueToTree(this.getServerSideEncryptionConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3express.CfnDirectoryBucket.BucketEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BucketEncryptionProperty.Jsii$Proxy that = (BucketEncryptionProperty.Jsii$Proxy) o;

                return this.serverSideEncryptionConfiguration.equals(that.serverSideEncryptionConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.serverSideEncryptionConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * Container for lifecycle rules. You can add as many as 1000 rules.
     * <p>
     * For more information see, <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-lifecycle.html">Creating and managing a lifecycle configuration for directory buckets</a> in the <em>Amazon S3 User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3express.*;
     * LifecycleConfigurationProperty lifecycleConfigurationProperty = LifecycleConfigurationProperty.builder()
     *         .rules(List.of(RuleProperty.builder()
     *                 .status("status")
     *                 // the properties below are optional
     *                 .abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty.builder()
     *                         .daysAfterInitiation(123)
     *                         .build())
     *                 .expirationInDays(123)
     *                 .id("id")
     *                 .objectSizeGreaterThan("objectSizeGreaterThan")
     *                 .objectSizeLessThan("objectSizeLessThan")
     *                 .prefix("prefix")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-lifecycleconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-lifecycleconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3express.CfnDirectoryBucket.LifecycleConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LifecycleConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LifecycleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A lifecycle rule for individual objects in an Amazon S3 Express bucket.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.s3express.CfnDirectoryBucket.RuleProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-lifecycleconfiguration.html#cfn-s3express-directorybucket-lifecycleconfiguration-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-lifecycleconfiguration.html#cfn-s3express-directorybucket-lifecycleconfiguration-rules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LifecycleConfigurationProperty> {
            java.lang.Object rules;

            /**
             * Sets the value of {@link LifecycleConfigurationProperty#getRules}
             * @param rules A lifecycle rule for individual objects in an Amazon S3 Express bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link LifecycleConfigurationProperty#getRules}
             * @param rules A lifecycle rule for individual objects in an Amazon S3 Express bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LifecycleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LifecycleConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LifecycleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecycleConfigurationProperty {
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3express.CfnDirectoryBucket.LifecycleConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LifecycleConfigurationProperty.Jsii$Proxy that = (LifecycleConfigurationProperty.Jsii$Proxy) o;

                return this.rules.equals(that.rules);
            }

            @Override
            public final int hashCode() {
                int result = this.rules.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies lifecycle rules for an Amazon S3 bucket.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlifecycle.html">Put Bucket Lifecycle Configuration</a> in the <em>Amazon S3 API Reference</em> . For examples, see <a href="https://docs.aws.amazon.com//AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html#API_PutBucketLifecycleConfiguration_Examples">Put Bucket Lifecycle Configuration Examples</a> .
     * <p>
     * You must specify at least one of the following properties: <code>AbortIncompleteMultipartUpload</code> , or <code>ExpirationInDays</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3express.*;
     * RuleProperty ruleProperty = RuleProperty.builder()
     *         .status("status")
     *         // the properties below are optional
     *         .abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadProperty.builder()
     *                 .daysAfterInitiation(123)
     *                 .build())
     *         .expirationInDays(123)
     *         .id("id")
     *         .objectSizeGreaterThan("objectSizeGreaterThan")
     *         .objectSizeLessThan("objectSizeLessThan")
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3express.CfnDirectoryBucket.RuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If <code>Enabled</code> , the rule is currently being applied.
         * <p>
         * If <code>Disabled</code> , the rule is not currently being applied.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.s3express.CfnDirectoryBucket.AbortIncompleteMultipartUploadProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-abortincompletemultipartupload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-abortincompletemultipartupload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAbortIncompleteMultipartUpload() {
            return null;
        }

        /**
         * Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon S3 Glacier.
         * <p>
         * If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-expirationindays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-expirationindays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getExpirationInDays() {
            return null;
        }

        /**
         * Unique identifier for the rule.
         * <p>
         * The value can't be longer than 255 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getId() {
            return null;
        }

        /**
         * Specifies the minimum object size in bytes for this rule to apply to.
         * <p>
         * Objects must be larger than this value in bytes. For more information about size based rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules">Lifecycle configuration using size-based rules</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-objectsizegreaterthan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-objectsizegreaterthan</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectSizeGreaterThan() {
            return null;
        }

        /**
         * Specifies the maximum object size in bytes for this rule to apply to.
         * <p>
         * Objects must be smaller than this value in bytes. For more information about sized based rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules">Lifecycle configuration using size-based rules</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-objectsizelessthan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-objectsizelessthan</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectSizeLessThan() {
            return null;
        }

        /**
         * Object key prefix that identifies one or more objects to which this rule applies.
         * <p>
         * <blockquote>
         * <p>
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">XML related object key constraints</a> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-rule.html#cfn-s3express-directorybucket-rule-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleProperty> {
            java.lang.String status;
            java.lang.Object abortIncompleteMultipartUpload;
            java.lang.Number expirationInDays;
            java.lang.String id;
            java.lang.String objectSizeGreaterThan;
            java.lang.String objectSizeLessThan;
            java.lang.String prefix;

            /**
             * Sets the value of {@link RuleProperty#getStatus}
             * @param status If <code>Enabled</code> , the rule is currently being applied. This parameter is required.
             *               If <code>Disabled</code> , the rule is not currently being applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getAbortIncompleteMultipartUpload}
             * @param abortIncompleteMultipartUpload Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder abortIncompleteMultipartUpload(software.amazon.awscdk.IResolvable abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getAbortIncompleteMultipartUpload}
             * @param abortIncompleteMultipartUpload Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder abortIncompleteMultipartUpload(software.amazon.awscdk.services.s3express.CfnDirectoryBucket.AbortIncompleteMultipartUploadProperty abortIncompleteMultipartUpload) {
                this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getExpirationInDays}
             * @param expirationInDays Indicates the number of days after creation when objects are deleted from Amazon S3 and Amazon S3 Glacier.
             *                         If you specify an expiration and transition time, you must use the same time unit for both properties (either in days or by date). The expiration time must also be later than the transition time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expirationInDays(java.lang.Number expirationInDays) {
                this.expirationInDays = expirationInDays;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getId}
             * @param id Unique identifier for the rule.
             *           The value can't be longer than 255 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getObjectSizeGreaterThan}
             * @param objectSizeGreaterThan Specifies the minimum object size in bytes for this rule to apply to.
             *                              Objects must be larger than this value in bytes. For more information about size based rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules">Lifecycle configuration using size-based rules</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectSizeGreaterThan(java.lang.String objectSizeGreaterThan) {
                this.objectSizeGreaterThan = objectSizeGreaterThan;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getObjectSizeLessThan}
             * @param objectSizeLessThan Specifies the maximum object size in bytes for this rule to apply to.
             *                           Objects must be smaller than this value in bytes. For more information about sized based rules, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/lifecycle-configuration-examples.html#lc-size-rules">Lifecycle configuration using size-based rules</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectSizeLessThan(java.lang.String objectSizeLessThan) {
                this.objectSizeLessThan = objectSizeLessThan;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getPrefix}
             * @param prefix Object key prefix that identifies one or more objects to which this rule applies.
             *               <blockquote>
             *               <p>
             *               Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">XML related object key constraints</a> .
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProperty {
            private final java.lang.String status;
            private final java.lang.Object abortIncompleteMultipartUpload;
            private final java.lang.Number expirationInDays;
            private final java.lang.String id;
            private final java.lang.String objectSizeGreaterThan;
            private final java.lang.String objectSizeLessThan;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.abortIncompleteMultipartUpload = software.amazon.jsii.Kernel.get(this, "abortIncompleteMultipartUpload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.expirationInDays = software.amazon.jsii.Kernel.get(this, "expirationInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectSizeGreaterThan = software.amazon.jsii.Kernel.get(this, "objectSizeGreaterThan", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectSizeLessThan = software.amazon.jsii.Kernel.get(this, "objectSizeLessThan", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
                this.abortIncompleteMultipartUpload = builder.abortIncompleteMultipartUpload;
                this.expirationInDays = builder.expirationInDays;
                this.id = builder.id;
                this.objectSizeGreaterThan = builder.objectSizeGreaterThan;
                this.objectSizeLessThan = builder.objectSizeLessThan;
                this.prefix = builder.prefix;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Object getAbortIncompleteMultipartUpload() {
                return this.abortIncompleteMultipartUpload;
            }

            @Override
            public final java.lang.Number getExpirationInDays() {
                return this.expirationInDays;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getObjectSizeGreaterThan() {
                return this.objectSizeGreaterThan;
            }

            @Override
            public final java.lang.String getObjectSizeLessThan() {
                return this.objectSizeLessThan;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getAbortIncompleteMultipartUpload() != null) {
                    data.set("abortIncompleteMultipartUpload", om.valueToTree(this.getAbortIncompleteMultipartUpload()));
                }
                if (this.getExpirationInDays() != null) {
                    data.set("expirationInDays", om.valueToTree(this.getExpirationInDays()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getObjectSizeGreaterThan() != null) {
                    data.set("objectSizeGreaterThan", om.valueToTree(this.getObjectSizeGreaterThan()));
                }
                if (this.getObjectSizeLessThan() != null) {
                    data.set("objectSizeLessThan", om.valueToTree(this.getObjectSizeLessThan()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3express.CfnDirectoryBucket.RuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleProperty.Jsii$Proxy that = (RuleProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                if (this.abortIncompleteMultipartUpload != null ? !this.abortIncompleteMultipartUpload.equals(that.abortIncompleteMultipartUpload) : that.abortIncompleteMultipartUpload != null) return false;
                if (this.expirationInDays != null ? !this.expirationInDays.equals(that.expirationInDays) : that.expirationInDays != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.objectSizeGreaterThan != null ? !this.objectSizeGreaterThan.equals(that.objectSizeGreaterThan) : that.objectSizeGreaterThan != null) return false;
                if (this.objectSizeLessThan != null ? !this.objectSizeLessThan.equals(that.objectSizeLessThan) : that.objectSizeLessThan != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.abortIncompleteMultipartUpload != null ? this.abortIncompleteMultipartUpload.hashCode() : 0);
                result = 31 * result + (this.expirationInDays != null ? this.expirationInDays.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.objectSizeGreaterThan != null ? this.objectSizeGreaterThan.hashCode() : 0);
                result = 31 * result + (this.objectSizeLessThan != null ? this.objectSizeLessThan.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the default server-side encryption to apply to new objects in the bucket.
     * <p>
     * If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTencryption.html">PutBucketEncryption</a> in the <em>Amazon S3 API Reference</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3express.*;
     * ServerSideEncryptionByDefaultProperty serverSideEncryptionByDefaultProperty = ServerSideEncryptionByDefaultProperty.builder()
     *         .sseAlgorithm("sseAlgorithm")
     *         // the properties below are optional
     *         .kmsMasterKeyId("kmsMasterKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-serversideencryptionbydefault.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-serversideencryptionbydefault.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3express.CfnDirectoryBucket.ServerSideEncryptionByDefaultProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerSideEncryptionByDefaultProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerSideEncryptionByDefaultProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Server-side encryption algorithm to use for the default encryption.
         * <p>
         * <blockquote>
         * <p>
         * For directory buckets, there are only two supported values for server-side encryption: <code>AES256</code> and <code>aws:kms</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-serversideencryptionbydefault.html#cfn-s3express-directorybucket-serversideencryptionbydefault-ssealgorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-serversideencryptionbydefault.html#cfn-s3express-directorybucket-serversideencryptionbydefault-ssealgorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSseAlgorithm();

        /**
         * AWS Key Management Service (KMS) customer managed key ID to use for the default encryption.
         * <p>
         * This parameter is allowed only if <code>SSEAlgorithm</code> is set to <code>aws:kms</code> .
         * <p>
         * You can specify this parameter with the key ID or the Amazon Resource Name (ARN) of the KMS key. You can’t use the key alias of the KMS key.
         * <p>
         * <ul>
         * <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * <li>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * </ul>
         * <p>
         * If you are using encryption with cross-account or AWS service operations, you must use a fully qualified KMS key ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-bucket-encryption.html#s3-express-bucket-encryption-update-bucket-policy">Using encryption for cross-account operations</a> .
         * <p>
         * <blockquote>
         * <p>
         * Your SSE-KMS configuration can only support 1 <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a> per directory bucket for the lifetime of the bucket. <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">AWS managed key</a> ( <code>aws/s3</code> ) isn't supported. Also, after you specify a customer managed key for SSE-KMS and upload objects with this configuration, you can't override the customer managed key for your SSE-KMS configuration. To use a new customer manager key for your data, we recommend copying your existing objects to a new directory bucket with a new customer managed key. &gt; Amazon S3 only supports symmetric encryption KMS keys. For more information, see <a href="https://docs.aws.amazon.com//kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-serversideencryptionbydefault.html#cfn-s3express-directorybucket-serversideencryptionbydefault-kmsmasterkeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-serversideencryptionbydefault.html#cfn-s3express-directorybucket-serversideencryptionbydefault-kmsmasterkeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsMasterKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerSideEncryptionByDefaultProperty> {
            java.lang.String sseAlgorithm;
            java.lang.String kmsMasterKeyId;

            /**
             * Sets the value of {@link ServerSideEncryptionByDefaultProperty#getSseAlgorithm}
             * @param sseAlgorithm Server-side encryption algorithm to use for the default encryption. This parameter is required.
             *                     <blockquote>
             *                     <p>
             *                     For directory buckets, there are only two supported values for server-side encryption: <code>AES256</code> and <code>aws:kms</code> .
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sseAlgorithm(java.lang.String sseAlgorithm) {
                this.sseAlgorithm = sseAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link ServerSideEncryptionByDefaultProperty#getKmsMasterKeyId}
             * @param kmsMasterKeyId AWS Key Management Service (KMS) customer managed key ID to use for the default encryption.
             *                       This parameter is allowed only if <code>SSEAlgorithm</code> is set to <code>aws:kms</code> .
             *                       <p>
             *                       You can specify this parameter with the key ID or the Amazon Resource Name (ARN) of the KMS key. You can’t use the key alias of the KMS key.
             *                       <p>
             *                       <ul>
             *                       <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
             *                       <li>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
             *                       </ul>
             *                       <p>
             *                       If you are using encryption with cross-account or AWS service operations, you must use a fully qualified KMS key ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-bucket-encryption.html#s3-express-bucket-encryption-update-bucket-policy">Using encryption for cross-account operations</a> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       Your SSE-KMS configuration can only support 1 <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk">customer managed key</a> per directory bucket for the lifetime of the bucket. <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">AWS managed key</a> ( <code>aws/s3</code> ) isn't supported. Also, after you specify a customer managed key for SSE-KMS and upload objects with this configuration, you can't override the customer managed key for your SSE-KMS configuration. To use a new customer manager key for your data, we recommend copying your existing objects to a new directory bucket with a new customer managed key. &gt; Amazon S3 only supports symmetric encryption KMS keys. For more information, see <a href="https://docs.aws.amazon.com//kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsMasterKeyId(java.lang.String kmsMasterKeyId) {
                this.kmsMasterKeyId = kmsMasterKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionByDefaultProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerSideEncryptionByDefaultProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerSideEncryptionByDefaultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerSideEncryptionByDefaultProperty {
            private final java.lang.String sseAlgorithm;
            private final java.lang.String kmsMasterKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sseAlgorithm = software.amazon.jsii.Kernel.get(this, "sseAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsMasterKeyId = software.amazon.jsii.Kernel.get(this, "kmsMasterKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sseAlgorithm = java.util.Objects.requireNonNull(builder.sseAlgorithm, "sseAlgorithm is required");
                this.kmsMasterKeyId = builder.kmsMasterKeyId;
            }

            @Override
            public final java.lang.String getSseAlgorithm() {
                return this.sseAlgorithm;
            }

            @Override
            public final java.lang.String getKmsMasterKeyId() {
                return this.kmsMasterKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sseAlgorithm", om.valueToTree(this.getSseAlgorithm()));
                if (this.getKmsMasterKeyId() != null) {
                    data.set("kmsMasterKeyId", om.valueToTree(this.getKmsMasterKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3express.CfnDirectoryBucket.ServerSideEncryptionByDefaultProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerSideEncryptionByDefaultProperty.Jsii$Proxy that = (ServerSideEncryptionByDefaultProperty.Jsii$Proxy) o;

                if (!sseAlgorithm.equals(that.sseAlgorithm)) return false;
                return this.kmsMasterKeyId != null ? this.kmsMasterKeyId.equals(that.kmsMasterKeyId) : that.kmsMasterKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sseAlgorithm.hashCode();
                result = 31 * result + (this.kmsMasterKeyId != null ? this.kmsMasterKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the default server-side encryption configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3express.*;
     * ServerSideEncryptionRuleProperty serverSideEncryptionRuleProperty = ServerSideEncryptionRuleProperty.builder()
     *         .bucketKeyEnabled(false)
     *         .serverSideEncryptionByDefault(ServerSideEncryptionByDefaultProperty.builder()
     *                 .sseAlgorithm("sseAlgorithm")
     *                 // the properties below are optional
     *                 .kmsMasterKeyId("kmsMasterKeyId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-serversideencryptionrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-serversideencryptionrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3express.CfnDirectoryBucket.ServerSideEncryptionRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerSideEncryptionRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerSideEncryptionRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket.
         * <p>
         * S3 Bucket Keys are always enabled for <code>GET</code> and <code>PUT</code> operations on a directory bucket and can’t be disabled. It's only allowed to set the <code>BucketKeyEnabled</code> element to <code>true</code> .
         * <p>
         * S3 Bucket Keys aren't supported, when you copy SSE-KMS encrypted objects from general purpose buckets to directory buckets, from directory buckets to general purpose buckets, or between directory buckets, through <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a> , <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a> , <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-Batch-Ops">the Copy operation in Batch Operations</a> , or <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-import-job">the import jobs</a> . In this case, Amazon S3 makes a call to AWS KMS every time a copy request is made for a KMS-encrypted object.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-UsingKMSEncryption.html#s3-express-sse-kms-bucket-keys">Amazon S3 Bucket Keys</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-serversideencryptionrule.html#cfn-s3express-directorybucket-serversideencryptionrule-bucketkeyenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-serversideencryptionrule.html#cfn-s3express-directorybucket-serversideencryptionrule-bucketkeyenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBucketKeyEnabled() {
            return null;
        }

        /**
         * Specifies the default server-side encryption to apply to new objects in the bucket.
         * <p>
         * If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.s3express.CfnDirectoryBucket.ServerSideEncryptionByDefaultProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-serversideencryptionrule.html#cfn-s3express-directorybucket-serversideencryptionrule-serversideencryptionbydefault">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3express-directorybucket-serversideencryptionrule.html#cfn-s3express-directorybucket-serversideencryptionrule-serversideencryptionbydefault</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServerSideEncryptionByDefault() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerSideEncryptionRuleProperty> {
            java.lang.Object bucketKeyEnabled;
            java.lang.Object serverSideEncryptionByDefault;

            /**
             * Sets the value of {@link ServerSideEncryptionRuleProperty#getBucketKeyEnabled}
             * @param bucketKeyEnabled Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket.
             *                         S3 Bucket Keys are always enabled for <code>GET</code> and <code>PUT</code> operations on a directory bucket and can’t be disabled. It's only allowed to set the <code>BucketKeyEnabled</code> element to <code>true</code> .
             *                         <p>
             *                         S3 Bucket Keys aren't supported, when you copy SSE-KMS encrypted objects from general purpose buckets to directory buckets, from directory buckets to general purpose buckets, or between directory buckets, through <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a> , <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a> , <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-Batch-Ops">the Copy operation in Batch Operations</a> , or <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-import-job">the import jobs</a> . In this case, Amazon S3 makes a call to AWS KMS every time a copy request is made for a KMS-encrypted object.
             *                         <p>
             *                         For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-UsingKMSEncryption.html#s3-express-sse-kms-bucket-keys">Amazon S3 Bucket Keys</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketKeyEnabled(java.lang.Boolean bucketKeyEnabled) {
                this.bucketKeyEnabled = bucketKeyEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ServerSideEncryptionRuleProperty#getBucketKeyEnabled}
             * @param bucketKeyEnabled Specifies whether Amazon S3 should use an S3 Bucket Key with server-side encryption using KMS (SSE-KMS) for new objects in the bucket.
             *                         S3 Bucket Keys are always enabled for <code>GET</code> and <code>PUT</code> operations on a directory bucket and can’t be disabled. It's only allowed to set the <code>BucketKeyEnabled</code> element to <code>true</code> .
             *                         <p>
             *                         S3 Bucket Keys aren't supported, when you copy SSE-KMS encrypted objects from general purpose buckets to directory buckets, from directory buckets to general purpose buckets, or between directory buckets, through <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html">CopyObject</a> , <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html">UploadPartCopy</a> , <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-Batch-Ops">the Copy operation in Batch Operations</a> , or <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/create-import-job">the import jobs</a> . In this case, Amazon S3 makes a call to AWS KMS every time a copy request is made for a KMS-encrypted object.
             *                         <p>
             *                         For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-UsingKMSEncryption.html#s3-express-sse-kms-bucket-keys">Amazon S3 Bucket Keys</a> in the <em>Amazon S3 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketKeyEnabled(software.amazon.awscdk.IResolvable bucketKeyEnabled) {
                this.bucketKeyEnabled = bucketKeyEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ServerSideEncryptionRuleProperty#getServerSideEncryptionByDefault}
             * @param serverSideEncryptionByDefault Specifies the default server-side encryption to apply to new objects in the bucket.
             *                                      If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionByDefault(software.amazon.awscdk.IResolvable serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            /**
             * Sets the value of {@link ServerSideEncryptionRuleProperty#getServerSideEncryptionByDefault}
             * @param serverSideEncryptionByDefault Specifies the default server-side encryption to apply to new objects in the bucket.
             *                                      If a PUT Object request doesn't specify any server-side encryption, this default encryption will be applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverSideEncryptionByDefault(software.amazon.awscdk.services.s3express.CfnDirectoryBucket.ServerSideEncryptionByDefaultProperty serverSideEncryptionByDefault) {
                this.serverSideEncryptionByDefault = serverSideEncryptionByDefault;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerSideEncryptionRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerSideEncryptionRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerSideEncryptionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerSideEncryptionRuleProperty {
            private final java.lang.Object bucketKeyEnabled;
            private final java.lang.Object serverSideEncryptionByDefault;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketKeyEnabled = software.amazon.jsii.Kernel.get(this, "bucketKeyEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serverSideEncryptionByDefault = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionByDefault", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketKeyEnabled = builder.bucketKeyEnabled;
                this.serverSideEncryptionByDefault = builder.serverSideEncryptionByDefault;
            }

            @Override
            public final java.lang.Object getBucketKeyEnabled() {
                return this.bucketKeyEnabled;
            }

            @Override
            public final java.lang.Object getServerSideEncryptionByDefault() {
                return this.serverSideEncryptionByDefault;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucketKeyEnabled() != null) {
                    data.set("bucketKeyEnabled", om.valueToTree(this.getBucketKeyEnabled()));
                }
                if (this.getServerSideEncryptionByDefault() != null) {
                    data.set("serverSideEncryptionByDefault", om.valueToTree(this.getServerSideEncryptionByDefault()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3express.CfnDirectoryBucket.ServerSideEncryptionRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerSideEncryptionRuleProperty.Jsii$Proxy that = (ServerSideEncryptionRuleProperty.Jsii$Proxy) o;

                if (this.bucketKeyEnabled != null ? !this.bucketKeyEnabled.equals(that.bucketKeyEnabled) : that.bucketKeyEnabled != null) return false;
                return this.serverSideEncryptionByDefault != null ? this.serverSideEncryptionByDefault.equals(that.serverSideEncryptionByDefault) : that.serverSideEncryptionByDefault == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketKeyEnabled != null ? this.bucketKeyEnabled.hashCode() : 0;
                result = 31 * result + (this.serverSideEncryptionByDefault != null ? this.serverSideEncryptionByDefault.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3express.CfnDirectoryBucket}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3express.CfnDirectoryBucket> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3express.CfnDirectoryBucketProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3express.CfnDirectoryBucketProps.Builder();
        }

        /**
         * The number of Zone (Availability Zone or Local Zone) that's used for redundancy for the bucket.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-dataredundancy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-dataredundancy</a>
         * @param dataRedundancy The number of Zone (Availability Zone or Local Zone) that's used for redundancy for the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataRedundancy(final java.lang.String dataRedundancy) {
            this.props.dataRedundancy(dataRedundancy);
            return this;
        }

        /**
         * The name of the location where the bucket will be created.
         * <p>
         * For directory buckets, the name of the location is the Zone ID of the Availability Zone (AZ) or Local Zone (LZ) where the bucket will be created. An example AZ ID value is <code>usw2-az1</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-locationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-locationname</a>
         * @param locationName The name of the location where the bucket will be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locationName(final java.lang.String locationName) {
            this.props.locationName(locationName);
            return this;
        }

        /**
         * Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS).
         * <p>
         * For information about default encryption for directory buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-bucket-encryption.html">Setting and monitoring default encryption for directory buckets</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-bucketencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-bucketencryption</a>
         * @param bucketEncryption Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketEncryption(final software.amazon.awscdk.IResolvable bucketEncryption) {
            this.props.bucketEncryption(bucketEncryption);
            return this;
        }
        /**
         * Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS).
         * <p>
         * For information about default encryption for directory buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-bucket-encryption.html">Setting and monitoring default encryption for directory buckets</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-bucketencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-bucketencryption</a>
         * @param bucketEncryption Specifies default encryption for a bucket using server-side encryption with Amazon S3 managed keys (SSE-S3) or AWS KMS keys (SSE-KMS). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketEncryption(final software.amazon.awscdk.services.s3express.CfnDirectoryBucket.BucketEncryptionProperty bucketEncryption) {
            this.props.bucketEncryption(bucketEncryption);
            return this;
        }

        /**
         * A name for the bucket.
         * <p>
         * The bucket name must contain only lowercase letters, numbers, and hyphens (-). A directory bucket name must be unique in the chosen Zone (Availability Zone or Local Zone). The bucket name must also follow the format <code>*bucket_base_name* -- *zone_id* --x-s3</code> (for example, <code>*bucket_base_name* -- *usw2-az1* --x-s3</code> ). If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the bucket name. For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you need to replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-bucketname</a>
         * @param bucketName A name for the bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(final java.lang.String bucketName) {
            this.props.bucketName(bucketName);
            return this;
        }

        /**
         * Container for lifecycle rules. You can add as many as 1000 rules.
         * <p>
         * For more information see, <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-lifecycle.html">Creating and managing a lifecycle configuration for directory buckets</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-lifecycleconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-lifecycleconfiguration</a>
         * @param lifecycleConfiguration Container for lifecycle rules. You can add as many as 1000 rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(final software.amazon.awscdk.IResolvable lifecycleConfiguration) {
            this.props.lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }
        /**
         * Container for lifecycle rules. You can add as many as 1000 rules.
         * <p>
         * For more information see, <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-objects-lifecycle.html">Creating and managing a lifecycle configuration for directory buckets</a> in the <em>Amazon S3 User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-lifecycleconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-lifecycleconfiguration</a>
         * @param lifecycleConfiguration Container for lifecycle rules. You can add as many as 1000 rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleConfiguration(final software.amazon.awscdk.services.s3express.CfnDirectoryBucket.LifecycleConfigurationProperty lifecycleConfiguration) {
            this.props.lifecycleConfiguration(lifecycleConfiguration);
            return this;
        }

        /**
         * An array of tags that you can apply to the S3 directory bucket.
         * <p>
         * Tags are key-value pairs of metadata used to categorize and organize your buckets, track costs, and control access. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-tagging.html">Using tags with directory buckets</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3express-directorybucket.html#cfn-s3express-directorybucket-tags</a>
         * @param tags An array of tags that you can apply to the S3 directory bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.s3express.CfnDirectoryBucket}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3express.CfnDirectoryBucket build() {
            return new software.amazon.awscdk.services.s3express.CfnDirectoryBucket(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
