package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnMlflowTrackingServer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnMlflowTrackingServerProps cfnMlflowTrackingServerProps = CfnMlflowTrackingServerProps.builder()
 *         .artifactStoreUri("artifactStoreUri")
 *         .roleArn("roleArn")
 *         .trackingServerName("trackingServerName")
 *         // the properties below are optional
 *         .automaticModelRegistration(false)
 *         .mlflowVersion("mlflowVersion")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trackingServerSize("trackingServerSize")
 *         .weeklyMaintenanceWindowStart("weeklyMaintenanceWindowStart")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:29.117Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMlflowTrackingServerProps")
@software.amazon.jsii.Jsii.Proxy(CfnMlflowTrackingServerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMlflowTrackingServerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon S3 URI for MLFlow Tracking Server artifacts.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-artifactstoreuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-artifactstoreuri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getArtifactStoreUri();

    /**
     * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on behalf of the customer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The name of the MLFlow Tracking Server.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-trackingservername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-trackingservername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrackingServerName();

    /**
     * A flag to enable Automatic SageMaker Model Registration.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-automaticmodelregistration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-automaticmodelregistration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutomaticModelRegistration() {
        return null;
    }

    /**
     * The MLFlow Version used on the MLFlow Tracking Server.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-mlflowversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-mlflowversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMlflowVersion() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The size of the MLFlow Tracking Server.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-trackingserversize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-trackingserversize</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTrackingServerSize() {
        return null;
    }

    /**
     * The start of the time window for maintenance of the MLFlow Tracking Server in UTC time.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-weeklymaintenancewindowstart">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-mlflowtrackingserver.html#cfn-sagemaker-mlflowtrackingserver-weeklymaintenancewindowstart</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWeeklyMaintenanceWindowStart() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMlflowTrackingServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMlflowTrackingServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMlflowTrackingServerProps> {
        java.lang.String artifactStoreUri;
        java.lang.String roleArn;
        java.lang.String trackingServerName;
        java.lang.Object automaticModelRegistration;
        java.lang.String mlflowVersion;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String trackingServerSize;
        java.lang.String weeklyMaintenanceWindowStart;

        /**
         * Sets the value of {@link CfnMlflowTrackingServerProps#getArtifactStoreUri}
         * @param artifactStoreUri The Amazon S3 URI for MLFlow Tracking Server artifacts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStoreUri(java.lang.String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnMlflowTrackingServerProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on behalf of the customer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMlflowTrackingServerProps#getTrackingServerName}
         * @param trackingServerName The name of the MLFlow Tracking Server. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingServerName(java.lang.String trackingServerName) {
            this.trackingServerName = trackingServerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMlflowTrackingServerProps#getAutomaticModelRegistration}
         * @param automaticModelRegistration A flag to enable Automatic SageMaker Model Registration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticModelRegistration(java.lang.Boolean automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMlflowTrackingServerProps#getAutomaticModelRegistration}
         * @param automaticModelRegistration A flag to enable Automatic SageMaker Model Registration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticModelRegistration(software.amazon.awscdk.IResolvable automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMlflowTrackingServerProps#getMlflowVersion}
         * @param mlflowVersion The MLFlow Version used on the MLFlow Tracking Server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mlflowVersion(java.lang.String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnMlflowTrackingServerProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnMlflowTrackingServerProps#getTrackingServerSize}
         * @param trackingServerSize The size of the MLFlow Tracking Server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackingServerSize(java.lang.String trackingServerSize) {
            this.trackingServerSize = trackingServerSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnMlflowTrackingServerProps#getWeeklyMaintenanceWindowStart}
         * @param weeklyMaintenanceWindowStart The start of the time window for maintenance of the MLFlow Tracking Server in UTC time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weeklyMaintenanceWindowStart(java.lang.String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMlflowTrackingServerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMlflowTrackingServerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMlflowTrackingServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMlflowTrackingServerProps {
        private final java.lang.String artifactStoreUri;
        private final java.lang.String roleArn;
        private final java.lang.String trackingServerName;
        private final java.lang.Object automaticModelRegistration;
        private final java.lang.String mlflowVersion;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String trackingServerSize;
        private final java.lang.String weeklyMaintenanceWindowStart;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.artifactStoreUri = software.amazon.jsii.Kernel.get(this, "artifactStoreUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.trackingServerName = software.amazon.jsii.Kernel.get(this, "trackingServerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.automaticModelRegistration = software.amazon.jsii.Kernel.get(this, "automaticModelRegistration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mlflowVersion = software.amazon.jsii.Kernel.get(this, "mlflowVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.trackingServerSize = software.amazon.jsii.Kernel.get(this, "trackingServerSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.weeklyMaintenanceWindowStart = software.amazon.jsii.Kernel.get(this, "weeklyMaintenanceWindowStart", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.artifactStoreUri = java.util.Objects.requireNonNull(builder.artifactStoreUri, "artifactStoreUri is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.trackingServerName = java.util.Objects.requireNonNull(builder.trackingServerName, "trackingServerName is required");
            this.automaticModelRegistration = builder.automaticModelRegistration;
            this.mlflowVersion = builder.mlflowVersion;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.trackingServerSize = builder.trackingServerSize;
            this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        }

        @Override
        public final java.lang.String getArtifactStoreUri() {
            return this.artifactStoreUri;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getTrackingServerName() {
            return this.trackingServerName;
        }

        @Override
        public final java.lang.Object getAutomaticModelRegistration() {
            return this.automaticModelRegistration;
        }

        @Override
        public final java.lang.String getMlflowVersion() {
            return this.mlflowVersion;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTrackingServerSize() {
            return this.trackingServerSize;
        }

        @Override
        public final java.lang.String getWeeklyMaintenanceWindowStart() {
            return this.weeklyMaintenanceWindowStart;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("artifactStoreUri", om.valueToTree(this.getArtifactStoreUri()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("trackingServerName", om.valueToTree(this.getTrackingServerName()));
            if (this.getAutomaticModelRegistration() != null) {
                data.set("automaticModelRegistration", om.valueToTree(this.getAutomaticModelRegistration()));
            }
            if (this.getMlflowVersion() != null) {
                data.set("mlflowVersion", om.valueToTree(this.getMlflowVersion()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTrackingServerSize() != null) {
                data.set("trackingServerSize", om.valueToTree(this.getTrackingServerSize()));
            }
            if (this.getWeeklyMaintenanceWindowStart() != null) {
                data.set("weeklyMaintenanceWindowStart", om.valueToTree(this.getWeeklyMaintenanceWindowStart()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMlflowTrackingServerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMlflowTrackingServerProps.Jsii$Proxy that = (CfnMlflowTrackingServerProps.Jsii$Proxy) o;

            if (!artifactStoreUri.equals(that.artifactStoreUri)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (!trackingServerName.equals(that.trackingServerName)) return false;
            if (this.automaticModelRegistration != null ? !this.automaticModelRegistration.equals(that.automaticModelRegistration) : that.automaticModelRegistration != null) return false;
            if (this.mlflowVersion != null ? !this.mlflowVersion.equals(that.mlflowVersion) : that.mlflowVersion != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.trackingServerSize != null ? !this.trackingServerSize.equals(that.trackingServerSize) : that.trackingServerSize != null) return false;
            return this.weeklyMaintenanceWindowStart != null ? this.weeklyMaintenanceWindowStart.equals(that.weeklyMaintenanceWindowStart) : that.weeklyMaintenanceWindowStart == null;
        }

        @Override
        public final int hashCode() {
            int result = this.artifactStoreUri.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.trackingServerName.hashCode());
            result = 31 * result + (this.automaticModelRegistration != null ? this.automaticModelRegistration.hashCode() : 0);
            result = 31 * result + (this.mlflowVersion != null ? this.mlflowVersion.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.trackingServerSize != null ? this.trackingServerSize.hashCode() : 0);
            result = 31 * result + (this.weeklyMaintenanceWindowStart != null ? this.weeklyMaintenanceWindowStart.hashCode() : 0);
            return result;
        }
    }
}
