package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnMonitoringSchedule</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnMonitoringScheduleProps cfnMonitoringScheduleProps = CfnMonitoringScheduleProps.builder()
 *         .monitoringScheduleConfig(MonitoringScheduleConfigProperty.builder()
 *                 .monitoringJobDefinition(MonitoringJobDefinitionProperty.builder()
 *                         .monitoringAppSpecification(MonitoringAppSpecificationProperty.builder()
 *                                 .imageUri("imageUri")
 *                                 // the properties below are optional
 *                                 .containerArguments(List.of("containerArguments"))
 *                                 .containerEntrypoint(List.of("containerEntrypoint"))
 *                                 .postAnalyticsProcessorSourceUri("postAnalyticsProcessorSourceUri")
 *                                 .recordPreprocessorSourceUri("recordPreprocessorSourceUri")
 *                                 .build())
 *                         .monitoringInputs(List.of(MonitoringInputProperty.builder()
 *                                 .batchTransformInput(BatchTransformInputProperty.builder()
 *                                         .dataCapturedDestinationS3Uri("dataCapturedDestinationS3Uri")
 *                                         .datasetFormat(DatasetFormatProperty.builder()
 *                                                 .csv(CsvProperty.builder()
 *                                                         .header(false)
 *                                                         .build())
 *                                                 .json(JsonProperty.builder()
 *                                                         .line(false)
 *                                                         .build())
 *                                                 .parquet(false)
 *                                                 .build())
 *                                         .localPath("localPath")
 *                                         // the properties below are optional
 *                                         .excludeFeaturesAttribute("excludeFeaturesAttribute")
 *                                         .s3DataDistributionType("s3DataDistributionType")
 *                                         .s3InputMode("s3InputMode")
 *                                         .build())
 *                                 .endpointInput(EndpointInputProperty.builder()
 *                                         .endpointName("endpointName")
 *                                         .localPath("localPath")
 *                                         // the properties below are optional
 *                                         .excludeFeaturesAttribute("excludeFeaturesAttribute")
 *                                         .s3DataDistributionType("s3DataDistributionType")
 *                                         .s3InputMode("s3InputMode")
 *                                         .build())
 *                                 .build()))
 *                         .monitoringOutputConfig(MonitoringOutputConfigProperty.builder()
 *                                 .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
 *                                         .s3Output(S3OutputProperty.builder()
 *                                                 .localPath("localPath")
 *                                                 .s3Uri("s3Uri")
 *                                                 // the properties below are optional
 *                                                 .s3UploadMode("s3UploadMode")
 *                                                 .build())
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .kmsKeyId("kmsKeyId")
 *                                 .build())
 *                         .monitoringResources(MonitoringResourcesProperty.builder()
 *                                 .clusterConfig(ClusterConfigProperty.builder()
 *                                         .instanceCount(123)
 *                                         .instanceType("instanceType")
 *                                         .volumeSizeInGb(123)
 *                                         // the properties below are optional
 *                                         .volumeKmsKeyId("volumeKmsKeyId")
 *                                         .build())
 *                                 .build())
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .baselineConfig(BaselineConfigProperty.builder()
 *                                 .constraintsResource(ConstraintsResourceProperty.builder()
 *                                         .s3Uri("s3Uri")
 *                                         .build())
 *                                 .statisticsResource(StatisticsResourceProperty.builder()
 *                                         .s3Uri("s3Uri")
 *                                         .build())
 *                                 .build())
 *                         .environment(Map.of(
 *                                 "environmentKey", "environment"))
 *                         .networkConfig(NetworkConfigProperty.builder()
 *                                 .enableInterContainerTrafficEncryption(false)
 *                                 .enableNetworkIsolation(false)
 *                                 .vpcConfig(VpcConfigProperty.builder()
 *                                         .securityGroupIds(List.of("securityGroupIds"))
 *                                         .subnets(List.of("subnets"))
 *                                         .build())
 *                                 .build())
 *                         .stoppingCondition(StoppingConditionProperty.builder()
 *                                 .maxRuntimeInSeconds(123)
 *                                 .build())
 *                         .build())
 *                 .monitoringJobDefinitionName("monitoringJobDefinitionName")
 *                 .monitoringType("monitoringType")
 *                 .scheduleConfig(ScheduleConfigProperty.builder()
 *                         .scheduleExpression("scheduleExpression")
 *                         // the properties below are optional
 *                         .dataAnalysisEndTime("dataAnalysisEndTime")
 *                         .dataAnalysisStartTime("dataAnalysisStartTime")
 *                         .build())
 *                 .build())
 *         .monitoringScheduleName("monitoringScheduleName")
 *         // the properties below are optional
 *         .endpointName("endpointName")
 *         .failureReason("failureReason")
 *         .lastMonitoringExecutionSummary(MonitoringExecutionSummaryProperty.builder()
 *                 .creationTime("creationTime")
 *                 .lastModifiedTime("lastModifiedTime")
 *                 .monitoringExecutionStatus("monitoringExecutionStatus")
 *                 .monitoringScheduleName("monitoringScheduleName")
 *                 .scheduledTime("scheduledTime")
 *                 // the properties below are optional
 *                 .endpointName("endpointName")
 *                 .failureReason("failureReason")
 *                 .processingJobArn("processingJobArn")
 *                 .build())
 *         .monitoringScheduleStatus("monitoringScheduleStatus")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:29.286Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringScheduleProps")
@software.amazon.jsii.Jsii.Proxy(CfnMonitoringScheduleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMonitoringScheduleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The configuration object that specifies the monitoring schedule and defines the monitoring job.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringScheduleConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringScheduleConfig();

    /**
     * The name of the monitoring schedule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMonitoringScheduleName();

    /**
     * The name of the endpoint using the monitoring schedule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointName() {
        return null;
    }

    /**
     * Contains the reason a monitoring job failed, if it failed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFailureReason() {
        return null;
    }

    /**
     * Describes metadata on the last execution to run, if there was one.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringExecutionSummaryProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLastMonitoringExecutionSummary() {
        return null;
    }

    /**
     * The status of the monitoring schedule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMonitoringScheduleStatus() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMonitoringScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMonitoringScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMonitoringScheduleProps> {
        java.lang.Object monitoringScheduleConfig;
        java.lang.String monitoringScheduleName;
        java.lang.String endpointName;
        java.lang.String failureReason;
        java.lang.Object lastMonitoringExecutionSummary;
        java.lang.String monitoringScheduleStatus;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnMonitoringScheduleProps#getMonitoringScheduleConfig}
         * @param monitoringScheduleConfig The configuration object that specifies the monitoring schedule and defines the monitoring job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringScheduleConfig(software.amazon.awscdk.IResolvable monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitoringScheduleProps#getMonitoringScheduleConfig}
         * @param monitoringScheduleConfig The configuration object that specifies the monitoring schedule and defines the monitoring job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringScheduleConfig(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringScheduleConfigProperty monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitoringScheduleProps#getMonitoringScheduleName}
         * @param monitoringScheduleName The name of the monitoring schedule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringScheduleName(java.lang.String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitoringScheduleProps#getEndpointName}
         * @param endpointName The name of the endpoint using the monitoring schedule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointName(java.lang.String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitoringScheduleProps#getFailureReason}
         * @param failureReason Contains the reason a monitoring job failed, if it failed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureReason(java.lang.String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitoringScheduleProps#getLastMonitoringExecutionSummary}
         * @param lastMonitoringExecutionSummary Describes metadata on the last execution to run, if there was one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastMonitoringExecutionSummary(software.amazon.awscdk.IResolvable lastMonitoringExecutionSummary) {
            this.lastMonitoringExecutionSummary = lastMonitoringExecutionSummary;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitoringScheduleProps#getLastMonitoringExecutionSummary}
         * @param lastMonitoringExecutionSummary Describes metadata on the last execution to run, if there was one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastMonitoringExecutionSummary(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringExecutionSummaryProperty lastMonitoringExecutionSummary) {
            this.lastMonitoringExecutionSummary = lastMonitoringExecutionSummary;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitoringScheduleProps#getMonitoringScheduleStatus}
         * @param monitoringScheduleStatus The status of the monitoring schedule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringScheduleStatus(java.lang.String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnMonitoringScheduleProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMonitoringScheduleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMonitoringScheduleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMonitoringScheduleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMonitoringScheduleProps {
        private final java.lang.Object monitoringScheduleConfig;
        private final java.lang.String monitoringScheduleName;
        private final java.lang.String endpointName;
        private final java.lang.String failureReason;
        private final java.lang.Object lastMonitoringExecutionSummary;
        private final java.lang.String monitoringScheduleStatus;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.monitoringScheduleConfig = software.amazon.jsii.Kernel.get(this, "monitoringScheduleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.monitoringScheduleName = software.amazon.jsii.Kernel.get(this, "monitoringScheduleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.failureReason = software.amazon.jsii.Kernel.get(this, "failureReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lastMonitoringExecutionSummary = software.amazon.jsii.Kernel.get(this, "lastMonitoringExecutionSummary", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.monitoringScheduleStatus = software.amazon.jsii.Kernel.get(this, "monitoringScheduleStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.monitoringScheduleConfig = java.util.Objects.requireNonNull(builder.monitoringScheduleConfig, "monitoringScheduleConfig is required");
            this.monitoringScheduleName = java.util.Objects.requireNonNull(builder.monitoringScheduleName, "monitoringScheduleName is required");
            this.endpointName = builder.endpointName;
            this.failureReason = builder.failureReason;
            this.lastMonitoringExecutionSummary = builder.lastMonitoringExecutionSummary;
            this.monitoringScheduleStatus = builder.monitoringScheduleStatus;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getMonitoringScheduleConfig() {
            return this.monitoringScheduleConfig;
        }

        @Override
        public final java.lang.String getMonitoringScheduleName() {
            return this.monitoringScheduleName;
        }

        @Override
        public final java.lang.String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final java.lang.String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final java.lang.Object getLastMonitoringExecutionSummary() {
            return this.lastMonitoringExecutionSummary;
        }

        @Override
        public final java.lang.String getMonitoringScheduleStatus() {
            return this.monitoringScheduleStatus;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("monitoringScheduleConfig", om.valueToTree(this.getMonitoringScheduleConfig()));
            data.set("monitoringScheduleName", om.valueToTree(this.getMonitoringScheduleName()));
            if (this.getEndpointName() != null) {
                data.set("endpointName", om.valueToTree(this.getEndpointName()));
            }
            if (this.getFailureReason() != null) {
                data.set("failureReason", om.valueToTree(this.getFailureReason()));
            }
            if (this.getLastMonitoringExecutionSummary() != null) {
                data.set("lastMonitoringExecutionSummary", om.valueToTree(this.getLastMonitoringExecutionSummary()));
            }
            if (this.getMonitoringScheduleStatus() != null) {
                data.set("monitoringScheduleStatus", om.valueToTree(this.getMonitoringScheduleStatus()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringScheduleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMonitoringScheduleProps.Jsii$Proxy that = (CfnMonitoringScheduleProps.Jsii$Proxy) o;

            if (!monitoringScheduleConfig.equals(that.monitoringScheduleConfig)) return false;
            if (!monitoringScheduleName.equals(that.monitoringScheduleName)) return false;
            if (this.endpointName != null ? !this.endpointName.equals(that.endpointName) : that.endpointName != null) return false;
            if (this.failureReason != null ? !this.failureReason.equals(that.failureReason) : that.failureReason != null) return false;
            if (this.lastMonitoringExecutionSummary != null ? !this.lastMonitoringExecutionSummary.equals(that.lastMonitoringExecutionSummary) : that.lastMonitoringExecutionSummary != null) return false;
            if (this.monitoringScheduleStatus != null ? !this.monitoringScheduleStatus.equals(that.monitoringScheduleStatus) : that.monitoringScheduleStatus != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.monitoringScheduleConfig.hashCode();
            result = 31 * result + (this.monitoringScheduleName.hashCode());
            result = 31 * result + (this.endpointName != null ? this.endpointName.hashCode() : 0);
            result = 31 * result + (this.failureReason != null ? this.failureReason.hashCode() : 0);
            result = 31 * result + (this.lastMonitoringExecutionSummary != null ? this.lastMonitoringExecutionSummary.hashCode() : 0);
            result = 31 * result + (this.monitoringScheduleStatus != null ? this.monitoringScheduleStatus.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
