package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnProcessingJob</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnProcessingJobProps cfnProcessingJobProps = CfnProcessingJobProps.builder()
 *         .appSpecification(AppSpecificationProperty.builder()
 *                 .imageUri("imageUri")
 *                 // the properties below are optional
 *                 .containerArguments(List.of("containerArguments"))
 *                 .containerEntrypoint(List.of("containerEntrypoint"))
 *                 .build())
 *         .processingResources(ProcessingResourcesProperty.builder()
 *                 .clusterConfig(ClusterConfigProperty.builder()
 *                         .instanceCount(123)
 *                         .instanceType("instanceType")
 *                         .volumeSizeInGb(123)
 *                         // the properties below are optional
 *                         .volumeKmsKeyId("volumeKmsKeyId")
 *                         .build())
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .environment(Map.of(
 *                 "environmentKey", "environment"))
 *         .experimentConfig(ExperimentConfigProperty.builder()
 *                 .experimentName("experimentName")
 *                 .runName("runName")
 *                 .trialComponentDisplayName("trialComponentDisplayName")
 *                 .trialName("trialName")
 *                 .build())
 *         .networkConfig(NetworkConfigProperty.builder()
 *                 .enableInterContainerTrafficEncryption(false)
 *                 .enableNetworkIsolation(false)
 *                 .vpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .build())
 *         .processingInputs(List.of(ProcessingInputsObjectProperty.builder()
 *                 .inputName("inputName")
 *                 // the properties below are optional
 *                 .appManaged(false)
 *                 .datasetDefinition(DatasetDefinitionProperty.builder()
 *                         .athenaDatasetDefinition(AthenaDatasetDefinitionProperty.builder()
 *                                 .catalog("catalog")
 *                                 .database("database")
 *                                 .outputFormat("outputFormat")
 *                                 .outputS3Uri("outputS3Uri")
 *                                 .queryString("queryString")
 *                                 // the properties below are optional
 *                                 .kmsKeyId("kmsKeyId")
 *                                 .outputCompression("outputCompression")
 *                                 .workGroup("workGroup")
 *                                 .build())
 *                         .dataDistributionType("dataDistributionType")
 *                         .inputMode("inputMode")
 *                         .localPath("localPath")
 *                         .redshiftDatasetDefinition(RedshiftDatasetDefinitionProperty.builder()
 *                                 .clusterId("clusterId")
 *                                 .clusterRoleArn("clusterRoleArn")
 *                                 .database("database")
 *                                 .dbUser("dbUser")
 *                                 .outputFormat("outputFormat")
 *                                 .outputS3Uri("outputS3Uri")
 *                                 .queryString("queryString")
 *                                 // the properties below are optional
 *                                 .kmsKeyId("kmsKeyId")
 *                                 .outputCompression("outputCompression")
 *                                 .build())
 *                         .build())
 *                 .s3Input(S3InputProperty.builder()
 *                         .s3DataType("s3DataType")
 *                         .s3Uri("s3Uri")
 *                         // the properties below are optional
 *                         .localPath("localPath")
 *                         .s3CompressionType("s3CompressionType")
 *                         .s3DataDistributionType("s3DataDistributionType")
 *                         .s3InputMode("s3InputMode")
 *                         .build())
 *                 .build()))
 *         .processingJobName("processingJobName")
 *         .processingOutputConfig(ProcessingOutputConfigProperty.builder()
 *                 .outputs(List.of(ProcessingOutputsObjectProperty.builder()
 *                         .outputName("outputName")
 *                         // the properties below are optional
 *                         .appManaged(false)
 *                         .featureStoreOutput(FeatureStoreOutputProperty.builder()
 *                                 .featureGroupName("featureGroupName")
 *                                 .build())
 *                         .s3Output(S3OutputProperty.builder()
 *                                 .s3UploadMode("s3UploadMode")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .localPath("localPath")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .stoppingCondition(StoppingConditionProperty.builder()
 *                 .maxRuntimeInSeconds(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:29.328Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJobProps")
@software.amazon.jsii.Jsii.Proxy(CfnProcessingJobProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnProcessingJobProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Configuration to run a processing job in a specified container image.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.AppSpecificationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-appspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-appspecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAppSpecification();

    /**
     * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job.
     * <p>
     * In distributed training, you specify more than one instance.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingResourcesProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingresources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getProcessingResources();

    /**
     * The ARN of the role used to create the processing job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * Sets the environment variables in the Docker container.
     * <p>
     * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-environment</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
        return null;
    }

    /**
     * Associates a SageMaker job as a trial component with an experiment and trial.
     * <p>
     * Specified when you call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html">CreateProcessingJob</a> API.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ExperimentConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-experimentconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-experimentconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExperimentConfig() {
        return null;
    }

    /**
     * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.NetworkConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-networkconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-networkconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfig() {
        return null;
    }

    /**
     * List of input configurations for the processing job.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingInputsObjectProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processinginputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processinginputs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingInputs() {
        return null;
    }

    /**
     * The name of the processing job.
     * <p>
     * If you don't provide a job name, then a unique name is automatically created for the job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingjobname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingjobname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProcessingJobName() {
        return null;
    }

    /**
     * Contains information about the output location for the compiled model and the target device that the model runs on.
     * <p>
     * <code>TargetDevice</code> and <code>TargetPlatform</code> are mutually exclusive, so you need to choose one between the two to specify your target device or platform. If you cannot find your device you want to use from the <code>TargetDevice</code> list, use <code>TargetPlatform</code> to describe the platform of your edge device and <code>CompilerOptions</code> if there are specific settings that are required or recommended to use for particular TargetPlatform.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingOutputConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingoutputconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingoutputconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingOutputConfig() {
        return null;
    }

    /**
     * Configures conditions under which the processing job should be stopped, such as how long the processing job has been running.
     * <p>
     * After the condition is met, the processing job is stopped.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.StoppingConditionProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-stoppingcondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-stoppingcondition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStoppingCondition() {
        return null;
    }

    /**
     * An array of key-value pairs.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <em>AWS Billing and Cost Management User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnProcessingJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnProcessingJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnProcessingJobProps> {
        java.lang.Object appSpecification;
        java.lang.Object processingResources;
        java.lang.String roleArn;
        java.lang.Object environment;
        java.lang.Object experimentConfig;
        java.lang.Object networkConfig;
        java.lang.Object processingInputs;
        java.lang.String processingJobName;
        java.lang.Object processingOutputConfig;
        java.lang.Object stoppingCondition;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnProcessingJobProps#getAppSpecification}
         * @param appSpecification Configuration to run a processing job in a specified container image. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appSpecification(software.amazon.awscdk.IResolvable appSpecification) {
            this.appSpecification = appSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getAppSpecification}
         * @param appSpecification Configuration to run a processing job in a specified container image. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appSpecification(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.AppSpecificationProperty appSpecification) {
            this.appSpecification = appSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getProcessingResources}
         * @param processingResources Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. This parameter is required.
         *                            In distributed training, you specify more than one instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingResources(software.amazon.awscdk.IResolvable processingResources) {
            this.processingResources = processingResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getProcessingResources}
         * @param processingResources Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. This parameter is required.
         *                            In distributed training, you specify more than one instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingResources(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingResourcesProperty processingResources) {
            this.processingResources = processingResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getRoleArn}
         * @param roleArn The ARN of the role used to create the processing job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getEnvironment}
         * @param environment Sets the environment variables in the Docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getEnvironment}
         * @param environment Sets the environment variables in the Docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(software.amazon.awscdk.IResolvable environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getExperimentConfig}
         * @param experimentConfig Associates a SageMaker job as a trial component with an experiment and trial.
         *                         Specified when you call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html">CreateProcessingJob</a> API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder experimentConfig(software.amazon.awscdk.IResolvable experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getExperimentConfig}
         * @param experimentConfig Associates a SageMaker job as a trial component with an experiment and trial.
         *                         Specified when you call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html">CreateProcessingJob</a> API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder experimentConfig(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ExperimentConfigProperty experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getNetworkConfig}
         * @param networkConfig Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(software.amazon.awscdk.IResolvable networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getNetworkConfig}
         * @param networkConfig Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.NetworkConfigProperty networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getProcessingInputs}
         * @param processingInputs List of input configurations for the processing job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingInputs(software.amazon.awscdk.IResolvable processingInputs) {
            this.processingInputs = processingInputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getProcessingInputs}
         * @param processingInputs List of input configurations for the processing job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingInputs(java.util.List<? extends java.lang.Object> processingInputs) {
            this.processingInputs = processingInputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getProcessingJobName}
         * @param processingJobName The name of the processing job.
         *                          If you don't provide a job name, then a unique name is automatically created for the job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingJobName(java.lang.String processingJobName) {
            this.processingJobName = processingJobName;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getProcessingOutputConfig}
         * @param processingOutputConfig Contains information about the output location for the compiled model and the target device that the model runs on.
         *                               <code>TargetDevice</code> and <code>TargetPlatform</code> are mutually exclusive, so you need to choose one between the two to specify your target device or platform. If you cannot find your device you want to use from the <code>TargetDevice</code> list, use <code>TargetPlatform</code> to describe the platform of your edge device and <code>CompilerOptions</code> if there are specific settings that are required or recommended to use for particular TargetPlatform.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingOutputConfig(software.amazon.awscdk.IResolvable processingOutputConfig) {
            this.processingOutputConfig = processingOutputConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getProcessingOutputConfig}
         * @param processingOutputConfig Contains information about the output location for the compiled model and the target device that the model runs on.
         *                               <code>TargetDevice</code> and <code>TargetPlatform</code> are mutually exclusive, so you need to choose one between the two to specify your target device or platform. If you cannot find your device you want to use from the <code>TargetDevice</code> list, use <code>TargetPlatform</code> to describe the platform of your edge device and <code>CompilerOptions</code> if there are specific settings that are required or recommended to use for particular TargetPlatform.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingOutputConfig(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingOutputConfigProperty processingOutputConfig) {
            this.processingOutputConfig = processingOutputConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getStoppingCondition}
         * @param stoppingCondition Configures conditions under which the processing job should be stopped, such as how long the processing job has been running.
         *                          After the condition is met, the processing job is stopped.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(software.amazon.awscdk.IResolvable stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getStoppingCondition}
         * @param stoppingCondition Configures conditions under which the processing job should be stopped, such as how long the processing job has been running.
         *                          After the condition is met, the processing job is stopped.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.StoppingConditionProperty stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link CfnProcessingJobProps#getTags}
         * @param tags An array of key-value pairs.
         *             For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <em>AWS Billing and Cost Management User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnProcessingJobProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnProcessingJobProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnProcessingJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnProcessingJobProps {
        private final java.lang.Object appSpecification;
        private final java.lang.Object processingResources;
        private final java.lang.String roleArn;
        private final java.lang.Object environment;
        private final java.lang.Object experimentConfig;
        private final java.lang.Object networkConfig;
        private final java.lang.Object processingInputs;
        private final java.lang.String processingJobName;
        private final java.lang.Object processingOutputConfig;
        private final java.lang.Object stoppingCondition;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appSpecification = software.amazon.jsii.Kernel.get(this, "appSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.processingResources = software.amazon.jsii.Kernel.get(this, "processingResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.experimentConfig = software.amazon.jsii.Kernel.get(this, "experimentConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.networkConfig = software.amazon.jsii.Kernel.get(this, "networkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.processingInputs = software.amazon.jsii.Kernel.get(this, "processingInputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.processingJobName = software.amazon.jsii.Kernel.get(this, "processingJobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.processingOutputConfig = software.amazon.jsii.Kernel.get(this, "processingOutputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.stoppingCondition = software.amazon.jsii.Kernel.get(this, "stoppingCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appSpecification = java.util.Objects.requireNonNull(builder.appSpecification, "appSpecification is required");
            this.processingResources = java.util.Objects.requireNonNull(builder.processingResources, "processingResources is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.environment = builder.environment;
            this.experimentConfig = builder.experimentConfig;
            this.networkConfig = builder.networkConfig;
            this.processingInputs = builder.processingInputs;
            this.processingJobName = builder.processingJobName;
            this.processingOutputConfig = builder.processingOutputConfig;
            this.stoppingCondition = builder.stoppingCondition;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getAppSpecification() {
            return this.appSpecification;
        }

        @Override
        public final java.lang.Object getProcessingResources() {
            return this.processingResources;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.Object getExperimentConfig() {
            return this.experimentConfig;
        }

        @Override
        public final java.lang.Object getNetworkConfig() {
            return this.networkConfig;
        }

        @Override
        public final java.lang.Object getProcessingInputs() {
            return this.processingInputs;
        }

        @Override
        public final java.lang.String getProcessingJobName() {
            return this.processingJobName;
        }

        @Override
        public final java.lang.Object getProcessingOutputConfig() {
            return this.processingOutputConfig;
        }

        @Override
        public final java.lang.Object getStoppingCondition() {
            return this.stoppingCondition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appSpecification", om.valueToTree(this.getAppSpecification()));
            data.set("processingResources", om.valueToTree(this.getProcessingResources()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getExperimentConfig() != null) {
                data.set("experimentConfig", om.valueToTree(this.getExperimentConfig()));
            }
            if (this.getNetworkConfig() != null) {
                data.set("networkConfig", om.valueToTree(this.getNetworkConfig()));
            }
            if (this.getProcessingInputs() != null) {
                data.set("processingInputs", om.valueToTree(this.getProcessingInputs()));
            }
            if (this.getProcessingJobName() != null) {
                data.set("processingJobName", om.valueToTree(this.getProcessingJobName()));
            }
            if (this.getProcessingOutputConfig() != null) {
                data.set("processingOutputConfig", om.valueToTree(this.getProcessingOutputConfig()));
            }
            if (this.getStoppingCondition() != null) {
                data.set("stoppingCondition", om.valueToTree(this.getStoppingCondition()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJobProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnProcessingJobProps.Jsii$Proxy that = (CfnProcessingJobProps.Jsii$Proxy) o;

            if (!appSpecification.equals(that.appSpecification)) return false;
            if (!processingResources.equals(that.processingResources)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.experimentConfig != null ? !this.experimentConfig.equals(that.experimentConfig) : that.experimentConfig != null) return false;
            if (this.networkConfig != null ? !this.networkConfig.equals(that.networkConfig) : that.networkConfig != null) return false;
            if (this.processingInputs != null ? !this.processingInputs.equals(that.processingInputs) : that.processingInputs != null) return false;
            if (this.processingJobName != null ? !this.processingJobName.equals(that.processingJobName) : that.processingJobName != null) return false;
            if (this.processingOutputConfig != null ? !this.processingOutputConfig.equals(that.processingOutputConfig) : that.processingOutputConfig != null) return false;
            if (this.stoppingCondition != null ? !this.stoppingCondition.equals(that.stoppingCondition) : that.stoppingCondition != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.appSpecification.hashCode();
            result = 31 * result + (this.processingResources.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.experimentConfig != null ? this.experimentConfig.hashCode() : 0);
            result = 31 * result + (this.networkConfig != null ? this.networkConfig.hashCode() : 0);
            result = 31 * result + (this.processingInputs != null ? this.processingInputs.hashCode() : 0);
            result = 31 * result + (this.processingJobName != null ? this.processingJobName.hashCode() : 0);
            result = 31 * result + (this.processingOutputConfig != null ? this.processingOutputConfig.hashCode() : 0);
            result = 31 * result + (this.stoppingCondition != null ? this.stoppingCondition.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
