package software.amazon.awscdk.services.scheduler;

/**
 * An EventBridge Schedule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * IDeliveryStream deliveryStream;
 * Map&lt;String, String&gt; payload = Map.of(
 *         "Data", "record");
 * Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.rate(Duration.minutes(60)))
 *         .target(FirehosePutRecord.Builder.create(deliveryStream)
 *                 .input(ScheduleTargetInput.fromObject(payload))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:29.509Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.Schedule")
public class Schedule extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.scheduler.ISchedule {

    protected Schedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Schedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.scheduler.Schedule.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Schedule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing schedule using the ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param scheduleArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ISchedule fromScheduleArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String scheduleArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "fromScheduleArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ISchedule.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(scheduleArn, "scheduleArn is required") });
    }

    /**
     * Return the given named metric for all schedules.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAll(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAll", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for all schedules.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAll(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAll", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Metric for all invocation attempts across all schedules.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllAttempts(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllAttempts", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for all invocation attempts across all schedules.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllAttempts() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllAttempts", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for dropped invocations when EventBridge Scheduler stops attempting to invoke the target after a schedule's retry policy has been exhausted.
     * <p>
     * Metric is calculated for all schedules.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllDropped(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllDropped", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for dropped invocations when EventBridge Scheduler stops attempting to invoke the target after a schedule's retry policy has been exhausted.
     * <p>
     * Metric is calculated for all schedules.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllDropped() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllDropped", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Emitted when the target returns an exception after EventBridge Scheduler calls the target API across all schedules.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Emitted when the target returns an exception after EventBridge Scheduler calls the target API across all schedules.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllErrors() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for failed invocations that also failed to deliver to DLQ across all schedules.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param errorCode
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllFailedToBeSentToDLQ(final @org.jetbrains.annotations.Nullable java.lang.String errorCode, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllFailedToBeSentToDLQ", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { errorCode, props });
    }

    /**
     * Metric for failed invocations that also failed to deliver to DLQ across all schedules.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param errorCode
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllFailedToBeSentToDLQ(final @org.jetbrains.annotations.Nullable java.lang.String errorCode) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllFailedToBeSentToDLQ", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { errorCode });
    }

    /**
     * Metric for failed invocations that also failed to deliver to DLQ across all schedules.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllFailedToBeSentToDLQ() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllFailedToBeSentToDLQ", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for invocations delivered to the DLQ across all schedules.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllSentToDLQ(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllSentToDLQ", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for invocations delivered to the DLQ across all schedules.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllSentToDLQ() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllSentToDLQ", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for delivery of failed invocations to DLQ when the payload of the event sent to the DLQ exceeds the maximum size allowed by Amazon SQS.
     * <p>
     * Metric is calculated for all schedules.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllSentToDLQTruncated(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllSentToDLQTruncated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for delivery of failed invocations to DLQ when the payload of the event sent to the DLQ exceeds the maximum size allowed by Amazon SQS.
     * <p>
     * Metric is calculated for all schedules.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllSentToDLQTruncated() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllSentToDLQTruncated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for invocation failures due to API throttling by the target across all schedules.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllTargetThrottled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllTargetThrottled", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for invocation failures due to API throttling by the target across all schedules.
     * <p>
     * Default: - sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllTargetThrottled() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllTargetThrottled", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the number of invocations that were throttled across all schedules.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/scheduler-quotas.html">https://docs.aws.amazon.com/scheduler/latest/UserGuide/scheduler-quotas.html</a>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllThrottled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllThrottled", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the number of invocations that were throttled across all schedules.
     * <p>
     * Default: - sum over 5 minutes
     * <p>
     * @see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/scheduler-quotas.html">https://docs.aws.amazon.com/scheduler/latest/UserGuide/scheduler-quotas.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAllThrottled() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.scheduler.Schedule.class, "metricAllThrottled", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The arn of the schedule.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScheduleArn() {
        return software.amazon.jsii.Kernel.get(this, "scheduleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the schedule.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScheduleName() {
        return software.amazon.jsii.Kernel.get(this, "scheduleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKey() {
        return software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * The schedule group associated with this schedule.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.scheduler.IScheduleGroup getScheduleGroup() {
        return software.amazon.jsii.Kernel.get(this, "scheduleGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.IScheduleGroup.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.scheduler.Schedule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.scheduler.Schedule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.scheduler.ScheduleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.scheduler.ScheduleProps.Builder();
        }

        /**
         * The expression that defines when the schedule runs.
         * <p>
         * Can be either a <code>at</code>, <code>rate</code>
         * or <code>cron</code> expression.
         * <p>
         * @return {@code this}
         * @param schedule The expression that defines when the schedule runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.scheduler.ScheduleExpression schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The schedule's target details.
         * <p>
         * @return {@code this}
         * @param target The schedule's target details. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final software.amazon.awscdk.services.scheduler.IScheduleTarget target) {
            this.props.target(target);
            return this;
        }

        /**
         * The description you specify for the schedule.
         * <p>
         * Default: - no value
         * <p>
         * @return {@code this}
         * @param description The description you specify for the schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Indicates whether the schedule is enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Indicates whether the schedule is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * The date, in UTC, before which the schedule can invoke its target.
         * <p>
         * EventBridge Scheduler ignores end for one-time schedules.
         * <p>
         * Default: - no value
         * <p>
         * @return {@code this}
         * @param end The date, in UTC, before which the schedule can invoke its target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder end(final java.time.Instant end) {
            this.props.end(end);
            return this;
        }

        /**
         * The customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data.
         * <p>
         * Default: - All events in Scheduler are encrypted with a key that AWS owns and manages.
         * <p>
         * @return {@code this}
         * @param key The customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(final software.amazon.awscdk.services.kms.IKey key) {
            this.props.key(key);
            return this;
        }

        /**
         * The schedule's group.
         * <p>
         * Default: - By default a schedule will be associated with the `default` group.
         * <p>
         * @return {@code this}
         * @param scheduleGroup The schedule's group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleGroup(final software.amazon.awscdk.services.scheduler.IScheduleGroup scheduleGroup) {
            this.props.scheduleGroup(scheduleGroup);
            return this;
        }

        /**
         * The name of the schedule.
         * <p>
         * Up to 64 letters (uppercase and lowercase), numbers, hyphens, underscores and dots are allowed.
         * <p>
         * Default: - A unique name will be generated
         * <p>
         * @return {@code this}
         * @param scheduleName The name of the schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleName(final java.lang.String scheduleName) {
            this.props.scheduleName(scheduleName);
            return this;
        }

        /**
         * The date, in UTC, after which the schedule can begin invoking its target.
         * <p>
         * EventBridge Scheduler ignores start for one-time schedules.
         * <p>
         * Default: - no value
         * <p>
         * @return {@code this}
         * @param start The date, in UTC, after which the schedule can begin invoking its target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder start(final java.time.Instant start) {
            this.props.start(start);
            return this;
        }

        /**
         * A time window during which EventBridge Scheduler invokes the schedule.
         * <p>
         * Default: TimeWindow.off()
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-schedule-flexible-time-windows.html">https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-schedule-flexible-time-windows.html</a>
         * @param timeWindow A time window during which EventBridge Scheduler invokes the schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeWindow(final software.amazon.awscdk.services.scheduler.TimeWindow timeWindow) {
            this.props.timeWindow(timeWindow);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.scheduler.Schedule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.scheduler.Schedule build() {
            return new software.amazon.awscdk.services.scheduler.Schedule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
