package software.amazon.awscdk.services.securityhub;

/**
 * The <code>AWS::SecurityHub::Insight</code> resource creates a custom insight in Security Hub .
 * <p>
 * An insight is a collection of findings that relate to a security issue that requires attention or remediation. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-insights.html">Insights in Security Hub</a> in the <em>Security Hub User Guide</em> .
 * <p>
 * Tags aren't supported for this resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securityhub.*;
 * CfnInsight cfnInsight = CfnInsight.Builder.create(this, "MyCfnInsight")
 *         .filters(AwsSecurityFindingFiltersProperty.builder()
 *                 .awsAccountId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .awsAccountName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .companyName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceAssociatedStandardsId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceSecurityControlId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceSecurityControlParametersName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceSecurityControlParametersValue(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceStatus(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .confidence(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .createdAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .criticality(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .description(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .findingProviderFieldsConfidence(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .findingProviderFieldsCriticality(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .findingProviderFieldsRelatedFindingsId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .findingProviderFieldsRelatedFindingsProductArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .findingProviderFieldsSeverityLabel(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .findingProviderFieldsSeverityOriginal(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .findingProviderFieldsTypes(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .firstObservedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .generatorId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .id(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .keyword(List.of(KeywordFilterProperty.builder()
 *                         .value("value")
 *                         .build()))
 *                 .lastObservedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .malwareName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .malwarePath(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .malwareState(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .malwareType(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .networkDestinationDomain(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .networkDestinationIpV4(List.of(IpFilterProperty.builder()
 *                         .cidr("cidr")
 *                         .build()))
 *                 .networkDestinationIpV6(List.of(IpFilterProperty.builder()
 *                         .cidr("cidr")
 *                         .build()))
 *                 .networkDestinationPort(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .networkDirection(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .networkProtocol(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .networkSourceDomain(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .networkSourceIpV4(List.of(IpFilterProperty.builder()
 *                         .cidr("cidr")
 *                         .build()))
 *                 .networkSourceIpV6(List.of(IpFilterProperty.builder()
 *                         .cidr("cidr")
 *                         .build()))
 *                 .networkSourceMac(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .networkSourcePort(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .noteText(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .noteUpdatedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .noteUpdatedBy(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .processLaunchedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .processName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .processParentPid(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .processPath(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .processPid(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .processTerminatedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .productArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .productFields(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .productName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .recommendationText(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .recordState(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .region(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .relatedFindingsId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .relatedFindingsProductArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceApplicationArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceApplicationName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsEc2InstanceIamInstanceProfileArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsEc2InstanceImageId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsEc2InstanceIpV4Addresses(List.of(IpFilterProperty.builder()
 *                         .cidr("cidr")
 *                         .build()))
 *                 .resourceAwsEc2InstanceIpV6Addresses(List.of(IpFilterProperty.builder()
 *                         .cidr("cidr")
 *                         .build()))
 *                 .resourceAwsEc2InstanceKeyName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsEc2InstanceLaunchedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .resourceAwsEc2InstanceSubnetId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsEc2InstanceType(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsEc2InstanceVpcId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsIamAccessKeyCreatedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .resourceAwsIamAccessKeyPrincipalName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsIamAccessKeyStatus(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsIamAccessKeyUserName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsIamUserUserName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsS3BucketOwnerId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceAwsS3BucketOwnerName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceContainerImageId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceContainerImageName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceContainerLaunchedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .resourceContainerName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceDetailsOther(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .resourceId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourcePartition(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceRegion(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceTags(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .resourceType(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .sample(List.of(BooleanFilterProperty.builder()
 *                         .value(false)
 *                         .build()))
 *                 .severityLabel(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .severityNormalized(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .severityProduct(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .sourceUrl(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .threatIntelIndicatorCategory(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .threatIntelIndicatorLastObservedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .threatIntelIndicatorSource(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .threatIntelIndicatorSourceUrl(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .threatIntelIndicatorType(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .threatIntelIndicatorValue(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .title(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .type(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .updatedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .userDefinedFields(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .verificationState(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .vulnerabilitiesExploitAvailable(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .vulnerabilitiesFixAvailable(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .workflowState(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .workflowStatus(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .groupByAttribute("groupByAttribute")
 *         .name("name")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:29.684Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnInsight")
public class CfnInsight extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.securityhub.IInsightRef {

    protected CfnInsight(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInsight(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.securityhub.CfnInsight.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::SecurityHub::Insight</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInsight(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.securityhub.CfnInsightProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForInsight(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.securityhub.IInsightRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.securityhub.CfnInsight.class, "arnForInsight", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnInsight.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnInsight(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.securityhub.CfnInsight.class, "isCfnInsight", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of a Security Hub insight.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrInsightArn() {
        return software.amazon.jsii.Kernel.get(this, "attrInsightArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a Insight resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.securityhub.InsightReference getInsightRef() {
        return software.amazon.jsii.Kernel.get(this, "insightRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.securityhub.InsightReference.class));
    }

    /**
     * One or more attributes used to filter the findings included in the insight.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.AwsSecurityFindingFiltersProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFilters() {
        return software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * One or more attributes used to filter the findings included in the insight.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFilters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "filters", java.util.Objects.requireNonNull(value, "filters is required"));
    }

    /**
     * One or more attributes used to filter the findings included in the insight.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFilters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.securityhub.CfnInsight.AwsSecurityFindingFiltersProperty value) {
        software.amazon.jsii.Kernel.set(this, "filters", java.util.Objects.requireNonNull(value, "filters is required"));
    }

    /**
     * The grouping attribute for the insight's findings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getGroupByAttribute() {
        return software.amazon.jsii.Kernel.get(this, "groupByAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The grouping attribute for the insight's findings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupByAttribute(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "groupByAttribute", java.util.Objects.requireNonNull(value, "groupByAttribute is required"));
    }

    /**
     * The name of a Security Hub insight.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a Security Hub insight.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }
    /**
     * A collection of filters that are applied to all active findings aggregated by Security Hub .
     * <p>
     * You can filter by up to ten finding attributes. For each attribute, you can provide up to 20 filter values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * AwsSecurityFindingFiltersProperty awsSecurityFindingFiltersProperty = AwsSecurityFindingFiltersProperty.builder()
     *         .awsAccountId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .awsAccountName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .companyName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .complianceAssociatedStandardsId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .complianceSecurityControlId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .complianceSecurityControlParametersName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .complianceSecurityControlParametersValue(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .complianceStatus(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .confidence(List.of(NumberFilterProperty.builder()
     *                 .eq(123)
     *                 .gte(123)
     *                 .lte(123)
     *                 .build()))
     *         .createdAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .criticality(List.of(NumberFilterProperty.builder()
     *                 .eq(123)
     *                 .gte(123)
     *                 .lte(123)
     *                 .build()))
     *         .description(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .findingProviderFieldsConfidence(List.of(NumberFilterProperty.builder()
     *                 .eq(123)
     *                 .gte(123)
     *                 .lte(123)
     *                 .build()))
     *         .findingProviderFieldsCriticality(List.of(NumberFilterProperty.builder()
     *                 .eq(123)
     *                 .gte(123)
     *                 .lte(123)
     *                 .build()))
     *         .findingProviderFieldsRelatedFindingsId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .findingProviderFieldsRelatedFindingsProductArn(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .findingProviderFieldsSeverityLabel(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .findingProviderFieldsSeverityOriginal(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .findingProviderFieldsTypes(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .firstObservedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .generatorId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .id(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .keyword(List.of(KeywordFilterProperty.builder()
     *                 .value("value")
     *                 .build()))
     *         .lastObservedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .malwareName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .malwarePath(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .malwareState(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .malwareType(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .networkDestinationDomain(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .networkDestinationIpV4(List.of(IpFilterProperty.builder()
     *                 .cidr("cidr")
     *                 .build()))
     *         .networkDestinationIpV6(List.of(IpFilterProperty.builder()
     *                 .cidr("cidr")
     *                 .build()))
     *         .networkDestinationPort(List.of(NumberFilterProperty.builder()
     *                 .eq(123)
     *                 .gte(123)
     *                 .lte(123)
     *                 .build()))
     *         .networkDirection(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .networkProtocol(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .networkSourceDomain(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .networkSourceIpV4(List.of(IpFilterProperty.builder()
     *                 .cidr("cidr")
     *                 .build()))
     *         .networkSourceIpV6(List.of(IpFilterProperty.builder()
     *                 .cidr("cidr")
     *                 .build()))
     *         .networkSourceMac(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .networkSourcePort(List.of(NumberFilterProperty.builder()
     *                 .eq(123)
     *                 .gte(123)
     *                 .lte(123)
     *                 .build()))
     *         .noteText(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .noteUpdatedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .noteUpdatedBy(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .processLaunchedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .processName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .processParentPid(List.of(NumberFilterProperty.builder()
     *                 .eq(123)
     *                 .gte(123)
     *                 .lte(123)
     *                 .build()))
     *         .processPath(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .processPid(List.of(NumberFilterProperty.builder()
     *                 .eq(123)
     *                 .gte(123)
     *                 .lte(123)
     *                 .build()))
     *         .processTerminatedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .productArn(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .productFields(List.of(MapFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .productName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .recommendationText(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .recordState(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .region(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .relatedFindingsId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .relatedFindingsProductArn(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceApplicationArn(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceApplicationName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceAwsEc2InstanceIamInstanceProfileArn(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceAwsEc2InstanceImageId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceAwsEc2InstanceIpV4Addresses(List.of(IpFilterProperty.builder()
     *                 .cidr("cidr")
     *                 .build()))
     *         .resourceAwsEc2InstanceIpV6Addresses(List.of(IpFilterProperty.builder()
     *                 .cidr("cidr")
     *                 .build()))
     *         .resourceAwsEc2InstanceKeyName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceAwsEc2InstanceLaunchedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .resourceAwsEc2InstanceSubnetId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceAwsEc2InstanceType(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceAwsEc2InstanceVpcId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceAwsIamAccessKeyCreatedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .resourceAwsIamAccessKeyPrincipalName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceAwsIamAccessKeyStatus(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceAwsIamAccessKeyUserName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceAwsIamUserUserName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceAwsS3BucketOwnerId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceAwsS3BucketOwnerName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceContainerImageId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceContainerImageName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceContainerLaunchedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .resourceContainerName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceDetailsOther(List.of(MapFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .resourceId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourcePartition(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceRegion(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceTags(List.of(MapFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .resourceType(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .sample(List.of(BooleanFilterProperty.builder()
     *                 .value(false)
     *                 .build()))
     *         .severityLabel(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .severityNormalized(List.of(NumberFilterProperty.builder()
     *                 .eq(123)
     *                 .gte(123)
     *                 .lte(123)
     *                 .build()))
     *         .severityProduct(List.of(NumberFilterProperty.builder()
     *                 .eq(123)
     *                 .gte(123)
     *                 .lte(123)
     *                 .build()))
     *         .sourceUrl(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .threatIntelIndicatorCategory(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .threatIntelIndicatorLastObservedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .threatIntelIndicatorSource(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .threatIntelIndicatorSourceUrl(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .threatIntelIndicatorType(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .threatIntelIndicatorValue(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .title(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .type(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .updatedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .userDefinedFields(List.of(MapFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .verificationState(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .vulnerabilitiesExploitAvailable(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .vulnerabilitiesFixAvailable(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .workflowState(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .workflowStatus(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnInsight.AwsSecurityFindingFiltersProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsSecurityFindingFiltersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsSecurityFindingFiltersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS account ID in which a finding is generated.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-awsaccountid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsAccountId() {
            return null;
        }

        /**
         * The name of the AWS account in which a finding is generated.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-awsaccountname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-awsaccountname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsAccountName() {
            return null;
        }

        /**
         * The name of the findings provider (company) that owns the solution (product) that generates findings.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-companyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-companyname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompanyName() {
            return null;
        }

        /**
         * The unique identifier of a standard in which a control is enabled.
         * <p>
         * This field consists of the resource portion of the Amazon Resource Name (ARN) returned for a standard in the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html">DescribeStandards</a> API response.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-complianceassociatedstandardsid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-complianceassociatedstandardsid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComplianceAssociatedStandardsId() {
            return null;
        }

        /**
         * The unique identifier of a control across standards.
         * <p>
         * Values for this field typically consist of an AWS service and a number, such as APIGateway.5.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-compliancesecuritycontrolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-compliancesecuritycontrolid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComplianceSecurityControlId() {
            return null;
        }

        /**
         * The name of a security control parameter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-compliancesecuritycontrolparametersname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-compliancesecuritycontrolparametersname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComplianceSecurityControlParametersName() {
            return null;
        }

        /**
         * The current value of a security control parameter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-compliancesecuritycontrolparametersvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-compliancesecuritycontrolparametersvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComplianceSecurityControlParametersValue() {
            return null;
        }

        /**
         * Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS AWS Foundations.
         * <p>
         * Contains security standard-related finding details.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-compliancestatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-compliancestatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComplianceStatus() {
            return null;
        }

        /**
         * A finding's confidence.
         * <p>
         * Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
         * <p>
         * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.NumberFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-confidence">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-confidence</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfidence() {
            return null;
        }

        /**
         * A timestamp that indicates when the security findings provider created the potential security issue that a finding reflects.
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.DateFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-createdat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-createdat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreatedAt() {
            return null;
        }

        /**
         * The level of importance assigned to the resources associated with the finding.
         * <p>
         * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.NumberFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-criticality">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-criticality</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCriticality() {
            return null;
        }

        /**
         * A finding's description.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDescription() {
            return null;
        }

        /**
         * The finding provider value for the finding confidence.
         * <p>
         * Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
         * <p>
         * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.NumberFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldsconfidence">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldsconfidence</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFindingProviderFieldsConfidence() {
            return null;
        }

        /**
         * The finding provider value for the level of importance assigned to the resources associated with the findings.
         * <p>
         * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.NumberFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldscriticality">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldscriticality</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFindingProviderFieldsCriticality() {
            return null;
        }

        /**
         * The finding identifier of a related finding that is identified by the finding provider.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldsrelatedfindingsid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldsrelatedfindingsid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFindingProviderFieldsRelatedFindingsId() {
            return null;
        }

        /**
         * The ARN of the solution that generated a related finding that is identified by the finding provider.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldsrelatedfindingsproductarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldsrelatedfindingsproductarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFindingProviderFieldsRelatedFindingsProductArn() {
            return null;
        }

        /**
         * The finding provider value for the severity label.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldsseveritylabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldsseveritylabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFindingProviderFieldsSeverityLabel() {
            return null;
        }

        /**
         * The finding provider's original value for the severity.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldsseverityoriginal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldsseverityoriginal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFindingProviderFieldsSeverityOriginal() {
            return null;
        }

        /**
         * One or more finding types that the finding provider assigned to the finding.
         * <p>
         * Uses the format of <code>namespace/category/classifier</code> that classify a finding.
         * <p>
         * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldstypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-findingproviderfieldstypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFindingProviderFieldsTypes() {
            return null;
        }

        /**
         * A timestamp that indicates when the security findings provider first observed the potential security issue that a finding captured.
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.DateFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-firstobservedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-firstobservedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFirstObservedAt() {
            return null;
        }

        /**
         * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding.
         * <p>
         * In various security findings providers' solutions, this generator can be called a rule, a check, a detector, a plugin, etc.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-generatorid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-generatorid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGeneratorId() {
            return null;
        }

        /**
         * The security findings provider-specific identifier for a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getId() {
            return null;
        }

        /**
         * This field is deprecated.
         * <p>
         * A keyword for a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.KeywordFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-keyword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-keyword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyword() {
            return null;
        }

        /**
         * A timestamp that indicates when the security findings provider most recently observed a change in the resource that is involved in the finding.
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.DateFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-lastobservedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-lastobservedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLastObservedAt() {
            return null;
        }

        /**
         * The name of the malware that was observed.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-malwarename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-malwarename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMalwareName() {
            return null;
        }

        /**
         * The filesystem path of the malware that was observed.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-malwarepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-malwarepath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMalwarePath() {
            return null;
        }

        /**
         * The state of the malware that was observed.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-malwarestate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-malwarestate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMalwareState() {
            return null;
        }

        /**
         * The type of the malware that was observed.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-malwaretype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-malwaretype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMalwareType() {
            return null;
        }

        /**
         * The destination domain of network-related information about a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networkdestinationdomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networkdestinationdomain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkDestinationDomain() {
            return null;
        }

        /**
         * The destination IPv4 address of network-related information about a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.IpFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networkdestinationipv4">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networkdestinationipv4</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkDestinationIpV4() {
            return null;
        }

        /**
         * The destination IPv6 address of network-related information about a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.IpFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networkdestinationipv6">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networkdestinationipv6</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkDestinationIpV6() {
            return null;
        }

        /**
         * The destination port of network-related information about a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.NumberFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networkdestinationport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networkdestinationport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkDestinationPort() {
            return null;
        }

        /**
         * Indicates the direction of network traffic associated with a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networkdirection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networkdirection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkDirection() {
            return null;
        }

        /**
         * The protocol of network-related information about a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networkprotocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networkprotocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkProtocol() {
            return null;
        }

        /**
         * The source domain of network-related information about a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networksourcedomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networksourcedomain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkSourceDomain() {
            return null;
        }

        /**
         * The source IPv4 address of network-related information about a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.IpFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networksourceipv4">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networksourceipv4</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkSourceIpV4() {
            return null;
        }

        /**
         * The source IPv6 address of network-related information about a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.IpFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networksourceipv6">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networksourceipv6</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkSourceIpV6() {
            return null;
        }

        /**
         * The source media access control (MAC) address of network-related information about a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networksourcemac">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networksourcemac</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkSourceMac() {
            return null;
        }

        /**
         * The source port of network-related information about a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.NumberFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networksourceport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-networksourceport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkSourcePort() {
            return null;
        }

        /**
         * The text of a note.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-notetext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-notetext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoteText() {
            return null;
        }

        /**
         * The timestamp of when the note was updated.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.DateFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-noteupdatedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-noteupdatedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoteUpdatedAt() {
            return null;
        }

        /**
         * The principal that created a note.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-noteupdatedby">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-noteupdatedby</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoteUpdatedBy() {
            return null;
        }

        /**
         * A timestamp that identifies when the process was launched.
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.DateFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-processlaunchedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-processlaunchedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessLaunchedAt() {
            return null;
        }

        /**
         * The name of the process.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-processname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-processname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessName() {
            return null;
        }

        /**
         * The parent process ID.
         * <p>
         * This field accepts positive integers between <code>O</code> and <code>2147483647</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.NumberFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-processparentpid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-processparentpid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessParentPid() {
            return null;
        }

        /**
         * The path to the process executable.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-processpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-processpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessPath() {
            return null;
        }

        /**
         * The process ID.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.NumberFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-processpid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-processpid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessPid() {
            return null;
        }

        /**
         * A timestamp that identifies when the process was terminated.
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.DateFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-processterminatedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-processterminatedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessTerminatedAt() {
            return null;
        }

        /**
         * The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-productarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-productarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProductArn() {
            return null;
        }

        /**
         * A data type where security findings providers can include additional solution-specific details that aren't part of the defined <code>AwsSecurityFinding</code> format.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.MapFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-productfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-productfields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProductFields() {
            return null;
        }

        /**
         * The name of the solution (product) that generates findings.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-productname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-productname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProductName() {
            return null;
        }

        /**
         * The recommendation of what to do about the issue described in a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-recommendationtext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-recommendationtext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRecommendationText() {
            return null;
        }

        /**
         * The updated record state for the finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-recordstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-recordstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRecordState() {
            return null;
        }

        /**
         * The Region from which the finding was generated.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRegion() {
            return null;
        }

        /**
         * The solution-generated identifier for a related finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-relatedfindingsid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-relatedfindingsid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelatedFindingsId() {
            return null;
        }

        /**
         * The ARN of the solution that generated a related finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-relatedfindingsproductarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-relatedfindingsproductarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelatedFindingsProductArn() {
            return null;
        }

        /**
         * The ARN of the application that is related to a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceapplicationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceapplicationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceApplicationArn() {
            return null;
        }

        /**
         * The name of the application that is related to a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceapplicationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceapplicationname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceApplicationName() {
            return null;
        }

        /**
         * The IAM profile ARN of the instance.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instanceiaminstanceprofilearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instanceiaminstanceprofilearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsEc2InstanceIamInstanceProfileArn() {
            return null;
        }

        /**
         * The Amazon Machine Image (AMI) ID of the instance.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instanceimageid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instanceimageid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsEc2InstanceImageId() {
            return null;
        }

        /**
         * The IPv4 addresses associated with the instance.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.IpFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instanceipv4addresses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instanceipv4addresses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsEc2InstanceIpV4Addresses() {
            return null;
        }

        /**
         * The IPv6 addresses associated with the instance.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.IpFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instanceipv6addresses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instanceipv6addresses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsEc2InstanceIpV6Addresses() {
            return null;
        }

        /**
         * The key name associated with the instance.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instancekeyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instancekeyname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsEc2InstanceKeyName() {
            return null;
        }

        /**
         * The date and time the instance was launched.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.DateFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instancelaunchedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instancelaunchedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsEc2InstanceLaunchedAt() {
            return null;
        }

        /**
         * The identifier of the subnet that the instance was launched in.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instancesubnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instancesubnetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsEc2InstanceSubnetId() {
            return null;
        }

        /**
         * The instance type of the instance.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsEc2InstanceType() {
            return null;
        }

        /**
         * The identifier of the VPC that the instance was launched in.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instancevpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsec2instancevpcid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsEc2InstanceVpcId() {
            return null;
        }

        /**
         * The creation date/time of the IAM access key related to a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.DateFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsiamaccesskeycreatedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsiamaccesskeycreatedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsIamAccessKeyCreatedAt() {
            return null;
        }

        /**
         * The name of the principal that is associated with an IAM access key.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsiamaccesskeyprincipalname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsiamaccesskeyprincipalname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsIamAccessKeyPrincipalName() {
            return null;
        }

        /**
         * The status of the IAM access key related to a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsiamaccesskeystatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsiamaccesskeystatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsIamAccessKeyStatus() {
            return null;
        }

        /**
         * This field is deprecated.
         * <p>
         * The username associated with the IAM access key related to a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsiamaccesskeyusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsiamaccesskeyusername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsIamAccessKeyUserName() {
            return null;
        }

        /**
         * The name of an IAM user.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsiamuserusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawsiamuserusername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsIamUserUserName() {
            return null;
        }

        /**
         * The canonical user ID of the owner of the S3 bucket.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawss3bucketownerid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawss3bucketownerid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsS3BucketOwnerId() {
            return null;
        }

        /**
         * The display name of the owner of the S3 bucket.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawss3bucketownername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceawss3bucketownername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAwsS3BucketOwnerName() {
            return null;
        }

        /**
         * The identifier of the image related to a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcecontainerimageid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcecontainerimageid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceContainerImageId() {
            return null;
        }

        /**
         * The name of the image related to a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcecontainerimagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcecontainerimagename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceContainerImageName() {
            return null;
        }

        /**
         * A timestamp that identifies when the container was started.
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.DateFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcecontainerlaunchedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcecontainerlaunchedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceContainerLaunchedAt() {
            return null;
        }

        /**
         * The name of the container related to a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcecontainername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcecontainername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceContainerName() {
            return null;
        }

        /**
         * The details of a resource that doesn't have a specific subfield for the resource type defined.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.MapFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcedetailsother">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcedetailsother</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceDetailsOther() {
            return null;
        }

        /**
         * The canonical identifier for the given resource type.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceId() {
            return null;
        }

        /**
         * The canonical AWS partition name that the Region is assigned to.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcepartition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcepartition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourcePartition() {
            return null;
        }

        /**
         * The canonical AWS external Region name where this resource is located.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourceregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceRegion() {
            return null;
        }

        /**
         * A list of AWS tags associated with a resource at the time the finding was processed.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.MapFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcetags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceTags() {
            return null;
        }

        /**
         * Specifies the type of the resource that details are provided for.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-resourcetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceType() {
            return null;
        }

        /**
         * Indicates whether or not sample findings are included in the filter results.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.BooleanFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-sample">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-sample</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSample() {
            return null;
        }

        /**
         * The label of a finding's severity.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-severitylabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-severitylabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSeverityLabel() {
            return null;
        }

        /**
         * Deprecated. The normalized severity of a finding. Instead of providing <code>Normalized</code> , provide <code>Label</code> .
         * <p>
         * The value of <code>Normalized</code> can be an integer between <code>0</code> and <code>100</code> .
         * <p>
         * If you provide <code>Label</code> and don't provide <code>Normalized</code> , then <code>Normalized</code> is set automatically as follows.
         * <p>
         * <ul>
         * <li><code>INFORMATIONAL</code> - 0</li>
         * <li><code>LOW</code> - 1</li>
         * <li><code>MEDIUM</code> - 40</li>
         * <li><code>HIGH</code> - 70</li>
         * <li><code>CRITICAL</code> - 90</li>
         * </ul>
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.NumberFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-severitynormalized">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-severitynormalized</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSeverityNormalized() {
            return null;
        }

        /**
         * Deprecated. This attribute isn't included in findings. Instead of providing <code>Product</code> , provide <code>Original</code> .
         * <p>
         * The native severity as defined by the AWS service or integrated partner product that generated the finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.NumberFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-severityproduct">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-severityproduct</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSeverityProduct() {
            return null;
        }

        /**
         * A URL that links to a page about the current finding in the security findings provider's solution.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-sourceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-sourceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceUrl() {
            return null;
        }

        /**
         * The category of a threat intelligence indicator.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-threatintelindicatorcategory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-threatintelindicatorcategory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getThreatIntelIndicatorCategory() {
            return null;
        }

        /**
         * A timestamp that identifies the last observation of a threat intelligence indicator.
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.DateFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-threatintelindicatorlastobservedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-threatintelindicatorlastobservedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getThreatIntelIndicatorLastObservedAt() {
            return null;
        }

        /**
         * The source of the threat intelligence.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-threatintelindicatorsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-threatintelindicatorsource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getThreatIntelIndicatorSource() {
            return null;
        }

        /**
         * The URL for more details from the source of the threat intelligence.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-threatintelindicatorsourceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-threatintelindicatorsourceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getThreatIntelIndicatorSourceUrl() {
            return null;
        }

        /**
         * The type of a threat intelligence indicator.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-threatintelindicatortype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-threatintelindicatortype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getThreatIntelIndicatorType() {
            return null;
        }

        /**
         * The value of a threat intelligence indicator.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-threatintelindicatorvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-threatintelindicatorvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getThreatIntelIndicatorValue() {
            return null;
        }

        /**
         * A finding's title.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTitle() {
            return null;
        }

        /**
         * A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getType() {
            return null;
        }

        /**
         * A timestamp that indicates when the security findings provider last updated the finding record.
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.DateFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-updatedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-updatedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpdatedAt() {
            return null;
        }

        /**
         * A list of name/value string pairs associated with the finding.
         * <p>
         * These are custom, user-defined fields added to a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.MapFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-userdefinedfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-userdefinedfields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserDefinedFields() {
            return null;
        }

        /**
         * The veracity of a finding.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-verificationstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-verificationstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVerificationState() {
            return null;
        }

        /**
         * Indicates whether a software vulnerability in your environment has a known exploit.
         * <p>
         * You can filter findings by this field only if you use Security Hub and Amazon Inspector.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-vulnerabilitiesexploitavailable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-vulnerabilitiesexploitavailable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVulnerabilitiesExploitAvailable() {
            return null;
        }

        /**
         * Indicates whether a vulnerability is fixed in a newer version of the affected software packages.
         * <p>
         * You can filter findings by this field only if you use Security Hub and Amazon Inspector.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-vulnerabilitiesfixavailable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-vulnerabilitiesfixavailable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVulnerabilitiesFixAvailable() {
            return null;
        }

        /**
         * The workflow state of a finding.
         * <p>
         * Note that this field is deprecated. To search for a finding based on its workflow status, use <code>WorkflowStatus</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-workflowstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-workflowstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWorkflowState() {
            return null;
        }

        /**
         * The status of the investigation into a finding. Allowed values are the following.
         * <p>
         * <ul>
         * <li><code>NEW</code> - The initial state of a finding, before it is reviewed.</li>
         * </ul>
         * <p>
         * Security Hub also resets the workflow status from <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the following cases:
         * <p>
         * <ul>
         * <li><code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .</li>
         * <li><code>Compliance.Status</code> changes from <code>PASSED</code> to either <code>WARNING</code> , <code>FAILED</code> , or <code>NOT_AVAILABLE</code> .</li>
         * <li><code>NOTIFIED</code> - Indicates that the resource owner has been notified about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.</li>
         * </ul>
         * <p>
         * If one of the following occurs, the workflow status is changed automatically from <code>NOTIFIED</code> to <code>NEW</code> :
         * <p>
         * <ul>
         * <li><code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .</li>
         * <li><code>Compliance.Status</code> changes from <code>PASSED</code> to <code>FAILED</code> , <code>WARNING</code> , or <code>NOT_AVAILABLE</code> .</li>
         * <li><code>SUPPRESSED</code> - Indicates that you reviewed the finding and don't believe that any action is needed.</li>
         * </ul>
         * <p>
         * The workflow status of a <code>SUPPRESSED</code> finding does not change if <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .
         * <p>
         * <ul>
         * <li><code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.</li>
         * </ul>
         * <p>
         * The finding remains <code>RESOLVED</code> unless one of the following occurs:
         * <p>
         * <ul>
         * <li><code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .</li>
         * <li><code>Compliance.Status</code> changes from <code>PASSED</code> to <code>FAILED</code> , <code>WARNING</code> , or <code>NOT_AVAILABLE</code> .</li>
         * </ul>
         * <p>
         * In those cases, the workflow status is automatically reset to <code>NEW</code> .
         * <p>
         * For findings from controls, if <code>Compliance.Status</code> is <code>PASSED</code> , then Security Hub automatically sets the workflow status to <code>RESOLVED</code> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.StringFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-workflowstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-awssecurityfindingfilters.html#cfn-securityhub-insight-awssecurityfindingfilters-workflowstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWorkflowStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AwsSecurityFindingFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsSecurityFindingFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsSecurityFindingFiltersProperty> {
            java.lang.Object awsAccountId;
            java.lang.Object awsAccountName;
            java.lang.Object companyName;
            java.lang.Object complianceAssociatedStandardsId;
            java.lang.Object complianceSecurityControlId;
            java.lang.Object complianceSecurityControlParametersName;
            java.lang.Object complianceSecurityControlParametersValue;
            java.lang.Object complianceStatus;
            java.lang.Object confidence;
            java.lang.Object createdAt;
            java.lang.Object criticality;
            java.lang.Object description;
            java.lang.Object findingProviderFieldsConfidence;
            java.lang.Object findingProviderFieldsCriticality;
            java.lang.Object findingProviderFieldsRelatedFindingsId;
            java.lang.Object findingProviderFieldsRelatedFindingsProductArn;
            java.lang.Object findingProviderFieldsSeverityLabel;
            java.lang.Object findingProviderFieldsSeverityOriginal;
            java.lang.Object findingProviderFieldsTypes;
            java.lang.Object firstObservedAt;
            java.lang.Object generatorId;
            java.lang.Object id;
            java.lang.Object keyword;
            java.lang.Object lastObservedAt;
            java.lang.Object malwareName;
            java.lang.Object malwarePath;
            java.lang.Object malwareState;
            java.lang.Object malwareType;
            java.lang.Object networkDestinationDomain;
            java.lang.Object networkDestinationIpV4;
            java.lang.Object networkDestinationIpV6;
            java.lang.Object networkDestinationPort;
            java.lang.Object networkDirection;
            java.lang.Object networkProtocol;
            java.lang.Object networkSourceDomain;
            java.lang.Object networkSourceIpV4;
            java.lang.Object networkSourceIpV6;
            java.lang.Object networkSourceMac;
            java.lang.Object networkSourcePort;
            java.lang.Object noteText;
            java.lang.Object noteUpdatedAt;
            java.lang.Object noteUpdatedBy;
            java.lang.Object processLaunchedAt;
            java.lang.Object processName;
            java.lang.Object processParentPid;
            java.lang.Object processPath;
            java.lang.Object processPid;
            java.lang.Object processTerminatedAt;
            java.lang.Object productArn;
            java.lang.Object productFields;
            java.lang.Object productName;
            java.lang.Object recommendationText;
            java.lang.Object recordState;
            java.lang.Object region;
            java.lang.Object relatedFindingsId;
            java.lang.Object relatedFindingsProductArn;
            java.lang.Object resourceApplicationArn;
            java.lang.Object resourceApplicationName;
            java.lang.Object resourceAwsEc2InstanceIamInstanceProfileArn;
            java.lang.Object resourceAwsEc2InstanceImageId;
            java.lang.Object resourceAwsEc2InstanceIpV4Addresses;
            java.lang.Object resourceAwsEc2InstanceIpV6Addresses;
            java.lang.Object resourceAwsEc2InstanceKeyName;
            java.lang.Object resourceAwsEc2InstanceLaunchedAt;
            java.lang.Object resourceAwsEc2InstanceSubnetId;
            java.lang.Object resourceAwsEc2InstanceType;
            java.lang.Object resourceAwsEc2InstanceVpcId;
            java.lang.Object resourceAwsIamAccessKeyCreatedAt;
            java.lang.Object resourceAwsIamAccessKeyPrincipalName;
            java.lang.Object resourceAwsIamAccessKeyStatus;
            java.lang.Object resourceAwsIamAccessKeyUserName;
            java.lang.Object resourceAwsIamUserUserName;
            java.lang.Object resourceAwsS3BucketOwnerId;
            java.lang.Object resourceAwsS3BucketOwnerName;
            java.lang.Object resourceContainerImageId;
            java.lang.Object resourceContainerImageName;
            java.lang.Object resourceContainerLaunchedAt;
            java.lang.Object resourceContainerName;
            java.lang.Object resourceDetailsOther;
            java.lang.Object resourceId;
            java.lang.Object resourcePartition;
            java.lang.Object resourceRegion;
            java.lang.Object resourceTags;
            java.lang.Object resourceType;
            java.lang.Object sample;
            java.lang.Object severityLabel;
            java.lang.Object severityNormalized;
            java.lang.Object severityProduct;
            java.lang.Object sourceUrl;
            java.lang.Object threatIntelIndicatorCategory;
            java.lang.Object threatIntelIndicatorLastObservedAt;
            java.lang.Object threatIntelIndicatorSource;
            java.lang.Object threatIntelIndicatorSourceUrl;
            java.lang.Object threatIntelIndicatorType;
            java.lang.Object threatIntelIndicatorValue;
            java.lang.Object title;
            java.lang.Object type;
            java.lang.Object updatedAt;
            java.lang.Object userDefinedFields;
            java.lang.Object verificationState;
            java.lang.Object vulnerabilitiesExploitAvailable;
            java.lang.Object vulnerabilitiesFixAvailable;
            java.lang.Object workflowState;
            java.lang.Object workflowStatus;

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getAwsAccountId}
             * @param awsAccountId The AWS account ID in which a finding is generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountId(software.amazon.awscdk.IResolvable awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getAwsAccountId}
             * @param awsAccountId The AWS account ID in which a finding is generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountId(java.util.List<? extends java.lang.Object> awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getAwsAccountName}
             * @param awsAccountName The name of the AWS account in which a finding is generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountName(software.amazon.awscdk.IResolvable awsAccountName) {
                this.awsAccountName = awsAccountName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getAwsAccountName}
             * @param awsAccountName The name of the AWS account in which a finding is generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountName(java.util.List<? extends java.lang.Object> awsAccountName) {
                this.awsAccountName = awsAccountName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getCompanyName}
             * @param companyName The name of the findings provider (company) that owns the solution (product) that generates findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder companyName(software.amazon.awscdk.IResolvable companyName) {
                this.companyName = companyName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getCompanyName}
             * @param companyName The name of the findings provider (company) that owns the solution (product) that generates findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder companyName(java.util.List<? extends java.lang.Object> companyName) {
                this.companyName = companyName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getComplianceAssociatedStandardsId}
             * @param complianceAssociatedStandardsId The unique identifier of a standard in which a control is enabled.
             *                                        This field consists of the resource portion of the Amazon Resource Name (ARN) returned for a standard in the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html">DescribeStandards</a> API response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceAssociatedStandardsId(software.amazon.awscdk.IResolvable complianceAssociatedStandardsId) {
                this.complianceAssociatedStandardsId = complianceAssociatedStandardsId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getComplianceAssociatedStandardsId}
             * @param complianceAssociatedStandardsId The unique identifier of a standard in which a control is enabled.
             *                                        This field consists of the resource portion of the Amazon Resource Name (ARN) returned for a standard in the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html">DescribeStandards</a> API response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceAssociatedStandardsId(java.util.List<? extends java.lang.Object> complianceAssociatedStandardsId) {
                this.complianceAssociatedStandardsId = complianceAssociatedStandardsId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getComplianceSecurityControlId}
             * @param complianceSecurityControlId The unique identifier of a control across standards.
             *                                    Values for this field typically consist of an AWS service and a number, such as APIGateway.5.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceSecurityControlId(software.amazon.awscdk.IResolvable complianceSecurityControlId) {
                this.complianceSecurityControlId = complianceSecurityControlId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getComplianceSecurityControlId}
             * @param complianceSecurityControlId The unique identifier of a control across standards.
             *                                    Values for this field typically consist of an AWS service and a number, such as APIGateway.5.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceSecurityControlId(java.util.List<? extends java.lang.Object> complianceSecurityControlId) {
                this.complianceSecurityControlId = complianceSecurityControlId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getComplianceSecurityControlParametersName}
             * @param complianceSecurityControlParametersName The name of a security control parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceSecurityControlParametersName(software.amazon.awscdk.IResolvable complianceSecurityControlParametersName) {
                this.complianceSecurityControlParametersName = complianceSecurityControlParametersName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getComplianceSecurityControlParametersName}
             * @param complianceSecurityControlParametersName The name of a security control parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceSecurityControlParametersName(java.util.List<? extends java.lang.Object> complianceSecurityControlParametersName) {
                this.complianceSecurityControlParametersName = complianceSecurityControlParametersName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getComplianceSecurityControlParametersValue}
             * @param complianceSecurityControlParametersValue The current value of a security control parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceSecurityControlParametersValue(software.amazon.awscdk.IResolvable complianceSecurityControlParametersValue) {
                this.complianceSecurityControlParametersValue = complianceSecurityControlParametersValue;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getComplianceSecurityControlParametersValue}
             * @param complianceSecurityControlParametersValue The current value of a security control parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceSecurityControlParametersValue(java.util.List<? extends java.lang.Object> complianceSecurityControlParametersValue) {
                this.complianceSecurityControlParametersValue = complianceSecurityControlParametersValue;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getComplianceStatus}
             * @param complianceStatus Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS AWS Foundations.
             *                         Contains security standard-related finding details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceStatus(software.amazon.awscdk.IResolvable complianceStatus) {
                this.complianceStatus = complianceStatus;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getComplianceStatus}
             * @param complianceStatus Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS AWS Foundations.
             *                         Contains security standard-related finding details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceStatus(java.util.List<? extends java.lang.Object> complianceStatus) {
                this.complianceStatus = complianceStatus;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getConfidence}
             * @param confidence A finding's confidence.
             *                   Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
             *                   <p>
             *                   Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confidence(software.amazon.awscdk.IResolvable confidence) {
                this.confidence = confidence;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getConfidence}
             * @param confidence A finding's confidence.
             *                   Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
             *                   <p>
             *                   Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confidence(java.util.List<? extends java.lang.Object> confidence) {
                this.confidence = confidence;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getCreatedAt}
             * @param createdAt A timestamp that indicates when the security findings provider created the potential security issue that a finding reflects.
             *                  For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdAt(software.amazon.awscdk.IResolvable createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getCreatedAt}
             * @param createdAt A timestamp that indicates when the security findings provider created the potential security issue that a finding reflects.
             *                  For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdAt(java.util.List<? extends java.lang.Object> createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getCriticality}
             * @param criticality The level of importance assigned to the resources associated with the finding.
             *                    A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criticality(software.amazon.awscdk.IResolvable criticality) {
                this.criticality = criticality;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getCriticality}
             * @param criticality The level of importance assigned to the resources associated with the finding.
             *                    A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criticality(java.util.List<? extends java.lang.Object> criticality) {
                this.criticality = criticality;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getDescription}
             * @param description A finding's description.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(software.amazon.awscdk.IResolvable description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getDescription}
             * @param description A finding's description.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.util.List<? extends java.lang.Object> description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsConfidence}
             * @param findingProviderFieldsConfidence The finding provider value for the finding confidence.
             *                                        Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
             *                                        <p>
             *                                        Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsConfidence(software.amazon.awscdk.IResolvable findingProviderFieldsConfidence) {
                this.findingProviderFieldsConfidence = findingProviderFieldsConfidence;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsConfidence}
             * @param findingProviderFieldsConfidence The finding provider value for the finding confidence.
             *                                        Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
             *                                        <p>
             *                                        Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsConfidence(java.util.List<? extends java.lang.Object> findingProviderFieldsConfidence) {
                this.findingProviderFieldsConfidence = findingProviderFieldsConfidence;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsCriticality}
             * @param findingProviderFieldsCriticality The finding provider value for the level of importance assigned to the resources associated with the findings.
             *                                         A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsCriticality(software.amazon.awscdk.IResolvable findingProviderFieldsCriticality) {
                this.findingProviderFieldsCriticality = findingProviderFieldsCriticality;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsCriticality}
             * @param findingProviderFieldsCriticality The finding provider value for the level of importance assigned to the resources associated with the findings.
             *                                         A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsCriticality(java.util.List<? extends java.lang.Object> findingProviderFieldsCriticality) {
                this.findingProviderFieldsCriticality = findingProviderFieldsCriticality;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsRelatedFindingsId}
             * @param findingProviderFieldsRelatedFindingsId The finding identifier of a related finding that is identified by the finding provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsRelatedFindingsId(software.amazon.awscdk.IResolvable findingProviderFieldsRelatedFindingsId) {
                this.findingProviderFieldsRelatedFindingsId = findingProviderFieldsRelatedFindingsId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsRelatedFindingsId}
             * @param findingProviderFieldsRelatedFindingsId The finding identifier of a related finding that is identified by the finding provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsRelatedFindingsId(java.util.List<? extends java.lang.Object> findingProviderFieldsRelatedFindingsId) {
                this.findingProviderFieldsRelatedFindingsId = findingProviderFieldsRelatedFindingsId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsRelatedFindingsProductArn}
             * @param findingProviderFieldsRelatedFindingsProductArn The ARN of the solution that generated a related finding that is identified by the finding provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsRelatedFindingsProductArn(software.amazon.awscdk.IResolvable findingProviderFieldsRelatedFindingsProductArn) {
                this.findingProviderFieldsRelatedFindingsProductArn = findingProviderFieldsRelatedFindingsProductArn;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsRelatedFindingsProductArn}
             * @param findingProviderFieldsRelatedFindingsProductArn The ARN of the solution that generated a related finding that is identified by the finding provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsRelatedFindingsProductArn(java.util.List<? extends java.lang.Object> findingProviderFieldsRelatedFindingsProductArn) {
                this.findingProviderFieldsRelatedFindingsProductArn = findingProviderFieldsRelatedFindingsProductArn;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsSeverityLabel}
             * @param findingProviderFieldsSeverityLabel The finding provider value for the severity label.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsSeverityLabel(software.amazon.awscdk.IResolvable findingProviderFieldsSeverityLabel) {
                this.findingProviderFieldsSeverityLabel = findingProviderFieldsSeverityLabel;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsSeverityLabel}
             * @param findingProviderFieldsSeverityLabel The finding provider value for the severity label.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsSeverityLabel(java.util.List<? extends java.lang.Object> findingProviderFieldsSeverityLabel) {
                this.findingProviderFieldsSeverityLabel = findingProviderFieldsSeverityLabel;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsSeverityOriginal}
             * @param findingProviderFieldsSeverityOriginal The finding provider's original value for the severity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsSeverityOriginal(software.amazon.awscdk.IResolvable findingProviderFieldsSeverityOriginal) {
                this.findingProviderFieldsSeverityOriginal = findingProviderFieldsSeverityOriginal;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsSeverityOriginal}
             * @param findingProviderFieldsSeverityOriginal The finding provider's original value for the severity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsSeverityOriginal(java.util.List<? extends java.lang.Object> findingProviderFieldsSeverityOriginal) {
                this.findingProviderFieldsSeverityOriginal = findingProviderFieldsSeverityOriginal;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsTypes}
             * @param findingProviderFieldsTypes One or more finding types that the finding provider assigned to the finding.
             *                                   Uses the format of <code>namespace/category/classifier</code> that classify a finding.
             *                                   <p>
             *                                   Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsTypes(software.amazon.awscdk.IResolvable findingProviderFieldsTypes) {
                this.findingProviderFieldsTypes = findingProviderFieldsTypes;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFindingProviderFieldsTypes}
             * @param findingProviderFieldsTypes One or more finding types that the finding provider assigned to the finding.
             *                                   Uses the format of <code>namespace/category/classifier</code> that classify a finding.
             *                                   <p>
             *                                   Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingProviderFieldsTypes(java.util.List<? extends java.lang.Object> findingProviderFieldsTypes) {
                this.findingProviderFieldsTypes = findingProviderFieldsTypes;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFirstObservedAt}
             * @param firstObservedAt A timestamp that indicates when the security findings provider first observed the potential security issue that a finding captured.
             *                        For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstObservedAt(software.amazon.awscdk.IResolvable firstObservedAt) {
                this.firstObservedAt = firstObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getFirstObservedAt}
             * @param firstObservedAt A timestamp that indicates when the security findings provider first observed the potential security issue that a finding captured.
             *                        For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstObservedAt(java.util.List<? extends java.lang.Object> firstObservedAt) {
                this.firstObservedAt = firstObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getGeneratorId}
             * @param generatorId The identifier for the solution-specific component (a discrete unit of logic) that generated a finding.
             *                    In various security findings providers' solutions, this generator can be called a rule, a check, a detector, a plugin, etc.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generatorId(software.amazon.awscdk.IResolvable generatorId) {
                this.generatorId = generatorId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getGeneratorId}
             * @param generatorId The identifier for the solution-specific component (a discrete unit of logic) that generated a finding.
             *                    In various security findings providers' solutions, this generator can be called a rule, a check, a detector, a plugin, etc.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generatorId(java.util.List<? extends java.lang.Object> generatorId) {
                this.generatorId = generatorId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getId}
             * @param id The security findings provider-specific identifier for a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(software.amazon.awscdk.IResolvable id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getId}
             * @param id The security findings provider-specific identifier for a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.util.List<? extends java.lang.Object> id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getKeyword}
             * @param keyword This field is deprecated.
             *                A keyword for a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyword(software.amazon.awscdk.IResolvable keyword) {
                this.keyword = keyword;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getKeyword}
             * @param keyword This field is deprecated.
             *                A keyword for a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyword(java.util.List<? extends java.lang.Object> keyword) {
                this.keyword = keyword;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getLastObservedAt}
             * @param lastObservedAt A timestamp that indicates when the security findings provider most recently observed a change in the resource that is involved in the finding.
             *                       For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastObservedAt(software.amazon.awscdk.IResolvable lastObservedAt) {
                this.lastObservedAt = lastObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getLastObservedAt}
             * @param lastObservedAt A timestamp that indicates when the security findings provider most recently observed a change in the resource that is involved in the finding.
             *                       For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastObservedAt(java.util.List<? extends java.lang.Object> lastObservedAt) {
                this.lastObservedAt = lastObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getMalwareName}
             * @param malwareName The name of the malware that was observed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder malwareName(software.amazon.awscdk.IResolvable malwareName) {
                this.malwareName = malwareName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getMalwareName}
             * @param malwareName The name of the malware that was observed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder malwareName(java.util.List<? extends java.lang.Object> malwareName) {
                this.malwareName = malwareName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getMalwarePath}
             * @param malwarePath The filesystem path of the malware that was observed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder malwarePath(software.amazon.awscdk.IResolvable malwarePath) {
                this.malwarePath = malwarePath;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getMalwarePath}
             * @param malwarePath The filesystem path of the malware that was observed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder malwarePath(java.util.List<? extends java.lang.Object> malwarePath) {
                this.malwarePath = malwarePath;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getMalwareState}
             * @param malwareState The state of the malware that was observed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder malwareState(software.amazon.awscdk.IResolvable malwareState) {
                this.malwareState = malwareState;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getMalwareState}
             * @param malwareState The state of the malware that was observed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder malwareState(java.util.List<? extends java.lang.Object> malwareState) {
                this.malwareState = malwareState;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getMalwareType}
             * @param malwareType The type of the malware that was observed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder malwareType(software.amazon.awscdk.IResolvable malwareType) {
                this.malwareType = malwareType;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getMalwareType}
             * @param malwareType The type of the malware that was observed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder malwareType(java.util.List<? extends java.lang.Object> malwareType) {
                this.malwareType = malwareType;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkDestinationDomain}
             * @param networkDestinationDomain The destination domain of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkDestinationDomain(software.amazon.awscdk.IResolvable networkDestinationDomain) {
                this.networkDestinationDomain = networkDestinationDomain;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkDestinationDomain}
             * @param networkDestinationDomain The destination domain of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkDestinationDomain(java.util.List<? extends java.lang.Object> networkDestinationDomain) {
                this.networkDestinationDomain = networkDestinationDomain;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkDestinationIpV4}
             * @param networkDestinationIpV4 The destination IPv4 address of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkDestinationIpV4(software.amazon.awscdk.IResolvable networkDestinationIpV4) {
                this.networkDestinationIpV4 = networkDestinationIpV4;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkDestinationIpV4}
             * @param networkDestinationIpV4 The destination IPv4 address of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkDestinationIpV4(java.util.List<? extends java.lang.Object> networkDestinationIpV4) {
                this.networkDestinationIpV4 = networkDestinationIpV4;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkDestinationIpV6}
             * @param networkDestinationIpV6 The destination IPv6 address of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkDestinationIpV6(software.amazon.awscdk.IResolvable networkDestinationIpV6) {
                this.networkDestinationIpV6 = networkDestinationIpV6;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkDestinationIpV6}
             * @param networkDestinationIpV6 The destination IPv6 address of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkDestinationIpV6(java.util.List<? extends java.lang.Object> networkDestinationIpV6) {
                this.networkDestinationIpV6 = networkDestinationIpV6;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkDestinationPort}
             * @param networkDestinationPort The destination port of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkDestinationPort(software.amazon.awscdk.IResolvable networkDestinationPort) {
                this.networkDestinationPort = networkDestinationPort;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkDestinationPort}
             * @param networkDestinationPort The destination port of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkDestinationPort(java.util.List<? extends java.lang.Object> networkDestinationPort) {
                this.networkDestinationPort = networkDestinationPort;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkDirection}
             * @param networkDirection Indicates the direction of network traffic associated with a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkDirection(software.amazon.awscdk.IResolvable networkDirection) {
                this.networkDirection = networkDirection;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkDirection}
             * @param networkDirection Indicates the direction of network traffic associated with a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkDirection(java.util.List<? extends java.lang.Object> networkDirection) {
                this.networkDirection = networkDirection;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkProtocol}
             * @param networkProtocol The protocol of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkProtocol(software.amazon.awscdk.IResolvable networkProtocol) {
                this.networkProtocol = networkProtocol;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkProtocol}
             * @param networkProtocol The protocol of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkProtocol(java.util.List<? extends java.lang.Object> networkProtocol) {
                this.networkProtocol = networkProtocol;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkSourceDomain}
             * @param networkSourceDomain The source domain of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkSourceDomain(software.amazon.awscdk.IResolvable networkSourceDomain) {
                this.networkSourceDomain = networkSourceDomain;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkSourceDomain}
             * @param networkSourceDomain The source domain of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkSourceDomain(java.util.List<? extends java.lang.Object> networkSourceDomain) {
                this.networkSourceDomain = networkSourceDomain;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkSourceIpV4}
             * @param networkSourceIpV4 The source IPv4 address of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkSourceIpV4(software.amazon.awscdk.IResolvable networkSourceIpV4) {
                this.networkSourceIpV4 = networkSourceIpV4;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkSourceIpV4}
             * @param networkSourceIpV4 The source IPv4 address of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkSourceIpV4(java.util.List<? extends java.lang.Object> networkSourceIpV4) {
                this.networkSourceIpV4 = networkSourceIpV4;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkSourceIpV6}
             * @param networkSourceIpV6 The source IPv6 address of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkSourceIpV6(software.amazon.awscdk.IResolvable networkSourceIpV6) {
                this.networkSourceIpV6 = networkSourceIpV6;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkSourceIpV6}
             * @param networkSourceIpV6 The source IPv6 address of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkSourceIpV6(java.util.List<? extends java.lang.Object> networkSourceIpV6) {
                this.networkSourceIpV6 = networkSourceIpV6;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkSourceMac}
             * @param networkSourceMac The source media access control (MAC) address of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkSourceMac(software.amazon.awscdk.IResolvable networkSourceMac) {
                this.networkSourceMac = networkSourceMac;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkSourceMac}
             * @param networkSourceMac The source media access control (MAC) address of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkSourceMac(java.util.List<? extends java.lang.Object> networkSourceMac) {
                this.networkSourceMac = networkSourceMac;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkSourcePort}
             * @param networkSourcePort The source port of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkSourcePort(software.amazon.awscdk.IResolvable networkSourcePort) {
                this.networkSourcePort = networkSourcePort;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNetworkSourcePort}
             * @param networkSourcePort The source port of network-related information about a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkSourcePort(java.util.List<? extends java.lang.Object> networkSourcePort) {
                this.networkSourcePort = networkSourcePort;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNoteText}
             * @param noteText The text of a note.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noteText(software.amazon.awscdk.IResolvable noteText) {
                this.noteText = noteText;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNoteText}
             * @param noteText The text of a note.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noteText(java.util.List<? extends java.lang.Object> noteText) {
                this.noteText = noteText;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNoteUpdatedAt}
             * @param noteUpdatedAt The timestamp of when the note was updated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noteUpdatedAt(software.amazon.awscdk.IResolvable noteUpdatedAt) {
                this.noteUpdatedAt = noteUpdatedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNoteUpdatedAt}
             * @param noteUpdatedAt The timestamp of when the note was updated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noteUpdatedAt(java.util.List<? extends java.lang.Object> noteUpdatedAt) {
                this.noteUpdatedAt = noteUpdatedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNoteUpdatedBy}
             * @param noteUpdatedBy The principal that created a note.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noteUpdatedBy(software.amazon.awscdk.IResolvable noteUpdatedBy) {
                this.noteUpdatedBy = noteUpdatedBy;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getNoteUpdatedBy}
             * @param noteUpdatedBy The principal that created a note.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noteUpdatedBy(java.util.List<? extends java.lang.Object> noteUpdatedBy) {
                this.noteUpdatedBy = noteUpdatedBy;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProcessLaunchedAt}
             * @param processLaunchedAt A timestamp that identifies when the process was launched.
             *                          For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processLaunchedAt(software.amazon.awscdk.IResolvable processLaunchedAt) {
                this.processLaunchedAt = processLaunchedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProcessLaunchedAt}
             * @param processLaunchedAt A timestamp that identifies when the process was launched.
             *                          For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processLaunchedAt(java.util.List<? extends java.lang.Object> processLaunchedAt) {
                this.processLaunchedAt = processLaunchedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProcessName}
             * @param processName The name of the process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processName(software.amazon.awscdk.IResolvable processName) {
                this.processName = processName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProcessName}
             * @param processName The name of the process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processName(java.util.List<? extends java.lang.Object> processName) {
                this.processName = processName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProcessParentPid}
             * @param processParentPid The parent process ID.
             *                         This field accepts positive integers between <code>O</code> and <code>2147483647</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processParentPid(software.amazon.awscdk.IResolvable processParentPid) {
                this.processParentPid = processParentPid;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProcessParentPid}
             * @param processParentPid The parent process ID.
             *                         This field accepts positive integers between <code>O</code> and <code>2147483647</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processParentPid(java.util.List<? extends java.lang.Object> processParentPid) {
                this.processParentPid = processParentPid;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProcessPath}
             * @param processPath The path to the process executable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processPath(software.amazon.awscdk.IResolvable processPath) {
                this.processPath = processPath;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProcessPath}
             * @param processPath The path to the process executable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processPath(java.util.List<? extends java.lang.Object> processPath) {
                this.processPath = processPath;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProcessPid}
             * @param processPid The process ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processPid(software.amazon.awscdk.IResolvable processPid) {
                this.processPid = processPid;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProcessPid}
             * @param processPid The process ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processPid(java.util.List<? extends java.lang.Object> processPid) {
                this.processPid = processPid;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProcessTerminatedAt}
             * @param processTerminatedAt A timestamp that identifies when the process was terminated.
             *                            For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processTerminatedAt(software.amazon.awscdk.IResolvable processTerminatedAt) {
                this.processTerminatedAt = processTerminatedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProcessTerminatedAt}
             * @param processTerminatedAt A timestamp that identifies when the process was terminated.
             *                            For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processTerminatedAt(java.util.List<? extends java.lang.Object> processTerminatedAt) {
                this.processTerminatedAt = processTerminatedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProductArn}
             * @param productArn The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productArn(software.amazon.awscdk.IResolvable productArn) {
                this.productArn = productArn;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProductArn}
             * @param productArn The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productArn(java.util.List<? extends java.lang.Object> productArn) {
                this.productArn = productArn;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProductFields}
             * @param productFields A data type where security findings providers can include additional solution-specific details that aren't part of the defined <code>AwsSecurityFinding</code> format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productFields(software.amazon.awscdk.IResolvable productFields) {
                this.productFields = productFields;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProductFields}
             * @param productFields A data type where security findings providers can include additional solution-specific details that aren't part of the defined <code>AwsSecurityFinding</code> format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productFields(java.util.List<? extends java.lang.Object> productFields) {
                this.productFields = productFields;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProductName}
             * @param productName The name of the solution (product) that generates findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productName(software.amazon.awscdk.IResolvable productName) {
                this.productName = productName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getProductName}
             * @param productName The name of the solution (product) that generates findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productName(java.util.List<? extends java.lang.Object> productName) {
                this.productName = productName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getRecommendationText}
             * @param recommendationText The recommendation of what to do about the issue described in a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recommendationText(software.amazon.awscdk.IResolvable recommendationText) {
                this.recommendationText = recommendationText;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getRecommendationText}
             * @param recommendationText The recommendation of what to do about the issue described in a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recommendationText(java.util.List<? extends java.lang.Object> recommendationText) {
                this.recommendationText = recommendationText;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getRecordState}
             * @param recordState The updated record state for the finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordState(software.amazon.awscdk.IResolvable recordState) {
                this.recordState = recordState;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getRecordState}
             * @param recordState The updated record state for the finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordState(java.util.List<? extends java.lang.Object> recordState) {
                this.recordState = recordState;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getRegion}
             * @param region The Region from which the finding was generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(software.amazon.awscdk.IResolvable region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getRegion}
             * @param region The Region from which the finding was generated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.util.List<? extends java.lang.Object> region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getRelatedFindingsId}
             * @param relatedFindingsId The solution-generated identifier for a related finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relatedFindingsId(software.amazon.awscdk.IResolvable relatedFindingsId) {
                this.relatedFindingsId = relatedFindingsId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getRelatedFindingsId}
             * @param relatedFindingsId The solution-generated identifier for a related finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relatedFindingsId(java.util.List<? extends java.lang.Object> relatedFindingsId) {
                this.relatedFindingsId = relatedFindingsId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getRelatedFindingsProductArn}
             * @param relatedFindingsProductArn The ARN of the solution that generated a related finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relatedFindingsProductArn(software.amazon.awscdk.IResolvable relatedFindingsProductArn) {
                this.relatedFindingsProductArn = relatedFindingsProductArn;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getRelatedFindingsProductArn}
             * @param relatedFindingsProductArn The ARN of the solution that generated a related finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relatedFindingsProductArn(java.util.List<? extends java.lang.Object> relatedFindingsProductArn) {
                this.relatedFindingsProductArn = relatedFindingsProductArn;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceApplicationArn}
             * @param resourceApplicationArn The ARN of the application that is related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceApplicationArn(software.amazon.awscdk.IResolvable resourceApplicationArn) {
                this.resourceApplicationArn = resourceApplicationArn;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceApplicationArn}
             * @param resourceApplicationArn The ARN of the application that is related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceApplicationArn(java.util.List<? extends java.lang.Object> resourceApplicationArn) {
                this.resourceApplicationArn = resourceApplicationArn;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceApplicationName}
             * @param resourceApplicationName The name of the application that is related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceApplicationName(software.amazon.awscdk.IResolvable resourceApplicationName) {
                this.resourceApplicationName = resourceApplicationName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceApplicationName}
             * @param resourceApplicationName The name of the application that is related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceApplicationName(java.util.List<? extends java.lang.Object> resourceApplicationName) {
                this.resourceApplicationName = resourceApplicationName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceIamInstanceProfileArn}
             * @param resourceAwsEc2InstanceIamInstanceProfileArn The IAM profile ARN of the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceIamInstanceProfileArn(software.amazon.awscdk.IResolvable resourceAwsEc2InstanceIamInstanceProfileArn) {
                this.resourceAwsEc2InstanceIamInstanceProfileArn = resourceAwsEc2InstanceIamInstanceProfileArn;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceIamInstanceProfileArn}
             * @param resourceAwsEc2InstanceIamInstanceProfileArn The IAM profile ARN of the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceIamInstanceProfileArn(java.util.List<? extends java.lang.Object> resourceAwsEc2InstanceIamInstanceProfileArn) {
                this.resourceAwsEc2InstanceIamInstanceProfileArn = resourceAwsEc2InstanceIamInstanceProfileArn;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceImageId}
             * @param resourceAwsEc2InstanceImageId The Amazon Machine Image (AMI) ID of the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceImageId(software.amazon.awscdk.IResolvable resourceAwsEc2InstanceImageId) {
                this.resourceAwsEc2InstanceImageId = resourceAwsEc2InstanceImageId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceImageId}
             * @param resourceAwsEc2InstanceImageId The Amazon Machine Image (AMI) ID of the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceImageId(java.util.List<? extends java.lang.Object> resourceAwsEc2InstanceImageId) {
                this.resourceAwsEc2InstanceImageId = resourceAwsEc2InstanceImageId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceIpV4Addresses}
             * @param resourceAwsEc2InstanceIpV4Addresses The IPv4 addresses associated with the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceIpV4Addresses(software.amazon.awscdk.IResolvable resourceAwsEc2InstanceIpV4Addresses) {
                this.resourceAwsEc2InstanceIpV4Addresses = resourceAwsEc2InstanceIpV4Addresses;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceIpV4Addresses}
             * @param resourceAwsEc2InstanceIpV4Addresses The IPv4 addresses associated with the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceIpV4Addresses(java.util.List<? extends java.lang.Object> resourceAwsEc2InstanceIpV4Addresses) {
                this.resourceAwsEc2InstanceIpV4Addresses = resourceAwsEc2InstanceIpV4Addresses;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceIpV6Addresses}
             * @param resourceAwsEc2InstanceIpV6Addresses The IPv6 addresses associated with the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceIpV6Addresses(software.amazon.awscdk.IResolvable resourceAwsEc2InstanceIpV6Addresses) {
                this.resourceAwsEc2InstanceIpV6Addresses = resourceAwsEc2InstanceIpV6Addresses;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceIpV6Addresses}
             * @param resourceAwsEc2InstanceIpV6Addresses The IPv6 addresses associated with the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceIpV6Addresses(java.util.List<? extends java.lang.Object> resourceAwsEc2InstanceIpV6Addresses) {
                this.resourceAwsEc2InstanceIpV6Addresses = resourceAwsEc2InstanceIpV6Addresses;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceKeyName}
             * @param resourceAwsEc2InstanceKeyName The key name associated with the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceKeyName(software.amazon.awscdk.IResolvable resourceAwsEc2InstanceKeyName) {
                this.resourceAwsEc2InstanceKeyName = resourceAwsEc2InstanceKeyName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceKeyName}
             * @param resourceAwsEc2InstanceKeyName The key name associated with the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceKeyName(java.util.List<? extends java.lang.Object> resourceAwsEc2InstanceKeyName) {
                this.resourceAwsEc2InstanceKeyName = resourceAwsEc2InstanceKeyName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceLaunchedAt}
             * @param resourceAwsEc2InstanceLaunchedAt The date and time the instance was launched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceLaunchedAt(software.amazon.awscdk.IResolvable resourceAwsEc2InstanceLaunchedAt) {
                this.resourceAwsEc2InstanceLaunchedAt = resourceAwsEc2InstanceLaunchedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceLaunchedAt}
             * @param resourceAwsEc2InstanceLaunchedAt The date and time the instance was launched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceLaunchedAt(java.util.List<? extends java.lang.Object> resourceAwsEc2InstanceLaunchedAt) {
                this.resourceAwsEc2InstanceLaunchedAt = resourceAwsEc2InstanceLaunchedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceSubnetId}
             * @param resourceAwsEc2InstanceSubnetId The identifier of the subnet that the instance was launched in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceSubnetId(software.amazon.awscdk.IResolvable resourceAwsEc2InstanceSubnetId) {
                this.resourceAwsEc2InstanceSubnetId = resourceAwsEc2InstanceSubnetId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceSubnetId}
             * @param resourceAwsEc2InstanceSubnetId The identifier of the subnet that the instance was launched in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceSubnetId(java.util.List<? extends java.lang.Object> resourceAwsEc2InstanceSubnetId) {
                this.resourceAwsEc2InstanceSubnetId = resourceAwsEc2InstanceSubnetId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceType}
             * @param resourceAwsEc2InstanceType The instance type of the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceType(software.amazon.awscdk.IResolvable resourceAwsEc2InstanceType) {
                this.resourceAwsEc2InstanceType = resourceAwsEc2InstanceType;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceType}
             * @param resourceAwsEc2InstanceType The instance type of the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceType(java.util.List<? extends java.lang.Object> resourceAwsEc2InstanceType) {
                this.resourceAwsEc2InstanceType = resourceAwsEc2InstanceType;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceVpcId}
             * @param resourceAwsEc2InstanceVpcId The identifier of the VPC that the instance was launched in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceVpcId(software.amazon.awscdk.IResolvable resourceAwsEc2InstanceVpcId) {
                this.resourceAwsEc2InstanceVpcId = resourceAwsEc2InstanceVpcId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsEc2InstanceVpcId}
             * @param resourceAwsEc2InstanceVpcId The identifier of the VPC that the instance was launched in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsEc2InstanceVpcId(java.util.List<? extends java.lang.Object> resourceAwsEc2InstanceVpcId) {
                this.resourceAwsEc2InstanceVpcId = resourceAwsEc2InstanceVpcId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsIamAccessKeyCreatedAt}
             * @param resourceAwsIamAccessKeyCreatedAt The creation date/time of the IAM access key related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsIamAccessKeyCreatedAt(software.amazon.awscdk.IResolvable resourceAwsIamAccessKeyCreatedAt) {
                this.resourceAwsIamAccessKeyCreatedAt = resourceAwsIamAccessKeyCreatedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsIamAccessKeyCreatedAt}
             * @param resourceAwsIamAccessKeyCreatedAt The creation date/time of the IAM access key related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsIamAccessKeyCreatedAt(java.util.List<? extends java.lang.Object> resourceAwsIamAccessKeyCreatedAt) {
                this.resourceAwsIamAccessKeyCreatedAt = resourceAwsIamAccessKeyCreatedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsIamAccessKeyPrincipalName}
             * @param resourceAwsIamAccessKeyPrincipalName The name of the principal that is associated with an IAM access key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsIamAccessKeyPrincipalName(software.amazon.awscdk.IResolvable resourceAwsIamAccessKeyPrincipalName) {
                this.resourceAwsIamAccessKeyPrincipalName = resourceAwsIamAccessKeyPrincipalName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsIamAccessKeyPrincipalName}
             * @param resourceAwsIamAccessKeyPrincipalName The name of the principal that is associated with an IAM access key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsIamAccessKeyPrincipalName(java.util.List<? extends java.lang.Object> resourceAwsIamAccessKeyPrincipalName) {
                this.resourceAwsIamAccessKeyPrincipalName = resourceAwsIamAccessKeyPrincipalName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsIamAccessKeyStatus}
             * @param resourceAwsIamAccessKeyStatus The status of the IAM access key related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsIamAccessKeyStatus(software.amazon.awscdk.IResolvable resourceAwsIamAccessKeyStatus) {
                this.resourceAwsIamAccessKeyStatus = resourceAwsIamAccessKeyStatus;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsIamAccessKeyStatus}
             * @param resourceAwsIamAccessKeyStatus The status of the IAM access key related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsIamAccessKeyStatus(java.util.List<? extends java.lang.Object> resourceAwsIamAccessKeyStatus) {
                this.resourceAwsIamAccessKeyStatus = resourceAwsIamAccessKeyStatus;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsIamAccessKeyUserName}
             * @param resourceAwsIamAccessKeyUserName This field is deprecated.
             *                                        The username associated with the IAM access key related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsIamAccessKeyUserName(software.amazon.awscdk.IResolvable resourceAwsIamAccessKeyUserName) {
                this.resourceAwsIamAccessKeyUserName = resourceAwsIamAccessKeyUserName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsIamAccessKeyUserName}
             * @param resourceAwsIamAccessKeyUserName This field is deprecated.
             *                                        The username associated with the IAM access key related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsIamAccessKeyUserName(java.util.List<? extends java.lang.Object> resourceAwsIamAccessKeyUserName) {
                this.resourceAwsIamAccessKeyUserName = resourceAwsIamAccessKeyUserName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsIamUserUserName}
             * @param resourceAwsIamUserUserName The name of an IAM user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsIamUserUserName(software.amazon.awscdk.IResolvable resourceAwsIamUserUserName) {
                this.resourceAwsIamUserUserName = resourceAwsIamUserUserName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsIamUserUserName}
             * @param resourceAwsIamUserUserName The name of an IAM user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsIamUserUserName(java.util.List<? extends java.lang.Object> resourceAwsIamUserUserName) {
                this.resourceAwsIamUserUserName = resourceAwsIamUserUserName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsS3BucketOwnerId}
             * @param resourceAwsS3BucketOwnerId The canonical user ID of the owner of the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsS3BucketOwnerId(software.amazon.awscdk.IResolvable resourceAwsS3BucketOwnerId) {
                this.resourceAwsS3BucketOwnerId = resourceAwsS3BucketOwnerId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsS3BucketOwnerId}
             * @param resourceAwsS3BucketOwnerId The canonical user ID of the owner of the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsS3BucketOwnerId(java.util.List<? extends java.lang.Object> resourceAwsS3BucketOwnerId) {
                this.resourceAwsS3BucketOwnerId = resourceAwsS3BucketOwnerId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsS3BucketOwnerName}
             * @param resourceAwsS3BucketOwnerName The display name of the owner of the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsS3BucketOwnerName(software.amazon.awscdk.IResolvable resourceAwsS3BucketOwnerName) {
                this.resourceAwsS3BucketOwnerName = resourceAwsS3BucketOwnerName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceAwsS3BucketOwnerName}
             * @param resourceAwsS3BucketOwnerName The display name of the owner of the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAwsS3BucketOwnerName(java.util.List<? extends java.lang.Object> resourceAwsS3BucketOwnerName) {
                this.resourceAwsS3BucketOwnerName = resourceAwsS3BucketOwnerName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceContainerImageId}
             * @param resourceContainerImageId The identifier of the image related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceContainerImageId(software.amazon.awscdk.IResolvable resourceContainerImageId) {
                this.resourceContainerImageId = resourceContainerImageId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceContainerImageId}
             * @param resourceContainerImageId The identifier of the image related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceContainerImageId(java.util.List<? extends java.lang.Object> resourceContainerImageId) {
                this.resourceContainerImageId = resourceContainerImageId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceContainerImageName}
             * @param resourceContainerImageName The name of the image related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceContainerImageName(software.amazon.awscdk.IResolvable resourceContainerImageName) {
                this.resourceContainerImageName = resourceContainerImageName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceContainerImageName}
             * @param resourceContainerImageName The name of the image related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceContainerImageName(java.util.List<? extends java.lang.Object> resourceContainerImageName) {
                this.resourceContainerImageName = resourceContainerImageName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceContainerLaunchedAt}
             * @param resourceContainerLaunchedAt A timestamp that identifies when the container was started.
             *                                    For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceContainerLaunchedAt(software.amazon.awscdk.IResolvable resourceContainerLaunchedAt) {
                this.resourceContainerLaunchedAt = resourceContainerLaunchedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceContainerLaunchedAt}
             * @param resourceContainerLaunchedAt A timestamp that identifies when the container was started.
             *                                    For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceContainerLaunchedAt(java.util.List<? extends java.lang.Object> resourceContainerLaunchedAt) {
                this.resourceContainerLaunchedAt = resourceContainerLaunchedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceContainerName}
             * @param resourceContainerName The name of the container related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceContainerName(software.amazon.awscdk.IResolvable resourceContainerName) {
                this.resourceContainerName = resourceContainerName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceContainerName}
             * @param resourceContainerName The name of the container related to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceContainerName(java.util.List<? extends java.lang.Object> resourceContainerName) {
                this.resourceContainerName = resourceContainerName;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceDetailsOther}
             * @param resourceDetailsOther The details of a resource that doesn't have a specific subfield for the resource type defined.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceDetailsOther(software.amazon.awscdk.IResolvable resourceDetailsOther) {
                this.resourceDetailsOther = resourceDetailsOther;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceDetailsOther}
             * @param resourceDetailsOther The details of a resource that doesn't have a specific subfield for the resource type defined.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceDetailsOther(java.util.List<? extends java.lang.Object> resourceDetailsOther) {
                this.resourceDetailsOther = resourceDetailsOther;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceId}
             * @param resourceId The canonical identifier for the given resource type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(software.amazon.awscdk.IResolvable resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceId}
             * @param resourceId The canonical identifier for the given resource type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.util.List<? extends java.lang.Object> resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourcePartition}
             * @param resourcePartition The canonical AWS partition name that the Region is assigned to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePartition(software.amazon.awscdk.IResolvable resourcePartition) {
                this.resourcePartition = resourcePartition;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourcePartition}
             * @param resourcePartition The canonical AWS partition name that the Region is assigned to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePartition(java.util.List<? extends java.lang.Object> resourcePartition) {
                this.resourcePartition = resourcePartition;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceRegion}
             * @param resourceRegion The canonical AWS external Region name where this resource is located.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRegion(software.amazon.awscdk.IResolvable resourceRegion) {
                this.resourceRegion = resourceRegion;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceRegion}
             * @param resourceRegion The canonical AWS external Region name where this resource is located.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRegion(java.util.List<? extends java.lang.Object> resourceRegion) {
                this.resourceRegion = resourceRegion;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceTags}
             * @param resourceTags A list of AWS tags associated with a resource at the time the finding was processed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTags(software.amazon.awscdk.IResolvable resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceTags}
             * @param resourceTags A list of AWS tags associated with a resource at the time the finding was processed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTags(java.util.List<? extends java.lang.Object> resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceType}
             * @param resourceType Specifies the type of the resource that details are provided for.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(software.amazon.awscdk.IResolvable resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getResourceType}
             * @param resourceType Specifies the type of the resource that details are provided for.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.util.List<? extends java.lang.Object> resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getSample}
             * @param sample Indicates whether or not sample findings are included in the filter results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sample(software.amazon.awscdk.IResolvable sample) {
                this.sample = sample;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getSample}
             * @param sample Indicates whether or not sample findings are included in the filter results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sample(java.util.List<? extends java.lang.Object> sample) {
                this.sample = sample;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getSeverityLabel}
             * @param severityLabel The label of a finding's severity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severityLabel(software.amazon.awscdk.IResolvable severityLabel) {
                this.severityLabel = severityLabel;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getSeverityLabel}
             * @param severityLabel The label of a finding's severity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severityLabel(java.util.List<? extends java.lang.Object> severityLabel) {
                this.severityLabel = severityLabel;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getSeverityNormalized}
             * @param severityNormalized Deprecated. The normalized severity of a finding. Instead of providing <code>Normalized</code> , provide <code>Label</code> .
             *                           The value of <code>Normalized</code> can be an integer between <code>0</code> and <code>100</code> .
             *                           <p>
             *                           If you provide <code>Label</code> and don't provide <code>Normalized</code> , then <code>Normalized</code> is set automatically as follows.
             *                           <p>
             *                           <ul>
             *                           <li><code>INFORMATIONAL</code> - 0</li>
             *                           <li><code>LOW</code> - 1</li>
             *                           <li><code>MEDIUM</code> - 40</li>
             *                           <li><code>HIGH</code> - 70</li>
             *                           <li><code>CRITICAL</code> - 90</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severityNormalized(software.amazon.awscdk.IResolvable severityNormalized) {
                this.severityNormalized = severityNormalized;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getSeverityNormalized}
             * @param severityNormalized Deprecated. The normalized severity of a finding. Instead of providing <code>Normalized</code> , provide <code>Label</code> .
             *                           The value of <code>Normalized</code> can be an integer between <code>0</code> and <code>100</code> .
             *                           <p>
             *                           If you provide <code>Label</code> and don't provide <code>Normalized</code> , then <code>Normalized</code> is set automatically as follows.
             *                           <p>
             *                           <ul>
             *                           <li><code>INFORMATIONAL</code> - 0</li>
             *                           <li><code>LOW</code> - 1</li>
             *                           <li><code>MEDIUM</code> - 40</li>
             *                           <li><code>HIGH</code> - 70</li>
             *                           <li><code>CRITICAL</code> - 90</li>
             *                           </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severityNormalized(java.util.List<? extends java.lang.Object> severityNormalized) {
                this.severityNormalized = severityNormalized;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getSeverityProduct}
             * @param severityProduct Deprecated. This attribute isn't included in findings. Instead of providing <code>Product</code> , provide <code>Original</code> .
             *                        The native severity as defined by the AWS service or integrated partner product that generated the finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severityProduct(software.amazon.awscdk.IResolvable severityProduct) {
                this.severityProduct = severityProduct;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getSeverityProduct}
             * @param severityProduct Deprecated. This attribute isn't included in findings. Instead of providing <code>Product</code> , provide <code>Original</code> .
             *                        The native severity as defined by the AWS service or integrated partner product that generated the finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severityProduct(java.util.List<? extends java.lang.Object> severityProduct) {
                this.severityProduct = severityProduct;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getSourceUrl}
             * @param sourceUrl A URL that links to a page about the current finding in the security findings provider's solution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceUrl(software.amazon.awscdk.IResolvable sourceUrl) {
                this.sourceUrl = sourceUrl;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getSourceUrl}
             * @param sourceUrl A URL that links to a page about the current finding in the security findings provider's solution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceUrl(java.util.List<? extends java.lang.Object> sourceUrl) {
                this.sourceUrl = sourceUrl;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getThreatIntelIndicatorCategory}
             * @param threatIntelIndicatorCategory The category of a threat intelligence indicator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threatIntelIndicatorCategory(software.amazon.awscdk.IResolvable threatIntelIndicatorCategory) {
                this.threatIntelIndicatorCategory = threatIntelIndicatorCategory;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getThreatIntelIndicatorCategory}
             * @param threatIntelIndicatorCategory The category of a threat intelligence indicator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threatIntelIndicatorCategory(java.util.List<? extends java.lang.Object> threatIntelIndicatorCategory) {
                this.threatIntelIndicatorCategory = threatIntelIndicatorCategory;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getThreatIntelIndicatorLastObservedAt}
             * @param threatIntelIndicatorLastObservedAt A timestamp that identifies the last observation of a threat intelligence indicator.
             *                                           For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threatIntelIndicatorLastObservedAt(software.amazon.awscdk.IResolvable threatIntelIndicatorLastObservedAt) {
                this.threatIntelIndicatorLastObservedAt = threatIntelIndicatorLastObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getThreatIntelIndicatorLastObservedAt}
             * @param threatIntelIndicatorLastObservedAt A timestamp that identifies the last observation of a threat intelligence indicator.
             *                                           For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threatIntelIndicatorLastObservedAt(java.util.List<? extends java.lang.Object> threatIntelIndicatorLastObservedAt) {
                this.threatIntelIndicatorLastObservedAt = threatIntelIndicatorLastObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getThreatIntelIndicatorSource}
             * @param threatIntelIndicatorSource The source of the threat intelligence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threatIntelIndicatorSource(software.amazon.awscdk.IResolvable threatIntelIndicatorSource) {
                this.threatIntelIndicatorSource = threatIntelIndicatorSource;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getThreatIntelIndicatorSource}
             * @param threatIntelIndicatorSource The source of the threat intelligence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threatIntelIndicatorSource(java.util.List<? extends java.lang.Object> threatIntelIndicatorSource) {
                this.threatIntelIndicatorSource = threatIntelIndicatorSource;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getThreatIntelIndicatorSourceUrl}
             * @param threatIntelIndicatorSourceUrl The URL for more details from the source of the threat intelligence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threatIntelIndicatorSourceUrl(software.amazon.awscdk.IResolvable threatIntelIndicatorSourceUrl) {
                this.threatIntelIndicatorSourceUrl = threatIntelIndicatorSourceUrl;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getThreatIntelIndicatorSourceUrl}
             * @param threatIntelIndicatorSourceUrl The URL for more details from the source of the threat intelligence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threatIntelIndicatorSourceUrl(java.util.List<? extends java.lang.Object> threatIntelIndicatorSourceUrl) {
                this.threatIntelIndicatorSourceUrl = threatIntelIndicatorSourceUrl;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getThreatIntelIndicatorType}
             * @param threatIntelIndicatorType The type of a threat intelligence indicator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threatIntelIndicatorType(software.amazon.awscdk.IResolvable threatIntelIndicatorType) {
                this.threatIntelIndicatorType = threatIntelIndicatorType;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getThreatIntelIndicatorType}
             * @param threatIntelIndicatorType The type of a threat intelligence indicator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threatIntelIndicatorType(java.util.List<? extends java.lang.Object> threatIntelIndicatorType) {
                this.threatIntelIndicatorType = threatIntelIndicatorType;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getThreatIntelIndicatorValue}
             * @param threatIntelIndicatorValue The value of a threat intelligence indicator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threatIntelIndicatorValue(software.amazon.awscdk.IResolvable threatIntelIndicatorValue) {
                this.threatIntelIndicatorValue = threatIntelIndicatorValue;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getThreatIntelIndicatorValue}
             * @param threatIntelIndicatorValue The value of a threat intelligence indicator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threatIntelIndicatorValue(java.util.List<? extends java.lang.Object> threatIntelIndicatorValue) {
                this.threatIntelIndicatorValue = threatIntelIndicatorValue;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getTitle}
             * @param title A finding's title.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(software.amazon.awscdk.IResolvable title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getTitle}
             * @param title A finding's title.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.util.List<? extends java.lang.Object> title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getType}
             * @param type A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(software.amazon.awscdk.IResolvable type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getType}
             * @param type A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.util.List<? extends java.lang.Object> type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getUpdatedAt}
             * @param updatedAt A timestamp that indicates when the security findings provider last updated the finding record.
             *                  For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updatedAt(software.amazon.awscdk.IResolvable updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getUpdatedAt}
             * @param updatedAt A timestamp that indicates when the security findings provider last updated the finding record.
             *                  For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updatedAt(java.util.List<? extends java.lang.Object> updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getUserDefinedFields}
             * @param userDefinedFields A list of name/value string pairs associated with the finding.
             *                          These are custom, user-defined fields added to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userDefinedFields(software.amazon.awscdk.IResolvable userDefinedFields) {
                this.userDefinedFields = userDefinedFields;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getUserDefinedFields}
             * @param userDefinedFields A list of name/value string pairs associated with the finding.
             *                          These are custom, user-defined fields added to a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userDefinedFields(java.util.List<? extends java.lang.Object> userDefinedFields) {
                this.userDefinedFields = userDefinedFields;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getVerificationState}
             * @param verificationState The veracity of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verificationState(software.amazon.awscdk.IResolvable verificationState) {
                this.verificationState = verificationState;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getVerificationState}
             * @param verificationState The veracity of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verificationState(java.util.List<? extends java.lang.Object> verificationState) {
                this.verificationState = verificationState;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getVulnerabilitiesExploitAvailable}
             * @param vulnerabilitiesExploitAvailable Indicates whether a software vulnerability in your environment has a known exploit.
             *                                        You can filter findings by this field only if you use Security Hub and Amazon Inspector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vulnerabilitiesExploitAvailable(software.amazon.awscdk.IResolvable vulnerabilitiesExploitAvailable) {
                this.vulnerabilitiesExploitAvailable = vulnerabilitiesExploitAvailable;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getVulnerabilitiesExploitAvailable}
             * @param vulnerabilitiesExploitAvailable Indicates whether a software vulnerability in your environment has a known exploit.
             *                                        You can filter findings by this field only if you use Security Hub and Amazon Inspector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vulnerabilitiesExploitAvailable(java.util.List<? extends java.lang.Object> vulnerabilitiesExploitAvailable) {
                this.vulnerabilitiesExploitAvailable = vulnerabilitiesExploitAvailable;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getVulnerabilitiesFixAvailable}
             * @param vulnerabilitiesFixAvailable Indicates whether a vulnerability is fixed in a newer version of the affected software packages.
             *                                    You can filter findings by this field only if you use Security Hub and Amazon Inspector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vulnerabilitiesFixAvailable(software.amazon.awscdk.IResolvable vulnerabilitiesFixAvailable) {
                this.vulnerabilitiesFixAvailable = vulnerabilitiesFixAvailable;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getVulnerabilitiesFixAvailable}
             * @param vulnerabilitiesFixAvailable Indicates whether a vulnerability is fixed in a newer version of the affected software packages.
             *                                    You can filter findings by this field only if you use Security Hub and Amazon Inspector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vulnerabilitiesFixAvailable(java.util.List<? extends java.lang.Object> vulnerabilitiesFixAvailable) {
                this.vulnerabilitiesFixAvailable = vulnerabilitiesFixAvailable;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getWorkflowState}
             * @param workflowState The workflow state of a finding.
             *                      Note that this field is deprecated. To search for a finding based on its workflow status, use <code>WorkflowStatus</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workflowState(software.amazon.awscdk.IResolvable workflowState) {
                this.workflowState = workflowState;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getWorkflowState}
             * @param workflowState The workflow state of a finding.
             *                      Note that this field is deprecated. To search for a finding based on its workflow status, use <code>WorkflowStatus</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workflowState(java.util.List<? extends java.lang.Object> workflowState) {
                this.workflowState = workflowState;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getWorkflowStatus}
             * @param workflowStatus The status of the investigation into a finding. Allowed values are the following.
             *                       <ul>
             *                       <li><code>NEW</code> - The initial state of a finding, before it is reviewed.</li>
             *                       </ul>
             *                       <p>
             *                       Security Hub also resets the workflow status from <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the following cases:
             *                       <p>
             *                       <ul>
             *                       <li><code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .</li>
             *                       <li><code>Compliance.Status</code> changes from <code>PASSED</code> to either <code>WARNING</code> , <code>FAILED</code> , or <code>NOT_AVAILABLE</code> .</li>
             *                       <li><code>NOTIFIED</code> - Indicates that the resource owner has been notified about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.</li>
             *                       </ul>
             *                       <p>
             *                       If one of the following occurs, the workflow status is changed automatically from <code>NOTIFIED</code> to <code>NEW</code> :
             *                       <p>
             *                       <ul>
             *                       <li><code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .</li>
             *                       <li><code>Compliance.Status</code> changes from <code>PASSED</code> to <code>FAILED</code> , <code>WARNING</code> , or <code>NOT_AVAILABLE</code> .</li>
             *                       <li><code>SUPPRESSED</code> - Indicates that you reviewed the finding and don't believe that any action is needed.</li>
             *                       </ul>
             *                       <p>
             *                       The workflow status of a <code>SUPPRESSED</code> finding does not change if <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .
             *                       <p>
             *                       <ul>
             *                       <li><code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.</li>
             *                       </ul>
             *                       <p>
             *                       The finding remains <code>RESOLVED</code> unless one of the following occurs:
             *                       <p>
             *                       <ul>
             *                       <li><code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .</li>
             *                       <li><code>Compliance.Status</code> changes from <code>PASSED</code> to <code>FAILED</code> , <code>WARNING</code> , or <code>NOT_AVAILABLE</code> .</li>
             *                       </ul>
             *                       <p>
             *                       In those cases, the workflow status is automatically reset to <code>NEW</code> .
             *                       <p>
             *                       For findings from controls, if <code>Compliance.Status</code> is <code>PASSED</code> , then Security Hub automatically sets the workflow status to <code>RESOLVED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workflowStatus(software.amazon.awscdk.IResolvable workflowStatus) {
                this.workflowStatus = workflowStatus;
                return this;
            }

            /**
             * Sets the value of {@link AwsSecurityFindingFiltersProperty#getWorkflowStatus}
             * @param workflowStatus The status of the investigation into a finding. Allowed values are the following.
             *                       <ul>
             *                       <li><code>NEW</code> - The initial state of a finding, before it is reviewed.</li>
             *                       </ul>
             *                       <p>
             *                       Security Hub also resets the workflow status from <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the following cases:
             *                       <p>
             *                       <ul>
             *                       <li><code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .</li>
             *                       <li><code>Compliance.Status</code> changes from <code>PASSED</code> to either <code>WARNING</code> , <code>FAILED</code> , or <code>NOT_AVAILABLE</code> .</li>
             *                       <li><code>NOTIFIED</code> - Indicates that the resource owner has been notified about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.</li>
             *                       </ul>
             *                       <p>
             *                       If one of the following occurs, the workflow status is changed automatically from <code>NOTIFIED</code> to <code>NEW</code> :
             *                       <p>
             *                       <ul>
             *                       <li><code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .</li>
             *                       <li><code>Compliance.Status</code> changes from <code>PASSED</code> to <code>FAILED</code> , <code>WARNING</code> , or <code>NOT_AVAILABLE</code> .</li>
             *                       <li><code>SUPPRESSED</code> - Indicates that you reviewed the finding and don't believe that any action is needed.</li>
             *                       </ul>
             *                       <p>
             *                       The workflow status of a <code>SUPPRESSED</code> finding does not change if <code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .
             *                       <p>
             *                       <ul>
             *                       <li><code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.</li>
             *                       </ul>
             *                       <p>
             *                       The finding remains <code>RESOLVED</code> unless one of the following occurs:
             *                       <p>
             *                       <ul>
             *                       <li><code>RecordState</code> changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .</li>
             *                       <li><code>Compliance.Status</code> changes from <code>PASSED</code> to <code>FAILED</code> , <code>WARNING</code> , or <code>NOT_AVAILABLE</code> .</li>
             *                       </ul>
             *                       <p>
             *                       In those cases, the workflow status is automatically reset to <code>NEW</code> .
             *                       <p>
             *                       For findings from controls, if <code>Compliance.Status</code> is <code>PASSED</code> , then Security Hub automatically sets the workflow status to <code>RESOLVED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workflowStatus(java.util.List<? extends java.lang.Object> workflowStatus) {
                this.workflowStatus = workflowStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsSecurityFindingFiltersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsSecurityFindingFiltersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsSecurityFindingFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsSecurityFindingFiltersProperty {
            private final java.lang.Object awsAccountId;
            private final java.lang.Object awsAccountName;
            private final java.lang.Object companyName;
            private final java.lang.Object complianceAssociatedStandardsId;
            private final java.lang.Object complianceSecurityControlId;
            private final java.lang.Object complianceSecurityControlParametersName;
            private final java.lang.Object complianceSecurityControlParametersValue;
            private final java.lang.Object complianceStatus;
            private final java.lang.Object confidence;
            private final java.lang.Object createdAt;
            private final java.lang.Object criticality;
            private final java.lang.Object description;
            private final java.lang.Object findingProviderFieldsConfidence;
            private final java.lang.Object findingProviderFieldsCriticality;
            private final java.lang.Object findingProviderFieldsRelatedFindingsId;
            private final java.lang.Object findingProviderFieldsRelatedFindingsProductArn;
            private final java.lang.Object findingProviderFieldsSeverityLabel;
            private final java.lang.Object findingProviderFieldsSeverityOriginal;
            private final java.lang.Object findingProviderFieldsTypes;
            private final java.lang.Object firstObservedAt;
            private final java.lang.Object generatorId;
            private final java.lang.Object id;
            private final java.lang.Object keyword;
            private final java.lang.Object lastObservedAt;
            private final java.lang.Object malwareName;
            private final java.lang.Object malwarePath;
            private final java.lang.Object malwareState;
            private final java.lang.Object malwareType;
            private final java.lang.Object networkDestinationDomain;
            private final java.lang.Object networkDestinationIpV4;
            private final java.lang.Object networkDestinationIpV6;
            private final java.lang.Object networkDestinationPort;
            private final java.lang.Object networkDirection;
            private final java.lang.Object networkProtocol;
            private final java.lang.Object networkSourceDomain;
            private final java.lang.Object networkSourceIpV4;
            private final java.lang.Object networkSourceIpV6;
            private final java.lang.Object networkSourceMac;
            private final java.lang.Object networkSourcePort;
            private final java.lang.Object noteText;
            private final java.lang.Object noteUpdatedAt;
            private final java.lang.Object noteUpdatedBy;
            private final java.lang.Object processLaunchedAt;
            private final java.lang.Object processName;
            private final java.lang.Object processParentPid;
            private final java.lang.Object processPath;
            private final java.lang.Object processPid;
            private final java.lang.Object processTerminatedAt;
            private final java.lang.Object productArn;
            private final java.lang.Object productFields;
            private final java.lang.Object productName;
            private final java.lang.Object recommendationText;
            private final java.lang.Object recordState;
            private final java.lang.Object region;
            private final java.lang.Object relatedFindingsId;
            private final java.lang.Object relatedFindingsProductArn;
            private final java.lang.Object resourceApplicationArn;
            private final java.lang.Object resourceApplicationName;
            private final java.lang.Object resourceAwsEc2InstanceIamInstanceProfileArn;
            private final java.lang.Object resourceAwsEc2InstanceImageId;
            private final java.lang.Object resourceAwsEc2InstanceIpV4Addresses;
            private final java.lang.Object resourceAwsEc2InstanceIpV6Addresses;
            private final java.lang.Object resourceAwsEc2InstanceKeyName;
            private final java.lang.Object resourceAwsEc2InstanceLaunchedAt;
            private final java.lang.Object resourceAwsEc2InstanceSubnetId;
            private final java.lang.Object resourceAwsEc2InstanceType;
            private final java.lang.Object resourceAwsEc2InstanceVpcId;
            private final java.lang.Object resourceAwsIamAccessKeyCreatedAt;
            private final java.lang.Object resourceAwsIamAccessKeyPrincipalName;
            private final java.lang.Object resourceAwsIamAccessKeyStatus;
            private final java.lang.Object resourceAwsIamAccessKeyUserName;
            private final java.lang.Object resourceAwsIamUserUserName;
            private final java.lang.Object resourceAwsS3BucketOwnerId;
            private final java.lang.Object resourceAwsS3BucketOwnerName;
            private final java.lang.Object resourceContainerImageId;
            private final java.lang.Object resourceContainerImageName;
            private final java.lang.Object resourceContainerLaunchedAt;
            private final java.lang.Object resourceContainerName;
            private final java.lang.Object resourceDetailsOther;
            private final java.lang.Object resourceId;
            private final java.lang.Object resourcePartition;
            private final java.lang.Object resourceRegion;
            private final java.lang.Object resourceTags;
            private final java.lang.Object resourceType;
            private final java.lang.Object sample;
            private final java.lang.Object severityLabel;
            private final java.lang.Object severityNormalized;
            private final java.lang.Object severityProduct;
            private final java.lang.Object sourceUrl;
            private final java.lang.Object threatIntelIndicatorCategory;
            private final java.lang.Object threatIntelIndicatorLastObservedAt;
            private final java.lang.Object threatIntelIndicatorSource;
            private final java.lang.Object threatIntelIndicatorSourceUrl;
            private final java.lang.Object threatIntelIndicatorType;
            private final java.lang.Object threatIntelIndicatorValue;
            private final java.lang.Object title;
            private final java.lang.Object type;
            private final java.lang.Object updatedAt;
            private final java.lang.Object userDefinedFields;
            private final java.lang.Object verificationState;
            private final java.lang.Object vulnerabilitiesExploitAvailable;
            private final java.lang.Object vulnerabilitiesFixAvailable;
            private final java.lang.Object workflowState;
            private final java.lang.Object workflowStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.awsAccountName = software.amazon.jsii.Kernel.get(this, "awsAccountName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.companyName = software.amazon.jsii.Kernel.get(this, "companyName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.complianceAssociatedStandardsId = software.amazon.jsii.Kernel.get(this, "complianceAssociatedStandardsId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.complianceSecurityControlId = software.amazon.jsii.Kernel.get(this, "complianceSecurityControlId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.complianceSecurityControlParametersName = software.amazon.jsii.Kernel.get(this, "complianceSecurityControlParametersName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.complianceSecurityControlParametersValue = software.amazon.jsii.Kernel.get(this, "complianceSecurityControlParametersValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.complianceStatus = software.amazon.jsii.Kernel.get(this, "complianceStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.confidence = software.amazon.jsii.Kernel.get(this, "confidence", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createdAt = software.amazon.jsii.Kernel.get(this, "createdAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.criticality = software.amazon.jsii.Kernel.get(this, "criticality", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.findingProviderFieldsConfidence = software.amazon.jsii.Kernel.get(this, "findingProviderFieldsConfidence", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.findingProviderFieldsCriticality = software.amazon.jsii.Kernel.get(this, "findingProviderFieldsCriticality", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.findingProviderFieldsRelatedFindingsId = software.amazon.jsii.Kernel.get(this, "findingProviderFieldsRelatedFindingsId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.findingProviderFieldsRelatedFindingsProductArn = software.amazon.jsii.Kernel.get(this, "findingProviderFieldsRelatedFindingsProductArn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.findingProviderFieldsSeverityLabel = software.amazon.jsii.Kernel.get(this, "findingProviderFieldsSeverityLabel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.findingProviderFieldsSeverityOriginal = software.amazon.jsii.Kernel.get(this, "findingProviderFieldsSeverityOriginal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.findingProviderFieldsTypes = software.amazon.jsii.Kernel.get(this, "findingProviderFieldsTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.firstObservedAt = software.amazon.jsii.Kernel.get(this, "firstObservedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.generatorId = software.amazon.jsii.Kernel.get(this, "generatorId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyword = software.amazon.jsii.Kernel.get(this, "keyword", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lastObservedAt = software.amazon.jsii.Kernel.get(this, "lastObservedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.malwareName = software.amazon.jsii.Kernel.get(this, "malwareName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.malwarePath = software.amazon.jsii.Kernel.get(this, "malwarePath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.malwareState = software.amazon.jsii.Kernel.get(this, "malwareState", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.malwareType = software.amazon.jsii.Kernel.get(this, "malwareType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkDestinationDomain = software.amazon.jsii.Kernel.get(this, "networkDestinationDomain", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkDestinationIpV4 = software.amazon.jsii.Kernel.get(this, "networkDestinationIpV4", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkDestinationIpV6 = software.amazon.jsii.Kernel.get(this, "networkDestinationIpV6", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkDestinationPort = software.amazon.jsii.Kernel.get(this, "networkDestinationPort", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkDirection = software.amazon.jsii.Kernel.get(this, "networkDirection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkProtocol = software.amazon.jsii.Kernel.get(this, "networkProtocol", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkSourceDomain = software.amazon.jsii.Kernel.get(this, "networkSourceDomain", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkSourceIpV4 = software.amazon.jsii.Kernel.get(this, "networkSourceIpV4", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkSourceIpV6 = software.amazon.jsii.Kernel.get(this, "networkSourceIpV6", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkSourceMac = software.amazon.jsii.Kernel.get(this, "networkSourceMac", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkSourcePort = software.amazon.jsii.Kernel.get(this, "networkSourcePort", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noteText = software.amazon.jsii.Kernel.get(this, "noteText", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noteUpdatedAt = software.amazon.jsii.Kernel.get(this, "noteUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noteUpdatedBy = software.amazon.jsii.Kernel.get(this, "noteUpdatedBy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processLaunchedAt = software.amazon.jsii.Kernel.get(this, "processLaunchedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processName = software.amazon.jsii.Kernel.get(this, "processName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processParentPid = software.amazon.jsii.Kernel.get(this, "processParentPid", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processPath = software.amazon.jsii.Kernel.get(this, "processPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processPid = software.amazon.jsii.Kernel.get(this, "processPid", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processTerminatedAt = software.amazon.jsii.Kernel.get(this, "processTerminatedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.productArn = software.amazon.jsii.Kernel.get(this, "productArn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.productFields = software.amazon.jsii.Kernel.get(this, "productFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.productName = software.amazon.jsii.Kernel.get(this, "productName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recommendationText = software.amazon.jsii.Kernel.get(this, "recommendationText", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recordState = software.amazon.jsii.Kernel.get(this, "recordState", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relatedFindingsId = software.amazon.jsii.Kernel.get(this, "relatedFindingsId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relatedFindingsProductArn = software.amazon.jsii.Kernel.get(this, "relatedFindingsProductArn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceApplicationArn = software.amazon.jsii.Kernel.get(this, "resourceApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceApplicationName = software.amazon.jsii.Kernel.get(this, "resourceApplicationName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsEc2InstanceIamInstanceProfileArn = software.amazon.jsii.Kernel.get(this, "resourceAwsEc2InstanceIamInstanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsEc2InstanceImageId = software.amazon.jsii.Kernel.get(this, "resourceAwsEc2InstanceImageId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsEc2InstanceIpV4Addresses = software.amazon.jsii.Kernel.get(this, "resourceAwsEc2InstanceIpV4Addresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsEc2InstanceIpV6Addresses = software.amazon.jsii.Kernel.get(this, "resourceAwsEc2InstanceIpV6Addresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsEc2InstanceKeyName = software.amazon.jsii.Kernel.get(this, "resourceAwsEc2InstanceKeyName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsEc2InstanceLaunchedAt = software.amazon.jsii.Kernel.get(this, "resourceAwsEc2InstanceLaunchedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsEc2InstanceSubnetId = software.amazon.jsii.Kernel.get(this, "resourceAwsEc2InstanceSubnetId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsEc2InstanceType = software.amazon.jsii.Kernel.get(this, "resourceAwsEc2InstanceType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsEc2InstanceVpcId = software.amazon.jsii.Kernel.get(this, "resourceAwsEc2InstanceVpcId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsIamAccessKeyCreatedAt = software.amazon.jsii.Kernel.get(this, "resourceAwsIamAccessKeyCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsIamAccessKeyPrincipalName = software.amazon.jsii.Kernel.get(this, "resourceAwsIamAccessKeyPrincipalName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsIamAccessKeyStatus = software.amazon.jsii.Kernel.get(this, "resourceAwsIamAccessKeyStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsIamAccessKeyUserName = software.amazon.jsii.Kernel.get(this, "resourceAwsIamAccessKeyUserName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsIamUserUserName = software.amazon.jsii.Kernel.get(this, "resourceAwsIamUserUserName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsS3BucketOwnerId = software.amazon.jsii.Kernel.get(this, "resourceAwsS3BucketOwnerId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAwsS3BucketOwnerName = software.amazon.jsii.Kernel.get(this, "resourceAwsS3BucketOwnerName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceContainerImageId = software.amazon.jsii.Kernel.get(this, "resourceContainerImageId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceContainerImageName = software.amazon.jsii.Kernel.get(this, "resourceContainerImageName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceContainerLaunchedAt = software.amazon.jsii.Kernel.get(this, "resourceContainerLaunchedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceContainerName = software.amazon.jsii.Kernel.get(this, "resourceContainerName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceDetailsOther = software.amazon.jsii.Kernel.get(this, "resourceDetailsOther", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourcePartition = software.amazon.jsii.Kernel.get(this, "resourcePartition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceRegion = software.amazon.jsii.Kernel.get(this, "resourceRegion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceTags = software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sample = software.amazon.jsii.Kernel.get(this, "sample", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.severityLabel = software.amazon.jsii.Kernel.get(this, "severityLabel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.severityNormalized = software.amazon.jsii.Kernel.get(this, "severityNormalized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.severityProduct = software.amazon.jsii.Kernel.get(this, "severityProduct", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceUrl = software.amazon.jsii.Kernel.get(this, "sourceUrl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.threatIntelIndicatorCategory = software.amazon.jsii.Kernel.get(this, "threatIntelIndicatorCategory", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.threatIntelIndicatorLastObservedAt = software.amazon.jsii.Kernel.get(this, "threatIntelIndicatorLastObservedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.threatIntelIndicatorSource = software.amazon.jsii.Kernel.get(this, "threatIntelIndicatorSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.threatIntelIndicatorSourceUrl = software.amazon.jsii.Kernel.get(this, "threatIntelIndicatorSourceUrl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.threatIntelIndicatorType = software.amazon.jsii.Kernel.get(this, "threatIntelIndicatorType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.threatIntelIndicatorValue = software.amazon.jsii.Kernel.get(this, "threatIntelIndicatorValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.updatedAt = software.amazon.jsii.Kernel.get(this, "updatedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userDefinedFields = software.amazon.jsii.Kernel.get(this, "userDefinedFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.verificationState = software.amazon.jsii.Kernel.get(this, "verificationState", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vulnerabilitiesExploitAvailable = software.amazon.jsii.Kernel.get(this, "vulnerabilitiesExploitAvailable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vulnerabilitiesFixAvailable = software.amazon.jsii.Kernel.get(this, "vulnerabilitiesFixAvailable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.workflowState = software.amazon.jsii.Kernel.get(this, "workflowState", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.workflowStatus = software.amazon.jsii.Kernel.get(this, "workflowStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsAccountId = builder.awsAccountId;
                this.awsAccountName = builder.awsAccountName;
                this.companyName = builder.companyName;
                this.complianceAssociatedStandardsId = builder.complianceAssociatedStandardsId;
                this.complianceSecurityControlId = builder.complianceSecurityControlId;
                this.complianceSecurityControlParametersName = builder.complianceSecurityControlParametersName;
                this.complianceSecurityControlParametersValue = builder.complianceSecurityControlParametersValue;
                this.complianceStatus = builder.complianceStatus;
                this.confidence = builder.confidence;
                this.createdAt = builder.createdAt;
                this.criticality = builder.criticality;
                this.description = builder.description;
                this.findingProviderFieldsConfidence = builder.findingProviderFieldsConfidence;
                this.findingProviderFieldsCriticality = builder.findingProviderFieldsCriticality;
                this.findingProviderFieldsRelatedFindingsId = builder.findingProviderFieldsRelatedFindingsId;
                this.findingProviderFieldsRelatedFindingsProductArn = builder.findingProviderFieldsRelatedFindingsProductArn;
                this.findingProviderFieldsSeverityLabel = builder.findingProviderFieldsSeverityLabel;
                this.findingProviderFieldsSeverityOriginal = builder.findingProviderFieldsSeverityOriginal;
                this.findingProviderFieldsTypes = builder.findingProviderFieldsTypes;
                this.firstObservedAt = builder.firstObservedAt;
                this.generatorId = builder.generatorId;
                this.id = builder.id;
                this.keyword = builder.keyword;
                this.lastObservedAt = builder.lastObservedAt;
                this.malwareName = builder.malwareName;
                this.malwarePath = builder.malwarePath;
                this.malwareState = builder.malwareState;
                this.malwareType = builder.malwareType;
                this.networkDestinationDomain = builder.networkDestinationDomain;
                this.networkDestinationIpV4 = builder.networkDestinationIpV4;
                this.networkDestinationIpV6 = builder.networkDestinationIpV6;
                this.networkDestinationPort = builder.networkDestinationPort;
                this.networkDirection = builder.networkDirection;
                this.networkProtocol = builder.networkProtocol;
                this.networkSourceDomain = builder.networkSourceDomain;
                this.networkSourceIpV4 = builder.networkSourceIpV4;
                this.networkSourceIpV6 = builder.networkSourceIpV6;
                this.networkSourceMac = builder.networkSourceMac;
                this.networkSourcePort = builder.networkSourcePort;
                this.noteText = builder.noteText;
                this.noteUpdatedAt = builder.noteUpdatedAt;
                this.noteUpdatedBy = builder.noteUpdatedBy;
                this.processLaunchedAt = builder.processLaunchedAt;
                this.processName = builder.processName;
                this.processParentPid = builder.processParentPid;
                this.processPath = builder.processPath;
                this.processPid = builder.processPid;
                this.processTerminatedAt = builder.processTerminatedAt;
                this.productArn = builder.productArn;
                this.productFields = builder.productFields;
                this.productName = builder.productName;
                this.recommendationText = builder.recommendationText;
                this.recordState = builder.recordState;
                this.region = builder.region;
                this.relatedFindingsId = builder.relatedFindingsId;
                this.relatedFindingsProductArn = builder.relatedFindingsProductArn;
                this.resourceApplicationArn = builder.resourceApplicationArn;
                this.resourceApplicationName = builder.resourceApplicationName;
                this.resourceAwsEc2InstanceIamInstanceProfileArn = builder.resourceAwsEc2InstanceIamInstanceProfileArn;
                this.resourceAwsEc2InstanceImageId = builder.resourceAwsEc2InstanceImageId;
                this.resourceAwsEc2InstanceIpV4Addresses = builder.resourceAwsEc2InstanceIpV4Addresses;
                this.resourceAwsEc2InstanceIpV6Addresses = builder.resourceAwsEc2InstanceIpV6Addresses;
                this.resourceAwsEc2InstanceKeyName = builder.resourceAwsEc2InstanceKeyName;
                this.resourceAwsEc2InstanceLaunchedAt = builder.resourceAwsEc2InstanceLaunchedAt;
                this.resourceAwsEc2InstanceSubnetId = builder.resourceAwsEc2InstanceSubnetId;
                this.resourceAwsEc2InstanceType = builder.resourceAwsEc2InstanceType;
                this.resourceAwsEc2InstanceVpcId = builder.resourceAwsEc2InstanceVpcId;
                this.resourceAwsIamAccessKeyCreatedAt = builder.resourceAwsIamAccessKeyCreatedAt;
                this.resourceAwsIamAccessKeyPrincipalName = builder.resourceAwsIamAccessKeyPrincipalName;
                this.resourceAwsIamAccessKeyStatus = builder.resourceAwsIamAccessKeyStatus;
                this.resourceAwsIamAccessKeyUserName = builder.resourceAwsIamAccessKeyUserName;
                this.resourceAwsIamUserUserName = builder.resourceAwsIamUserUserName;
                this.resourceAwsS3BucketOwnerId = builder.resourceAwsS3BucketOwnerId;
                this.resourceAwsS3BucketOwnerName = builder.resourceAwsS3BucketOwnerName;
                this.resourceContainerImageId = builder.resourceContainerImageId;
                this.resourceContainerImageName = builder.resourceContainerImageName;
                this.resourceContainerLaunchedAt = builder.resourceContainerLaunchedAt;
                this.resourceContainerName = builder.resourceContainerName;
                this.resourceDetailsOther = builder.resourceDetailsOther;
                this.resourceId = builder.resourceId;
                this.resourcePartition = builder.resourcePartition;
                this.resourceRegion = builder.resourceRegion;
                this.resourceTags = builder.resourceTags;
                this.resourceType = builder.resourceType;
                this.sample = builder.sample;
                this.severityLabel = builder.severityLabel;
                this.severityNormalized = builder.severityNormalized;
                this.severityProduct = builder.severityProduct;
                this.sourceUrl = builder.sourceUrl;
                this.threatIntelIndicatorCategory = builder.threatIntelIndicatorCategory;
                this.threatIntelIndicatorLastObservedAt = builder.threatIntelIndicatorLastObservedAt;
                this.threatIntelIndicatorSource = builder.threatIntelIndicatorSource;
                this.threatIntelIndicatorSourceUrl = builder.threatIntelIndicatorSourceUrl;
                this.threatIntelIndicatorType = builder.threatIntelIndicatorType;
                this.threatIntelIndicatorValue = builder.threatIntelIndicatorValue;
                this.title = builder.title;
                this.type = builder.type;
                this.updatedAt = builder.updatedAt;
                this.userDefinedFields = builder.userDefinedFields;
                this.verificationState = builder.verificationState;
                this.vulnerabilitiesExploitAvailable = builder.vulnerabilitiesExploitAvailable;
                this.vulnerabilitiesFixAvailable = builder.vulnerabilitiesFixAvailable;
                this.workflowState = builder.workflowState;
                this.workflowStatus = builder.workflowStatus;
            }

            @Override
            public final java.lang.Object getAwsAccountId() {
                return this.awsAccountId;
            }

            @Override
            public final java.lang.Object getAwsAccountName() {
                return this.awsAccountName;
            }

            @Override
            public final java.lang.Object getCompanyName() {
                return this.companyName;
            }

            @Override
            public final java.lang.Object getComplianceAssociatedStandardsId() {
                return this.complianceAssociatedStandardsId;
            }

            @Override
            public final java.lang.Object getComplianceSecurityControlId() {
                return this.complianceSecurityControlId;
            }

            @Override
            public final java.lang.Object getComplianceSecurityControlParametersName() {
                return this.complianceSecurityControlParametersName;
            }

            @Override
            public final java.lang.Object getComplianceSecurityControlParametersValue() {
                return this.complianceSecurityControlParametersValue;
            }

            @Override
            public final java.lang.Object getComplianceStatus() {
                return this.complianceStatus;
            }

            @Override
            public final java.lang.Object getConfidence() {
                return this.confidence;
            }

            @Override
            public final java.lang.Object getCreatedAt() {
                return this.createdAt;
            }

            @Override
            public final java.lang.Object getCriticality() {
                return this.criticality;
            }

            @Override
            public final java.lang.Object getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getFindingProviderFieldsConfidence() {
                return this.findingProviderFieldsConfidence;
            }

            @Override
            public final java.lang.Object getFindingProviderFieldsCriticality() {
                return this.findingProviderFieldsCriticality;
            }

            @Override
            public final java.lang.Object getFindingProviderFieldsRelatedFindingsId() {
                return this.findingProviderFieldsRelatedFindingsId;
            }

            @Override
            public final java.lang.Object getFindingProviderFieldsRelatedFindingsProductArn() {
                return this.findingProviderFieldsRelatedFindingsProductArn;
            }

            @Override
            public final java.lang.Object getFindingProviderFieldsSeverityLabel() {
                return this.findingProviderFieldsSeverityLabel;
            }

            @Override
            public final java.lang.Object getFindingProviderFieldsSeverityOriginal() {
                return this.findingProviderFieldsSeverityOriginal;
            }

            @Override
            public final java.lang.Object getFindingProviderFieldsTypes() {
                return this.findingProviderFieldsTypes;
            }

            @Override
            public final java.lang.Object getFirstObservedAt() {
                return this.firstObservedAt;
            }

            @Override
            public final java.lang.Object getGeneratorId() {
                return this.generatorId;
            }

            @Override
            public final java.lang.Object getId() {
                return this.id;
            }

            @Override
            public final java.lang.Object getKeyword() {
                return this.keyword;
            }

            @Override
            public final java.lang.Object getLastObservedAt() {
                return this.lastObservedAt;
            }

            @Override
            public final java.lang.Object getMalwareName() {
                return this.malwareName;
            }

            @Override
            public final java.lang.Object getMalwarePath() {
                return this.malwarePath;
            }

            @Override
            public final java.lang.Object getMalwareState() {
                return this.malwareState;
            }

            @Override
            public final java.lang.Object getMalwareType() {
                return this.malwareType;
            }

            @Override
            public final java.lang.Object getNetworkDestinationDomain() {
                return this.networkDestinationDomain;
            }

            @Override
            public final java.lang.Object getNetworkDestinationIpV4() {
                return this.networkDestinationIpV4;
            }

            @Override
            public final java.lang.Object getNetworkDestinationIpV6() {
                return this.networkDestinationIpV6;
            }

            @Override
            public final java.lang.Object getNetworkDestinationPort() {
                return this.networkDestinationPort;
            }

            @Override
            public final java.lang.Object getNetworkDirection() {
                return this.networkDirection;
            }

            @Override
            public final java.lang.Object getNetworkProtocol() {
                return this.networkProtocol;
            }

            @Override
            public final java.lang.Object getNetworkSourceDomain() {
                return this.networkSourceDomain;
            }

            @Override
            public final java.lang.Object getNetworkSourceIpV4() {
                return this.networkSourceIpV4;
            }

            @Override
            public final java.lang.Object getNetworkSourceIpV6() {
                return this.networkSourceIpV6;
            }

            @Override
            public final java.lang.Object getNetworkSourceMac() {
                return this.networkSourceMac;
            }

            @Override
            public final java.lang.Object getNetworkSourcePort() {
                return this.networkSourcePort;
            }

            @Override
            public final java.lang.Object getNoteText() {
                return this.noteText;
            }

            @Override
            public final java.lang.Object getNoteUpdatedAt() {
                return this.noteUpdatedAt;
            }

            @Override
            public final java.lang.Object getNoteUpdatedBy() {
                return this.noteUpdatedBy;
            }

            @Override
            public final java.lang.Object getProcessLaunchedAt() {
                return this.processLaunchedAt;
            }

            @Override
            public final java.lang.Object getProcessName() {
                return this.processName;
            }

            @Override
            public final java.lang.Object getProcessParentPid() {
                return this.processParentPid;
            }

            @Override
            public final java.lang.Object getProcessPath() {
                return this.processPath;
            }

            @Override
            public final java.lang.Object getProcessPid() {
                return this.processPid;
            }

            @Override
            public final java.lang.Object getProcessTerminatedAt() {
                return this.processTerminatedAt;
            }

            @Override
            public final java.lang.Object getProductArn() {
                return this.productArn;
            }

            @Override
            public final java.lang.Object getProductFields() {
                return this.productFields;
            }

            @Override
            public final java.lang.Object getProductName() {
                return this.productName;
            }

            @Override
            public final java.lang.Object getRecommendationText() {
                return this.recommendationText;
            }

            @Override
            public final java.lang.Object getRecordState() {
                return this.recordState;
            }

            @Override
            public final java.lang.Object getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.Object getRelatedFindingsId() {
                return this.relatedFindingsId;
            }

            @Override
            public final java.lang.Object getRelatedFindingsProductArn() {
                return this.relatedFindingsProductArn;
            }

            @Override
            public final java.lang.Object getResourceApplicationArn() {
                return this.resourceApplicationArn;
            }

            @Override
            public final java.lang.Object getResourceApplicationName() {
                return this.resourceApplicationName;
            }

            @Override
            public final java.lang.Object getResourceAwsEc2InstanceIamInstanceProfileArn() {
                return this.resourceAwsEc2InstanceIamInstanceProfileArn;
            }

            @Override
            public final java.lang.Object getResourceAwsEc2InstanceImageId() {
                return this.resourceAwsEc2InstanceImageId;
            }

            @Override
            public final java.lang.Object getResourceAwsEc2InstanceIpV4Addresses() {
                return this.resourceAwsEc2InstanceIpV4Addresses;
            }

            @Override
            public final java.lang.Object getResourceAwsEc2InstanceIpV6Addresses() {
                return this.resourceAwsEc2InstanceIpV6Addresses;
            }

            @Override
            public final java.lang.Object getResourceAwsEc2InstanceKeyName() {
                return this.resourceAwsEc2InstanceKeyName;
            }

            @Override
            public final java.lang.Object getResourceAwsEc2InstanceLaunchedAt() {
                return this.resourceAwsEc2InstanceLaunchedAt;
            }

            @Override
            public final java.lang.Object getResourceAwsEc2InstanceSubnetId() {
                return this.resourceAwsEc2InstanceSubnetId;
            }

            @Override
            public final java.lang.Object getResourceAwsEc2InstanceType() {
                return this.resourceAwsEc2InstanceType;
            }

            @Override
            public final java.lang.Object getResourceAwsEc2InstanceVpcId() {
                return this.resourceAwsEc2InstanceVpcId;
            }

            @Override
            public final java.lang.Object getResourceAwsIamAccessKeyCreatedAt() {
                return this.resourceAwsIamAccessKeyCreatedAt;
            }

            @Override
            public final java.lang.Object getResourceAwsIamAccessKeyPrincipalName() {
                return this.resourceAwsIamAccessKeyPrincipalName;
            }

            @Override
            public final java.lang.Object getResourceAwsIamAccessKeyStatus() {
                return this.resourceAwsIamAccessKeyStatus;
            }

            @Override
            public final java.lang.Object getResourceAwsIamAccessKeyUserName() {
                return this.resourceAwsIamAccessKeyUserName;
            }

            @Override
            public final java.lang.Object getResourceAwsIamUserUserName() {
                return this.resourceAwsIamUserUserName;
            }

            @Override
            public final java.lang.Object getResourceAwsS3BucketOwnerId() {
                return this.resourceAwsS3BucketOwnerId;
            }

            @Override
            public final java.lang.Object getResourceAwsS3BucketOwnerName() {
                return this.resourceAwsS3BucketOwnerName;
            }

            @Override
            public final java.lang.Object getResourceContainerImageId() {
                return this.resourceContainerImageId;
            }

            @Override
            public final java.lang.Object getResourceContainerImageName() {
                return this.resourceContainerImageName;
            }

            @Override
            public final java.lang.Object getResourceContainerLaunchedAt() {
                return this.resourceContainerLaunchedAt;
            }

            @Override
            public final java.lang.Object getResourceContainerName() {
                return this.resourceContainerName;
            }

            @Override
            public final java.lang.Object getResourceDetailsOther() {
                return this.resourceDetailsOther;
            }

            @Override
            public final java.lang.Object getResourceId() {
                return this.resourceId;
            }

            @Override
            public final java.lang.Object getResourcePartition() {
                return this.resourcePartition;
            }

            @Override
            public final java.lang.Object getResourceRegion() {
                return this.resourceRegion;
            }

            @Override
            public final java.lang.Object getResourceTags() {
                return this.resourceTags;
            }

            @Override
            public final java.lang.Object getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.lang.Object getSample() {
                return this.sample;
            }

            @Override
            public final java.lang.Object getSeverityLabel() {
                return this.severityLabel;
            }

            @Override
            public final java.lang.Object getSeverityNormalized() {
                return this.severityNormalized;
            }

            @Override
            public final java.lang.Object getSeverityProduct() {
                return this.severityProduct;
            }

            @Override
            public final java.lang.Object getSourceUrl() {
                return this.sourceUrl;
            }

            @Override
            public final java.lang.Object getThreatIntelIndicatorCategory() {
                return this.threatIntelIndicatorCategory;
            }

            @Override
            public final java.lang.Object getThreatIntelIndicatorLastObservedAt() {
                return this.threatIntelIndicatorLastObservedAt;
            }

            @Override
            public final java.lang.Object getThreatIntelIndicatorSource() {
                return this.threatIntelIndicatorSource;
            }

            @Override
            public final java.lang.Object getThreatIntelIndicatorSourceUrl() {
                return this.threatIntelIndicatorSourceUrl;
            }

            @Override
            public final java.lang.Object getThreatIntelIndicatorType() {
                return this.threatIntelIndicatorType;
            }

            @Override
            public final java.lang.Object getThreatIntelIndicatorValue() {
                return this.threatIntelIndicatorValue;
            }

            @Override
            public final java.lang.Object getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.Object getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getUpdatedAt() {
                return this.updatedAt;
            }

            @Override
            public final java.lang.Object getUserDefinedFields() {
                return this.userDefinedFields;
            }

            @Override
            public final java.lang.Object getVerificationState() {
                return this.verificationState;
            }

            @Override
            public final java.lang.Object getVulnerabilitiesExploitAvailable() {
                return this.vulnerabilitiesExploitAvailable;
            }

            @Override
            public final java.lang.Object getVulnerabilitiesFixAvailable() {
                return this.vulnerabilitiesFixAvailable;
            }

            @Override
            public final java.lang.Object getWorkflowState() {
                return this.workflowState;
            }

            @Override
            public final java.lang.Object getWorkflowStatus() {
                return this.workflowStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsAccountId() != null) {
                    data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
                }
                if (this.getAwsAccountName() != null) {
                    data.set("awsAccountName", om.valueToTree(this.getAwsAccountName()));
                }
                if (this.getCompanyName() != null) {
                    data.set("companyName", om.valueToTree(this.getCompanyName()));
                }
                if (this.getComplianceAssociatedStandardsId() != null) {
                    data.set("complianceAssociatedStandardsId", om.valueToTree(this.getComplianceAssociatedStandardsId()));
                }
                if (this.getComplianceSecurityControlId() != null) {
                    data.set("complianceSecurityControlId", om.valueToTree(this.getComplianceSecurityControlId()));
                }
                if (this.getComplianceSecurityControlParametersName() != null) {
                    data.set("complianceSecurityControlParametersName", om.valueToTree(this.getComplianceSecurityControlParametersName()));
                }
                if (this.getComplianceSecurityControlParametersValue() != null) {
                    data.set("complianceSecurityControlParametersValue", om.valueToTree(this.getComplianceSecurityControlParametersValue()));
                }
                if (this.getComplianceStatus() != null) {
                    data.set("complianceStatus", om.valueToTree(this.getComplianceStatus()));
                }
                if (this.getConfidence() != null) {
                    data.set("confidence", om.valueToTree(this.getConfidence()));
                }
                if (this.getCreatedAt() != null) {
                    data.set("createdAt", om.valueToTree(this.getCreatedAt()));
                }
                if (this.getCriticality() != null) {
                    data.set("criticality", om.valueToTree(this.getCriticality()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getFindingProviderFieldsConfidence() != null) {
                    data.set("findingProviderFieldsConfidence", om.valueToTree(this.getFindingProviderFieldsConfidence()));
                }
                if (this.getFindingProviderFieldsCriticality() != null) {
                    data.set("findingProviderFieldsCriticality", om.valueToTree(this.getFindingProviderFieldsCriticality()));
                }
                if (this.getFindingProviderFieldsRelatedFindingsId() != null) {
                    data.set("findingProviderFieldsRelatedFindingsId", om.valueToTree(this.getFindingProviderFieldsRelatedFindingsId()));
                }
                if (this.getFindingProviderFieldsRelatedFindingsProductArn() != null) {
                    data.set("findingProviderFieldsRelatedFindingsProductArn", om.valueToTree(this.getFindingProviderFieldsRelatedFindingsProductArn()));
                }
                if (this.getFindingProviderFieldsSeverityLabel() != null) {
                    data.set("findingProviderFieldsSeverityLabel", om.valueToTree(this.getFindingProviderFieldsSeverityLabel()));
                }
                if (this.getFindingProviderFieldsSeverityOriginal() != null) {
                    data.set("findingProviderFieldsSeverityOriginal", om.valueToTree(this.getFindingProviderFieldsSeverityOriginal()));
                }
                if (this.getFindingProviderFieldsTypes() != null) {
                    data.set("findingProviderFieldsTypes", om.valueToTree(this.getFindingProviderFieldsTypes()));
                }
                if (this.getFirstObservedAt() != null) {
                    data.set("firstObservedAt", om.valueToTree(this.getFirstObservedAt()));
                }
                if (this.getGeneratorId() != null) {
                    data.set("generatorId", om.valueToTree(this.getGeneratorId()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getKeyword() != null) {
                    data.set("keyword", om.valueToTree(this.getKeyword()));
                }
                if (this.getLastObservedAt() != null) {
                    data.set("lastObservedAt", om.valueToTree(this.getLastObservedAt()));
                }
                if (this.getMalwareName() != null) {
                    data.set("malwareName", om.valueToTree(this.getMalwareName()));
                }
                if (this.getMalwarePath() != null) {
                    data.set("malwarePath", om.valueToTree(this.getMalwarePath()));
                }
                if (this.getMalwareState() != null) {
                    data.set("malwareState", om.valueToTree(this.getMalwareState()));
                }
                if (this.getMalwareType() != null) {
                    data.set("malwareType", om.valueToTree(this.getMalwareType()));
                }
                if (this.getNetworkDestinationDomain() != null) {
                    data.set("networkDestinationDomain", om.valueToTree(this.getNetworkDestinationDomain()));
                }
                if (this.getNetworkDestinationIpV4() != null) {
                    data.set("networkDestinationIpV4", om.valueToTree(this.getNetworkDestinationIpV4()));
                }
                if (this.getNetworkDestinationIpV6() != null) {
                    data.set("networkDestinationIpV6", om.valueToTree(this.getNetworkDestinationIpV6()));
                }
                if (this.getNetworkDestinationPort() != null) {
                    data.set("networkDestinationPort", om.valueToTree(this.getNetworkDestinationPort()));
                }
                if (this.getNetworkDirection() != null) {
                    data.set("networkDirection", om.valueToTree(this.getNetworkDirection()));
                }
                if (this.getNetworkProtocol() != null) {
                    data.set("networkProtocol", om.valueToTree(this.getNetworkProtocol()));
                }
                if (this.getNetworkSourceDomain() != null) {
                    data.set("networkSourceDomain", om.valueToTree(this.getNetworkSourceDomain()));
                }
                if (this.getNetworkSourceIpV4() != null) {
                    data.set("networkSourceIpV4", om.valueToTree(this.getNetworkSourceIpV4()));
                }
                if (this.getNetworkSourceIpV6() != null) {
                    data.set("networkSourceIpV6", om.valueToTree(this.getNetworkSourceIpV6()));
                }
                if (this.getNetworkSourceMac() != null) {
                    data.set("networkSourceMac", om.valueToTree(this.getNetworkSourceMac()));
                }
                if (this.getNetworkSourcePort() != null) {
                    data.set("networkSourcePort", om.valueToTree(this.getNetworkSourcePort()));
                }
                if (this.getNoteText() != null) {
                    data.set("noteText", om.valueToTree(this.getNoteText()));
                }
                if (this.getNoteUpdatedAt() != null) {
                    data.set("noteUpdatedAt", om.valueToTree(this.getNoteUpdatedAt()));
                }
                if (this.getNoteUpdatedBy() != null) {
                    data.set("noteUpdatedBy", om.valueToTree(this.getNoteUpdatedBy()));
                }
                if (this.getProcessLaunchedAt() != null) {
                    data.set("processLaunchedAt", om.valueToTree(this.getProcessLaunchedAt()));
                }
                if (this.getProcessName() != null) {
                    data.set("processName", om.valueToTree(this.getProcessName()));
                }
                if (this.getProcessParentPid() != null) {
                    data.set("processParentPid", om.valueToTree(this.getProcessParentPid()));
                }
                if (this.getProcessPath() != null) {
                    data.set("processPath", om.valueToTree(this.getProcessPath()));
                }
                if (this.getProcessPid() != null) {
                    data.set("processPid", om.valueToTree(this.getProcessPid()));
                }
                if (this.getProcessTerminatedAt() != null) {
                    data.set("processTerminatedAt", om.valueToTree(this.getProcessTerminatedAt()));
                }
                if (this.getProductArn() != null) {
                    data.set("productArn", om.valueToTree(this.getProductArn()));
                }
                if (this.getProductFields() != null) {
                    data.set("productFields", om.valueToTree(this.getProductFields()));
                }
                if (this.getProductName() != null) {
                    data.set("productName", om.valueToTree(this.getProductName()));
                }
                if (this.getRecommendationText() != null) {
                    data.set("recommendationText", om.valueToTree(this.getRecommendationText()));
                }
                if (this.getRecordState() != null) {
                    data.set("recordState", om.valueToTree(this.getRecordState()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }
                if (this.getRelatedFindingsId() != null) {
                    data.set("relatedFindingsId", om.valueToTree(this.getRelatedFindingsId()));
                }
                if (this.getRelatedFindingsProductArn() != null) {
                    data.set("relatedFindingsProductArn", om.valueToTree(this.getRelatedFindingsProductArn()));
                }
                if (this.getResourceApplicationArn() != null) {
                    data.set("resourceApplicationArn", om.valueToTree(this.getResourceApplicationArn()));
                }
                if (this.getResourceApplicationName() != null) {
                    data.set("resourceApplicationName", om.valueToTree(this.getResourceApplicationName()));
                }
                if (this.getResourceAwsEc2InstanceIamInstanceProfileArn() != null) {
                    data.set("resourceAwsEc2InstanceIamInstanceProfileArn", om.valueToTree(this.getResourceAwsEc2InstanceIamInstanceProfileArn()));
                }
                if (this.getResourceAwsEc2InstanceImageId() != null) {
                    data.set("resourceAwsEc2InstanceImageId", om.valueToTree(this.getResourceAwsEc2InstanceImageId()));
                }
                if (this.getResourceAwsEc2InstanceIpV4Addresses() != null) {
                    data.set("resourceAwsEc2InstanceIpV4Addresses", om.valueToTree(this.getResourceAwsEc2InstanceIpV4Addresses()));
                }
                if (this.getResourceAwsEc2InstanceIpV6Addresses() != null) {
                    data.set("resourceAwsEc2InstanceIpV6Addresses", om.valueToTree(this.getResourceAwsEc2InstanceIpV6Addresses()));
                }
                if (this.getResourceAwsEc2InstanceKeyName() != null) {
                    data.set("resourceAwsEc2InstanceKeyName", om.valueToTree(this.getResourceAwsEc2InstanceKeyName()));
                }
                if (this.getResourceAwsEc2InstanceLaunchedAt() != null) {
                    data.set("resourceAwsEc2InstanceLaunchedAt", om.valueToTree(this.getResourceAwsEc2InstanceLaunchedAt()));
                }
                if (this.getResourceAwsEc2InstanceSubnetId() != null) {
                    data.set("resourceAwsEc2InstanceSubnetId", om.valueToTree(this.getResourceAwsEc2InstanceSubnetId()));
                }
                if (this.getResourceAwsEc2InstanceType() != null) {
                    data.set("resourceAwsEc2InstanceType", om.valueToTree(this.getResourceAwsEc2InstanceType()));
                }
                if (this.getResourceAwsEc2InstanceVpcId() != null) {
                    data.set("resourceAwsEc2InstanceVpcId", om.valueToTree(this.getResourceAwsEc2InstanceVpcId()));
                }
                if (this.getResourceAwsIamAccessKeyCreatedAt() != null) {
                    data.set("resourceAwsIamAccessKeyCreatedAt", om.valueToTree(this.getResourceAwsIamAccessKeyCreatedAt()));
                }
                if (this.getResourceAwsIamAccessKeyPrincipalName() != null) {
                    data.set("resourceAwsIamAccessKeyPrincipalName", om.valueToTree(this.getResourceAwsIamAccessKeyPrincipalName()));
                }
                if (this.getResourceAwsIamAccessKeyStatus() != null) {
                    data.set("resourceAwsIamAccessKeyStatus", om.valueToTree(this.getResourceAwsIamAccessKeyStatus()));
                }
                if (this.getResourceAwsIamAccessKeyUserName() != null) {
                    data.set("resourceAwsIamAccessKeyUserName", om.valueToTree(this.getResourceAwsIamAccessKeyUserName()));
                }
                if (this.getResourceAwsIamUserUserName() != null) {
                    data.set("resourceAwsIamUserUserName", om.valueToTree(this.getResourceAwsIamUserUserName()));
                }
                if (this.getResourceAwsS3BucketOwnerId() != null) {
                    data.set("resourceAwsS3BucketOwnerId", om.valueToTree(this.getResourceAwsS3BucketOwnerId()));
                }
                if (this.getResourceAwsS3BucketOwnerName() != null) {
                    data.set("resourceAwsS3BucketOwnerName", om.valueToTree(this.getResourceAwsS3BucketOwnerName()));
                }
                if (this.getResourceContainerImageId() != null) {
                    data.set("resourceContainerImageId", om.valueToTree(this.getResourceContainerImageId()));
                }
                if (this.getResourceContainerImageName() != null) {
                    data.set("resourceContainerImageName", om.valueToTree(this.getResourceContainerImageName()));
                }
                if (this.getResourceContainerLaunchedAt() != null) {
                    data.set("resourceContainerLaunchedAt", om.valueToTree(this.getResourceContainerLaunchedAt()));
                }
                if (this.getResourceContainerName() != null) {
                    data.set("resourceContainerName", om.valueToTree(this.getResourceContainerName()));
                }
                if (this.getResourceDetailsOther() != null) {
                    data.set("resourceDetailsOther", om.valueToTree(this.getResourceDetailsOther()));
                }
                if (this.getResourceId() != null) {
                    data.set("resourceId", om.valueToTree(this.getResourceId()));
                }
                if (this.getResourcePartition() != null) {
                    data.set("resourcePartition", om.valueToTree(this.getResourcePartition()));
                }
                if (this.getResourceRegion() != null) {
                    data.set("resourceRegion", om.valueToTree(this.getResourceRegion()));
                }
                if (this.getResourceTags() != null) {
                    data.set("resourceTags", om.valueToTree(this.getResourceTags()));
                }
                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getSample() != null) {
                    data.set("sample", om.valueToTree(this.getSample()));
                }
                if (this.getSeverityLabel() != null) {
                    data.set("severityLabel", om.valueToTree(this.getSeverityLabel()));
                }
                if (this.getSeverityNormalized() != null) {
                    data.set("severityNormalized", om.valueToTree(this.getSeverityNormalized()));
                }
                if (this.getSeverityProduct() != null) {
                    data.set("severityProduct", om.valueToTree(this.getSeverityProduct()));
                }
                if (this.getSourceUrl() != null) {
                    data.set("sourceUrl", om.valueToTree(this.getSourceUrl()));
                }
                if (this.getThreatIntelIndicatorCategory() != null) {
                    data.set("threatIntelIndicatorCategory", om.valueToTree(this.getThreatIntelIndicatorCategory()));
                }
                if (this.getThreatIntelIndicatorLastObservedAt() != null) {
                    data.set("threatIntelIndicatorLastObservedAt", om.valueToTree(this.getThreatIntelIndicatorLastObservedAt()));
                }
                if (this.getThreatIntelIndicatorSource() != null) {
                    data.set("threatIntelIndicatorSource", om.valueToTree(this.getThreatIntelIndicatorSource()));
                }
                if (this.getThreatIntelIndicatorSourceUrl() != null) {
                    data.set("threatIntelIndicatorSourceUrl", om.valueToTree(this.getThreatIntelIndicatorSourceUrl()));
                }
                if (this.getThreatIntelIndicatorType() != null) {
                    data.set("threatIntelIndicatorType", om.valueToTree(this.getThreatIntelIndicatorType()));
                }
                if (this.getThreatIntelIndicatorValue() != null) {
                    data.set("threatIntelIndicatorValue", om.valueToTree(this.getThreatIntelIndicatorValue()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUpdatedAt() != null) {
                    data.set("updatedAt", om.valueToTree(this.getUpdatedAt()));
                }
                if (this.getUserDefinedFields() != null) {
                    data.set("userDefinedFields", om.valueToTree(this.getUserDefinedFields()));
                }
                if (this.getVerificationState() != null) {
                    data.set("verificationState", om.valueToTree(this.getVerificationState()));
                }
                if (this.getVulnerabilitiesExploitAvailable() != null) {
                    data.set("vulnerabilitiesExploitAvailable", om.valueToTree(this.getVulnerabilitiesExploitAvailable()));
                }
                if (this.getVulnerabilitiesFixAvailable() != null) {
                    data.set("vulnerabilitiesFixAvailable", om.valueToTree(this.getVulnerabilitiesFixAvailable()));
                }
                if (this.getWorkflowState() != null) {
                    data.set("workflowState", om.valueToTree(this.getWorkflowState()));
                }
                if (this.getWorkflowStatus() != null) {
                    data.set("workflowStatus", om.valueToTree(this.getWorkflowStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnInsight.AwsSecurityFindingFiltersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsSecurityFindingFiltersProperty.Jsii$Proxy that = (AwsSecurityFindingFiltersProperty.Jsii$Proxy) o;

                if (this.awsAccountId != null ? !this.awsAccountId.equals(that.awsAccountId) : that.awsAccountId != null) return false;
                if (this.awsAccountName != null ? !this.awsAccountName.equals(that.awsAccountName) : that.awsAccountName != null) return false;
                if (this.companyName != null ? !this.companyName.equals(that.companyName) : that.companyName != null) return false;
                if (this.complianceAssociatedStandardsId != null ? !this.complianceAssociatedStandardsId.equals(that.complianceAssociatedStandardsId) : that.complianceAssociatedStandardsId != null) return false;
                if (this.complianceSecurityControlId != null ? !this.complianceSecurityControlId.equals(that.complianceSecurityControlId) : that.complianceSecurityControlId != null) return false;
                if (this.complianceSecurityControlParametersName != null ? !this.complianceSecurityControlParametersName.equals(that.complianceSecurityControlParametersName) : that.complianceSecurityControlParametersName != null) return false;
                if (this.complianceSecurityControlParametersValue != null ? !this.complianceSecurityControlParametersValue.equals(that.complianceSecurityControlParametersValue) : that.complianceSecurityControlParametersValue != null) return false;
                if (this.complianceStatus != null ? !this.complianceStatus.equals(that.complianceStatus) : that.complianceStatus != null) return false;
                if (this.confidence != null ? !this.confidence.equals(that.confidence) : that.confidence != null) return false;
                if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) return false;
                if (this.criticality != null ? !this.criticality.equals(that.criticality) : that.criticality != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.findingProviderFieldsConfidence != null ? !this.findingProviderFieldsConfidence.equals(that.findingProviderFieldsConfidence) : that.findingProviderFieldsConfidence != null) return false;
                if (this.findingProviderFieldsCriticality != null ? !this.findingProviderFieldsCriticality.equals(that.findingProviderFieldsCriticality) : that.findingProviderFieldsCriticality != null) return false;
                if (this.findingProviderFieldsRelatedFindingsId != null ? !this.findingProviderFieldsRelatedFindingsId.equals(that.findingProviderFieldsRelatedFindingsId) : that.findingProviderFieldsRelatedFindingsId != null) return false;
                if (this.findingProviderFieldsRelatedFindingsProductArn != null ? !this.findingProviderFieldsRelatedFindingsProductArn.equals(that.findingProviderFieldsRelatedFindingsProductArn) : that.findingProviderFieldsRelatedFindingsProductArn != null) return false;
                if (this.findingProviderFieldsSeverityLabel != null ? !this.findingProviderFieldsSeverityLabel.equals(that.findingProviderFieldsSeverityLabel) : that.findingProviderFieldsSeverityLabel != null) return false;
                if (this.findingProviderFieldsSeverityOriginal != null ? !this.findingProviderFieldsSeverityOriginal.equals(that.findingProviderFieldsSeverityOriginal) : that.findingProviderFieldsSeverityOriginal != null) return false;
                if (this.findingProviderFieldsTypes != null ? !this.findingProviderFieldsTypes.equals(that.findingProviderFieldsTypes) : that.findingProviderFieldsTypes != null) return false;
                if (this.firstObservedAt != null ? !this.firstObservedAt.equals(that.firstObservedAt) : that.firstObservedAt != null) return false;
                if (this.generatorId != null ? !this.generatorId.equals(that.generatorId) : that.generatorId != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.keyword != null ? !this.keyword.equals(that.keyword) : that.keyword != null) return false;
                if (this.lastObservedAt != null ? !this.lastObservedAt.equals(that.lastObservedAt) : that.lastObservedAt != null) return false;
                if (this.malwareName != null ? !this.malwareName.equals(that.malwareName) : that.malwareName != null) return false;
                if (this.malwarePath != null ? !this.malwarePath.equals(that.malwarePath) : that.malwarePath != null) return false;
                if (this.malwareState != null ? !this.malwareState.equals(that.malwareState) : that.malwareState != null) return false;
                if (this.malwareType != null ? !this.malwareType.equals(that.malwareType) : that.malwareType != null) return false;
                if (this.networkDestinationDomain != null ? !this.networkDestinationDomain.equals(that.networkDestinationDomain) : that.networkDestinationDomain != null) return false;
                if (this.networkDestinationIpV4 != null ? !this.networkDestinationIpV4.equals(that.networkDestinationIpV4) : that.networkDestinationIpV4 != null) return false;
                if (this.networkDestinationIpV6 != null ? !this.networkDestinationIpV6.equals(that.networkDestinationIpV6) : that.networkDestinationIpV6 != null) return false;
                if (this.networkDestinationPort != null ? !this.networkDestinationPort.equals(that.networkDestinationPort) : that.networkDestinationPort != null) return false;
                if (this.networkDirection != null ? !this.networkDirection.equals(that.networkDirection) : that.networkDirection != null) return false;
                if (this.networkProtocol != null ? !this.networkProtocol.equals(that.networkProtocol) : that.networkProtocol != null) return false;
                if (this.networkSourceDomain != null ? !this.networkSourceDomain.equals(that.networkSourceDomain) : that.networkSourceDomain != null) return false;
                if (this.networkSourceIpV4 != null ? !this.networkSourceIpV4.equals(that.networkSourceIpV4) : that.networkSourceIpV4 != null) return false;
                if (this.networkSourceIpV6 != null ? !this.networkSourceIpV6.equals(that.networkSourceIpV6) : that.networkSourceIpV6 != null) return false;
                if (this.networkSourceMac != null ? !this.networkSourceMac.equals(that.networkSourceMac) : that.networkSourceMac != null) return false;
                if (this.networkSourcePort != null ? !this.networkSourcePort.equals(that.networkSourcePort) : that.networkSourcePort != null) return false;
                if (this.noteText != null ? !this.noteText.equals(that.noteText) : that.noteText != null) return false;
                if (this.noteUpdatedAt != null ? !this.noteUpdatedAt.equals(that.noteUpdatedAt) : that.noteUpdatedAt != null) return false;
                if (this.noteUpdatedBy != null ? !this.noteUpdatedBy.equals(that.noteUpdatedBy) : that.noteUpdatedBy != null) return false;
                if (this.processLaunchedAt != null ? !this.processLaunchedAt.equals(that.processLaunchedAt) : that.processLaunchedAt != null) return false;
                if (this.processName != null ? !this.processName.equals(that.processName) : that.processName != null) return false;
                if (this.processParentPid != null ? !this.processParentPid.equals(that.processParentPid) : that.processParentPid != null) return false;
                if (this.processPath != null ? !this.processPath.equals(that.processPath) : that.processPath != null) return false;
                if (this.processPid != null ? !this.processPid.equals(that.processPid) : that.processPid != null) return false;
                if (this.processTerminatedAt != null ? !this.processTerminatedAt.equals(that.processTerminatedAt) : that.processTerminatedAt != null) return false;
                if (this.productArn != null ? !this.productArn.equals(that.productArn) : that.productArn != null) return false;
                if (this.productFields != null ? !this.productFields.equals(that.productFields) : that.productFields != null) return false;
                if (this.productName != null ? !this.productName.equals(that.productName) : that.productName != null) return false;
                if (this.recommendationText != null ? !this.recommendationText.equals(that.recommendationText) : that.recommendationText != null) return false;
                if (this.recordState != null ? !this.recordState.equals(that.recordState) : that.recordState != null) return false;
                if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
                if (this.relatedFindingsId != null ? !this.relatedFindingsId.equals(that.relatedFindingsId) : that.relatedFindingsId != null) return false;
                if (this.relatedFindingsProductArn != null ? !this.relatedFindingsProductArn.equals(that.relatedFindingsProductArn) : that.relatedFindingsProductArn != null) return false;
                if (this.resourceApplicationArn != null ? !this.resourceApplicationArn.equals(that.resourceApplicationArn) : that.resourceApplicationArn != null) return false;
                if (this.resourceApplicationName != null ? !this.resourceApplicationName.equals(that.resourceApplicationName) : that.resourceApplicationName != null) return false;
                if (this.resourceAwsEc2InstanceIamInstanceProfileArn != null ? !this.resourceAwsEc2InstanceIamInstanceProfileArn.equals(that.resourceAwsEc2InstanceIamInstanceProfileArn) : that.resourceAwsEc2InstanceIamInstanceProfileArn != null) return false;
                if (this.resourceAwsEc2InstanceImageId != null ? !this.resourceAwsEc2InstanceImageId.equals(that.resourceAwsEc2InstanceImageId) : that.resourceAwsEc2InstanceImageId != null) return false;
                if (this.resourceAwsEc2InstanceIpV4Addresses != null ? !this.resourceAwsEc2InstanceIpV4Addresses.equals(that.resourceAwsEc2InstanceIpV4Addresses) : that.resourceAwsEc2InstanceIpV4Addresses != null) return false;
                if (this.resourceAwsEc2InstanceIpV6Addresses != null ? !this.resourceAwsEc2InstanceIpV6Addresses.equals(that.resourceAwsEc2InstanceIpV6Addresses) : that.resourceAwsEc2InstanceIpV6Addresses != null) return false;
                if (this.resourceAwsEc2InstanceKeyName != null ? !this.resourceAwsEc2InstanceKeyName.equals(that.resourceAwsEc2InstanceKeyName) : that.resourceAwsEc2InstanceKeyName != null) return false;
                if (this.resourceAwsEc2InstanceLaunchedAt != null ? !this.resourceAwsEc2InstanceLaunchedAt.equals(that.resourceAwsEc2InstanceLaunchedAt) : that.resourceAwsEc2InstanceLaunchedAt != null) return false;
                if (this.resourceAwsEc2InstanceSubnetId != null ? !this.resourceAwsEc2InstanceSubnetId.equals(that.resourceAwsEc2InstanceSubnetId) : that.resourceAwsEc2InstanceSubnetId != null) return false;
                if (this.resourceAwsEc2InstanceType != null ? !this.resourceAwsEc2InstanceType.equals(that.resourceAwsEc2InstanceType) : that.resourceAwsEc2InstanceType != null) return false;
                if (this.resourceAwsEc2InstanceVpcId != null ? !this.resourceAwsEc2InstanceVpcId.equals(that.resourceAwsEc2InstanceVpcId) : that.resourceAwsEc2InstanceVpcId != null) return false;
                if (this.resourceAwsIamAccessKeyCreatedAt != null ? !this.resourceAwsIamAccessKeyCreatedAt.equals(that.resourceAwsIamAccessKeyCreatedAt) : that.resourceAwsIamAccessKeyCreatedAt != null) return false;
                if (this.resourceAwsIamAccessKeyPrincipalName != null ? !this.resourceAwsIamAccessKeyPrincipalName.equals(that.resourceAwsIamAccessKeyPrincipalName) : that.resourceAwsIamAccessKeyPrincipalName != null) return false;
                if (this.resourceAwsIamAccessKeyStatus != null ? !this.resourceAwsIamAccessKeyStatus.equals(that.resourceAwsIamAccessKeyStatus) : that.resourceAwsIamAccessKeyStatus != null) return false;
                if (this.resourceAwsIamAccessKeyUserName != null ? !this.resourceAwsIamAccessKeyUserName.equals(that.resourceAwsIamAccessKeyUserName) : that.resourceAwsIamAccessKeyUserName != null) return false;
                if (this.resourceAwsIamUserUserName != null ? !this.resourceAwsIamUserUserName.equals(that.resourceAwsIamUserUserName) : that.resourceAwsIamUserUserName != null) return false;
                if (this.resourceAwsS3BucketOwnerId != null ? !this.resourceAwsS3BucketOwnerId.equals(that.resourceAwsS3BucketOwnerId) : that.resourceAwsS3BucketOwnerId != null) return false;
                if (this.resourceAwsS3BucketOwnerName != null ? !this.resourceAwsS3BucketOwnerName.equals(that.resourceAwsS3BucketOwnerName) : that.resourceAwsS3BucketOwnerName != null) return false;
                if (this.resourceContainerImageId != null ? !this.resourceContainerImageId.equals(that.resourceContainerImageId) : that.resourceContainerImageId != null) return false;
                if (this.resourceContainerImageName != null ? !this.resourceContainerImageName.equals(that.resourceContainerImageName) : that.resourceContainerImageName != null) return false;
                if (this.resourceContainerLaunchedAt != null ? !this.resourceContainerLaunchedAt.equals(that.resourceContainerLaunchedAt) : that.resourceContainerLaunchedAt != null) return false;
                if (this.resourceContainerName != null ? !this.resourceContainerName.equals(that.resourceContainerName) : that.resourceContainerName != null) return false;
                if (this.resourceDetailsOther != null ? !this.resourceDetailsOther.equals(that.resourceDetailsOther) : that.resourceDetailsOther != null) return false;
                if (this.resourceId != null ? !this.resourceId.equals(that.resourceId) : that.resourceId != null) return false;
                if (this.resourcePartition != null ? !this.resourcePartition.equals(that.resourcePartition) : that.resourcePartition != null) return false;
                if (this.resourceRegion != null ? !this.resourceRegion.equals(that.resourceRegion) : that.resourceRegion != null) return false;
                if (this.resourceTags != null ? !this.resourceTags.equals(that.resourceTags) : that.resourceTags != null) return false;
                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                if (this.sample != null ? !this.sample.equals(that.sample) : that.sample != null) return false;
                if (this.severityLabel != null ? !this.severityLabel.equals(that.severityLabel) : that.severityLabel != null) return false;
                if (this.severityNormalized != null ? !this.severityNormalized.equals(that.severityNormalized) : that.severityNormalized != null) return false;
                if (this.severityProduct != null ? !this.severityProduct.equals(that.severityProduct) : that.severityProduct != null) return false;
                if (this.sourceUrl != null ? !this.sourceUrl.equals(that.sourceUrl) : that.sourceUrl != null) return false;
                if (this.threatIntelIndicatorCategory != null ? !this.threatIntelIndicatorCategory.equals(that.threatIntelIndicatorCategory) : that.threatIntelIndicatorCategory != null) return false;
                if (this.threatIntelIndicatorLastObservedAt != null ? !this.threatIntelIndicatorLastObservedAt.equals(that.threatIntelIndicatorLastObservedAt) : that.threatIntelIndicatorLastObservedAt != null) return false;
                if (this.threatIntelIndicatorSource != null ? !this.threatIntelIndicatorSource.equals(that.threatIntelIndicatorSource) : that.threatIntelIndicatorSource != null) return false;
                if (this.threatIntelIndicatorSourceUrl != null ? !this.threatIntelIndicatorSourceUrl.equals(that.threatIntelIndicatorSourceUrl) : that.threatIntelIndicatorSourceUrl != null) return false;
                if (this.threatIntelIndicatorType != null ? !this.threatIntelIndicatorType.equals(that.threatIntelIndicatorType) : that.threatIntelIndicatorType != null) return false;
                if (this.threatIntelIndicatorValue != null ? !this.threatIntelIndicatorValue.equals(that.threatIntelIndicatorValue) : that.threatIntelIndicatorValue != null) return false;
                if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                if (this.updatedAt != null ? !this.updatedAt.equals(that.updatedAt) : that.updatedAt != null) return false;
                if (this.userDefinedFields != null ? !this.userDefinedFields.equals(that.userDefinedFields) : that.userDefinedFields != null) return false;
                if (this.verificationState != null ? !this.verificationState.equals(that.verificationState) : that.verificationState != null) return false;
                if (this.vulnerabilitiesExploitAvailable != null ? !this.vulnerabilitiesExploitAvailable.equals(that.vulnerabilitiesExploitAvailable) : that.vulnerabilitiesExploitAvailable != null) return false;
                if (this.vulnerabilitiesFixAvailable != null ? !this.vulnerabilitiesFixAvailable.equals(that.vulnerabilitiesFixAvailable) : that.vulnerabilitiesFixAvailable != null) return false;
                if (this.workflowState != null ? !this.workflowState.equals(that.workflowState) : that.workflowState != null) return false;
                return this.workflowStatus != null ? this.workflowStatus.equals(that.workflowStatus) : that.workflowStatus == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsAccountId != null ? this.awsAccountId.hashCode() : 0;
                result = 31 * result + (this.awsAccountName != null ? this.awsAccountName.hashCode() : 0);
                result = 31 * result + (this.companyName != null ? this.companyName.hashCode() : 0);
                result = 31 * result + (this.complianceAssociatedStandardsId != null ? this.complianceAssociatedStandardsId.hashCode() : 0);
                result = 31 * result + (this.complianceSecurityControlId != null ? this.complianceSecurityControlId.hashCode() : 0);
                result = 31 * result + (this.complianceSecurityControlParametersName != null ? this.complianceSecurityControlParametersName.hashCode() : 0);
                result = 31 * result + (this.complianceSecurityControlParametersValue != null ? this.complianceSecurityControlParametersValue.hashCode() : 0);
                result = 31 * result + (this.complianceStatus != null ? this.complianceStatus.hashCode() : 0);
                result = 31 * result + (this.confidence != null ? this.confidence.hashCode() : 0);
                result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
                result = 31 * result + (this.criticality != null ? this.criticality.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.findingProviderFieldsConfidence != null ? this.findingProviderFieldsConfidence.hashCode() : 0);
                result = 31 * result + (this.findingProviderFieldsCriticality != null ? this.findingProviderFieldsCriticality.hashCode() : 0);
                result = 31 * result + (this.findingProviderFieldsRelatedFindingsId != null ? this.findingProviderFieldsRelatedFindingsId.hashCode() : 0);
                result = 31 * result + (this.findingProviderFieldsRelatedFindingsProductArn != null ? this.findingProviderFieldsRelatedFindingsProductArn.hashCode() : 0);
                result = 31 * result + (this.findingProviderFieldsSeverityLabel != null ? this.findingProviderFieldsSeverityLabel.hashCode() : 0);
                result = 31 * result + (this.findingProviderFieldsSeverityOriginal != null ? this.findingProviderFieldsSeverityOriginal.hashCode() : 0);
                result = 31 * result + (this.findingProviderFieldsTypes != null ? this.findingProviderFieldsTypes.hashCode() : 0);
                result = 31 * result + (this.firstObservedAt != null ? this.firstObservedAt.hashCode() : 0);
                result = 31 * result + (this.generatorId != null ? this.generatorId.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.keyword != null ? this.keyword.hashCode() : 0);
                result = 31 * result + (this.lastObservedAt != null ? this.lastObservedAt.hashCode() : 0);
                result = 31 * result + (this.malwareName != null ? this.malwareName.hashCode() : 0);
                result = 31 * result + (this.malwarePath != null ? this.malwarePath.hashCode() : 0);
                result = 31 * result + (this.malwareState != null ? this.malwareState.hashCode() : 0);
                result = 31 * result + (this.malwareType != null ? this.malwareType.hashCode() : 0);
                result = 31 * result + (this.networkDestinationDomain != null ? this.networkDestinationDomain.hashCode() : 0);
                result = 31 * result + (this.networkDestinationIpV4 != null ? this.networkDestinationIpV4.hashCode() : 0);
                result = 31 * result + (this.networkDestinationIpV6 != null ? this.networkDestinationIpV6.hashCode() : 0);
                result = 31 * result + (this.networkDestinationPort != null ? this.networkDestinationPort.hashCode() : 0);
                result = 31 * result + (this.networkDirection != null ? this.networkDirection.hashCode() : 0);
                result = 31 * result + (this.networkProtocol != null ? this.networkProtocol.hashCode() : 0);
                result = 31 * result + (this.networkSourceDomain != null ? this.networkSourceDomain.hashCode() : 0);
                result = 31 * result + (this.networkSourceIpV4 != null ? this.networkSourceIpV4.hashCode() : 0);
                result = 31 * result + (this.networkSourceIpV6 != null ? this.networkSourceIpV6.hashCode() : 0);
                result = 31 * result + (this.networkSourceMac != null ? this.networkSourceMac.hashCode() : 0);
                result = 31 * result + (this.networkSourcePort != null ? this.networkSourcePort.hashCode() : 0);
                result = 31 * result + (this.noteText != null ? this.noteText.hashCode() : 0);
                result = 31 * result + (this.noteUpdatedAt != null ? this.noteUpdatedAt.hashCode() : 0);
                result = 31 * result + (this.noteUpdatedBy != null ? this.noteUpdatedBy.hashCode() : 0);
                result = 31 * result + (this.processLaunchedAt != null ? this.processLaunchedAt.hashCode() : 0);
                result = 31 * result + (this.processName != null ? this.processName.hashCode() : 0);
                result = 31 * result + (this.processParentPid != null ? this.processParentPid.hashCode() : 0);
                result = 31 * result + (this.processPath != null ? this.processPath.hashCode() : 0);
                result = 31 * result + (this.processPid != null ? this.processPid.hashCode() : 0);
                result = 31 * result + (this.processTerminatedAt != null ? this.processTerminatedAt.hashCode() : 0);
                result = 31 * result + (this.productArn != null ? this.productArn.hashCode() : 0);
                result = 31 * result + (this.productFields != null ? this.productFields.hashCode() : 0);
                result = 31 * result + (this.productName != null ? this.productName.hashCode() : 0);
                result = 31 * result + (this.recommendationText != null ? this.recommendationText.hashCode() : 0);
                result = 31 * result + (this.recordState != null ? this.recordState.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                result = 31 * result + (this.relatedFindingsId != null ? this.relatedFindingsId.hashCode() : 0);
                result = 31 * result + (this.relatedFindingsProductArn != null ? this.relatedFindingsProductArn.hashCode() : 0);
                result = 31 * result + (this.resourceApplicationArn != null ? this.resourceApplicationArn.hashCode() : 0);
                result = 31 * result + (this.resourceApplicationName != null ? this.resourceApplicationName.hashCode() : 0);
                result = 31 * result + (this.resourceAwsEc2InstanceIamInstanceProfileArn != null ? this.resourceAwsEc2InstanceIamInstanceProfileArn.hashCode() : 0);
                result = 31 * result + (this.resourceAwsEc2InstanceImageId != null ? this.resourceAwsEc2InstanceImageId.hashCode() : 0);
                result = 31 * result + (this.resourceAwsEc2InstanceIpV4Addresses != null ? this.resourceAwsEc2InstanceIpV4Addresses.hashCode() : 0);
                result = 31 * result + (this.resourceAwsEc2InstanceIpV6Addresses != null ? this.resourceAwsEc2InstanceIpV6Addresses.hashCode() : 0);
                result = 31 * result + (this.resourceAwsEc2InstanceKeyName != null ? this.resourceAwsEc2InstanceKeyName.hashCode() : 0);
                result = 31 * result + (this.resourceAwsEc2InstanceLaunchedAt != null ? this.resourceAwsEc2InstanceLaunchedAt.hashCode() : 0);
                result = 31 * result + (this.resourceAwsEc2InstanceSubnetId != null ? this.resourceAwsEc2InstanceSubnetId.hashCode() : 0);
                result = 31 * result + (this.resourceAwsEc2InstanceType != null ? this.resourceAwsEc2InstanceType.hashCode() : 0);
                result = 31 * result + (this.resourceAwsEc2InstanceVpcId != null ? this.resourceAwsEc2InstanceVpcId.hashCode() : 0);
                result = 31 * result + (this.resourceAwsIamAccessKeyCreatedAt != null ? this.resourceAwsIamAccessKeyCreatedAt.hashCode() : 0);
                result = 31 * result + (this.resourceAwsIamAccessKeyPrincipalName != null ? this.resourceAwsIamAccessKeyPrincipalName.hashCode() : 0);
                result = 31 * result + (this.resourceAwsIamAccessKeyStatus != null ? this.resourceAwsIamAccessKeyStatus.hashCode() : 0);
                result = 31 * result + (this.resourceAwsIamAccessKeyUserName != null ? this.resourceAwsIamAccessKeyUserName.hashCode() : 0);
                result = 31 * result + (this.resourceAwsIamUserUserName != null ? this.resourceAwsIamUserUserName.hashCode() : 0);
                result = 31 * result + (this.resourceAwsS3BucketOwnerId != null ? this.resourceAwsS3BucketOwnerId.hashCode() : 0);
                result = 31 * result + (this.resourceAwsS3BucketOwnerName != null ? this.resourceAwsS3BucketOwnerName.hashCode() : 0);
                result = 31 * result + (this.resourceContainerImageId != null ? this.resourceContainerImageId.hashCode() : 0);
                result = 31 * result + (this.resourceContainerImageName != null ? this.resourceContainerImageName.hashCode() : 0);
                result = 31 * result + (this.resourceContainerLaunchedAt != null ? this.resourceContainerLaunchedAt.hashCode() : 0);
                result = 31 * result + (this.resourceContainerName != null ? this.resourceContainerName.hashCode() : 0);
                result = 31 * result + (this.resourceDetailsOther != null ? this.resourceDetailsOther.hashCode() : 0);
                result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
                result = 31 * result + (this.resourcePartition != null ? this.resourcePartition.hashCode() : 0);
                result = 31 * result + (this.resourceRegion != null ? this.resourceRegion.hashCode() : 0);
                result = 31 * result + (this.resourceTags != null ? this.resourceTags.hashCode() : 0);
                result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
                result = 31 * result + (this.sample != null ? this.sample.hashCode() : 0);
                result = 31 * result + (this.severityLabel != null ? this.severityLabel.hashCode() : 0);
                result = 31 * result + (this.severityNormalized != null ? this.severityNormalized.hashCode() : 0);
                result = 31 * result + (this.severityProduct != null ? this.severityProduct.hashCode() : 0);
                result = 31 * result + (this.sourceUrl != null ? this.sourceUrl.hashCode() : 0);
                result = 31 * result + (this.threatIntelIndicatorCategory != null ? this.threatIntelIndicatorCategory.hashCode() : 0);
                result = 31 * result + (this.threatIntelIndicatorLastObservedAt != null ? this.threatIntelIndicatorLastObservedAt.hashCode() : 0);
                result = 31 * result + (this.threatIntelIndicatorSource != null ? this.threatIntelIndicatorSource.hashCode() : 0);
                result = 31 * result + (this.threatIntelIndicatorSourceUrl != null ? this.threatIntelIndicatorSourceUrl.hashCode() : 0);
                result = 31 * result + (this.threatIntelIndicatorType != null ? this.threatIntelIndicatorType.hashCode() : 0);
                result = 31 * result + (this.threatIntelIndicatorValue != null ? this.threatIntelIndicatorValue.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.updatedAt != null ? this.updatedAt.hashCode() : 0);
                result = 31 * result + (this.userDefinedFields != null ? this.userDefinedFields.hashCode() : 0);
                result = 31 * result + (this.verificationState != null ? this.verificationState.hashCode() : 0);
                result = 31 * result + (this.vulnerabilitiesExploitAvailable != null ? this.vulnerabilitiesExploitAvailable.hashCode() : 0);
                result = 31 * result + (this.vulnerabilitiesFixAvailable != null ? this.vulnerabilitiesFixAvailable.hashCode() : 0);
                result = 31 * result + (this.workflowState != null ? this.workflowState.hashCode() : 0);
                result = 31 * result + (this.workflowStatus != null ? this.workflowStatus.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Boolean filter for querying findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * BooleanFilterProperty booleanFilterProperty = BooleanFilterProperty.builder()
     *         .value(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-booleanfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-booleanfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnInsight.BooleanFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(BooleanFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BooleanFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value of the boolean.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-booleanfilter.html#cfn-securityhub-insight-booleanfilter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-booleanfilter.html#cfn-securityhub-insight-booleanfilter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValue();

        /**
         * @return a {@link Builder} of {@link BooleanFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BooleanFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BooleanFilterProperty> {
            java.lang.Object value;

            /**
             * Sets the value of {@link BooleanFilterProperty#getValue}
             * @param value The value of the boolean. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Boolean value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link BooleanFilterProperty#getValue}
             * @param value The value of the boolean. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BooleanFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BooleanFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BooleanFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BooleanFilterProperty {
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnInsight.BooleanFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BooleanFilterProperty.Jsii$Proxy that = (BooleanFilterProperty.Jsii$Proxy) o;

                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                return result;
            }
        }
    }
    /**
     * A date filter for querying findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * DateFilterProperty dateFilterProperty = DateFilterProperty.builder()
     *         .dateRange(DateRangeProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .end("end")
     *         .start("start")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-datefilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-datefilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnInsight.DateFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(DateFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A date range for the date filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.securityhub.CfnInsight.DateRangeProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-datefilter.html#cfn-securityhub-insight-datefilter-daterange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-datefilter.html#cfn-securityhub-insight-datefilter-daterange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDateRange() {
            return null;
        }

        /**
         * A timestamp that provides the end date for the date filter.
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-datefilter.html#cfn-securityhub-insight-datefilter-end">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-datefilter.html#cfn-securityhub-insight-datefilter-end</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEnd() {
            return null;
        }

        /**
         * A timestamp that provides the start date for the date filter.
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-datefilter.html#cfn-securityhub-insight-datefilter-start">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-datefilter.html#cfn-securityhub-insight-datefilter-start</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStart() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateFilterProperty> {
            java.lang.Object dateRange;
            java.lang.String end;
            java.lang.String start;

            /**
             * Sets the value of {@link DateFilterProperty#getDateRange}
             * @param dateRange A date range for the date filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateRange(software.amazon.awscdk.IResolvable dateRange) {
                this.dateRange = dateRange;
                return this;
            }

            /**
             * Sets the value of {@link DateFilterProperty#getDateRange}
             * @param dateRange A date range for the date filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateRange(software.amazon.awscdk.services.securityhub.CfnInsight.DateRangeProperty dateRange) {
                this.dateRange = dateRange;
                return this;
            }

            /**
             * Sets the value of {@link DateFilterProperty#getEnd}
             * @param end A timestamp that provides the end date for the date filter.
             *            For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder end(java.lang.String end) {
                this.end = end;
                return this;
            }

            /**
             * Sets the value of {@link DateFilterProperty#getStart}
             * @param start A timestamp that provides the start date for the date filter.
             *              For more information about the validation and formatting of timestamp fields in Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder start(java.lang.String start) {
                this.start = start;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateFilterProperty {
            private final java.lang.Object dateRange;
            private final java.lang.String end;
            private final java.lang.String start;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateRange = software.amazon.jsii.Kernel.get(this, "dateRange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateRange = builder.dateRange;
                this.end = builder.end;
                this.start = builder.start;
            }

            @Override
            public final java.lang.Object getDateRange() {
                return this.dateRange;
            }

            @Override
            public final java.lang.String getEnd() {
                return this.end;
            }

            @Override
            public final java.lang.String getStart() {
                return this.start;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateRange() != null) {
                    data.set("dateRange", om.valueToTree(this.getDateRange()));
                }
                if (this.getEnd() != null) {
                    data.set("end", om.valueToTree(this.getEnd()));
                }
                if (this.getStart() != null) {
                    data.set("start", om.valueToTree(this.getStart()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnInsight.DateFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateFilterProperty.Jsii$Proxy that = (DateFilterProperty.Jsii$Proxy) o;

                if (this.dateRange != null ? !this.dateRange.equals(that.dateRange) : that.dateRange != null) return false;
                if (this.end != null ? !this.end.equals(that.end) : that.end != null) return false;
                return this.start != null ? this.start.equals(that.start) : that.start == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateRange != null ? this.dateRange.hashCode() : 0;
                result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
                result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A date range for the date filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * DateRangeProperty dateRangeProperty = DateRangeProperty.builder()
     *         .unit("unit")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-daterange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-daterange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnInsight.DateRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(DateRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A date range unit for the date filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-daterange.html#cfn-securityhub-insight-daterange-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-daterange.html#cfn-securityhub-insight-daterange-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * A date range value for the date filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-daterange.html#cfn-securityhub-insight-daterange-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-daterange.html#cfn-securityhub-insight-daterange-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link DateRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateRangeProperty> {
            java.lang.String unit;
            java.lang.Number value;

            /**
             * Sets the value of {@link DateRangeProperty#getUnit}
             * @param unit A date range unit for the date filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link DateRangeProperty#getValue}
             * @param value A date range value for the date filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateRangeProperty {
            private final java.lang.String unit;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("unit", om.valueToTree(this.getUnit()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnInsight.DateRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateRangeProperty.Jsii$Proxy that = (DateRangeProperty.Jsii$Proxy) o;

                if (!unit.equals(that.unit)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.unit.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The IP filter for querying findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * IpFilterProperty ipFilterProperty = IpFilterProperty.builder()
     *         .cidr("cidr")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-ipfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-ipfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnInsight.IpFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(IpFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IpFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A finding's CIDR value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-ipfilter.html#cfn-securityhub-insight-ipfilter-cidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-ipfilter.html#cfn-securityhub-insight-ipfilter-cidr</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCidr();

        /**
         * @return a {@link Builder} of {@link IpFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IpFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IpFilterProperty> {
            java.lang.String cidr;

            /**
             * Sets the value of {@link IpFilterProperty#getCidr}
             * @param cidr A finding's CIDR value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidr(java.lang.String cidr) {
                this.cidr = cidr;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IpFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IpFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IpFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IpFilterProperty {
            private final java.lang.String cidr;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cidr = software.amazon.jsii.Kernel.get(this, "cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cidr = java.util.Objects.requireNonNull(builder.cidr, "cidr is required");
            }

            @Override
            public final java.lang.String getCidr() {
                return this.cidr;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cidr", om.valueToTree(this.getCidr()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnInsight.IpFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IpFilterProperty.Jsii$Proxy that = (IpFilterProperty.Jsii$Proxy) o;

                return this.cidr.equals(that.cidr);
            }

            @Override
            public final int hashCode() {
                int result = this.cidr.hashCode();
                return result;
            }
        }
    }
    /**
     * A keyword filter for querying findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * KeywordFilterProperty keywordFilterProperty = KeywordFilterProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-keywordfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-keywordfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnInsight.KeywordFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(KeywordFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeywordFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value for the keyword.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-keywordfilter.html#cfn-securityhub-insight-keywordfilter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-keywordfilter.html#cfn-securityhub-insight-keywordfilter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link KeywordFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeywordFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeywordFilterProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link KeywordFilterProperty#getValue}
             * @param value A value for the keyword. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeywordFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeywordFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeywordFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeywordFilterProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnInsight.KeywordFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeywordFilterProperty.Jsii$Proxy that = (KeywordFilterProperty.Jsii$Proxy) o;

                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                return result;
            }
        }
    }
    /**
     * A map filter for filtering Security Hub findings.
     * <p>
     * Each map filter provides the field to check for, the value to check for, and the comparison operator.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * MapFilterProperty mapFilterProperty = MapFilterProperty.builder()
     *         .comparison("comparison")
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-mapfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-mapfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnInsight.MapFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(MapFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MapFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The condition to apply to the key value when filtering Security Hub findings with a map filter.
         * <p>
         * To search for values that have the filter value, use one of the following comparison operators:
         * <p>
         * <ul>
         * <li>To search for values that include the filter value, use <code>CONTAINS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department CONTAINS Security</code> matches findings that include the value <code>Security</code> for the <code>Department</code> tag. In the same example, a finding with a value of <code>Security team</code> for the <code>Department</code> tag is a match.</li>
         * <li>To search for values that exactly match the filter value, use <code>EQUALS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department EQUALS Security</code> matches findings that have the value <code>Security</code> for the <code>Department</code> tag.</li>
         * </ul>
         * <p>
         * <code>CONTAINS</code> and <code>EQUALS</code> filters on the same field are joined by <code>OR</code> . A finding matches if it matches any one of those filters. For example, the filters <code>Department CONTAINS Security OR Department CONTAINS Finance</code> match a finding that includes either <code>Security</code> , <code>Finance</code> , or both values.
         * <p>
         * To search for values that don't have the filter value, use one of the following comparison operators:
         * <p>
         * <ul>
         * <li>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_CONTAINS Finance</code> matches findings that exclude the value <code>Finance</code> for the <code>Department</code> tag.</li>
         * <li>To search for values other than the filter value, use <code>NOT_EQUALS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_EQUALS Finance</code> matches findings that don’t have the value <code>Finance</code> for the <code>Department</code> tag.</li>
         * </ul>
         * <p>
         * <code>NOT_CONTAINS</code> and <code>NOT_EQUALS</code> filters on the same field are joined by <code>AND</code> . A finding matches only if it matches all of those filters. For example, the filters <code>Department NOT_CONTAINS Security AND Department NOT_CONTAINS Finance</code> match a finding that excludes both the <code>Security</code> and <code>Finance</code> values.
         * <p>
         * <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters.
         * <p>
         * You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can’t have both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error.
         * <p>
         * <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <em>Security Hub User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-mapfilter.html#cfn-securityhub-insight-mapfilter-comparison">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-mapfilter.html#cfn-securityhub-insight-mapfilter-comparison</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparison();

        /**
         * The key of the map filter.
         * <p>
         * For example, for <code>ResourceTags</code> , <code>Key</code> identifies the name of the tag. For <code>UserDefinedFields</code> , <code>Key</code> is the name of the field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-mapfilter.html#cfn-securityhub-insight-mapfilter-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-mapfilter.html#cfn-securityhub-insight-mapfilter-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value for the key in the map filter.
         * <p>
         * Filter values are case sensitive. For example, one of the values for a tag called <code>Department</code> might be <code>Security</code> . If you provide <code>security</code> as the filter value, then there's no match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-mapfilter.html#cfn-securityhub-insight-mapfilter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-mapfilter.html#cfn-securityhub-insight-mapfilter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MapFilterProperty> {
            java.lang.String comparison;
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link MapFilterProperty#getComparison}
             * @param comparison The condition to apply to the key value when filtering Security Hub findings with a map filter. This parameter is required.
             *                   To search for values that have the filter value, use one of the following comparison operators:
             *                   <p>
             *                   <ul>
             *                   <li>To search for values that include the filter value, use <code>CONTAINS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department CONTAINS Security</code> matches findings that include the value <code>Security</code> for the <code>Department</code> tag. In the same example, a finding with a value of <code>Security team</code> for the <code>Department</code> tag is a match.</li>
             *                   <li>To search for values that exactly match the filter value, use <code>EQUALS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department EQUALS Security</code> matches findings that have the value <code>Security</code> for the <code>Department</code> tag.</li>
             *                   </ul>
             *                   <p>
             *                   <code>CONTAINS</code> and <code>EQUALS</code> filters on the same field are joined by <code>OR</code> . A finding matches if it matches any one of those filters. For example, the filters <code>Department CONTAINS Security OR Department CONTAINS Finance</code> match a finding that includes either <code>Security</code> , <code>Finance</code> , or both values.
             *                   <p>
             *                   To search for values that don't have the filter value, use one of the following comparison operators:
             *                   <p>
             *                   <ul>
             *                   <li>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_CONTAINS Finance</code> matches findings that exclude the value <code>Finance</code> for the <code>Department</code> tag.</li>
             *                   <li>To search for values other than the filter value, use <code>NOT_EQUALS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_EQUALS Finance</code> matches findings that don’t have the value <code>Finance</code> for the <code>Department</code> tag.</li>
             *                   </ul>
             *                   <p>
             *                   <code>NOT_CONTAINS</code> and <code>NOT_EQUALS</code> filters on the same field are joined by <code>AND</code> . A finding matches only if it matches all of those filters. For example, the filters <code>Department NOT_CONTAINS Security AND Department NOT_CONTAINS Finance</code> match a finding that excludes both the <code>Security</code> and <code>Finance</code> values.
             *                   <p>
             *                   <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters.
             *                   <p>
             *                   You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can’t have both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error.
             *                   <p>
             *                   <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <em>Security Hub User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparison(java.lang.String comparison) {
                this.comparison = comparison;
                return this;
            }

            /**
             * Sets the value of {@link MapFilterProperty#getKey}
             * @param key The key of the map filter. This parameter is required.
             *            For example, for <code>ResourceTags</code> , <code>Key</code> identifies the name of the tag. For <code>UserDefinedFields</code> , <code>Key</code> is the name of the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link MapFilterProperty#getValue}
             * @param value The value for the key in the map filter. This parameter is required.
             *              Filter values are case sensitive. For example, one of the values for a tag called <code>Department</code> might be <code>Security</code> . If you provide <code>security</code> as the filter value, then there's no match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MapFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MapFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MapFilterProperty {
            private final java.lang.String comparison;
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparison = software.amazon.jsii.Kernel.get(this, "comparison", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparison = java.util.Objects.requireNonNull(builder.comparison, "comparison is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getComparison() {
                return this.comparison;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparison", om.valueToTree(this.getComparison()));
                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnInsight.MapFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MapFilterProperty.Jsii$Proxy that = (MapFilterProperty.Jsii$Proxy) o;

                if (!comparison.equals(that.comparison)) return false;
                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.comparison.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * A number filter for querying findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * NumberFilterProperty numberFilterProperty = NumberFilterProperty.builder()
     *         .eq(123)
     *         .gte(123)
     *         .lte(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-numberfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-numberfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnInsight.NumberFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(NumberFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NumberFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The equal-to condition to be applied to a single field when querying for findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-numberfilter.html#cfn-securityhub-insight-numberfilter-eq">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-numberfilter.html#cfn-securityhub-insight-numberfilter-eq</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEq() {
            return null;
        }

        /**
         * The greater-than-equal condition to be applied to a single field when querying for findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-numberfilter.html#cfn-securityhub-insight-numberfilter-gte">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-numberfilter.html#cfn-securityhub-insight-numberfilter-gte</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGte() {
            return null;
        }

        /**
         * The less-than-equal condition to be applied to a single field when querying for findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-numberfilter.html#cfn-securityhub-insight-numberfilter-lte">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-numberfilter.html#cfn-securityhub-insight-numberfilter-lte</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLte() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NumberFilterProperty> {
            java.lang.Number eq;
            java.lang.Number gte;
            java.lang.Number lte;

            /**
             * Sets the value of {@link NumberFilterProperty#getEq}
             * @param eq The equal-to condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eq(java.lang.Number eq) {
                this.eq = eq;
                return this;
            }

            /**
             * Sets the value of {@link NumberFilterProperty#getGte}
             * @param gte The greater-than-equal condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gte(java.lang.Number gte) {
                this.gte = gte;
                return this;
            }

            /**
             * Sets the value of {@link NumberFilterProperty#getLte}
             * @param lte The less-than-equal condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lte(java.lang.Number lte) {
                this.lte = lte;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NumberFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NumberFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NumberFilterProperty {
            private final java.lang.Number eq;
            private final java.lang.Number gte;
            private final java.lang.Number lte;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eq = software.amazon.jsii.Kernel.get(this, "eq", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.gte = software.amazon.jsii.Kernel.get(this, "gte", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.lte = software.amazon.jsii.Kernel.get(this, "lte", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eq = builder.eq;
                this.gte = builder.gte;
                this.lte = builder.lte;
            }

            @Override
            public final java.lang.Number getEq() {
                return this.eq;
            }

            @Override
            public final java.lang.Number getGte() {
                return this.gte;
            }

            @Override
            public final java.lang.Number getLte() {
                return this.lte;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEq() != null) {
                    data.set("eq", om.valueToTree(this.getEq()));
                }
                if (this.getGte() != null) {
                    data.set("gte", om.valueToTree(this.getGte()));
                }
                if (this.getLte() != null) {
                    data.set("lte", om.valueToTree(this.getLte()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnInsight.NumberFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NumberFilterProperty.Jsii$Proxy that = (NumberFilterProperty.Jsii$Proxy) o;

                if (this.eq != null ? !this.eq.equals(that.eq) : that.eq != null) return false;
                if (this.gte != null ? !this.gte.equals(that.gte) : that.gte != null) return false;
                return this.lte != null ? this.lte.equals(that.lte) : that.lte == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eq != null ? this.eq.hashCode() : 0;
                result = 31 * result + (this.gte != null ? this.gte.hashCode() : 0);
                result = 31 * result + (this.lte != null ? this.lte.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A string filter for filtering Security Hub findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * StringFilterProperty stringFilterProperty = StringFilterProperty.builder()
     *         .comparison("comparison")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-stringfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-stringfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnInsight.StringFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(StringFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StringFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The condition to apply to a string value when filtering Security Hub findings.
         * <p>
         * To search for values that have the filter value, use one of the following comparison operators:
         * <p>
         * <ul>
         * <li>To search for values that include the filter value, use <code>CONTAINS</code> . For example, the filter <code>Title CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that includes the string CloudFront.</li>
         * <li>To search for values that exactly match the filter value, use <code>EQUALS</code> . For example, the filter <code>AwsAccountId EQUALS 123456789012</code> only matches findings that have an account ID of <code>123456789012</code> .</li>
         * <li>To search for values that start with the filter value, use <code>PREFIX</code> . For example, the filter <code>ResourceRegion PREFIX us</code> matches findings that have a <code>ResourceRegion</code> that starts with <code>us</code> . A <code>ResourceRegion</code> that starts with a different value, such as <code>af</code> , <code>ap</code> , or <code>ca</code> , doesn't match.</li>
         * </ul>
         * <p>
         * <code>CONTAINS</code> , <code>EQUALS</code> , and <code>PREFIX</code> filters on the same field are joined by <code>OR</code> . A finding matches if it matches any one of those filters. For example, the filters <code>Title CONTAINS CloudFront OR Title CONTAINS CloudWatch</code> match a finding that includes either <code>CloudFront</code> , <code>CloudWatch</code> , or both strings in the title.
         * <p>
         * To search for values that don’t have the filter value, use one of the following comparison operators:
         * <p>
         * <ul>
         * <li>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code> . For example, the filter <code>Title NOT_CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that excludes the string CloudFront.</li>
         * <li>To search for values other than the filter value, use <code>NOT_EQUALS</code> . For example, the filter <code>AwsAccountId NOT_EQUALS 123456789012</code> only matches findings that have an account ID other than <code>123456789012</code> .</li>
         * <li>To search for values that don't start with the filter value, use <code>PREFIX_NOT_EQUALS</code> . For example, the filter <code>ResourceRegion PREFIX_NOT_EQUALS us</code> matches findings with a <code>ResourceRegion</code> that starts with a value other than <code>us</code> .</li>
         * </ul>
         * <p>
         * <code>NOT_CONTAINS</code> , <code>NOT_EQUALS</code> , and <code>PREFIX_NOT_EQUALS</code> filters on the same field are joined by <code>AND</code> . A finding matches only if it matches all of those filters. For example, the filters <code>Title NOT_CONTAINS CloudFront AND Title NOT_CONTAINS CloudWatch</code> match a finding that excludes both <code>CloudFront</code> and <code>CloudWatch</code> in the title.
         * <p>
         * You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can't provide both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error. <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters.
         * <p>
         * You can combine <code>PREFIX</code> filters with <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters for the same field. Security Hub first processes the <code>PREFIX</code> filters, and then the <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters.
         * <p>
         * For example, for the following filters, Security Hub first identifies findings that have resource types that start with either <code>AwsIam</code> or <code>AwsEc2</code> . It then excludes findings that have a resource type of <code>AwsIamPolicy</code> and findings that have a resource type of <code>AwsEc2NetworkInterface</code> .
         * <p>
         * <ul>
         * <li><code>ResourceType PREFIX AwsIam</code></li>
         * <li><code>ResourceType PREFIX AwsEc2</code></li>
         * <li><code>ResourceType NOT_EQUALS AwsIamPolicy</code></li>
         * <li><code>ResourceType NOT_EQUALS AwsEc2NetworkInterface</code></li>
         * </ul>
         * <p>
         * <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules V1. <code>CONTAINS_WORD</code> operator is only supported in <code>GetFindingsV2</code> , <code>GetFindingStatisticsV2</code> , <code>GetResourcesV2</code> , and <code>GetResourceStatisticsV2</code> APIs. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <em>Security Hub User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-stringfilter.html#cfn-securityhub-insight-stringfilter-comparison">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-stringfilter.html#cfn-securityhub-insight-stringfilter-comparison</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparison();

        /**
         * The string filter value.
         * <p>
         * Filter values are case sensitive. For example, the product name for control-based findings is <code>Security Hub</code> . If you provide <code>security hub</code> as the filter value, there's no match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-stringfilter.html#cfn-securityhub-insight-stringfilter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-insight-stringfilter.html#cfn-securityhub-insight-stringfilter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link StringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StringFilterProperty> {
            java.lang.String comparison;
            java.lang.String value;

            /**
             * Sets the value of {@link StringFilterProperty#getComparison}
             * @param comparison The condition to apply to a string value when filtering Security Hub findings. This parameter is required.
             *                   To search for values that have the filter value, use one of the following comparison operators:
             *                   <p>
             *                   <ul>
             *                   <li>To search for values that include the filter value, use <code>CONTAINS</code> . For example, the filter <code>Title CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that includes the string CloudFront.</li>
             *                   <li>To search for values that exactly match the filter value, use <code>EQUALS</code> . For example, the filter <code>AwsAccountId EQUALS 123456789012</code> only matches findings that have an account ID of <code>123456789012</code> .</li>
             *                   <li>To search for values that start with the filter value, use <code>PREFIX</code> . For example, the filter <code>ResourceRegion PREFIX us</code> matches findings that have a <code>ResourceRegion</code> that starts with <code>us</code> . A <code>ResourceRegion</code> that starts with a different value, such as <code>af</code> , <code>ap</code> , or <code>ca</code> , doesn't match.</li>
             *                   </ul>
             *                   <p>
             *                   <code>CONTAINS</code> , <code>EQUALS</code> , and <code>PREFIX</code> filters on the same field are joined by <code>OR</code> . A finding matches if it matches any one of those filters. For example, the filters <code>Title CONTAINS CloudFront OR Title CONTAINS CloudWatch</code> match a finding that includes either <code>CloudFront</code> , <code>CloudWatch</code> , or both strings in the title.
             *                   <p>
             *                   To search for values that don’t have the filter value, use one of the following comparison operators:
             *                   <p>
             *                   <ul>
             *                   <li>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code> . For example, the filter <code>Title NOT_CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that excludes the string CloudFront.</li>
             *                   <li>To search for values other than the filter value, use <code>NOT_EQUALS</code> . For example, the filter <code>AwsAccountId NOT_EQUALS 123456789012</code> only matches findings that have an account ID other than <code>123456789012</code> .</li>
             *                   <li>To search for values that don't start with the filter value, use <code>PREFIX_NOT_EQUALS</code> . For example, the filter <code>ResourceRegion PREFIX_NOT_EQUALS us</code> matches findings with a <code>ResourceRegion</code> that starts with a value other than <code>us</code> .</li>
             *                   </ul>
             *                   <p>
             *                   <code>NOT_CONTAINS</code> , <code>NOT_EQUALS</code> , and <code>PREFIX_NOT_EQUALS</code> filters on the same field are joined by <code>AND</code> . A finding matches only if it matches all of those filters. For example, the filters <code>Title NOT_CONTAINS CloudFront AND Title NOT_CONTAINS CloudWatch</code> match a finding that excludes both <code>CloudFront</code> and <code>CloudWatch</code> in the title.
             *                   <p>
             *                   You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can't provide both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error. <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters.
             *                   <p>
             *                   You can combine <code>PREFIX</code> filters with <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters for the same field. Security Hub first processes the <code>PREFIX</code> filters, and then the <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters.
             *                   <p>
             *                   For example, for the following filters, Security Hub first identifies findings that have resource types that start with either <code>AwsIam</code> or <code>AwsEc2</code> . It then excludes findings that have a resource type of <code>AwsIamPolicy</code> and findings that have a resource type of <code>AwsEc2NetworkInterface</code> .
             *                   <p>
             *                   <ul>
             *                   <li><code>ResourceType PREFIX AwsIam</code></li>
             *                   <li><code>ResourceType PREFIX AwsEc2</code></li>
             *                   <li><code>ResourceType NOT_EQUALS AwsIamPolicy</code></li>
             *                   <li><code>ResourceType NOT_EQUALS AwsEc2NetworkInterface</code></li>
             *                   </ul>
             *                   <p>
             *                   <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules V1. <code>CONTAINS_WORD</code> operator is only supported in <code>GetFindingsV2</code> , <code>GetFindingStatisticsV2</code> , <code>GetResourcesV2</code> , and <code>GetResourceStatisticsV2</code> APIs. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <em>Security Hub User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparison(java.lang.String comparison) {
                this.comparison = comparison;
                return this;
            }

            /**
             * Sets the value of {@link StringFilterProperty#getValue}
             * @param value The string filter value. This parameter is required.
             *              Filter values are case sensitive. For example, the product name for control-based findings is <code>Security Hub</code> . If you provide <code>security hub</code> as the filter value, there's no match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StringFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StringFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringFilterProperty {
            private final java.lang.String comparison;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparison = software.amazon.jsii.Kernel.get(this, "comparison", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparison = java.util.Objects.requireNonNull(builder.comparison, "comparison is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getComparison() {
                return this.comparison;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparison", om.valueToTree(this.getComparison()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnInsight.StringFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StringFilterProperty.Jsii$Proxy that = (StringFilterProperty.Jsii$Proxy) o;

                if (!comparison.equals(that.comparison)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.comparison.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.securityhub.CfnInsight}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.securityhub.CfnInsight> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.securityhub.CfnInsightProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.securityhub.CfnInsightProps.Builder();
        }

        /**
         * One or more attributes used to filter the findings included in the insight.
         * <p>
         * The insight only includes findings that match the criteria defined in the filters. You can filter by up to ten finding attributes. For each attribute, you can provide up to 20 filter values.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-filters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-filters</a>
         * @param filters One or more attributes used to filter the findings included in the insight. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(final software.amazon.awscdk.IResolvable filters) {
            this.props.filters(filters);
            return this;
        }
        /**
         * One or more attributes used to filter the findings included in the insight.
         * <p>
         * The insight only includes findings that match the criteria defined in the filters. You can filter by up to ten finding attributes. For each attribute, you can provide up to 20 filter values.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-filters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-filters</a>
         * @param filters One or more attributes used to filter the findings included in the insight. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(final software.amazon.awscdk.services.securityhub.CfnInsight.AwsSecurityFindingFiltersProperty filters) {
            this.props.filters(filters);
            return this;
        }

        /**
         * The grouping attribute for the insight's findings.
         * <p>
         * Indicates how to group the matching findings, and identifies the type of item that the insight applies to. For example, if an insight is grouped by resource identifier, then the insight produces a list of resource identifiers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-groupbyattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-groupbyattribute</a>
         * @param groupByAttribute The grouping attribute for the insight's findings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupByAttribute(final java.lang.String groupByAttribute) {
            this.props.groupByAttribute(groupByAttribute);
            return this;
        }

        /**
         * The name of a Security Hub insight.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-insight.html#cfn-securityhub-insight-name</a>
         * @param name The name of a Security Hub insight. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.securityhub.CfnInsight}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.securityhub.CfnInsight build() {
            return new software.amazon.awscdk.services.securityhub.CfnInsight(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
