package software.amazon.awscdk.services.ses;

/**
 * Properties for defining a <code>CfnMailManagerTrafficPolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnMailManagerTrafficPolicyProps cfnMailManagerTrafficPolicyProps = CfnMailManagerTrafficPolicyProps.builder()
 *         .defaultAction("defaultAction")
 *         .policyStatements(List.of(PolicyStatementProperty.builder()
 *                 .action("action")
 *                 .conditions(List.of(PolicyConditionProperty.builder()
 *                         .booleanExpression(IngressBooleanExpressionProperty.builder()
 *                                 .evaluate(IngressBooleanToEvaluateProperty.builder()
 *                                         .analysis(IngressAnalysisProperty.builder()
 *                                                 .analyzer("analyzer")
 *                                                 .resultField("resultField")
 *                                                 .build())
 *                                         .isInAddressList(IngressIsInAddressListProperty.builder()
 *                                                 .addressLists(List.of("addressLists"))
 *                                                 .attribute("attribute")
 *                                                 .build())
 *                                         .build())
 *                                 .operator("operator")
 *                                 .build())
 *                         .ipExpression(IngressIpv4ExpressionProperty.builder()
 *                                 .evaluate(IngressIpToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .ipv6Expression(IngressIpv6ExpressionProperty.builder()
 *                                 .evaluate(IngressIpv6ToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .stringExpression(IngressStringExpressionProperty.builder()
 *                                 .evaluate(IngressStringToEvaluateProperty.builder()
 *                                         .analysis(IngressAnalysisProperty.builder()
 *                                                 .analyzer("analyzer")
 *                                                 .resultField("resultField")
 *                                                 .build())
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .tlsExpression(IngressTlsProtocolExpressionProperty.builder()
 *                                 .evaluate(IngressTlsProtocolToEvaluateProperty.builder()
 *                                         .attribute("attribute")
 *                                         .build())
 *                                 .operator("operator")
 *                                 .value("value")
 *                                 .build())
 *                         .build()))
 *                 .build()))
 *         // the properties below are optional
 *         .maxMessageSizeBytes(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trafficPolicyName("trafficPolicyName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:30.007Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnMailManagerTrafficPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMailManagerTrafficPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not addressed by) the conditions of your policy statements.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-defaultaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-defaultaction</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDefaultAction();

    /**
     * Conditional statements for filtering email traffic.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ses.CfnMailManagerTrafficPolicy.PolicyStatementProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-policystatements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-policystatements</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPolicyStatements();

    /**
     * The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be blocked.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-maxmessagesizebytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-maxmessagesizebytes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxMessageSizeBytes() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for the resource.
     * <p>
     * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The name of the policy.
     * <p>
     * The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-trafficpolicyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-mailmanagertrafficpolicy.html#cfn-ses-mailmanagertrafficpolicy-trafficpolicyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTrafficPolicyName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMailManagerTrafficPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMailManagerTrafficPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMailManagerTrafficPolicyProps> {
        java.lang.String defaultAction;
        java.lang.Object policyStatements;
        java.lang.Number maxMessageSizeBytes;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String trafficPolicyName;

        /**
         * Sets the value of {@link CfnMailManagerTrafficPolicyProps#getDefaultAction}
         * @param defaultAction Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not addressed by) the conditions of your policy statements. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAction(java.lang.String defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerTrafficPolicyProps#getPolicyStatements}
         * @param policyStatements Conditional statements for filtering email traffic. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStatements(software.amazon.awscdk.IResolvable policyStatements) {
            this.policyStatements = policyStatements;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerTrafficPolicyProps#getPolicyStatements}
         * @param policyStatements Conditional statements for filtering email traffic. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStatements(java.util.List<? extends java.lang.Object> policyStatements) {
            this.policyStatements = policyStatements;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerTrafficPolicyProps#getMaxMessageSizeBytes}
         * @param maxMessageSizeBytes The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be blocked.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxMessageSizeBytes(java.lang.Number maxMessageSizeBytes) {
            this.maxMessageSizeBytes = maxMessageSizeBytes;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerTrafficPolicyProps#getTags}
         * @param tags The tags used to organize, track, or control access for the resource.
         *             For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnMailManagerTrafficPolicyProps#getTrafficPolicyName}
         * @param trafficPolicyName The name of the policy.
         *                          The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficPolicyName(java.lang.String trafficPolicyName) {
            this.trafficPolicyName = trafficPolicyName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMailManagerTrafficPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMailManagerTrafficPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMailManagerTrafficPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMailManagerTrafficPolicyProps {
        private final java.lang.String defaultAction;
        private final java.lang.Object policyStatements;
        private final java.lang.Number maxMessageSizeBytes;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String trafficPolicyName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultAction = software.amazon.jsii.Kernel.get(this, "defaultAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyStatements = software.amazon.jsii.Kernel.get(this, "policyStatements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maxMessageSizeBytes = software.amazon.jsii.Kernel.get(this, "maxMessageSizeBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.trafficPolicyName = software.amazon.jsii.Kernel.get(this, "trafficPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultAction = java.util.Objects.requireNonNull(builder.defaultAction, "defaultAction is required");
            this.policyStatements = java.util.Objects.requireNonNull(builder.policyStatements, "policyStatements is required");
            this.maxMessageSizeBytes = builder.maxMessageSizeBytes;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.trafficPolicyName = builder.trafficPolicyName;
        }

        @Override
        public final java.lang.String getDefaultAction() {
            return this.defaultAction;
        }

        @Override
        public final java.lang.Object getPolicyStatements() {
            return this.policyStatements;
        }

        @Override
        public final java.lang.Number getMaxMessageSizeBytes() {
            return this.maxMessageSizeBytes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTrafficPolicyName() {
            return this.trafficPolicyName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("defaultAction", om.valueToTree(this.getDefaultAction()));
            data.set("policyStatements", om.valueToTree(this.getPolicyStatements()));
            if (this.getMaxMessageSizeBytes() != null) {
                data.set("maxMessageSizeBytes", om.valueToTree(this.getMaxMessageSizeBytes()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTrafficPolicyName() != null) {
                data.set("trafficPolicyName", om.valueToTree(this.getTrafficPolicyName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnMailManagerTrafficPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMailManagerTrafficPolicyProps.Jsii$Proxy that = (CfnMailManagerTrafficPolicyProps.Jsii$Proxy) o;

            if (!defaultAction.equals(that.defaultAction)) return false;
            if (!policyStatements.equals(that.policyStatements)) return false;
            if (this.maxMessageSizeBytes != null ? !this.maxMessageSizeBytes.equals(that.maxMessageSizeBytes) : that.maxMessageSizeBytes != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.trafficPolicyName != null ? this.trafficPolicyName.equals(that.trafficPolicyName) : that.trafficPolicyName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultAction.hashCode();
            result = 31 * result + (this.policyStatements.hashCode());
            result = 31 * result + (this.maxMessageSizeBytes != null ? this.maxMessageSizeBytes.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.trafficPolicyName != null ? this.trafficPolicyName.hashCode() : 0);
            return result;
        }
    }
}
