package software.amazon.awscdk.services.ses;

/**
 * Configuration for DKIM identity.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * DkimIdentityConfig dkimIdentityConfig = DkimIdentityConfig.builder()
 *         .domainSigningPrivateKey("domainSigningPrivateKey")
 *         .domainSigningSelector("domainSigningSelector")
 *         .nextSigningKeyLength(EasyDkimSigningKeyLength.RSA_1024_BIT)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:30.030Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.DkimIdentityConfig")
@software.amazon.jsii.Jsii.Proxy(DkimIdentityConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DkimIdentityConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * A private key that's used to generate a DKIM signature.
     * <p>
     * Default: - use Easy DKIM
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainSigningPrivateKey() {
        return null;
    }

    /**
     * A string that's used to identify a public key in the DNS configuration for a domain.
     * <p>
     * Default: - use Easy DKIM
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainSigningSelector() {
        return null;
    }

    /**
     * The key length of the future DKIM key pair to be generated.
     * <p>
     * This can be changed
     * at most once per day.
     * <p>
     * Default: EasyDkimSigningKeyLength.RSA_2048_BIT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.EasyDkimSigningKeyLength getNextSigningKeyLength() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DkimIdentityConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DkimIdentityConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DkimIdentityConfig> {
        java.lang.String domainSigningPrivateKey;
        java.lang.String domainSigningSelector;
        software.amazon.awscdk.services.ses.EasyDkimSigningKeyLength nextSigningKeyLength;

        /**
         * Sets the value of {@link DkimIdentityConfig#getDomainSigningPrivateKey}
         * @param domainSigningPrivateKey A private key that's used to generate a DKIM signature.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainSigningPrivateKey(java.lang.String domainSigningPrivateKey) {
            this.domainSigningPrivateKey = domainSigningPrivateKey;
            return this;
        }

        /**
         * Sets the value of {@link DkimIdentityConfig#getDomainSigningSelector}
         * @param domainSigningSelector A string that's used to identify a public key in the DNS configuration for a domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainSigningSelector(java.lang.String domainSigningSelector) {
            this.domainSigningSelector = domainSigningSelector;
            return this;
        }

        /**
         * Sets the value of {@link DkimIdentityConfig#getNextSigningKeyLength}
         * @param nextSigningKeyLength The key length of the future DKIM key pair to be generated.
         *                             This can be changed
         *                             at most once per day.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nextSigningKeyLength(software.amazon.awscdk.services.ses.EasyDkimSigningKeyLength nextSigningKeyLength) {
            this.nextSigningKeyLength = nextSigningKeyLength;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DkimIdentityConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DkimIdentityConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DkimIdentityConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DkimIdentityConfig {
        private final java.lang.String domainSigningPrivateKey;
        private final java.lang.String domainSigningSelector;
        private final software.amazon.awscdk.services.ses.EasyDkimSigningKeyLength nextSigningKeyLength;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainSigningPrivateKey = software.amazon.jsii.Kernel.get(this, "domainSigningPrivateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainSigningSelector = software.amazon.jsii.Kernel.get(this, "domainSigningSelector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nextSigningKeyLength = software.amazon.jsii.Kernel.get(this, "nextSigningKeyLength", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.EasyDkimSigningKeyLength.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainSigningPrivateKey = builder.domainSigningPrivateKey;
            this.domainSigningSelector = builder.domainSigningSelector;
            this.nextSigningKeyLength = builder.nextSigningKeyLength;
        }

        @Override
        public final java.lang.String getDomainSigningPrivateKey() {
            return this.domainSigningPrivateKey;
        }

        @Override
        public final java.lang.String getDomainSigningSelector() {
            return this.domainSigningSelector;
        }

        @Override
        public final software.amazon.awscdk.services.ses.EasyDkimSigningKeyLength getNextSigningKeyLength() {
            return this.nextSigningKeyLength;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDomainSigningPrivateKey() != null) {
                data.set("domainSigningPrivateKey", om.valueToTree(this.getDomainSigningPrivateKey()));
            }
            if (this.getDomainSigningSelector() != null) {
                data.set("domainSigningSelector", om.valueToTree(this.getDomainSigningSelector()));
            }
            if (this.getNextSigningKeyLength() != null) {
                data.set("nextSigningKeyLength", om.valueToTree(this.getNextSigningKeyLength()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.DkimIdentityConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DkimIdentityConfig.Jsii$Proxy that = (DkimIdentityConfig.Jsii$Proxy) o;

            if (this.domainSigningPrivateKey != null ? !this.domainSigningPrivateKey.equals(that.domainSigningPrivateKey) : that.domainSigningPrivateKey != null) return false;
            if (this.domainSigningSelector != null ? !this.domainSigningSelector.equals(that.domainSigningSelector) : that.domainSigningSelector != null) return false;
            return this.nextSigningKeyLength != null ? this.nextSigningKeyLength.equals(that.nextSigningKeyLength) : that.nextSigningKeyLength == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainSigningPrivateKey != null ? this.domainSigningPrivateKey.hashCode() : 0;
            result = 31 * result + (this.domainSigningSelector != null ? this.domainSigningSelector.hashCode() : 0);
            result = 31 * result + (this.nextSigningKeyLength != null ? this.nextSigningKeyLength.hashCode() : 0);
            return result;
        }
    }
}
