package software.amazon.awscdk.services.ses;

/**
 * Scaling mode to use for this IP pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DedicatedIpPool.Builder.create(this, "Pool")
 *         .dedicatedIpPoolName("mypool")
 *         .scalingMode(ScalingMode.STANDARD)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/ses/latest/dg/dedicated-ip.html">https://docs.aws.amazon.com/ses/latest/dg/dedicated-ip.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:30.060Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.ScalingMode")
public enum ScalingMode {
    /**
     * The customer controls which IPs are part of the dedicated IP pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * The reputation and number of IPs are automatically managed by Amazon SES.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MANAGED,
}
