package software.amazon.awscdk.services.sns;

/**
 * The type of supported protocol for delivery status logging.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role role;
 * Topic topic = Topic.Builder.create(this, "MyTopic")
 *         .loggingConfigs(List.of(LoggingConfig.builder()
 *                 .protocol(LoggingProtocol.SQS)
 *                 .failureFeedbackRole(role)
 *                 .successFeedbackRole(role)
 *                 .successFeedbackSampleRate(50)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:30.174Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.LoggingProtocol")
public enum LoggingProtocol {
    /**
     * HTTP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP,
    /**
     * Amazon Simple Queue Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SQS,
    /**
     * AWS Lambda.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA,
    /**
     * Amazon Data Firehose.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIREHOSE,
    /**
     * Platform application endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    APPLICATION,
}
