package software.amazon.awscdk.services.sqs;

/**
 * Collection of grant methods for a IQueueRef.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sqs.*;
 * import software.amazon.awscdk.interfaces.sqs.*;
 * IQueueRef queueRef;
 * QueueGrants queueGrants = QueueGrants.fromQueue(queueRef);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:30.229Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sqs.QueueGrants")
public class QueueGrants extends software.amazon.jsii.JsiiObject {

    protected QueueGrants(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected QueueGrants(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates grants for QueueGrants.
     * <p>
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.QueueGrants fromQueue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.sqs.IQueueRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sqs.QueueGrants.class, "fromQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.QueueGrants.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Grant permissions to consume messages from a queue.
     * <p>
     * This will grant the following permissions:
     * <p>
     * <ul>
     * <li>sqs:ChangeMessageVisibility</li>
     * <li>sqs:DeleteMessage</li>
     * <li>sqs:ReceiveMessage</li>
     * <li>sqs:GetQueueAttributes</li>
     * <li>sqs:GetQueueUrl</li>
     * </ul>
     * <p>
     * If encryption is used, permission to use the key to decrypt the contents of the queue will also be granted to the same principal.
     * <p>
     * This will grant the following KMS permissions:
     * <p>
     * <ul>
     * <li>kms:Decrypt</li>
     * </ul>
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant consumeMessages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "consumeMessages", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grants purge permissions.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant purge(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "purge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant access to send messages to a queue to the given identity.
     * <p>
     * This will grant the following permissions:
     * <p>
     * <ul>
     * <li>sqs:SendMessage</li>
     * <li>sqs:GetQueueAttributes</li>
     * <li>sqs:GetQueueUrl</li>
     * </ul>
     * <p>
     * If encryption is used, permission to use the key to encrypt/decrypt the contents of the queue will also be granted to the same principal.
     * <p>
     * This will grant the following KMS permissions:
     * <p>
     * <ul>
     * <li>kms:Decrypt</li>
     * <li>kms:Encrypt</li>
     * <li>kms:ReEncrypt*</li>
     * <li>kms:GenerateDataKey*</li>
     * </ul>
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant sendMessages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "sendMessages", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.sqs.IQueueRef getResource() {
        return software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.sqs.IQueueRef.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IEncryptedResource getEncryptedResource() {
        return software.amazon.jsii.Kernel.get(this, "encryptedResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IEncryptedResource.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IResourceWithPolicyV2 getPolicyResource() {
        return software.amazon.jsii.Kernel.get(this, "policyResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IResourceWithPolicyV2.class));
    }
}
