package software.amazon.awscdk.services.ssm;

/**
 * Properties for defining a <code>CfnResourceDataSync</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssm.*;
 * CfnResourceDataSyncProps cfnResourceDataSyncProps = CfnResourceDataSyncProps.builder()
 *         .syncName("syncName")
 *         // the properties below are optional
 *         .bucketName("bucketName")
 *         .bucketPrefix("bucketPrefix")
 *         .bucketRegion("bucketRegion")
 *         .kmsKeyArn("kmsKeyArn")
 *         .s3Destination(S3DestinationProperty.builder()
 *                 .bucketName("bucketName")
 *                 .bucketRegion("bucketRegion")
 *                 .syncFormat("syncFormat")
 *                 // the properties below are optional
 *                 .bucketPrefix("bucketPrefix")
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .build())
 *         .syncFormat("syncFormat")
 *         .syncSource(SyncSourceProperty.builder()
 *                 .sourceRegions(List.of("sourceRegions"))
 *                 .sourceType("sourceType")
 *                 // the properties below are optional
 *                 .awsOrganizationsSource(AwsOrganizationsSourceProperty.builder()
 *                         .organizationSourceType("organizationSourceType")
 *                         // the properties below are optional
 *                         .organizationalUnits(List.of("organizationalUnits"))
 *                         .build())
 *                 .includeFutureRegions(false)
 *                 .build())
 *         .syncType("syncType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:30.299Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnResourceDataSyncProps")
@software.amazon.jsii.Jsii.Proxy(CfnResourceDataSyncProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourceDataSyncProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A name for the resource data sync.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSyncName();

    /**
     * The name of the S3 bucket where the aggregated data is stored.
     * <p>
     * Returns union: either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.s3.IBucketRef}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBucketName() {
        return null;
    }

    /**
     * An Amazon S3 prefix for the bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketprefix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
        return null;
    }

    /**
     * The AWS Region with the S3 bucket targeted by the resource data sync.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-bucketregion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketRegion() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of an encryption key for a destination in Amazon S3 .
     * <p>
     * You can use a KMS key to encrypt inventory data in Amazon S3 . You must specify a key that exist in the same AWS Region as the destination Amazon S3 bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-kmskeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return null;
    }

    /**
     * Configuration information for the target S3 bucket.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ssm.CfnResourceDataSync.S3DestinationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-s3destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-s3destination</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getS3Destination() {
        return null;
    }

    /**
     * A supported sync format.
     * <p>
     * The following format is currently supported: JsonSerDe
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncformat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSyncFormat() {
        return null;
    }

    /**
     * Information about the source where the data was synchronized.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ssm.CfnResourceDataSync.SyncSourceProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-syncsource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSyncSource() {
        return null;
    }

    /**
     * The type of resource data sync.
     * <p>
     * If <code>SyncType</code> is <code>SyncToDestination</code> , then the resource data sync synchronizes data to an S3 bucket. If the <code>SyncType</code> is <code>SyncFromSource</code> then the resource data sync synchronizes data from AWS Organizations or from multiple AWS Regions .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-synctype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-resourcedatasync.html#cfn-ssm-resourcedatasync-synctype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSyncType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResourceDataSyncProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourceDataSyncProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourceDataSyncProps> {
        java.lang.String syncName;
        java.lang.Object bucketName;
        java.lang.String bucketPrefix;
        java.lang.String bucketRegion;
        java.lang.String kmsKeyArn;
        java.lang.Object s3Destination;
        java.lang.String syncFormat;
        java.lang.Object syncSource;
        java.lang.String syncType;

        /**
         * Sets the value of {@link CfnResourceDataSyncProps#getSyncName}
         * @param syncName A name for the resource data sync. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncName(java.lang.String syncName) {
            this.syncName = syncName;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceDataSyncProps#getBucketName}
         * @param bucketName The name of the S3 bucket where the aggregated data is stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(java.lang.String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceDataSyncProps#getBucketName}
         * @param bucketName The name of the S3 bucket where the aggregated data is stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(software.amazon.awscdk.interfaces.s3.IBucketRef bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceDataSyncProps#getBucketPrefix}
         * @param bucketPrefix An Amazon S3 prefix for the bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketPrefix(java.lang.String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceDataSyncProps#getBucketRegion}
         * @param bucketRegion The AWS Region with the S3 bucket targeted by the resource data sync.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketRegion(java.lang.String bucketRegion) {
            this.bucketRegion = bucketRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceDataSyncProps#getKmsKeyArn}
         * @param kmsKeyArn The Amazon Resource Name (ARN) of an encryption key for a destination in Amazon S3 .
         *                  You can use a KMS key to encrypt inventory data in Amazon S3 . You must specify a key that exist in the same AWS Region as the destination Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceDataSyncProps#getS3Destination}
         * @param s3Destination Configuration information for the target S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Destination(software.amazon.awscdk.IResolvable s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceDataSyncProps#getS3Destination}
         * @param s3Destination Configuration information for the target S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Destination(software.amazon.awscdk.services.ssm.CfnResourceDataSync.S3DestinationProperty s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceDataSyncProps#getSyncFormat}
         * @param syncFormat A supported sync format.
         *                   The following format is currently supported: JsonSerDe
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncFormat(java.lang.String syncFormat) {
            this.syncFormat = syncFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceDataSyncProps#getSyncSource}
         * @param syncSource Information about the source where the data was synchronized.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncSource(software.amazon.awscdk.IResolvable syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceDataSyncProps#getSyncSource}
         * @param syncSource Information about the source where the data was synchronized.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncSource(software.amazon.awscdk.services.ssm.CfnResourceDataSync.SyncSourceProperty syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceDataSyncProps#getSyncType}
         * @param syncType The type of resource data sync.
         *                 If <code>SyncType</code> is <code>SyncToDestination</code> , then the resource data sync synchronizes data to an S3 bucket. If the <code>SyncType</code> is <code>SyncFromSource</code> then the resource data sync synchronizes data from AWS Organizations or from multiple AWS Regions .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncType(java.lang.String syncType) {
            this.syncType = syncType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceDataSyncProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResourceDataSyncProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResourceDataSyncProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourceDataSyncProps {
        private final java.lang.String syncName;
        private final java.lang.Object bucketName;
        private final java.lang.String bucketPrefix;
        private final java.lang.String bucketRegion;
        private final java.lang.String kmsKeyArn;
        private final java.lang.Object s3Destination;
        private final java.lang.String syncFormat;
        private final java.lang.Object syncSource;
        private final java.lang.String syncType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.syncName = software.amazon.jsii.Kernel.get(this, "syncName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketRegion = software.amazon.jsii.Kernel.get(this, "bucketRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3Destination = software.amazon.jsii.Kernel.get(this, "s3Destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.syncFormat = software.amazon.jsii.Kernel.get(this, "syncFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.syncSource = software.amazon.jsii.Kernel.get(this, "syncSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.syncType = software.amazon.jsii.Kernel.get(this, "syncType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.syncName = java.util.Objects.requireNonNull(builder.syncName, "syncName is required");
            this.bucketName = builder.bucketName;
            this.bucketPrefix = builder.bucketPrefix;
            this.bucketRegion = builder.bucketRegion;
            this.kmsKeyArn = builder.kmsKeyArn;
            this.s3Destination = builder.s3Destination;
            this.syncFormat = builder.syncFormat;
            this.syncSource = builder.syncSource;
            this.syncType = builder.syncType;
        }

        @Override
        public final java.lang.String getSyncName() {
            return this.syncName;
        }

        @Override
        public final java.lang.Object getBucketName() {
            return this.bucketName;
        }

        @Override
        public final java.lang.String getBucketPrefix() {
            return this.bucketPrefix;
        }

        @Override
        public final java.lang.String getBucketRegion() {
            return this.bucketRegion;
        }

        @Override
        public final java.lang.String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final java.lang.Object getS3Destination() {
            return this.s3Destination;
        }

        @Override
        public final java.lang.String getSyncFormat() {
            return this.syncFormat;
        }

        @Override
        public final java.lang.Object getSyncSource() {
            return this.syncSource;
        }

        @Override
        public final java.lang.String getSyncType() {
            return this.syncType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("syncName", om.valueToTree(this.getSyncName()));
            if (this.getBucketName() != null) {
                data.set("bucketName", om.valueToTree(this.getBucketName()));
            }
            if (this.getBucketPrefix() != null) {
                data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
            }
            if (this.getBucketRegion() != null) {
                data.set("bucketRegion", om.valueToTree(this.getBucketRegion()));
            }
            if (this.getKmsKeyArn() != null) {
                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
            }
            if (this.getS3Destination() != null) {
                data.set("s3Destination", om.valueToTree(this.getS3Destination()));
            }
            if (this.getSyncFormat() != null) {
                data.set("syncFormat", om.valueToTree(this.getSyncFormat()));
            }
            if (this.getSyncSource() != null) {
                data.set("syncSource", om.valueToTree(this.getSyncSource()));
            }
            if (this.getSyncType() != null) {
                data.set("syncType", om.valueToTree(this.getSyncType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnResourceDataSyncProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourceDataSyncProps.Jsii$Proxy that = (CfnResourceDataSyncProps.Jsii$Proxy) o;

            if (!syncName.equals(that.syncName)) return false;
            if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
            if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
            if (this.bucketRegion != null ? !this.bucketRegion.equals(that.bucketRegion) : that.bucketRegion != null) return false;
            if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
            if (this.s3Destination != null ? !this.s3Destination.equals(that.s3Destination) : that.s3Destination != null) return false;
            if (this.syncFormat != null ? !this.syncFormat.equals(that.syncFormat) : that.syncFormat != null) return false;
            if (this.syncSource != null ? !this.syncSource.equals(that.syncSource) : that.syncSource != null) return false;
            return this.syncType != null ? this.syncType.equals(that.syncType) : that.syncType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.syncName.hashCode();
            result = 31 * result + (this.bucketName != null ? this.bucketName.hashCode() : 0);
            result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
            result = 31 * result + (this.bucketRegion != null ? this.bucketRegion.hashCode() : 0);
            result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
            result = 31 * result + (this.s3Destination != null ? this.s3Destination.hashCode() : 0);
            result = 31 * result + (this.syncFormat != null ? this.syncFormat.hashCode() : 0);
            result = 31 * result + (this.syncSource != null ? this.syncSource.hashCode() : 0);
            result = 31 * result + (this.syncType != null ? this.syncType.hashCode() : 0);
            return result;
        }
    }
}
