package software.amazon.awscdk.services.ssm;

/**
 * SSM parameter data type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DistributionConfiguration distributionConfiguration = DistributionConfiguration.Builder.create(this, "DistributionConfiguration")
 *         .distributionConfigurationName("test-distribution-configuration")
 *         .description("A Distribution Configuration")
 *         .amiDistributions(List.of(AmiDistribution.builder()
 *                 // Distribute AMI to us-east-2 and publish the AMI ID to an SSM parameter
 *                 .region("us-east-2")
 *                 .ssmParameters(List.of(SSMParameterConfigurations.builder()
 *                         .parameter(StringParameter.fromStringParameterAttributes(this, "CrossRegionParameter", StringParameterAttributes.builder()
 *                                 .parameterName("/imagebuilder/ami")
 *                                 .forceDynamicReference(true)
 *                                 .build()))
 *                         .build()))
 *                 .build()))
 *         .build();
 * // For AMI-based image builds - add an AMI distribution in the current region
 * distributionConfiguration.addAmiDistributions(AmiDistribution.builder()
 *         .amiName("imagebuilder-{{ imagebuilder:buildDate }}")
 *         .amiDescription("Build AMI")
 *         .amiKmsKey(Key.fromLookup(this, "ComponentKey", KeyLookupOptions.builder().aliasName("alias/distribution-encryption-key").build()))
 *         // Copy the AMI to different accounts
 *         .amiTargetAccountIds(List.of("123456789012", "098765432109"))
 *         // Add launch permissions on the AMI
 *         .amiLaunchPermission(AmiLaunchPermission.builder()
 *                 .organizationArns(List.of(this.formatArn(ArnComponents.builder().region("").service("organizations").resource("organization").resourceName("o-1234567abc").build())))
 *                 .organizationalUnitArns(List.of(this.formatArn(ArnComponents.builder()
 *                         .region("")
 *                         .service("organizations")
 *                         .resource("ou")
 *                         .resourceName("o-1234567abc/ou-a123-b4567890")
 *                         .build())))
 *                 .isPublicUserGroup(true)
 *                 .accountIds(List.of("234567890123"))
 *                 .build())
 *         // Attach tags to the AMI
 *         .amiTags(Map.of(
 *                 "Environment", "production",
 *                 "Version", "{{ imagebuilder:buildVersion }}"))
 *         // Optional - publish the distributed AMI ID to an SSM parameter
 *         .ssmParameters(List.of(SSMParameterConfigurations.builder()
 *                 .parameter(StringParameter.fromStringParameterAttributes(this, "Parameter", StringParameterAttributes.builder()
 *                         .parameterName("/imagebuilder/ami")
 *                         .forceDynamicReference(true)
 *                         .build()))
 *                 .build(), SSMParameterConfigurations.builder()
 *                 .amiAccount("098765432109")
 *                 .dataType(ParameterDataType.TEXT)
 *                 .parameter(StringParameter.fromStringParameterAttributes(this, "CrossAccountParameter", StringParameterAttributes.builder()
 *                         .parameterName("imagebuilder-prod-ami")
 *                         .forceDynamicReference(true)
 *                         .build()))
 *                 .build()))
 *         // Optional - create a new launch template version with the distributed AMI ID
 *         .launchTemplates(List.of(LaunchTemplateConfiguration.builder()
 *                 .launchTemplate(LaunchTemplate.fromLaunchTemplateAttributes(this, "LaunchTemplate", LaunchTemplateAttributes.builder()
 *                         .launchTemplateId("lt-1234")
 *                         .build()))
 *                 .setDefaultVersion(true)
 *                 .build(), LaunchTemplateConfiguration.builder()
 *                 .accountId("123456789012")
 *                 .launchTemplate(LaunchTemplate.fromLaunchTemplateAttributes(this, "CrossAccountLaunchTemplate", LaunchTemplateAttributes.builder()
 *                         .launchTemplateId("lt-5678")
 *                         .build()))
 *                 .setDefaultVersion(true)
 *                 .build()))
 *         // Optional - enable Fast Launch on an imported launch template
 *         .fastLaunchConfigurations(List.of(FastLaunchConfiguration.builder()
 *                 .enabled(true)
 *                 .launchTemplate(LaunchTemplate.fromLaunchTemplateAttributes(this, "FastLaunchLT", LaunchTemplateAttributes.builder()
 *                         .launchTemplateName("fast-launch-lt")
 *                         .build()))
 *                 .maxParallelLaunches(10)
 *                 .targetSnapshotCount(2)
 *                 .build()))
 *         // Optional - license configurations to apply to the AMI
 *         .licenseConfigurationArns(List.of("arn:aws:license-manager:us-west-2:123456789012:license-configuration:lic-abcdefghijklmnopqrstuvwxyz"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:30.318Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.ParameterDataType")
public enum ParameterDataType {
    /**
     * Text.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TEXT,
    /**
     * Aws Ec2 Image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EC2_IMAGE,
}
