package software.amazon.awscdk.services.ssm;

/**
 * The type of CFN SSM Parameter.
 * <p>
 * Using specific types can be helpful in catching invalid values
 * at the start of creating or updating a stack. CloudFormation validates
 * the values against existing values in the account.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * StringParameter.valueForTypedStringParameterV2(this, "/My/Public/Parameter", ParameterValueType.AWS_EC2_IMAGE_ID);
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/parameters-section-structure.html#aws-ssm-parameter-types</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:30.320Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.ParameterValueType")
public enum ParameterValueType {
    /**
     * String.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STRING,
    /**
     * An Availability Zone, such as us-west-2a.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EC2_AVAILABILITYZONE_NAME,
    /**
     * An Amazon EC2 image ID, such as ami-0ff8a91507f77f867.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EC2_IMAGE_ID,
    /**
     * An Amazon EC2 instance ID, such as i-1e731a32.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EC2_INSTANCE_ID,
    /**
     * An Amazon EC2 key pair name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EC2_KEYPAIR_KEYNAME,
    /**
     * An EC2-Classic or default VPC security group name, such as my-sg-abc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EC2_SECURITYGROUP_GROUPNAME,
    /**
     * A security group ID, such as sg-a123fd85.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EC2_SECURITYGROUP_ID,
    /**
     * A subnet ID, such as subnet-123a351e.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EC2_SUBNET_ID,
    /**
     * An Amazon EBS volume ID, such as vol-3cdd3f56.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EC2_VOLUME_ID,
    /**
     * A VPC ID, such as vpc-a123baa3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EC2_VPC_ID,
    /**
     * An Amazon Route 53 hosted zone ID, such as Z23YXV4OVPL04A.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_ROUTE53_HOSTEDZONE_ID,
}
