package software.amazon.awscdk.services.stepfunctions;

/**
 * Define a Map state in the state machine.
 * <p>
 * A <code>Map</code> state can be used to run a set of steps for each element of an input array.
 * A Map state will execute the same steps for multiple entries of an array in the state input.
 * <p>
 * While the Parallel state executes multiple branches of steps using the same input, a Map state
 * will execute the same steps for multiple entries of an array in the state input.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Map map = Map.Builder.create(this, "Map State")
 *         .maxConcurrency(1)
 *         .itemsPath(JsonPath.stringAt("$.inputForMap"))
 *         .itemSelector(Map.of(
 *                 "item", JsonPath.stringAt("$.Map.Item.Value")))
 *         .resultPath("$.mapOutput")
 *         .build();
 * map.itemProcessor(new Pass(this, "Pass State"), ProcessorConfig.builder()
 *         .mode(ProcessorMode.DISTRIBUTED)
 *         .executionType(ProcessorType.STANDARD)
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:30.524Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.Map")
public class Map extends software.amazon.awscdk.services.stepfunctions.MapBase implements software.amazon.awscdk.services.stepfunctions.INextable {

    protected Map(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Map(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id Descriptive identifier for this chainable. This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Map(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.MapProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id Descriptive identifier for this chainable. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Map(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Define a Map state using JSONata in the state machine.
     * <p>
     * A <code>Map</code> state can be used to run a set of steps for each element of an input array.
     * A Map state will execute the same steps for multiple entries of an array in the state input.
     * <p>
     * While the Parallel state executes multiple branches of steps using the same input, a Map state
     * will execute the same steps for multiple entries of an array in the state input.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html</a>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map jsonata(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.MapJsonataProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Map.class, "jsonata", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Define a Map state using JSONata in the state machine.
     * <p>
     * A <code>Map</code> state can be used to run a set of steps for each element of an input array.
     * A Map state will execute the same steps for multiple entries of an array in the state input.
     * <p>
     * While the Parallel state executes multiple branches of steps using the same input, a Map state
     * will execute the same steps for multiple entries of an array in the state input.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html</a>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map jsonata(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Map.class, "jsonata", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Define a Map state using JSONPath in the state machine.
     * <p>
     * A <code>Map</code> state can be used to run a set of steps for each element of an input array.
     * A Map state will execute the same steps for multiple entries of an array in the state input.
     * <p>
     * While the Parallel state executes multiple branches of steps using the same input, a Map state
     * will execute the same steps for multiple entries of an array in the state input.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html</a>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map jsonPath(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.MapJsonPathProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Map.class, "jsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Define a Map state using JSONPath in the state machine.
     * <p>
     * A <code>Map</code> state can be used to run a set of steps for each element of an input array.
     * A Map state will execute the same steps for multiple entries of an array in the state input.
     * <p>
     * While the Parallel state executes multiple branches of steps using the same input, a Map state
     * will execute the same steps for multiple entries of an array in the state input.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html</a>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map jsonPath(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Map.class, "jsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Add a recovery handler for this state.
     * <p>
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     * <p>
     * @param handler This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map addCatch(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable handler, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.CatchProps props) {
        return software.amazon.jsii.Kernel.call(this, "addCatch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { java.util.Objects.requireNonNull(handler, "handler is required"), props });
    }

    /**
     * Add a recovery handler for this state.
     * <p>
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     * <p>
     * @param handler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map addCatch(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable handler) {
        return software.amazon.jsii.Kernel.call(this, "addCatch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { java.util.Objects.requireNonNull(handler, "handler is required") });
    }

    /**
     * Add retry configuration for this state.
     * <p>
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map addRetry(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.RetryProps props) {
        return software.amazon.jsii.Kernel.call(this, "addRetry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { props });
    }

    /**
     * Add retry configuration for this state.
     * <p>
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map addRetry() {
        return software.amazon.jsii.Kernel.call(this, "addRetry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class));
    }

    /**
     * Define item processor in Map.
     * <p>
     * A Map must either have a non-empty iterator or a non-empty item processor (mutually exclusive  with <code>iterator</code>).
     * <p>
     * @param processor This parameter is required.
     * @param config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map itemProcessor(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable processor, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ProcessorConfig config) {
        return software.amazon.jsii.Kernel.call(this, "itemProcessor", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { java.util.Objects.requireNonNull(processor, "processor is required"), config });
    }

    /**
     * Define item processor in Map.
     * <p>
     * A Map must either have a non-empty iterator or a non-empty item processor (mutually exclusive  with <code>iterator</code>).
     * <p>
     * @param processor This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map itemProcessor(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable processor) {
        return software.amazon.jsii.Kernel.call(this, "itemProcessor", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { java.util.Objects.requireNonNull(processor, "processor is required") });
    }

    /**
     * (deprecated) Define iterator state machine in Map.
     * <p>
     * A Map must either have a non-empty iterator or a non-empty item processor (mutually exclusive  with <code>itemProcessor</code>).
     * <p>
     * @deprecated <ul>
     * <li>use <code>itemProcessor</code> instead.</li>
     * </ul>
     * @param iterator This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map iterator(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable iterator) {
        return software.amazon.jsii.Kernel.call(this, "iterator", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { java.util.Objects.requireNonNull(iterator, "iterator is required") });
    }

    /**
     * Return the Amazon States Language object for this state.
     * <p>
     * @param queryLanguage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
        return software.amazon.jsii.Kernel.call(this, "toStateJson", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class), new Object[] { queryLanguage });
    }

    /**
     * Return the Amazon States Language object for this state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
        return software.amazon.jsii.Kernel.call(this, "toStateJson", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
    }

    /**
     * Validate this state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateState() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateState", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.Map}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.Map> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id Descriptive identifier for this chainable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.stepfunctions.MapProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A comment describing this state.
         * <p>
         * Default: No comment
         * <p>
         * @return {@code this}
         * @param comment A comment describing this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props().comment(comment);
            return this;
        }

        /**
         * The name of the query language used by the state.
         * <p>
         * If the state does not contain a <code>queryLanguage</code> field,
         * then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * <p>
         * Default: - JSONPath
         * <p>
         * @return {@code this}
         * @param queryLanguage The name of the query language used by the state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.props().queryLanguage(queryLanguage);
            return this;
        }

        /**
         * Optional name for this state.
         * <p>
         * Default: - The construct ID will be used as state name
         * <p>
         * @return {@code this}
         * @param stateName Optional name for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(final java.lang.String stateName) {
            this.props().stateName(stateName);
            return this;
        }

        /**
         * Workflow variables to store in this step.
         * <p>
         * Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * <p>
         * Default: - Not assign variables
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/workflow-variables.html">https://docs.aws.amazon.com/step-functions/latest/dg/workflow-variables.html</a>
         * @param assign Workflow variables to store in this step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assign(final java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.props().assign(assign);
            return this;
        }

        /**
         * The JSON that you want to override your default iteration input (mutually exclusive  with <code>parameters</code> and <code>jsonataItemSelector</code>).
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-itemselector.html">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-itemselector.html</a>
         * @param itemSelector The JSON that you want to override your default iteration input (mutually exclusive  with <code>parameters</code> and <code>jsonataItemSelector</code>). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder itemSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> itemSelector) {
            this.props().itemSelector(itemSelector);
            return this;
        }

        /**
         * Jsonata expression that evaluates to a JSON array to override your default iteration input (mutually exclusive with <code>parameters</code> and <code>itemSelector</code>).
         * <p>
         * Example value: <code>{% {\"foo\": \"foo\", \"input\": $states.input} %}</code>
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param jsonataItemSelector Jsonata expression that evaluates to a JSON array to override your default iteration input (mutually exclusive with <code>parameters</code> and <code>itemSelector</code>). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonataItemSelector(final java.lang.String jsonataItemSelector) {
            this.props().jsonataItemSelector(jsonataItemSelector);
            return this;
        }

        /**
         * MaxConcurrency.
         * <p>
         * An upper bound on the number of iterations you want running at once.
         * <p>
         * Default: - full concurrency
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-asl-use-map-state-inline.html#map-state-inline-additional-fields">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-asl-use-map-state-inline.html#map-state-inline-additional-fields</a>
         * @param maxConcurrency MaxConcurrency. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrency(final java.lang.Number maxConcurrency) {
            this.props().maxConcurrency(maxConcurrency);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props().inputPath(inputPath);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the output to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props().outputPath(outputPath);
            return this;
        }

        /**
         * JSONPath expression to select the array to iterate over.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param itemsPath JSONPath expression to select the array to iterate over. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder itemsPath(final java.lang.String itemsPath) {
            this.props().itemsPath(itemsPath);
            return this;
        }

        /**
         * MaxConcurrencyPath.
         * <p>
         * A JsonPath that specifies the maximum concurrency dynamically from the state input.
         * <p>
         * Default: - full concurrency
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-asl-use-map-state-inline.html#map-state-inline-additional-fields">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-asl-use-map-state-inline.html#map-state-inline-additional-fields</a>
         * @param maxConcurrencyPath MaxConcurrencyPath. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrencyPath(final java.lang.String maxConcurrencyPath) {
            this.props().maxConcurrencyPath(maxConcurrencyPath);
            return this;
        }

        /**
         * JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props().resultPath(resultPath);
            return this;
        }

        /**
         * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         * <p>
         * You can use ResultSelector to create a payload with values that are static
         * or selected from the state's raw result.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector</a>
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.props().resultSelector(resultSelector);
            return this;
        }

        /**
         * Used to specify and transform output from the state.
         * <p>
         * When specified, the value overrides the state output default.
         * The output field accepts any JSON value (object, array, string, number, boolean, null).
         * Any string value, including those inside objects or arrays,
         * will be evaluated as JSONata if surrounded by {% %} characters.
         * Output also accepts a JSONata expression directly.
         * <p>
         * Default: - $states.result or $states.errorOutput
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html</a>
         * @param outputs Used to specify and transform output from the state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final java.lang.Object outputs) {
            this.props().outputs(outputs);
            return this;
        }

        /**
         * The array that the Map state will iterate over.
         * <p>
         * Default: - The state input as is.
         * <p>
         * @return {@code this}
         * @param items The array that the Map state will iterate over. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder items(final software.amazon.awscdk.services.stepfunctions.ProvideItems items) {
            this.props().items(items);
            return this;
        }

        /**
         * (deprecated) The JSON that you want to override your default iteration input (mutually exclusive  with <code>itemSelector</code>).
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-itemselector.html">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-itemselector.html</a>
         * @deprecated Step Functions has deprecated the <code>parameters</code> field in favor of
         * the new <code>itemSelector</code> field
         * @param parameters The JSON that you want to override your default iteration input (mutually exclusive  with <code>itemSelector</code>). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder parameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.Map}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.Map build() {
            return new software.amazon.awscdk.services.stepfunctions.Map(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.stepfunctions.MapProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.stepfunctions.MapProps.Builder();
            }
            return this.props;
        }
    }
}
