package software.amazon.awscdk.services.stepfunctions;

/**
 * Base properties for defining a Map state.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object assign;
 * Object itemSelector;
 * MapBaseOptions mapBaseOptions = MapBaseOptions.builder()
 *         .assign(Map.of(
 *                 "assignKey", assign))
 *         .itemSelector(Map.of(
 *                 "itemSelectorKey", itemSelector))
 *         .jsonataItemSelector("jsonataItemSelector")
 *         .maxConcurrency(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:30.528Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.MapBaseOptions")
@software.amazon.jsii.Jsii.Proxy(MapBaseOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MapBaseOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.AssignableStateOptions {

    /**
     * The JSON that you want to override your default iteration input (mutually exclusive  with <code>parameters</code> and <code>jsonataItemSelector</code>).
     * <p>
     * Default: $
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-itemselector.html">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-itemselector.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getItemSelector() {
        return null;
    }

    /**
     * Jsonata expression that evaluates to a JSON array to override your default iteration input (mutually exclusive with <code>parameters</code> and <code>itemSelector</code>).
     * <p>
     * Example value: <code>{% {\"foo\": \"foo\", \"input\": $states.input} %}</code>
     * <p>
     * Default: $
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJsonataItemSelector() {
        return null;
    }

    /**
     * MaxConcurrency.
     * <p>
     * An upper bound on the number of iterations you want running at once.
     * <p>
     * Default: - full concurrency
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-asl-use-map-state-inline.html#map-state-inline-additional-fields">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-asl-use-map-state-inline.html#map-state-inline-additional-fields</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrency() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MapBaseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MapBaseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MapBaseOptions> {
        java.util.Map<java.lang.String, java.lang.Object> itemSelector;
        java.lang.String jsonataItemSelector;
        java.lang.Number maxConcurrency;
        java.util.Map<java.lang.String, java.lang.Object> assign;

        /**
         * Sets the value of {@link MapBaseOptions#getItemSelector}
         * @param itemSelector The JSON that you want to override your default iteration input (mutually exclusive  with <code>parameters</code> and <code>jsonataItemSelector</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder itemSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> itemSelector) {
            this.itemSelector = (java.util.Map<java.lang.String, java.lang.Object>)itemSelector;
            return this;
        }

        /**
         * Sets the value of {@link MapBaseOptions#getJsonataItemSelector}
         * @param jsonataItemSelector Jsonata expression that evaluates to a JSON array to override your default iteration input (mutually exclusive with <code>parameters</code> and <code>itemSelector</code>).
         *                            Example value: <code>{% {\"foo\": \"foo\", \"input\": $states.input} %}</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonataItemSelector(java.lang.String jsonataItemSelector) {
            this.jsonataItemSelector = jsonataItemSelector;
            return this;
        }

        /**
         * Sets the value of {@link MapBaseOptions#getMaxConcurrency}
         * @param maxConcurrency MaxConcurrency.
         *                       An upper bound on the number of iterations you want running at once.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrency(java.lang.Number maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        /**
         * Sets the value of {@link MapBaseOptions#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MapBaseOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MapBaseOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MapBaseOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MapBaseOptions {
        private final java.util.Map<java.lang.String, java.lang.Object> itemSelector;
        private final java.lang.String jsonataItemSelector;
        private final java.lang.Number maxConcurrency;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.itemSelector = software.amazon.jsii.Kernel.get(this, "itemSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.jsonataItemSelector = software.amazon.jsii.Kernel.get(this, "jsonataItemSelector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxConcurrency = software.amazon.jsii.Kernel.get(this, "maxConcurrency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.itemSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.itemSelector;
            this.jsonataItemSelector = builder.jsonataItemSelector;
            this.maxConcurrency = builder.maxConcurrency;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getItemSelector() {
            return this.itemSelector;
        }

        @Override
        public final java.lang.String getJsonataItemSelector() {
            return this.jsonataItemSelector;
        }

        @Override
        public final java.lang.Number getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getItemSelector() != null) {
                data.set("itemSelector", om.valueToTree(this.getItemSelector()));
            }
            if (this.getJsonataItemSelector() != null) {
                data.set("jsonataItemSelector", om.valueToTree(this.getJsonataItemSelector()));
            }
            if (this.getMaxConcurrency() != null) {
                data.set("maxConcurrency", om.valueToTree(this.getMaxConcurrency()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.MapBaseOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MapBaseOptions.Jsii$Proxy that = (MapBaseOptions.Jsii$Proxy) o;

            if (this.itemSelector != null ? !this.itemSelector.equals(that.itemSelector) : that.itemSelector != null) return false;
            if (this.jsonataItemSelector != null ? !this.jsonataItemSelector.equals(that.jsonataItemSelector) : that.jsonataItemSelector != null) return false;
            if (this.maxConcurrency != null ? !this.maxConcurrency.equals(that.maxConcurrency) : that.maxConcurrency != null) return false;
            return this.assign != null ? this.assign.equals(that.assign) : that.assign == null;
        }

        @Override
        public final int hashCode() {
            int result = this.itemSelector != null ? this.itemSelector.hashCode() : 0;
            result = 31 * result + (this.jsonataItemSelector != null ? this.jsonataItemSelector.hashCode() : 0);
            result = 31 * result + (this.maxConcurrency != null ? this.maxConcurrency.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            return result;
        }
    }
}
