package software.amazon.awscdk.services.stepfunctions;

/**
 * The array that the Map state will iterate over.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object array;
 * ProvideItems provideItems = ProvideItems.jsonArray(List.of(array));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:30.540Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ProvideItems")
public abstract class ProvideItems extends software.amazon.jsii.JsiiObject {

    protected ProvideItems(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ProvideItems(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ProvideItems() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Use a JSON array as Map state items.
     * <p>
     * Example value: <code>[1, "{% $two %}", 3]</code>
     * <p>
     * @param array This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.ProvideItems jsonArray(final @org.jetbrains.annotations.NotNull java.util.List<? extends java.lang.Object> array) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.ProvideItems.class, "jsonArray", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ProvideItems.class), new Object[] { java.util.Objects.requireNonNull(array, "array is required") });
    }

    /**
     * Use a JSONata expression as Map state items.
     * <p>
     * Example value: <code>{% $states.input.items %}</code>
     * <p>
     * @param jsonataExpression This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.ProvideItems jsonata(final @org.jetbrains.annotations.NotNull java.lang.String jsonataExpression) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.ProvideItems.class, "jsonata", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ProvideItems.class), new Object[] { java.util.Objects.requireNonNull(jsonataExpression, "jsonataExpression is required") });
    }

    /**
     * The array that the Map state will iterate over.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.Object getItems();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.ProvideItems {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The array that the Map state will iterate over.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Object getItems() {
            return software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }
    }
}
