package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for StateMachineGrants.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * import software.amazon.awscdk.interfaces.stepfunctions.*;
 * IStateMachineRef stateMachineRef;
 * StateMachineGrantsProps stateMachineGrantsProps = StateMachineGrantsProps.builder()
 *         .resource(stateMachineRef)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:30.571Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.StateMachineGrantsProps")
@software.amazon.jsii.Jsii.Proxy(StateMachineGrantsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StateMachineGrantsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The resource on which actions will be allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.stepfunctions.IStateMachineRef getResource();

    /**
     * @return a {@link Builder} of {@link StateMachineGrantsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StateMachineGrantsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StateMachineGrantsProps> {
        software.amazon.awscdk.interfaces.stepfunctions.IStateMachineRef resource;

        /**
         * Sets the value of {@link StateMachineGrantsProps#getResource}
         * @param resource The resource on which actions will be allowed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(software.amazon.awscdk.interfaces.stepfunctions.IStateMachineRef resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StateMachineGrantsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StateMachineGrantsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StateMachineGrantsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateMachineGrantsProps {
        private final software.amazon.awscdk.interfaces.stepfunctions.IStateMachineRef resource;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.stepfunctions.IStateMachineRef.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resource = java.util.Objects.requireNonNull(builder.resource, "resource is required");
        }

        @Override
        public final software.amazon.awscdk.interfaces.stepfunctions.IStateMachineRef getResource() {
            return this.resource;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resource", om.valueToTree(this.getResource()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.StateMachineGrantsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StateMachineGrantsProps.Jsii$Proxy that = (StateMachineGrantsProps.Jsii$Proxy) o;

            return this.resource.equals(that.resource);
        }

        @Override
        public final int hashCode() {
            int result = this.resource.hashCode();
            return result;
        }
    }
}
