package software.amazon.awscdk.services.supportapp;

/**
 * You can use the <code>AWS::SupportApp::SlackChannelConfiguration</code> resource to specify your AWS account when you configure the AWS Support App .
 * <p>
 * This resource includes the following information:
 * <p>
 * <ul>
 * <li>The Slack channel name and ID</li>
 * <li>The team ID in Slack</li>
 * <li>The Amazon Resource Name (ARN) of the AWS Identity and Access Management ( IAM ) role</li>
 * <li>Whether you want the AWS Support App to notify you when your support cases are created, updated, resolved, or reopened</li>
 * <li>The case severity that you want to get notified for</li>
 * </ul>
 * <p>
 * For more information, see the following topics in the <em>User Guide</em> :
 * <p>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/awssupport/latest/user/aws-support-app-for-slack.html">AWS Support App in Slack</a></li>
 * <li><a href="https://docs.aws.amazon.com/awssupport/latest/user/creating-resources-with-cloudformation.html">Creating AWS Support App in Slack resources with AWS CloudFormation</a></li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.supportapp.*;
 * CfnSlackChannelConfiguration cfnSlackChannelConfiguration = CfnSlackChannelConfiguration.Builder.create(this, "MyCfnSlackChannelConfiguration")
 *         .channelId("channelId")
 *         .channelRoleArn("channelRoleArn")
 *         .notifyOnCaseSeverity("notifyOnCaseSeverity")
 *         .teamId("teamId")
 *         // the properties below are optional
 *         .channelName("channelName")
 *         .notifyOnAddCorrespondenceToCase(false)
 *         .notifyOnCreateOrReopenCase(false)
 *         .notifyOnResolveCase(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:31.116Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_supportapp.CfnSlackChannelConfiguration")
public class CfnSlackChannelConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.supportapp.ISlackChannelConfigurationRef {

    protected CfnSlackChannelConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSlackChannelConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.supportapp.CfnSlackChannelConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::SupportApp::SlackChannelConfiguration</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSlackChannelConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.supportapp.CfnSlackChannelConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Checks whether the given object is a CfnSlackChannelConfiguration.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnSlackChannelConfiguration(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.supportapp.CfnSlackChannelConfiguration.class, "isCfnSlackChannelConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a SlackChannelConfiguration resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.supportapp.SlackChannelConfigurationReference getSlackChannelConfigurationRef() {
        return software.amazon.jsii.Kernel.get(this, "slackChannelConfigurationRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.supportapp.SlackChannelConfigurationReference.class));
    }

    /**
     * The channel ID in Slack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelId() {
        return software.amazon.jsii.Kernel.get(this, "channelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The channel ID in Slack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelId", java.util.Objects.requireNonNull(value, "channelId is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role for this Slack channel configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "channelRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role for this Slack channel configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelRoleArn", java.util.Objects.requireNonNull(value, "channelRoleArn is required"));
    }

    /**
     * The case severity for your support cases that you want to receive notifications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNotifyOnCaseSeverity() {
        return software.amazon.jsii.Kernel.get(this, "notifyOnCaseSeverity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The case severity for your support cases that you want to receive notifications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnCaseSeverity(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnCaseSeverity", java.util.Objects.requireNonNull(value, "notifyOnCaseSeverity is required"));
    }

    /**
     * The team ID in Slack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTeamId() {
        return software.amazon.jsii.Kernel.get(this, "teamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The team ID in Slack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTeamId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "teamId", java.util.Objects.requireNonNull(value, "teamId is required"));
    }

    /**
     * The channel name in Slack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getChannelName() {
        return software.amazon.jsii.Kernel.get(this, "channelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The channel name in Slack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelName", value);
    }

    /**
     * Whether to get notified when a correspondence is added to your support cases.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotifyOnAddCorrespondenceToCase() {
        return software.amazon.jsii.Kernel.get(this, "notifyOnAddCorrespondenceToCase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether to get notified when a correspondence is added to your support cases.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnAddCorrespondenceToCase(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnAddCorrespondenceToCase", value);
    }

    /**
     * Whether to get notified when a correspondence is added to your support cases.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnAddCorrespondenceToCase(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnAddCorrespondenceToCase", value);
    }

    /**
     * Whether to get notified when your support cases are created or reopened.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotifyOnCreateOrReopenCase() {
        return software.amazon.jsii.Kernel.get(this, "notifyOnCreateOrReopenCase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether to get notified when your support cases are created or reopened.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnCreateOrReopenCase(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnCreateOrReopenCase", value);
    }

    /**
     * Whether to get notified when your support cases are created or reopened.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnCreateOrReopenCase(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnCreateOrReopenCase", value);
    }

    /**
     * Whether to get notified when your support cases are resolved.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotifyOnResolveCase() {
        return software.amazon.jsii.Kernel.get(this, "notifyOnResolveCase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether to get notified when your support cases are resolved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnResolveCase(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnResolveCase", value);
    }

    /**
     * Whether to get notified when your support cases are resolved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifyOnResolveCase(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notifyOnResolveCase", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.supportapp.CfnSlackChannelConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.supportapp.CfnSlackChannelConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.supportapp.CfnSlackChannelConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.supportapp.CfnSlackChannelConfigurationProps.Builder();
        }

        /**
         * The channel ID in Slack.
         * <p>
         * This ID identifies a channel within a Slack workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelid</a>
         * @param channelId The channel ID in Slack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelId(final java.lang.String channelId) {
            this.props.channelId(channelId);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role for this Slack channel configuration.
         * <p>
         * The  App uses this role to perform  and Service Quotas actions on your behalf.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelrolearn</a>
         * @param channelRoleArn The Amazon Resource Name (ARN) of the IAM role for this Slack channel configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelRoleArn(final java.lang.String channelRoleArn) {
            this.props.channelRoleArn(channelRoleArn);
            return this;
        }
        /**
         * The Amazon Resource Name (ARN) of the IAM role for this Slack channel configuration.
         * <p>
         * The  App uses this role to perform  and Service Quotas actions on your behalf.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelrolearn</a>
         * @param channelRoleArn The Amazon Resource Name (ARN) of the IAM role for this Slack channel configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelRoleArn(final software.amazon.awscdk.interfaces.iam.IRoleRef channelRoleArn) {
            this.props.channelRoleArn(channelRoleArn);
            return this;
        }

        /**
         * The case severity for your support cases that you want to receive notifications.
         * <p>
         * You can specify <code>none</code> , <code>all</code> , or <code>high</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncaseseverity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncaseseverity</a>
         * @param notifyOnCaseSeverity The case severity for your support cases that you want to receive notifications. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnCaseSeverity(final java.lang.String notifyOnCaseSeverity) {
            this.props.notifyOnCaseSeverity(notifyOnCaseSeverity);
            return this;
        }

        /**
         * The team ID in Slack.
         * <p>
         * This ID uniquely identifies a Slack workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-teamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-teamid</a>
         * @param teamId The team ID in Slack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder teamId(final java.lang.String teamId) {
            this.props.teamId(teamId);
            return this;
        }

        /**
         * The channel name in Slack.
         * <p>
         * This is the channel where you invite the AWS Support App .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelname</a>
         * @param channelName The channel name in Slack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelName(final java.lang.String channelName) {
            this.props.channelName(channelName);
            return this;
        }

        /**
         * Whether to get notified when a correspondence is added to your support cases.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonaddcorrespondencetocase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonaddcorrespondencetocase</a>
         * @param notifyOnAddCorrespondenceToCase Whether to get notified when a correspondence is added to your support cases. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnAddCorrespondenceToCase(final java.lang.Boolean notifyOnAddCorrespondenceToCase) {
            this.props.notifyOnAddCorrespondenceToCase(notifyOnAddCorrespondenceToCase);
            return this;
        }
        /**
         * Whether to get notified when a correspondence is added to your support cases.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonaddcorrespondencetocase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonaddcorrespondencetocase</a>
         * @param notifyOnAddCorrespondenceToCase Whether to get notified when a correspondence is added to your support cases. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnAddCorrespondenceToCase(final software.amazon.awscdk.IResolvable notifyOnAddCorrespondenceToCase) {
            this.props.notifyOnAddCorrespondenceToCase(notifyOnAddCorrespondenceToCase);
            return this;
        }

        /**
         * Whether to get notified when your support cases are created or reopened.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncreateorreopencase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncreateorreopencase</a>
         * @param notifyOnCreateOrReopenCase Whether to get notified when your support cases are created or reopened. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnCreateOrReopenCase(final java.lang.Boolean notifyOnCreateOrReopenCase) {
            this.props.notifyOnCreateOrReopenCase(notifyOnCreateOrReopenCase);
            return this;
        }
        /**
         * Whether to get notified when your support cases are created or reopened.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncreateorreopencase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncreateorreopencase</a>
         * @param notifyOnCreateOrReopenCase Whether to get notified when your support cases are created or reopened. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnCreateOrReopenCase(final software.amazon.awscdk.IResolvable notifyOnCreateOrReopenCase) {
            this.props.notifyOnCreateOrReopenCase(notifyOnCreateOrReopenCase);
            return this;
        }

        /**
         * Whether to get notified when your support cases are resolved.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonresolvecase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonresolvecase</a>
         * @param notifyOnResolveCase Whether to get notified when your support cases are resolved. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnResolveCase(final java.lang.Boolean notifyOnResolveCase) {
            this.props.notifyOnResolveCase(notifyOnResolveCase);
            return this;
        }
        /**
         * Whether to get notified when your support cases are resolved.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonresolvecase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonresolvecase</a>
         * @param notifyOnResolveCase Whether to get notified when your support cases are resolved. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnResolveCase(final software.amazon.awscdk.IResolvable notifyOnResolveCase) {
            this.props.notifyOnResolveCase(notifyOnResolveCase);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.supportapp.CfnSlackChannelConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.supportapp.CfnSlackChannelConfiguration build() {
            return new software.amazon.awscdk.services.supportapp.CfnSlackChannelConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
