package software.amazon.awscdk.triggers;

/**
 * The invocation type to apply to a trigger.
 * <p>
 * This determines whether the trigger function should await the result of the to be triggered function or not.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.triggers.*;
 * Function func = Function.Builder.create(this, "MyFunction")
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .code(Code.fromInline("foo"))
 *         .build();
 * Trigger.Builder.create(this, "MyTrigger")
 *         .handler(func)
 *         .timeout(Duration.minutes(10))
 *         .invocationType(InvocationType.EVENT)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:33.438Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.triggers.InvocationType")
public enum InvocationType {
    /**
     * Invoke the function asynchronously.
     * <p>
     * Send events that fail multiple times to the function's dead-letter queue (if one is configured).
     * The API response only includes a status code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EVENT,
    /**
     * Invoke the function synchronously.
     * <p>
     * Keep the connection open until the function returns a response or times out.
     * The API response includes the function response and additional data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUEST_RESPONSE,
    /**
     * Validate parameter values and verify that the user or role has permission to invoke the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DRY_RUN,
}
