/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda.eventsources;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.kinesis.IStream;
import software.amazon.awscdk.services.lambda.IEventSourceDlq;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.lambda.StartingPosition;
import software.amazon.awscdk.services.lambda.eventsources.KinesisEventSourceProps;
import software.amazon.awscdk.services.lambda.eventsources.StreamEventSource;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lambda_event_sources.KinesisEventSource")
public class KinesisEventSource
extends StreamEventSource {
    protected KinesisEventSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KinesisEventSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public KinesisEventSource(@NotNull IStream stream, @NotNull KinesisEventSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(stream, "stream is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void bind(@NotNull IFunction target) {
        Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    @NotNull
    public String getEventSourceMappingId() {
        return (String)Kernel.get((Object)this, (String)"eventSourceMappingId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IStream getStream() {
        return (IStream)Kernel.get((Object)this, (String)"stream", (NativeType)NativeType.forClass(IStream.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<KinesisEventSource> {
        private final IStream stream;
        private final KinesisEventSourceProps.Builder props;

        public static Builder create(IStream stream) {
            return new Builder(stream);
        }

        private Builder(IStream stream) {
            this.stream = stream;
            this.props = new KinesisEventSourceProps.Builder();
        }

        public Builder startingPosition(StartingPosition startingPosition) {
            this.props.startingPosition(startingPosition);
            return this;
        }

        public Builder batchSize(Number batchSize) {
            this.props.batchSize(batchSize);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder maxBatchingWindow(Duration maxBatchingWindow) {
            this.props.maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        public Builder bisectBatchOnError(Boolean bisectBatchOnError) {
            this.props.bisectBatchOnError(bisectBatchOnError);
            return this;
        }

        public Builder maxRecordAge(Duration maxRecordAge) {
            this.props.maxRecordAge(maxRecordAge);
            return this;
        }

        public Builder onFailure(IEventSourceDlq onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        public Builder parallelizationFactor(Number parallelizationFactor) {
            this.props.parallelizationFactor(parallelizationFactor);
            return this;
        }

        public Builder reportBatchItemFailures(Boolean reportBatchItemFailures) {
            this.props.reportBatchItemFailures(reportBatchItemFailures);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        public Builder tumblingWindow(Duration tumblingWindow) {
            this.props.tumblingWindow(tumblingWindow);
            return this;
        }

        public KinesisEventSource build() {
            return new KinesisEventSource(this.stream, this.props.build());
        }
    }
}

